/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.BehaviorRetained;
import javax.media.j3d.BehaviorStructure;
import javax.media.j3d.Bounds;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.Sensor;
import javax.media.j3d.WakeupCriterion;
import javax.media.j3d.WakeupIndexedList;

public final class WakeupOnSensorExit
extends WakeupCriterion {
    static final int COND_IN_BS_LIST = 0;
    static final int SENSOREXIT_IN_BS_LIST = 1;
    static final int TOTAL_INDEXED_UNORDER_SET_TYPES = 2;
    Bounds region;
    Bounds transformedRegion;
    Sensor armingSensor;

    public WakeupOnSensorExit(Bounds bounds) {
        this.region = (Bounds)bounds.clone();
        WakeupIndexedList.init(this, 2);
    }

    public Bounds getBounds() {
        return (Bounds)this.region.clone();
    }

    void updateTransformRegion() {
        if (this.transformedRegion != null) {
            this.transformedRegion.set(this.region);
        } else {
            this.transformedRegion = (Bounds)this.region.clone();
        }
        this.transformedRegion.transform(this.behav.getCurrentLocalToVworld(null));
    }

    void addBehaviorCondition(BehaviorStructure behaviorStructure) {
        behaviorStructure.addSensorExitCondition(this);
        if (this.behav != null && this.behav.enable) {
            ++behaviorStructure.activeWakeupOnSensorCount;
        }
    }

    void removeBehaviorCondition(BehaviorStructure behaviorStructure) {
        behaviorStructure.removeSensorExitCondition(this);
        if (this.behav != null && this.behav.enable) {
            --behaviorStructure.activeWakeupOnSensorCount;
        }
    }

    void setTarget(Sensor sensor) {
        this.armingSensor = sensor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sensor getTriggeringSensor() {
        if (this.behav == null) {
            throw new IllegalStateException(J3dI18N.getString("WakeupOnSensorExit0"));
        }
        BehaviorRetained behaviorRetained = this.behav;
        synchronized (behaviorRetained) {
            if (!this.behav.inCallback) {
                throw new IllegalStateException(J3dI18N.getString("WakeupOnSensorExit0"));
            }
        }
        return this.armingSensor;
    }

    void resetBehaviorCondition(BehaviorStructure behaviorStructure) {
    }
}

