/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.File;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import loci.common.ByteArrayHandle;
import loci.common.DataTools;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.common.xml.BaseHandler;
import loci.common.xml.XMLTools;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.MetadataLevel;
import loci.formats.in.MinimalTiffReader;
import loci.formats.in.TiffReader;
import loci.formats.meta.MetadataStore;
import loci.formats.tiff.IFD;
import loci.formats.tiff.TiffParser;
import ome.units.UNITS;
import ome.units.quantity.Length;
import ome.units.quantity.Time;
import ome.xml.model.primitives.NonNegativeInteger;
import ome.xml.model.primitives.PositiveInteger;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class ScanrReader
extends FormatReader {
    private static final String XML_FILE = "experiment_descriptor.xml";
    private static final String EXPERIMENT_FILE = "experiment_descriptor.dat";
    private static final String ACQUISITION_FILE = "AcquisitionLog.dat";
    private static final String[] METADATA_SUFFIXES = new String[]{"dat", "xml"};
    private final List<String> metadataFiles = new ArrayList<String>();
    private int wellRows;
    private int wellColumns;
    private int fieldRows;
    private int fieldColumns;
    private int wellCount = 0;
    private final List<String> channelNames = new ArrayList<String>();
    private Map<String, Integer> wellLabels = new HashMap<String, Integer>();
    private Map<Integer, Integer> wellNumbers = new HashMap<Integer, Integer>();
    private String plateName;
    private Double pixelSize;
    private int tileWidth = 0;
    private int tileHeight = 0;
    private String[] tiffs;
    private MinimalTiffReader reader;
    private boolean foundPositions = false;
    private Length[] fieldPositionX;
    private Length[] fieldPositionY;
    private final List<Double> exposures = new ArrayList<Double>();
    private Double deltaT = null;
    private Map<Integer, String[]> seriesFiles = new HashMap<Integer, String[]>();

    public ScanrReader() {
        super("Olympus ScanR", new String[]{"dat", "xml", "tif"});
        this.domains = new String[]{"High-Content Screening (HCS)"};
        this.suffixSufficient = false;
        this.hasCompanionFiles = true;
        this.datasetDescription = "One .xml file, one 'data' directory containing .tif/.tiff files, and optionally two .dat files";
    }

    @Override
    public boolean isSingleFile(String id) throws FormatException, IOException {
        Location file2 = new Location(id).getAbsoluteFile();
        String name = file2.getName();
        if (name.equals(XML_FILE) || name.equals(EXPERIMENT_FILE) || name.equals(ACQUISITION_FILE)) {
            return true;
        }
        Location parent = file2.getParentFile();
        if (parent != null) {
            parent = parent.getParentFile();
        }
        return new Location(parent, XML_FILE).exists();
    }

    @Override
    public int fileGroupOption(String id) throws FormatException, IOException {
        return 0;
    }

    @Override
    public boolean isThisType(String name, boolean open) {
        Location xmlFile;
        String localName = new Location(name).getName();
        if (localName.equals(XML_FILE) || localName.equals(EXPERIMENT_FILE) || localName.equals(ACQUISITION_FILE)) {
            return true;
        }
        Location parent = new Location(name).getAbsoluteFile().getParentFile();
        if (ScanrReader.checkSuffix(name, "tif") && parent.getName().equalsIgnoreCase("Data")) {
            parent = parent.getParentFile();
        }
        if (!(xmlFile = new Location(parent, XML_FILE)).exists()) {
            return false;
        }
        return super.isThisType(name, open);
    }

    @Override
    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        TiffParser p = new TiffParser(stream);
        IFD ifd = p.getFirstIFD();
        if (ifd == null) {
            return false;
        }
        Object s = ifd.getIFDValue(305);
        if (s == null) {
            return false;
        }
        String software = s instanceof String[] ? ((String[])s)[0] : s.toString();
        return software.trim().equals("National Instruments IMAQ");
    }

    @Override
    public String[] getSeriesUsedFiles(boolean noPixels) {
        FormatTools.assertId(this.currentId, true, 1);
        if (this.seriesFiles.containsKey(this.getSeries())) {
            return this.seriesFiles.get(this.getSeries());
        }
        ArrayList<String> files = new ArrayList<String>();
        for (String file2 : this.metadataFiles) {
            if (file2 == null) continue;
            files.add(file2);
        }
        if (!noPixels && this.tiffs != null) {
            int offset = this.getSeries() * this.getImageCount();
            for (int i = 0; i < this.getImageCount(); ++i) {
                if (offset + i >= this.tiffs.length || this.tiffs[offset + i] == null || !this.isThisType(this.tiffs[offset + i])) continue;
                files.add(this.tiffs[offset + i]);
            }
        }
        String[] fileList = files.toArray(new String[files.size()]);
        this.seriesFiles.put(this.getSeries(), fileList);
        return fileList;
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            if (this.reader != null) {
                this.reader.close();
            }
            this.reader = null;
            this.tiffs = null;
            this.plateName = null;
            this.channelNames.clear();
            this.fieldColumns = 0;
            this.fieldRows = 0;
            this.wellColumns = 0;
            this.wellRows = 0;
            this.metadataFiles.clear();
            this.wellLabels.clear();
            this.wellNumbers.clear();
            this.wellCount = 0;
            this.pixelSize = null;
            this.tileWidth = 0;
            this.tileHeight = 0;
            this.fieldPositionX = null;
            this.fieldPositionY = null;
            this.exposures.clear();
            this.deltaT = null;
            this.foundPositions = false;
            this.seriesFiles.clear();
        }
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        int index = this.getSeries() * this.getImageCount() + no;
        if (index < this.tiffs.length && this.tiffs[index] != null) {
            try {
                this.reader.setId(this.tiffs[index]);
                this.reader.openBytes(0, buf, x, y, w, h);
                this.reader.close();
            }
            catch (FormatException e) {
                this.reader.close();
                Arrays.fill(buf, (byte)0);
                return buf;
            }
            ByteArrayHandle pixels = new ByteArrayHandle(buf);
            pixels.setOrder(this.isLittleEndian() ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN);
            for (int i = 0; i < buf.length; i += 2) {
                pixels.seek(i);
                short value = pixels.readShort();
                value = (short)(value & 0xFFF);
                pixels.seek(i);
                pixels.writeShort(value);
            }
            buf = pixels.getBytes();
            pixels.close();
        }
        return buf;
    }

    @Override
    public int getOptimalTileWidth() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.tileWidth;
    }

    @Override
    public int getOptimalTileHeight() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.tileHeight;
    }

    @Override
    protected void initFile(String id) throws FormatException, IOException {
        int i;
        Location dataDir;
        int nChannels;
        String[] list;
        super.initFile(id);
        if (this.metadataFiles.size() > 0) {
            return;
        }
        if (!ScanrReader.checkSuffix(id, "xml") && this.isGroupFiles()) {
            Location parent = new Location(id).getAbsoluteFile().getParentFile();
            if (ScanrReader.checkSuffix(id, "tif") && parent.getName().equalsIgnoreCase("Data")) {
                parent = parent.getParentFile();
            }
            for (String file2 : list = parent.list()) {
                if (!file2.equals(XML_FILE)) continue;
                id = new Location(parent, file2).getAbsolutePath();
                super.initFile(id);
                break;
            }
            if (!ScanrReader.checkSuffix(id, "xml")) {
                throw new FormatException("Could not find experiment_descriptor.xml in " + parent.getAbsolutePath());
            }
        } else if (!this.isGroupFiles() && ScanrReader.checkSuffix(id, "tif")) {
            TiffReader r = new TiffReader();
            r.setMetadataStore(this.getMetadataStore());
            r.setId(id);
            this.core = new ArrayList<CoreMetadata>(r.getCoreMetadataList());
            this.metadataStore = r.getMetadataStore();
            Hashtable<String, Object> globalMetadata = r.getGlobalMetadata();
            for (Map.Entry entry : globalMetadata.entrySet()) {
                this.addGlobalMeta((String)entry.getKey(), entry.getValue());
            }
            r.close();
            this.tiffs = new String[]{id};
            this.reader = new MinimalTiffReader();
            return;
        }
        Location dir = new Location(id).getAbsoluteFile().getParentFile();
        for (String file2 : list = dir.list(true)) {
            Location f = new Location(dir, file2);
            if (!ScanrReader.checkSuffix(file2, METADATA_SUFFIXES) || f.isDirectory()) continue;
            this.metadataFiles.add(f.getAbsolutePath());
        }
        String xml = DataTools.readFile(id).trim();
        if (xml.startsWith("<?")) {
            xml = xml.substring(xml.indexOf("?>") + 2);
        }
        xml = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>" + xml;
        XMLTools.parseXML(xml, (DefaultHandler)new ScanrHandler());
        ArrayList<String> uniqueRows = new ArrayList<String>();
        ArrayList<String> uniqueColumns = new ArrayList<String>();
        if (this.wellRows == 0 || this.wellColumns == 0) {
            for (String well : this.wellLabels.keySet()) {
                if (!Character.isLetter(well.charAt(0))) continue;
                String row = well.substring(0, 1).trim();
                String column = well.substring(1).trim();
                if (!uniqueRows.contains(row) && row.length() > 0) {
                    uniqueRows.add(row);
                }
                if (uniqueColumns.contains(column) || column.length() <= 0) continue;
                uniqueColumns.add(column);
            }
            this.wellRows = uniqueRows.size();
            this.wellColumns = uniqueColumns.size();
            if (this.wellRows * this.wellColumns != this.wellCount) {
                this.adjustWellDimensions();
            }
        }
        int n = nChannels = this.getSizeC() == 0 ? this.channelNames.size() : Math.min(this.channelNames.size(), this.getSizeC());
        if (nChannels == 0) {
            nChannels = 1;
        }
        int nSlices = this.getSizeZ() == 0 ? 1 : this.getSizeZ();
        int nTimepoints = this.getSizeT();
        int nWells = this.wellCount;
        int nPos = 0;
        nPos = this.foundPositions ? this.fieldPositionX.length : this.fieldRows * this.fieldColumns;
        if (nPos == 0) {
            nPos = 1;
        }
        if ((list = (dataDir = new Location(dir, "data")).list(true)) == null) {
            list = dir.list(true);
        } else {
            dir = dataDir;
        }
        if ((nTimepoints == 0 || list.length < nTimepoints * nChannels * nSlices * nWells * nPos) && (nTimepoints = list.length / (nChannels * nWells * nPos * nSlices)) == 0) {
            nTimepoints = 1;
        }
        this.tiffs = new String[nChannels * nWells * nPos * nTimepoints * nSlices];
        Arrays.sort(list, new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                String label2;
                String dir2;
                int lastSeparator1 = s1.lastIndexOf(File.separator) + 1;
                int lastSeparator2 = s2.lastIndexOf(File.separator) + 1;
                String dir1 = s1.substring(0, lastSeparator1);
                if (!dir1.equals(dir2 = s2.substring(0, lastSeparator2))) {
                    return dir1.compareTo(dir2);
                }
                int dash1 = s1.indexOf("-", lastSeparator1);
                int dash2 = s2.indexOf("-", lastSeparator2);
                String label1 = dash1 < 0 ? "" : s1.substring(lastSeparator1, dash1);
                String string = label2 = dash2 < 0 ? "" : s2.substring(lastSeparator2, dash2);
                if (label1.equals(label2)) {
                    String remainder1 = dash1 < 0 ? s1 : s1.substring(dash1);
                    String remainder2 = dash2 < 0 ? s2 : s2.substring(dash2);
                    return remainder1.compareTo(remainder2);
                }
                Integer index1 = (Integer)ScanrReader.this.wellLabels.get(label1);
                Integer index2 = (Integer)ScanrReader.this.wellLabels.get(label2);
                if (index1 == null && index2 != null) {
                    return 1;
                }
                if (index1 != null && index2 == null) {
                    return -1;
                }
                return index1.compareTo(index2);
            }
        });
        int lastListIndex = 0;
        int next = 0;
        String[] keys = this.wellLabels.keySet().toArray(new String[this.wellLabels.size()]);
        Arrays.sort(keys, new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                char row1 = s1.charAt(0);
                char row2 = s2.charAt(0);
                Integer col1 = new Integer(s1.substring(1));
                Integer col2 = new Integer(s2.substring(1));
                if (row1 < row2) {
                    return -1;
                }
                if (row1 > row2) {
                    return 1;
                }
                return col1.compareTo(col2);
            }
        });
        int realPosCount = 0;
        for (int well = 0; well < nWells; ++well) {
            int missingWellFiles = 0;
            int wellIndex = this.wellNumbers.get(well);
            String wellPos = this.getBlock(wellIndex, "W");
            int originalIndex = next;
            for (int pos = 0; pos < nPos; ++pos) {
                String posPos = this.getBlock(pos + 1, "P");
                int posIndex = next;
                for (int z = 0; z < nSlices; ++z) {
                    String zPos = this.getBlock(z, "Z");
                    for (int t = 0; t < nTimepoints; ++t) {
                        String tPos = this.getBlock(t, "T");
                        for (int c = 0; c < nChannels; ++c) {
                            for (int i2 = lastListIndex; i2 < list.length; ++i2) {
                                String file3 = list[i2];
                                if (file3.indexOf(wellPos) == -1 || file3.indexOf(zPos) == -1 || file3.indexOf(posPos) == -1 || file3.indexOf(tPos) == -1 || file3.indexOf(this.channelNames.get(c)) == -1) continue;
                                this.tiffs[next++] = new Location(dir, file3).getAbsolutePath();
                                if (c != nChannels - 1) break;
                                lastListIndex = i2;
                                break;
                            }
                            if (next != originalIndex) continue;
                            ++missingWellFiles;
                        }
                    }
                }
                if (posIndex == next) continue;
                ++realPosCount;
            }
            if (next == originalIndex && well < keys.length) {
                this.wellLabels.remove(keys[well]);
            }
            if (next != originalIndex || missingWellFiles != nSlices * nTimepoints * nChannels * nPos) continue;
            this.wellNumbers.remove(well);
        }
        nWells = this.wellNumbers.size();
        if (this.wellLabels.size() > 0 && this.wellLabels.size() != nWells) {
            uniqueRows.clear();
            uniqueColumns.clear();
            for (String well : this.wellLabels.keySet()) {
                if (!Character.isLetter(well.charAt(0))) continue;
                String row = well.substring(0, 1).trim();
                String column = well.substring(1).trim();
                if (!uniqueRows.contains(row) && row.length() > 0) {
                    uniqueRows.add(row);
                }
                if (uniqueColumns.contains(column) || column.length() <= 0) continue;
                uniqueColumns.add(column);
            }
            nWells = uniqueRows.size() * uniqueColumns.size();
            this.adjustWellDimensions();
        }
        if (realPosCount < nPos) {
            nPos = realPosCount;
        }
        this.reader = new MinimalTiffReader();
        this.reader.setId(this.tiffs[0]);
        int sizeX = this.reader.getSizeX();
        int sizeY = this.reader.getSizeY();
        int pixelType = this.reader.getPixelType();
        this.tileWidth = this.reader.getOptimalTileWidth();
        this.tileHeight = this.reader.getOptimalTileHeight();
        switch (pixelType) {
            case 0: {
                pixelType = 1;
                break;
            }
            case 2: {
                pixelType = 3;
            }
        }
        boolean rgb = this.reader.isRGB();
        boolean interleaved = this.reader.isInterleaved();
        boolean indexed = this.reader.isIndexed();
        boolean littleEndian = this.reader.isLittleEndian();
        this.reader.close();
        int seriesCount = nWells * nPos;
        this.core.clear();
        for (int i3 = 0; i3 < seriesCount; ++i3) {
            CoreMetadata ms = new CoreMetadata();
            this.core.add(ms);
            ms.sizeC = nChannels;
            ms.sizeZ = nSlices;
            ms.sizeT = nTimepoints;
            ms.sizeX = sizeX;
            ms.sizeY = sizeY;
            ms.pixelType = pixelType;
            ms.rgb = rgb;
            ms.interleaved = interleaved;
            ms.indexed = indexed;
            ms.littleEndian = littleEndian;
            ms.dimensionOrder = "XYCTZ";
            ms.imageCount = nSlices * nTimepoints * nChannels;
            ms.bitsPerPixel = 12;
        }
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
        store.setPlateID(MetadataTools.createLSID("Plate", 0), 0);
        store.setPlateColumns(new PositiveInteger(this.wellColumns), 0);
        store.setPlateRows(new PositiveInteger(this.wellRows), 0);
        String plateAcqID = MetadataTools.createLSID("PlateAcquisition", 0, 0);
        store.setPlateAcquisitionID(plateAcqID, 0, 0);
        int nFields = 0;
        nFields = this.foundPositions ? this.fieldPositionX.length : this.fieldRows * this.fieldColumns;
        PositiveInteger fieldCount = FormatTools.getMaxFieldCount(nFields);
        if (fieldCount != null) {
            store.setPlateAcquisitionMaximumFieldCount(fieldCount, 0, 0);
        }
        for (i = 0; i < this.getSeriesCount(); ++i) {
            int well;
            int index;
            int field = i % nFields;
            for (index = well = i / nFields; this.wellNumbers.get(index) == null && index < this.wellNumbers.size(); ++index) {
            }
            int wellIndex = this.wellNumbers.get(index) == null ? index : this.wellNumbers.get(index) - 1;
            int wellRow = wellIndex / this.wellColumns;
            int wellCol = wellIndex % this.wellColumns;
            if (field == 0) {
                store.setWellID(MetadataTools.createLSID("Well", 0, well), 0, well);
                store.setWellColumn(new NonNegativeInteger(wellCol), 0, well);
                store.setWellRow(new NonNegativeInteger(wellRow), 0, well);
            }
            String wellSample = MetadataTools.createLSID("WellSample", 0, well, field);
            store.setWellSampleID(wellSample, 0, well, field);
            store.setWellSampleIndex(new NonNegativeInteger(i), 0, well, field);
            String imageID = MetadataTools.createLSID("Image", i);
            store.setWellSampleImageRef(imageID, 0, well, field);
            store.setImageID(imageID, i);
            String name = "Well " + (well + 1) + ", Field " + (field + 1) + " (Spot " + (i + 1) + ")";
            store.setImageName(name, i);
            store.setPlateAcquisitionWellSampleRef(wellSample, 0, 0, i);
        }
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            for (i = 0; i < this.getSeriesCount(); ++i) {
                for (int c = 0; c < this.getSizeC(); ++c) {
                    store.setChannelName(this.channelNames.get(c), i, c);
                }
                Length x = FormatTools.getPhysicalSizeX(this.pixelSize);
                Length y = FormatTools.getPhysicalSizeY(this.pixelSize);
                if (x != null) {
                    store.setPixelsPhysicalSizeX(x, i);
                }
                if (y != null) {
                    store.setPixelsPhysicalSizeY(y, i);
                }
                if (this.fieldPositionX == null || this.fieldPositionY == null) continue;
                int field = i % nFields;
                int well = i / nFields;
                Length posX = this.fieldPositionX[field];
                Length posY = this.fieldPositionY[field];
                store.setWellSamplePositionX(posX, 0, well, field);
                store.setWellSamplePositionY(posY, 0, well, field);
                for (int c = 0; c < this.getSizeC(); ++c) {
                    int image = this.getIndex(0, c, 0);
                    store.setPlaneTheZ(new NonNegativeInteger(0), i, image);
                    store.setPlaneTheC(new NonNegativeInteger(c), i, image);
                    store.setPlaneTheT(new NonNegativeInteger(0), i, image);
                    store.setPlanePositionX(this.fieldPositionX[field], i, image);
                    store.setPlanePositionY(this.fieldPositionY[field], i, image);
                    Double time = this.exposures.get(c);
                    if (time != null) {
                        time = time / 1000.0;
                        store.setPlaneExposureTime(new Time(time, UNITS.S), i, image);
                    }
                    if (this.deltaT == null) continue;
                    store.setPlaneDeltaT(new Time(this.deltaT, UNITS.S), i, image);
                }
            }
            String row = this.wellRows > 26 ? "Number" : "Letter";
            String col = this.wellRows > 26 ? "Letter" : "Number";
            store.setPlateRowNamingConvention(this.getNamingConvention(row), 0);
            store.setPlateColumnNamingConvention(this.getNamingConvention(col), 0);
            store.setPlateName(this.plateName, 0);
        }
    }

    private String getBlock(int index, String axis) {
        String b = String.valueOf(index);
        while (b.length() < 5) {
            b = "0" + b;
        }
        return axis + b;
    }

    private void adjustWellDimensions() {
        if (this.wellCount <= 8) {
            this.wellColumns = 2;
            this.wellRows = 4;
        } else if (this.wellCount <= 96) {
            this.wellColumns = 12;
            this.wellRows = 8;
        } else if (this.wellCount <= 384) {
            this.wellColumns = 24;
            this.wellRows = 16;
        }
    }

    static /* synthetic */ Length[] access$202(ScanrReader x0, Length[] x1) {
        x0.fieldPositionX = x1;
        return x1;
    }

    static /* synthetic */ Length[] access$302(ScanrReader x0, Length[] x1) {
        x0.fieldPositionY = x1;
        return x1;
    }

    class ScanrHandler
    extends BaseHandler {
        private String key;
        private String qName;
        private String wellIndex;
        private boolean validChannel = false;
        private boolean foundPlateLayout = false;
        private int nextXPos = 0;
        private int nextYPos = 0;
        private StringBuffer currentValue = new StringBuffer();

        ScanrHandler() {
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            String v = new String(ch, start, length);
            this.currentValue.append(v);
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            this.currentValue.setLength(0);
            this.qName = qName;
            if (qName.equals("Array") || qName.equals("Cluster")) {
                this.validChannel = true;
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            String v = this.currentValue.toString().trim();
            if (v.length() > 0) {
                if (qName.equals("Name")) {
                    this.key = v;
                    if (v.equals("subposition list")) {
                        ScanrReader.this.foundPositions = true;
                    } else if (v.equals("format typedef")) {
                        this.foundPlateLayout = true;
                    }
                } else if (qName.equals("Dimsize") && ScanrReader.this.foundPositions && ScanrReader.this.fieldPositionX == null) {
                    int nPositions = Integer.parseInt(v);
                    ScanrReader.access$202(ScanrReader.this, new Length[nPositions]);
                    ScanrReader.access$302(ScanrReader.this, new Length[nPositions]);
                } else if ("Rows".equals(this.key) && this.foundPlateLayout) {
                    ScanrReader.this.wellRows = Integer.parseInt(v);
                } else if ("Columns".equals(this.key) && this.foundPlateLayout) {
                    ScanrReader.this.wellColumns = Integer.parseInt(v);
                    this.foundPlateLayout = false;
                } else if (qName.equals("Val")) {
                    CoreMetadata ms0 = (CoreMetadata)ScanrReader.this.core.get(0);
                    ScanrReader.this.addGlobalMeta(this.key, v);
                    if (this.key.equals("columns/well")) {
                        ScanrReader.this.fieldColumns = Integer.parseInt(v);
                    } else if (this.key.equals("rows/well")) {
                        ScanrReader.this.fieldRows = Integer.parseInt(v);
                    } else if (this.key.equals("# slices")) {
                        ms0.sizeZ = Integer.parseInt(v);
                    } else if (this.key.equals("timeloop real")) {
                        ms0.sizeT = Integer.parseInt(v);
                    } else if (this.key.equals("timeloop count")) {
                        ms0.sizeT = Integer.parseInt(v) + 1;
                    } else if (this.key.equals("timeloop delay [ms]")) {
                        ScanrReader.this.deltaT = (double)Integer.parseInt(v) / 1000.0;
                    } else if (this.key.equals("name") && this.validChannel) {
                        if (!ScanrReader.this.channelNames.contains(v)) {
                            ScanrReader.this.channelNames.add(v);
                        }
                    } else if (this.key.equals("plate name")) {
                        ScanrReader.this.plateName = v;
                    } else if (this.key.equals("exposure time")) {
                        ScanrReader.this.exposures.add(new Double(v));
                    } else if (this.key.equals("idle") && this.validChannel) {
                        int lastIndex = ScanrReader.this.channelNames.size() - 1;
                        if (v.equals("0") && !((String)ScanrReader.this.channelNames.get(lastIndex)).equals("Autofocus")) {
                            ++ms0.sizeC;
                        } else {
                            ScanrReader.this.channelNames.remove(lastIndex);
                            ScanrReader.this.exposures.remove(lastIndex);
                        }
                    } else if (this.key.equals("well selection table + cDNA")) {
                        if (Character.isDigit(v.charAt(0))) {
                            this.wellIndex = v;
                            ScanrReader.this.wellNumbers.put(ScanrReader.this.wellCount, new Integer(v));
                            ScanrReader.this.wellCount++;
                        } else {
                            ScanrReader.this.wellLabels.put(v, new Integer(this.wellIndex));
                        }
                    } else if (this.key.equals("conversion factor um/pixel")) {
                        ScanrReader.this.pixelSize = new Double(v);
                    } else if (ScanrReader.this.foundPositions) {
                        if (this.nextXPos == this.nextYPos) {
                            if (this.nextXPos < ScanrReader.this.fieldPositionX.length) {
                                Double number = Double.valueOf(v);
                                Length length = new Length(number, UNITS.REFERENCEFRAME);
                                ((ScanrReader)ScanrReader.this).fieldPositionX[this.nextXPos++] = length;
                            }
                        } else if (this.nextYPos < ScanrReader.this.fieldPositionY.length) {
                            Double number = Double.valueOf(v);
                            Length length = new Length(number, UNITS.REFERENCEFRAME);
                            ((ScanrReader)ScanrReader.this).fieldPositionY[this.nextYPos++] = length;
                        }
                    }
                }
            }
            if (qName.equals("Array") || qName.equals("Cluster")) {
                this.validChannel = false;
            }
        }
    }
}

