/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model.enums;

import ome.units.quantity.Power;
import ome.xml.model.enums.Enumeration;
import ome.xml.model.enums.EnumerationException;
import ome.xml.model.enums.handlers.UnitsPowerEnumHandler;
import ome.xml.model.primitives.PrimitiveNumber;

public enum UnitsPower implements Enumeration
{
    YOTTAW("YW"),
    ZETTAW("ZW"),
    EXAW("EW"),
    PETAW("PW"),
    TERAW("TW"),
    GIGAW("GW"),
    MEGAW("MW"),
    KW("kW"),
    HW("hW"),
    DAW("daW"),
    W("W"),
    DW("dW"),
    CW("cW"),
    MW("mW"),
    MICROW("\u00b5W"),
    NW("nW"),
    PW("pW"),
    FW("fW"),
    AW("aW"),
    ZW("zW"),
    YW("yW");

    private final String value;

    private UnitsPower(String value) {
        this.value = value;
    }

    public static UnitsPower fromString(String value) throws EnumerationException {
        if ("YW".equals(value)) {
            return YOTTAW;
        }
        if ("ZW".equals(value)) {
            return ZETTAW;
        }
        if ("EW".equals(value)) {
            return EXAW;
        }
        if ("PW".equals(value)) {
            return PETAW;
        }
        if ("TW".equals(value)) {
            return TERAW;
        }
        if ("GW".equals(value)) {
            return GIGAW;
        }
        if ("MW".equals(value)) {
            return MEGAW;
        }
        if ("kW".equals(value)) {
            return KW;
        }
        if ("hW".equals(value)) {
            return HW;
        }
        if ("daW".equals(value)) {
            return DAW;
        }
        if ("W".equals(value)) {
            return W;
        }
        if ("dW".equals(value)) {
            return DW;
        }
        if ("cW".equals(value)) {
            return CW;
        }
        if ("mW".equals(value)) {
            return MW;
        }
        if ("\u00b5W".equals(value)) {
            return MICROW;
        }
        if ("nW".equals(value)) {
            return NW;
        }
        if ("pW".equals(value)) {
            return PW;
        }
        if ("fW".equals(value)) {
            return FW;
        }
        if ("aW".equals(value)) {
            return AW;
        }
        if ("zW".equals(value)) {
            return ZW;
        }
        if ("yW".equals(value)) {
            return YW;
        }
        String s = String.format("'%s' not a supported value of '%s'", value, UnitsPower.class);
        throw new EnumerationException(s);
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends PrimitiveNumber> Power create(T newValue, UnitsPower newUnit) {
        Power theQuantity = null;
        try {
            theQuantity = UnitsPowerEnumHandler.getQuantity(newValue, newUnit);
            return theQuantity;
        }
        finally {
            return theQuantity;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends Number> Power create(T newValue, UnitsPower newUnit) {
        Power theQuantity = null;
        try {
            theQuantity = UnitsPowerEnumHandler.getQuantity(newValue, newUnit);
            return theQuantity;
        }
        finally {
            return theQuantity;
        }
    }
}

