/*
 * Decompiled with CFR 0.152.
 */
package loci.plugins.in;

import ij.ImagePlus;
import ij.measure.Calibration;
import java.util.Arrays;
import loci.formats.FormatTools;
import loci.formats.meta.IMetadata;
import loci.plugins.in.ImportProcess;
import ome.units.UNITS;
import ome.units.quantity.Length;
import ome.units.quantity.Time;
import ome.xml.model.primitives.NonNegativeInteger;
import ome.xml.model.primitives.PositiveInteger;

public class Calibrator {
    private final ImportProcess process;

    public Calibrator(ImportProcess process) {
        this.process = process;
    }

    public void applyCalibration(ImagePlus imp) {
        String type;
        int pixelType;
        boolean signed;
        boolean hasCalibration;
        boolean tcalPresent;
        Time td;
        Length zd;
        Length yd;
        IMetadata meta = this.process.getOMEMetadata();
        int series = (Integer)imp.getProperty("Series");
        double xcal = Double.NaN;
        double ycal = Double.NaN;
        double zcal = Double.NaN;
        double tcal = Double.NaN;
        Length xd = meta.getPixelsPhysicalSizeX(series);
        if (xd != null) {
            xcal = xd.value(UNITS.MICROM).doubleValue();
        }
        if ((yd = meta.getPixelsPhysicalSizeY(series)) != null) {
            ycal = yd.value(UNITS.MICROM).doubleValue();
        }
        if ((zd = meta.getPixelsPhysicalSizeZ(series)) != null) {
            zcal = zd.value(UNITS.MICROM).doubleValue();
        }
        if ((td = meta.getPixelsTimeIncrement(series)) != null) {
            tcal = td.value(UNITS.S).doubleValue();
        }
        boolean xcalPresent = !Double.isNaN(xcal);
        boolean ycalPresent = !Double.isNaN(ycal);
        boolean zcalPresent = !Double.isNaN(zcal);
        boolean bl = tcalPresent = !Double.isNaN(tcal) && tcal != 0.0;
        if (xcalPresent && !ycalPresent) {
            ycal = xcal;
        } else if (ycalPresent && !xcalPresent) {
            xcal = ycal;
        }
        if (!tcalPresent) {
            tcal = this.computeVariableTimeInterval(meta, series);
        }
        xcalPresent = !Double.isNaN(xcal);
        ycalPresent = !Double.isNaN(ycal);
        zcalPresent = !Double.isNaN(zcal);
        tcalPresent = !Double.isNaN(tcal);
        boolean hasSpatial = xcalPresent || ycalPresent || zcalPresent;
        boolean bl2 = hasCalibration = hasSpatial || ycalPresent;
        if (hasCalibration) {
            Calibration cal = new Calibration();
            if (hasSpatial) {
                cal.setUnit("micron");
            }
            if (xcalPresent) {
                double d = cal.pixelWidth = xcal == 0.0 ? 1.0 : xcal;
            }
            if (ycalPresent) {
                double d = cal.pixelHeight = ycal == 0.0 ? 1.0 : ycal;
            }
            if (zcalPresent) {
                double d = cal.pixelDepth = zcal == 0.0 ? 1.0 : zcal;
            }
            if (tcalPresent) {
                cal.frameInterval = tcal == 0.0 ? 1.0 : tcal;
            }
            imp.setCalibration(cal);
        }
        boolean bl3 = signed = (pixelType = FormatTools.pixelTypeFromString(type = meta.getPixelsType(series).toString())) == 0 || pixelType == 2;
        if (signed) {
            int bitsPerPixel = FormatTools.getBytesPerPixel(pixelType) * 8;
            double min = -1.0 * Math.pow(2.0, bitsPerPixel - 1);
            imp.getLocalCalibration().setFunction(0, new double[]{min, 1.0}, "gray value");
        }
    }

    private double computeVariableTimeInterval(IMetadata meta, int series) {
        PositiveInteger sizeT = meta.getPixelsSizeT(series);
        int tSize = sizeT == null ? 1 : (Integer)sizeT.getValue();
        int planeCount = meta.getPlaneCount(series);
        Object[] deltas = new Time[tSize];
        Arrays.fill(deltas, new Time(Double.NaN, UNITS.S));
        for (int p = 0; p < planeCount; ++p) {
            Time deltaT;
            int t;
            NonNegativeInteger theZ = meta.getPlaneTheZ(series, p);
            NonNegativeInteger theC = meta.getPlaneTheC(series, p);
            NonNegativeInteger theT = meta.getPlaneTheT(series, p);
            if (theZ == null || theC == null || theT == null || (Integer)theZ.getValue() != 0 || (Integer)theC.getValue() != 0 || (t = ((Integer)theT.getValue()).intValue()) >= tSize || (deltaT = meta.getPlaneDeltaT(series, p)) == null) continue;
            deltas[t] = deltaT;
        }
        double tiTotal = 0.0;
        int tiCount = 0;
        for (int t = 1; t < tSize; ++t) {
            double delta1 = ((Time)deltas[t - 1]).value(UNITS.S).doubleValue();
            double delta2 = ((Time)deltas[t]).value(UNITS.S).doubleValue();
            if (Double.isNaN(delta1) || Double.isNaN(delta2)) continue;
            tiTotal += delta2 - delta1;
            ++tiCount;
        }
        if (tiCount == 0) {
            return Double.NaN;
        }
        return (float)(tiTotal / (double)tiCount);
    }
}

