package plugins.nchenouard.particletracking.legacytracker.associationMethod;

import java.util.ArrayList;
import java.util.LinkedList;

import plugins.nchenouard.spot.Spot;

/**
 * @author nicolas chenouard
 * @date 30/08/2007
 **/
public class SolveOBAssociation extends AssignProblemSolver
{
	public final static int methoId = 1;
	protected final boolean addNewObjects;

	public SolveOBAssociation(boolean addNewObjects)
	{
		this.addNewObjects = addNewObjects;
	}

	void buildDown5(LinkedList<Integer> prevDetections, double[][] likelihoods, ArrayList<LinkedList<Integer>> feasibleHypothesis, int trackId, int numTracks, int numDetect)
	{
		for (int i =0; i<numDetect; i++)
		{
			if (feasibleHyp5(prevDetections, trackId, i, likelihoods))
			{
				LinkedList<Integer> detections = new LinkedList<Integer>(prevDetections);
				detections.addLast(new Integer(i));
				if ((trackId+1)<numTracks)
					buildDown5(detections, likelihoods, feasibleHypothesis, trackId+1, numTracks, numDetect);
				else
					feasibleHypothesis.add(detections);
			}
		}
	}

	void buildDown6(LinkedList<Integer> prevTracks, double[][] likelihoods, ArrayList<LinkedList<Integer>> feasibleHypothesis, int detect, int numTracks, int numDetect)
	{
		for (int i =0; i<numTracks; i++)
		{
			if (feasibleHyp6(prevTracks, detect, i, likelihoods))
			{
				LinkedList<Integer> tracks = new LinkedList<Integer>(prevTracks);
				tracks.addLast(new Integer(i));
				if ((detect+1)<numDetect)
					buildDown6(tracks, likelihoods, feasibleHypothesis, detect+1, numTracks, numDetect);
				else
					feasibleHypothesis.add(tracks);
			}
		}
	}

	boolean feasibleHyp5(LinkedList<Integer> usedDetections, int trackId, int detectId, double[][] likelihoods)
	{
		if (likelihoods[detectId][trackId]<=0)
			return false;
		if (usedDetections.contains(new Integer(detectId)))
			return false;
		return true;
	}

	boolean feasibleHyp6(LinkedList<Integer> usedTracks, int detectId, int trackId, double[][] likelihoods)
	{
		if (likelihoods[detectId][trackId]<=0)
			return false;
		if (usedTracks.contains(new Integer(trackId)))
			return false;
		return true;
	}
	
	double measurementCombinationLikelihood(int[] combination, double[][] likelihoods)
	{
		double l = 1;
		for (int i = 0; i<combination.length; i++)
			l*=likelihoods[combination[i]][i];
		return l;
	}
	
	double permutationLikelihood(int[] permutation, double[][] likelihoods)
	{
		double l = 1;
		for (int i = 0; i < permutation.length; i++)
			l*= likelihoods[i][permutation[i]];
		return l;
	}

	double permutationInnovation(int[] permutation, double[][] innovation)
	{
		double l = 0;
		for (int i = 0; i < permutation.length; i++)
			l+= innovation[i][permutation[i]];
		return l;
	}
	
	public void solve(AssignProblem pb)
	{	
		int numTracks = pb.tracks.size();
		int numDetect = pb.detections.size();

		pb.tracksToBeCreated.clear();
		pb.tracksToBeProlongated.clear();

		// case 1 : 1 prediction faces 1 measurement
		// no conflict, the single track selects the single measurement 
		if(numTracks == 1 && numDetect == 1)
		{ 
			solve1(pb);
			return;
		}

		// case 2 : 0 prediction faces 1 measurement
		// a track is created from the measurement.
		// (we can try with default profile to determine the number potential fused detections)

		if(numTracks == 0 && numDetect == 1)
		{ 
			solve2(pb);
			return;
		}
		// case 3 : 1 prediction faces 0 measurement
		// the track is prolongated with prediction
		// we can try to re-detect with profiles detection method

		if(numTracks == 1 && numDetect  == 0)
		{
			solve3(pb);
			return;
		}

		//case 4 : n predictions for n measurements
		//simplification : there is no fused spots nor new spot, there is a one-to-one association between measurements and tracks
		if (numTracks == numDetect)
		{
			solve4(pb, numTracks);
			return;
		}
		//General case : n predictions != m measurements
		else
		{
			//case 5 : n predictions < m measurements
			if(numTracks < numDetect)
			{
				solve5(pb, numTracks, numDetect);
			}
			//case 6 :	n predictions > m mesurements
			//we must find if some tracks has disappeared or if some has fused
			else
			{
				solve6(pb, numTracks, numDetect);
				return;
			}
		}
	}
	
	protected void solve1(AssignProblem pb)
	{
		Track  track       = (Track)  pb.tracks.get(0);
		Spot spot = (Spot) pb.detections.get(0);
		track.associate(spot, pb.t);
	}
	
	protected void solve2(AssignProblem pb)
	{
		if (addNewObjects)
			pb.tracksToBeCreated.add(pb.detections.get(0));
	}
	
	protected void solve3(AssignProblem pb)
	{
		pb.tracksToBeProlongated.add(pb.tracks.get(0));
	}

	protected void solve4(AssignProblem pb, int numTracks)
	{
		//FIXME a permutation generator is required
//		int [] bestHyp = new int[numTracks];
//		double bestLikelihood = 0;
//		PermutationGenerator pg = new PermutationGenerator(numTracks);
//		while(pg.hasMore())
//		{
//			int[] permutation = pg.getNext();
//			double likelihood = permutationLikelihood(permutation, pb.likelihoods);
//			if (likelihood >= bestLikelihood)
//			{
//				System.arraycopy(permutation, 0, bestHyp, 0, numTracks);
//				bestLikelihood  = likelihood;
//			}
//		}
//		if (bestLikelihood==0)
//		{	
//			System.out.println("Likelihood null in SolveOBAssociation.solve4");
//			for (Spot s:pb.detections)
//			{
//				System.out.println(" [" +s.mass_center.x + " "+s.mass_center.y+" "+s.mass_center.y+"]");
//			}
//			for (Track trk :pb.tracks)
//			{
//				System.out.print(" "+trk.getId()+" |");
//			}
//			for (int i = 0; i < pb.likelihoods.length; i++)
//			{
//				for(int j = 0; j < pb.likelihoods[i].length;j++)
//					System.out.print("    |    "+pb.likelihoods[i][j]);
//				System.out.println();
//			}
//		}
//		for (int i = 0; i < numTracks; i++)
//		{
//			Track track = (pb.tracks.get(bestHyp[i]));
//			track.associate((Spot)pb.detections.get(i), pb.t);
//		}
	}

	//num tracks < num measurements
	protected void solve5(AssignProblem pb, int numTracks, int numDetect)
	{
		//build feasible hypothesis
		ArrayList<LinkedList<Integer>> feasibleHypothesis = new ArrayList<LinkedList<Integer>>(); 
		int trackId = 0;
		for (int i =0; i<numDetect; i++)
		{
			if (pb.likelihoods[i][trackId]>0)
			{
				LinkedList<Integer> detections = new LinkedList<Integer>();
				detections.addLast(new Integer(i));
				if ((trackId+1)<numTracks)
					buildDown5(detections, pb.likelihoods, feasibleHypothesis, trackId+1, numTracks, numDetect);
				else
					feasibleHypothesis.add(detections);
			}
		}
		
		//select best hypothesis
		LinkedList<Integer> bestHyp= null;
		double bestLikelihood = 0;
		for (LinkedList<Integer> l:feasibleHypothesis)
		{
			double likelihood = 1;
			int track = 0;
			for (Integer detectId:l)
			{
				likelihood*=pb.likelihoods[detectId.intValue()][track];
				track++;
			}
			if (likelihood>bestLikelihood)
			{
				bestLikelihood = likelihood;
				bestHyp = l;
			}
		}
		if (bestHyp!=null)
		{
		int trackNum = 0;
		for (Integer detectId:bestHyp)
		{
			Track track = (pb.tracks.get(trackNum));
			track.associate((Spot)pb.detections.get(detectId.intValue()), pb.t);
			trackNum++;
		}
		for (int i =0; i < numDetect; i++)
		{
			if (!bestHyp.contains(new Integer(i)))
				pb.tracksToBeCreated.add(pb.detections.get(i));
		}
		}
		else
		{
			System.out.println("best hypothesis null in SolveOBAssociation solve 6");
			for (int i =0; i < numDetect; i++)
				pb.tracksToBeCreated.add(pb.detections.get(i));
		}
	}

	//num Tracks > num detect
	protected void solve6(AssignProblem pb, int numTracks, int numDetect)
	{
		ArrayList<LinkedList<Integer>> feasibleHypothesis = new ArrayList<LinkedList<Integer>>(); 
		int detect = 0;
		for (int i =0; i<numTracks; i++)
		{
			if (pb.likelihoods[detect][i]>0)
			{
				LinkedList<Integer> tracks = new LinkedList<Integer>();
				tracks.addLast(new Integer(i));
				if ((detect+1)<numDetect)
					buildDown6(tracks, pb.likelihoods, feasibleHypothesis, detect+1, numTracks, numDetect);
				else
					feasibleHypothesis.add(tracks);
			}
		}
		
		LinkedList<Integer> bestHyp = null;
		double bestLikelihood = 0;
		for (LinkedList<Integer> l:feasibleHypothesis)
		{
			double likelihood = 1;
			int detectId = 0;
			for (Integer trackId:l)
			{
				likelihood*=pb.likelihoods[detectId][trackId.intValue()];
				detectId++;
			}
			if (likelihood>bestLikelihood)
			{
				bestLikelihood = likelihood;
				bestHyp = l;
			}
		}
		if (bestHyp!=null)
		{
		int detectId = 0;
		for (Integer trackId:bestHyp)
		{
			Track track = (pb.tracks.get(trackId.intValue()));
			track.associate((Spot)pb.detections.get(detectId), pb.t);
			detectId++;
		}
		for (int i =0; i < numTracks; i++)
		{
			if (!bestHyp.contains(new Integer(i)))
				pb.tracksToBeProlongated.add(pb.tracks.get(i));
		}
		}
		else
		{
			System.out.println("best hypothesis null in SolveOBAssociation solve 6");
			for (int i =0; i < numTracks; i++)

					pb.tracksToBeProlongated.add(pb.tracks.get(i));
		}
	}

	double trackCombinationLikelihood(int[] combination, double[][] likelihoods)
	{
		double l = 1;
		for (int i = 0; i<combination.length; i++)
			l*=likelihoods[i][combination[i]];
//		PluginConsole.println("l2 "+l);
		return l;
	}

}
