/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.ImageRoi;
import ij.gui.Overlay;
import ij.gui.PointRoi;
import ij.gui.Roi;
import ij.gui.TextRoi;
import ij.measure.Calibration;
import ij.measure.ResultsTable;
import ij.plugin.Colors;
import ij.plugin.filter.Analyzer;
import ij.process.FloatPolygon;
import ij.text.TextWindow;
import ij.util.Tools;
import java.awt.Color;
import java.awt.Font;

public class RoiProperties {
    private ImagePlus imp;
    private Roi roi;
    private Overlay overlay;
    private String title;
    private boolean showName = true;
    private boolean showListCoordinates;
    private boolean addToOverlay;
    private boolean overlayOptions;
    private boolean setPositions;
    private boolean listCoordinates;
    private boolean listProperties;
    private static final String[] justNames = new String[]{"Left", "Center", "Right"};
    private int nProperties;

    public RoiProperties(String title, Roi roi) {
        if (roi == null) {
            throw new IllegalArgumentException("ROI is null");
        }
        this.title = title;
        this.showName = title.startsWith("Prop");
        this.showListCoordinates = this.showName && title.endsWith(" ");
        this.nProperties = this.showListCoordinates ? roi.getPropertyCount() : 0;
        this.addToOverlay = title.equals("Add to Overlay");
        this.overlayOptions = title.equals("Overlay Options");
        if (this.overlayOptions) {
            this.imp = WindowManager.getCurrentImage();
            this.overlay = this.imp != null ? this.imp.getOverlay() : null;
            this.setPositions = roi.getPosition() != 0;
        }
        this.roi = roi;
    }

    private String decodeColor(Color color, Color defaultColor) {
        String lc;
        String str;
        if (color == null) {
            color = defaultColor;
        }
        if ((str = "#" + Integer.toHexString(color.getRGB())).length() == 9 && str.startsWith("#ff")) {
            str = "#" + str.substring(3);
        }
        if ((lc = Colors.hexToColor(str)) != null) {
            str = lc;
        }
        return str;
    }

    public boolean showDialog() {
        boolean newOverlay;
        String nameLabel;
        String name = this.roi.getName();
        boolean isRange = name != null && name.startsWith("range:");
        String string = nameLabel = isRange ? "Range:" : "Name:";
        if (isRange) {
            name = name.substring(7);
        }
        if (name == null) {
            name = "";
        }
        if (!isRange && this.roi instanceof ImageRoi && !this.overlayOptions) {
            return this.showImageDialog(name);
        }
        Color strokeColor = this.roi.getStrokeColor();
        Color fillColor = this.roi.getFillColor();
        double strokeWidth = this.roi.getStrokeWidth();
        boolean isText = this.roi instanceof TextRoi;
        boolean isLine = this.roi.isLine();
        boolean isPoint = this.roi instanceof PointRoi;
        int justification = 0;
        double angle = 0.0;
        boolean antialias = true;
        if (isText) {
            TextRoi troi = (TextRoi)this.roi;
            Font font = troi.getCurrentFont();
            strokeWidth = font.getSize();
            angle = troi.getAngle();
            justification = troi.getJustification();
            antialias = troi.getAntialiased();
        }
        String position = "" + this.roi.getPosition();
        int cpos = this.roi.getCPosition();
        int zpos = this.roi.getZPosition();
        int tpos = this.roi.getTPosition();
        if (cpos > 0 || zpos > 0 || tpos > 0) {
            position = cpos + "," + zpos + "," + tpos;
        }
        if (position.equals("0")) {
            position = "none";
        }
        String linec = Colors.colorToString(strokeColor);
        String fillc = Colors.colorToString(fillColor);
        if (IJ.isMacro()) {
            fillc = "none";
            this.setPositions = false;
        }
        int digits = (double)((int)strokeWidth) == strokeWidth ? 0 : 1;
        GenericDialog gd = new GenericDialog(this.title);
        if (this.showName) {
            gd.addStringField(nameLabel, name, 15);
            gd.addStringField("Position:", position);
        }
        if (isText) {
            gd.addStringField("Stroke color:", linec);
            gd.addNumericField("Font size:", strokeWidth, digits, 4, "points");
            digits = (double)((int)angle) == angle ? 0 : 1;
            gd.addNumericField("Angle:", angle, digits, 4, "degrees");
            gd.setInsets(0, 0, 0);
            gd.addChoice("Justification:", justNames, justNames[justification]);
        } else if (isPoint) {
            gd.addStringField("Stroke (point) color:", linec);
        } else {
            gd.addStringField("Stroke color:", linec);
            gd.addNumericField("Width:", strokeWidth, digits);
        }
        if (!isLine) {
            if (isPoint) {
                int index = ((PointRoi)this.roi).getPointType();
                gd.addChoice("Point type:", PointRoi.types, PointRoi.types[index]);
                index = ((PointRoi)this.roi).getSize();
                gd.addChoice("Size:", PointRoi.sizes, PointRoi.sizes[index]);
            } else {
                gd.addMessage("");
                gd.addStringField("Fill color:", fillc);
            }
        }
        if (this.addToOverlay) {
            gd.addCheckbox("New overlay", false);
        }
        if (this.overlayOptions) {
            gd.addCheckbox("Set stack positions", this.setPositions);
            if (this.overlay != null) {
                int size = this.overlay.size();
                gd.setInsets(15, 20, 0);
                if (this.imp != null && this.imp.getHideOverlay()) {
                    gd.addMessage("Current overlay is hidden", null, Color.darkGray);
                } else {
                    gd.addMessage("Current overlay has " + size + " element" + (size > 1 ? "s" : ""), null, Color.darkGray);
                }
                gd.setInsets(0, 30, 0);
                gd.addCheckbox("Apply", false);
                gd.setInsets(0, 30, 0);
                gd.addCheckbox("Show labels", this.overlay.getDrawLabels());
                gd.setInsets(0, 30, 0);
                gd.addCheckbox("Hide", this.imp != null ? this.imp.getHideOverlay() : false);
            } else {
                gd.addMessage("No overlay", null, Color.darkGray);
            }
        }
        if (isText) {
            gd.addCheckbox("Antialiased text", antialias);
        }
        if (this.showListCoordinates) {
            int n = this.roi.getFloatPolygon().npoints;
            gd.addCheckbox("List coordinates (" + n + ")", this.listCoordinates);
            if (this.nProperties > 0) {
                gd.addCheckbox("List properties (" + this.nProperties + ")", this.listProperties);
            } else {
                gd.setInsets(5, 20, 0);
                gd.addMessage("No properties");
            }
        }
        if (this.showName && "".equals(name) && "none".equals(position) && "none".equals(fillc)) {
            gd.setSmartRecording(true);
        }
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        String position2 = "";
        if (this.showName) {
            name = gd.getNextString();
            if (!isRange) {
                this.roi.setName(name.length() > 0 ? name : null);
            }
            position2 = gd.getNextString();
        }
        linec = gd.getNextString();
        if (!isPoint) {
            strokeWidth = gd.getNextNumber();
        }
        if (isText) {
            angle = gd.getNextNumber();
            justification = gd.getNextChoiceIndex();
        }
        if (!isLine) {
            if (isPoint) {
                int index = gd.getNextChoiceIndex();
                ((PointRoi)this.roi).setPointType(index);
                index = gd.getNextChoiceIndex();
                ((PointRoi)this.roi).setSize(index);
            } else {
                fillc = gd.getNextString();
            }
        }
        boolean applyToOverlay = false;
        boolean bl = newOverlay = this.addToOverlay ? gd.getNextBoolean() : false;
        if (this.overlayOptions) {
            this.setPositions = gd.getNextBoolean();
            if (this.overlay != null) {
                applyToOverlay = gd.getNextBoolean();
                boolean labels = gd.getNextBoolean();
                boolean hideOverlay = gd.getNextBoolean();
                if (hideOverlay && this.imp != null) {
                    if (!this.imp.getHideOverlay()) {
                        this.imp.setHideOverlay(true);
                    }
                } else {
                    this.overlay.drawLabels(labels);
                    this.overlay.drawBackgrounds(true);
                    if (this.imp.getHideOverlay()) {
                        this.imp.setHideOverlay(false);
                    }
                    if (!applyToOverlay && this.imp != null) {
                        this.imp.draw();
                    }
                }
            }
            this.roi.setPosition(this.setPositions ? 1 : 0);
        }
        if (isText) {
            antialias = gd.getNextBoolean();
        }
        if (this.showListCoordinates) {
            this.listCoordinates = gd.getNextBoolean();
            if (this.nProperties > 0) {
                this.listProperties = gd.getNextBoolean();
            }
        }
        strokeColor = Colors.decode(linec, null);
        fillColor = Colors.decode(fillc, null);
        if (isText) {
            TextRoi troi = (TextRoi)this.roi;
            Font font = troi.getCurrentFont();
            if ((int)strokeWidth != font.getSize()) {
                font = new Font(font.getName(), font.getStyle(), (int)strokeWidth);
                troi.setCurrentFont(font);
            }
            troi.setAngle(angle);
            if (justification != troi.getJustification()) {
                troi.setJustification(justification);
            }
            troi.setAntialiased(antialias);
        } else {
            this.roi.setStrokeWidth((float)strokeWidth);
        }
        if (this.showName) {
            this.setPosition(this.roi, position, position2);
        }
        this.roi.setStrokeColor(strokeColor);
        this.roi.setFillColor(fillColor);
        if (newOverlay) {
            this.roi.setName("new-overlay");
        }
        if (applyToOverlay) {
            if (this.imp == null || this.overlay == null) {
                return true;
            }
            Roi[] rois = this.overlay.toArray();
            for (int i = 0; i < rois.length; ++i) {
                rois[i].setStrokeColor(strokeColor);
                rois[i].setStrokeWidth((float)strokeWidth);
                rois[i].setFillColor(fillColor);
            }
            this.imp.draw();
        }
        if (this.listCoordinates) {
            this.listCoordinates(this.roi);
        }
        if (this.listProperties && this.nProperties > 0) {
            this.listProperties(this.roi);
        }
        return true;
    }

    private void setPosition(Roi roi, String pos1, String pos2) {
        if (pos1.equals(pos2)) {
            return;
        }
        if (pos2.equals("none") || pos2.equals("0")) {
            roi.setPosition(0);
            return;
        }
        String[] positions = Tools.split(pos2, " ,");
        if (positions.length == 1) {
            double stackPos = Tools.parseDouble(positions[0]);
            if (!Double.isNaN(stackPos)) {
                roi.setPosition((int)stackPos);
            }
            return;
        }
        if (positions.length == 3) {
            int[] pos = new int[3];
            for (int i = 0; i < 3; ++i) {
                double dpos = Tools.parseDouble(positions[i]);
                if (Double.isNaN(dpos)) {
                    return;
                }
                pos[i] = (int)dpos;
            }
            roi.setPosition(pos[0], pos[1], pos[2]);
            return;
        }
    }

    public boolean showImageDialog(String name) {
        boolean newOverlay;
        GenericDialog gd = new GenericDialog(this.title);
        gd.addStringField("Name:", name, 15);
        gd.addNumericField("Opacity (0-100%):", ((ImageRoi)this.roi).getOpacity() * 100.0, 0);
        if (this.addToOverlay) {
            gd.addCheckbox("New Overlay", false);
        }
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        name = gd.getNextString();
        this.roi.setName(name.length() > 0 ? name : null);
        double opacity = gd.getNextNumber() / 100.0;
        ((ImageRoi)this.roi).setOpacity(opacity);
        boolean bl = newOverlay = this.addToOverlay ? gd.getNextBoolean() : false;
        if (newOverlay) {
            this.roi.setName("new-overlay");
        }
        return true;
    }

    void listCoordinates(Roi roi) {
        int i;
        if (roi == null) {
            return;
        }
        boolean allIntegers = true;
        FloatPolygon fp = roi.getFloatPolygon();
        ImagePlus imp = roi.getImage();
        String title = "Coordinates";
        if (imp != null) {
            Calibration cal = imp.getCalibration();
            if (cal.pixelWidth != 1.0 || cal.pixelHeight != 1.0) {
                i = 0;
                while (i < fp.npoints) {
                    int n = i;
                    fp.xpoints[n] = (float)((double)fp.xpoints[n] * cal.pixelWidth);
                    int n2 = i++;
                    fp.ypoints[n2] = (float)((double)fp.ypoints[n2] * cal.pixelHeight);
                }
                allIntegers = false;
            }
            title = imp.getTitle();
        }
        if (allIntegers) {
            for (int i2 = 0; i2 < fp.npoints; ++i2) {
                if ((float)((int)fp.xpoints[i2]) == fp.xpoints[i2] && (float)((int)fp.ypoints[i2]) == fp.ypoints[i2]) continue;
                allIntegers = false;
                break;
            }
        }
        ResultsTable rt = new ResultsTable();
        rt.setPrecision(allIntegers ? 0 : Analyzer.getPrecision());
        for (i = 0; i < fp.npoints; ++i) {
            rt.incrementCounter();
            rt.addValue("X", (double)fp.xpoints[i]);
            rt.addValue("Y", (double)fp.ypoints[i]);
        }
        rt.showRowNumbers(false);
        rt.show("XY_" + title);
    }

    void listProperties(Roi roi) {
        String props = roi.getProperties();
        if (props == null) {
            return;
        }
        props = props.replaceAll(": ", "\t");
        new TextWindow("Properties", "Key\tValue", props, 300, 300);
    }
}

