/*
 * Decompiled with CFR 0.152.
 */
package ij.measure;

import ij.ImagePlus;
import ij.measure.CurveFitter;
import ij.plugin.filter.Analyzer;

public class Calibration
implements Cloneable {
    public static final int STRAIGHT_LINE = 0;
    public static final int POLY2 = 1;
    public static final int POLY3 = 2;
    public static final int POLY4 = 3;
    public static final int EXPONENTIAL = 4;
    public static final int POWER = 5;
    public static final int LOG = 6;
    public static final int RODBARD = 7;
    public static final int GAMMA_VARIATE = 8;
    public static final int LOG2 = 9;
    public static final int RODBARD2 = 10;
    public static final int EXP_WITH_OFFSET = 11;
    public static final int GAUSSIAN = 12;
    public static final int EXP_RECOVERY = 13;
    public static final int NONE = 20;
    public static final int UNCALIBRATED_OD = 21;
    public static final int CUSTOM = 22;
    public static final String DEFAULT_VALUE_UNIT = "Gray Value";
    private static final int UNKNOWN = 0;
    public double pixelWidth = 1.0;
    public double pixelHeight = 1.0;
    public double pixelDepth = 1.0;
    public double frameInterval;
    public double fps;
    private static boolean loopBackAndForth;
    public boolean loop = loopBackAndForth;
    public double xOrigin;
    public double yOrigin;
    public double zOrigin;
    public String info;
    private double[] coefficients;
    private String unit = "pixel";
    private String yunit;
    private String zunit;
    private String units;
    private String valueUnit = "Gray Value";
    private String timeUnit = "sec";
    private int function = 20;
    private float[] cTable;
    private boolean invertedLut;
    private int bitDepth = 0;
    private boolean zeroClip;
    private boolean invertY;

    public Calibration(ImagePlus imp) {
        if (imp != null) {
            this.bitDepth = imp.getBitDepth();
            this.invertedLut = imp.isInvertedLut();
        }
    }

    public Calibration() {
    }

    public boolean scaled() {
        return this.pixelWidth != 1.0 || this.pixelHeight != 1.0 || this.pixelDepth != 1.0 || !this.unit.equals("pixel");
    }

    public void setUnit(String unit) {
        this.unit = Calibration.sanitizeUnit(unit);
        this.units = null;
    }

    public void setXUnit(String unit) {
        this.setUnit(unit);
    }

    public void setYUnit(String unit) {
        this.yunit = unit == null || unit.equals("") ? null : Calibration.sanitizeUnit(unit);
    }

    public void setZUnit(String unit) {
        this.zunit = unit == null || unit.equals("") ? null : Calibration.sanitizeUnit(unit);
    }

    private static String sanitizeUnit(String unit) {
        if (unit == null || unit.equals("")) {
            return "pixel";
        }
        if (unit.equals("um")) {
            unit = "\u00b5m";
        }
        return unit;
    }

    public String getUnit() {
        return this.unit;
    }

    public String getXUnit() {
        return this.unit;
    }

    public String getYUnit() {
        return this.yunit != null ? this.yunit : this.unit;
    }

    public String getZUnit() {
        return this.zunit != null ? this.zunit : this.unit;
    }

    public String getUnits() {
        if (this.units == null) {
            this.units = this.unit.equals("pixel") ? "pixels" : (this.unit.equals("micron") ? "microns" : (this.unit.equals("inch") ? "inches" : this.unit));
        }
        return this.units;
    }

    public void setTimeUnit(String unit) {
        this.timeUnit = unit == null || unit.equals("") ? "sec" : unit;
    }

    public String getTimeUnit() {
        return this.timeUnit;
    }

    public double getX(double x) {
        return (x - this.xOrigin) * this.pixelWidth;
    }

    public double getY(double y) {
        return (y - this.yOrigin) * this.pixelHeight;
    }

    public double getY(double y, int imageHeight) {
        if (this.invertY || (Analyzer.getMeasurements() & 0x1000) != 0) {
            if (this.yOrigin != 0.0) {
                return (this.yOrigin - y) * this.pixelHeight;
            }
            return ((double)imageHeight - y - 1.0) * this.pixelHeight;
        }
        return (y - this.yOrigin) * this.pixelHeight;
    }

    public double getZ(double z) {
        return (z - this.zOrigin) * this.pixelDepth;
    }

    public double getRawX(double x) {
        return x / this.pixelWidth + this.xOrigin;
    }

    public double getRawY(double y) {
        return y / this.pixelHeight + this.yOrigin;
    }

    public double getRawY(double y, int imageHeight) {
        if (this.invertY || (Analyzer.getMeasurements() & 0x1000) != 0) {
            if (this.yOrigin != 0.0) {
                return this.yOrigin - y / this.pixelHeight;
            }
            return (double)imageHeight - y / this.pixelHeight - 1.0;
        }
        return y / this.pixelHeight + this.yOrigin;
    }

    public void setFunction(int function, double[] coefficients, String unit) {
        this.setFunction(function, coefficients, unit, false);
    }

    public void setFunction(int function, double[] coefficients, String unit, boolean zeroClip) {
        if (function == 20) {
            this.disableDensityCalibration();
            return;
        }
        if (coefficients == null && function >= 0 && function <= 13) {
            return;
        }
        this.function = function;
        this.coefficients = coefficients;
        this.zeroClip = zeroClip;
        if (unit != null) {
            this.valueUnit = unit;
        }
        this.cTable = null;
    }

    public void setImage(ImagePlus imp) {
        if (imp == null) {
            return;
        }
        int type = imp.getType();
        int newBitDepth = imp.getBitDepth();
        if (newBitDepth == 16 && imp.getLocalCalibration().isSigned16Bit()) {
            double[] coeff = new double[]{-32768.0, 1.0};
            this.setFunction(0, coeff, DEFAULT_VALUE_UNIT);
        } else if (newBitDepth != this.bitDepth && this.bitDepth != 0 || type == 2 || type == 4) {
            String saveUnit = this.valueUnit;
            this.disableDensityCalibration();
            if (type == 2) {
                this.valueUnit = saveUnit;
            }
        }
        this.bitDepth = newBitDepth;
    }

    public void disableDensityCalibration() {
        this.function = 20;
        this.coefficients = null;
        this.cTable = null;
        this.valueUnit = DEFAULT_VALUE_UNIT;
    }

    public String getValueUnit() {
        return this.valueUnit;
    }

    public void setValueUnit(String unit) {
        if (unit != null) {
            this.valueUnit = unit;
        }
    }

    public double[] getCoefficients() {
        return this.coefficients;
    }

    public boolean calibrated() {
        return this.function != 20;
    }

    public int getFunction() {
        return this.function;
    }

    public float[] getCTable() {
        if (this.cTable == null) {
            this.makeCTable();
        }
        return this.cTable;
    }

    public void setCTable(float[] table, String unit) {
        if (table == null) {
            this.disableDensityCalibration();
            return;
        }
        if (this.bitDepth == 0) {
            if (table.length == 256) {
                this.bitDepth = 8;
            } else if (table.length == 65536) {
                this.bitDepth = 16;
            }
        }
        if (this.bitDepth == 16 && table.length != 65536) {
            throw new IllegalArgumentException("Table.length!=65536");
        }
        this.cTable = table;
        this.function = 22;
        this.coefficients = null;
        this.zeroClip = false;
        if (unit != null) {
            this.valueUnit = unit;
        }
    }

    void makeCTable() {
        if (this.bitDepth == 16) {
            this.make16BitCTable();
            return;
        }
        if (this.bitDepth == 0) {
            this.bitDepth = 8;
        }
        if (this.bitDepth != 8) {
            return;
        }
        if (this.function == 21) {
            this.cTable = new float[256];
            for (int i = 0; i < 256; ++i) {
                this.cTable[i] = (float)this.od(i);
            }
        } else if (this.function >= 0 && this.function <= 13 && this.coefficients != null) {
            this.cTable = new float[256];
            for (int i = 0; i < 256; ++i) {
                double value = CurveFitter.f(this.function, this.coefficients, i);
                this.cTable[i] = this.zeroClip && value < 0.0 ? 0.0f : (float)value;
            }
        } else {
            this.cTable = null;
        }
    }

    void make16BitCTable() {
        if (this.function >= 0 && this.function <= 13 && this.coefficients != null) {
            this.cTable = new float[65536];
            for (int i = 0; i < 65536; ++i) {
                this.cTable[i] = (float)CurveFitter.f(this.function, this.coefficients, i);
            }
        } else {
            this.cTable = null;
        }
    }

    double od(double v) {
        if (this.invertedLut) {
            if (v == 255.0) {
                v = 254.5;
            }
            return 0.434294481 * Math.log(255.0 / (255.0 - v));
        }
        if (v == 0.0) {
            v = 0.5;
        }
        return 0.434294481 * Math.log(255.0 / v);
    }

    public double getCValue(int value) {
        if (this.function == 20) {
            return value;
        }
        if (this.function >= 0 && this.function <= 13 && this.coefficients != null) {
            double v = CurveFitter.f(this.function, this.coefficients, value);
            if (this.zeroClip && v < 0.0) {
                return 0.0;
            }
            return v;
        }
        if (this.cTable == null) {
            this.makeCTable();
        }
        if (this.cTable != null && value >= 0 && value < this.cTable.length) {
            return this.cTable[value];
        }
        return value;
    }

    public double getCValue(double value) {
        if (this.function == 20) {
            return value;
        }
        if (this.function >= 0 && this.function <= 13 && this.coefficients != null) {
            double v = CurveFitter.f(this.function, this.coefficients, value);
            if (this.zeroClip && v < 0.0) {
                return 0.0;
            }
            return v;
        }
        return this.getCValue((int)value);
    }

    public double getRawValue(double value) {
        if (this.function == 20) {
            return value;
        }
        if (this.function == 0 && this.coefficients != null && this.coefficients.length == 2 && this.coefficients[1] != 0.0) {
            return (value - this.coefficients[0]) / this.coefficients[1];
        }
        if (this.cTable == null) {
            this.makeCTable();
        }
        float fvalue = (float)value;
        float smallestDiff = Float.MAX_VALUE;
        int index = 0;
        for (int i = 0; i < this.cTable.length; ++i) {
            float diff = fvalue - this.cTable[i];
            if (diff < 0.0f) {
                diff = -diff;
            }
            if (!(diff < smallestDiff)) continue;
            smallestDiff = diff;
            index = i;
        }
        return index;
    }

    public Calibration copy() {
        return (Calibration)this.clone();
    }

    public synchronized Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public boolean equals(Calibration cal) {
        if (cal == null) {
            return false;
        }
        boolean equal = true;
        if (cal.pixelWidth != this.pixelWidth || cal.pixelHeight != this.pixelHeight || cal.pixelDepth != this.pixelDepth) {
            equal = false;
        }
        if (!cal.unit.equals(this.unit)) {
            equal = false;
        }
        if (!cal.valueUnit.equals(this.valueUnit) || cal.function != this.function) {
            equal = false;
        }
        return equal;
    }

    public boolean isSigned16Bit() {
        return this.bitDepth == 16 && this.function >= 0 && this.function <= 13 && this.coefficients != null && this.coefficients[0] == -32768.0 && this.coefficients[1] == 1.0;
    }

    public void setSigned16BitCalibration() {
        double[] coeff = new double[]{-32768.0, 1.0};
        this.setFunction(0, coeff, DEFAULT_VALUE_UNIT);
    }

    public boolean zeroClip() {
        return this.zeroClip;
    }

    public void setInvertY(boolean invertYCoordinates) {
        this.invertY = invertYCoordinates;
    }

    public boolean getInvertY() {
        return this.invertY;
    }

    public static void setLoopBackAndForth(boolean loop) {
        loopBackAndForth = loop;
    }

    public String toString() {
        return "w=" + this.pixelWidth + ", h=" + this.pixelHeight + ", d=" + this.pixelDepth + ", unit=" + this.unit + ", f=" + this.function + ", nc=" + (this.coefficients != null ? "" + this.coefficients.length : "null") + ", table=" + (this.cTable != null ? "" + this.cTable.length : "null") + ", vunit=" + this.valueUnit;
    }
}

