/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Locale;

abstract class CompilerTool {
    CompilerTool() {
    }

    public static CompilerTool getDefault() {
        JavaxCompilerTool javax = new JavaxCompilerTool();
        if (((CompilerTool)javax).isSupported()) {
            if (IJ.debugMode) {
                IJ.log("javac: using javax.tool.JavaCompiler");
            }
            return javax;
        }
        LegacyCompilerTool legacy = new LegacyCompilerTool();
        if (((CompilerTool)legacy).isSupported()) {
            if (IJ.debugMode) {
                IJ.log("javac: using com.sun.tools.javac");
            }
            return legacy;
        }
        return null;
    }

    public abstract boolean compile(List var1, List var2, StringWriter var3);

    protected abstract Object getJavac() throws Exception;

    public boolean isSupported() {
        try {
            return null != this.getJavac();
        }
        catch (Exception e) {
            return false;
        }
    }

    public static class LegacyCompilerTool
    extends CompilerTool {
        protected static Class javacC;

        boolean areErrors(String s) {
            boolean errors;
            boolean bl = errors = s != null && s.length() > 0;
            if (errors && s.indexOf("1 warning") > 0 && s.indexOf("[deprecation] show()") > 0) {
                errors = false;
            }
            return errors;
        }

        public boolean compile(List sources, List options, StringWriter log) {
            try {
                String[] args = new String[sources.size() + options.size()];
                int argsIndex = 0;
                for (int optionsIndex = 0; optionsIndex < options.size(); ++optionsIndex) {
                    args[argsIndex++] = (String)options.get(optionsIndex);
                }
                for (int sourcesIndex = 0; sourcesIndex < sources.size(); ++sourcesIndex) {
                    args[argsIndex++] = (String)sources.get(sourcesIndex);
                }
                Object javac = this.getJavac();
                Class[] compileTypes = new Class[]{String[].class, PrintWriter.class};
                Method compile = javacC.getMethod("compile", compileTypes);
                PrintWriter printer = new PrintWriter(log);
                Object result = compile.invoke(javac, args, printer);
                printer.flush();
                return Integer.valueOf(0).equals(result) | this.areErrors(log.toString());
            }
            catch (Exception e) {
                e.printStackTrace(new PrintWriter(log));
                return false;
            }
        }

        protected Object getJavac() throws Exception {
            if (javacC == null) {
                javacC = Class.forName("com.sun.tools.javac.Main");
            }
            return javacC.newInstance();
        }
    }

    public static class JavaxCompilerTool
    extends CompilerTool {
        protected static Class charsetC;
        protected static Class diagnosticListenerC;
        protected static Class javaFileManagerC;
        protected static Class toolProviderC;

        public boolean compile(List sources, List options, StringWriter log) {
            try {
                Object javac = this.getJavac();
                Class[] getStandardFileManagerTypes = new Class[]{diagnosticListenerC, Locale.class, charsetC};
                Method getStandardFileManager = javac.getClass().getMethod("getStandardFileManager", getStandardFileManagerTypes);
                Object fileManager = getStandardFileManager.invoke(javac, null, null, null);
                Class[] getJavaFileObjectsFromStringsTypes = new Class[]{Iterable.class};
                Method getJavaFileObjectsFromStrings = fileManager.getClass().getMethod("getJavaFileObjectsFromStrings", getJavaFileObjectsFromStringsTypes);
                Object compilationUnits = getJavaFileObjectsFromStrings.invoke(fileManager, sources);
                Class[] getTaskParamTypes = new Class[]{Writer.class, javaFileManagerC, diagnosticListenerC, Iterable.class, Iterable.class, Iterable.class};
                Method getTask = javac.getClass().getMethod("getTask", getTaskParamTypes);
                Object task = getTask.invoke(javac, log, fileManager, null, options, null, compilationUnits);
                Method call = task.getClass().getMethod("call", new Class[0]);
                Object result = call.invoke(task, new Object[0]);
                return Boolean.TRUE.equals(result);
            }
            catch (Exception e) {
                PrintWriter printer = new PrintWriter(log);
                e.printStackTrace(printer);
                printer.flush();
                return false;
            }
        }

        protected Object getJavac() throws Exception {
            if (charsetC == null) {
                charsetC = Class.forName("java.nio.charset.Charset");
            }
            if (diagnosticListenerC == null) {
                diagnosticListenerC = Class.forName("javax.tools.DiagnosticListener");
            }
            if (javaFileManagerC == null) {
                javaFileManagerC = Class.forName("javax.tools.JavaFileManager");
            }
            if (toolProviderC == null) {
                toolProviderC = Class.forName("javax.tools.ToolProvider");
            }
            Method get = toolProviderC.getMethod("getSystemJavaCompiler", new Class[0]);
            return get.invoke(null, new Object[0]);
        }
    }
}

