/*
 * Decompiled with CFR 0.152.
 */
package loci.formats;

import java.awt.image.ColorModel;
import java.io.IOException;
import loci.common.DataTools;
import loci.common.RandomAccessOutputStream;
import loci.common.Region;
import loci.formats.FormatException;
import loci.formats.FormatHandler;
import loci.formats.FormatTools;
import loci.formats.IFormatWriter;
import loci.formats.MetadataTools;
import loci.formats.codec.CodecOptions;
import loci.formats.meta.DummyMetadata;
import loci.formats.meta.MetadataRetrieve;
import ome.xml.model.primitives.PositiveInteger;

public abstract class FormatWriter
extends FormatHandler
implements IFormatWriter {
    protected int fps = 10;
    protected ColorModel cm;
    protected String[] compressionTypes;
    protected String compression;
    protected CodecOptions options;
    protected boolean[][] initialized;
    protected boolean interleaved;
    protected int validBits;
    protected int series;
    protected boolean sequential;
    protected MetadataRetrieve metadataRetrieve = new DummyMetadata();
    protected RandomAccessOutputStream out;

    public FormatWriter(String format, String suffix) {
        super(format, suffix);
    }

    public FormatWriter(String format, String[] suffixes) {
        super(format, suffixes);
    }

    @Override
    public void changeOutputFile(String id) throws FormatException, IOException {
        this.setId(id);
    }

    @Override
    public void saveBytes(int no, byte[] buf) throws FormatException, IOException {
        int width = (Integer)this.metadataRetrieve.getPixelsSizeX(this.getSeries()).getValue();
        int height = (Integer)this.metadataRetrieve.getPixelsSizeY(this.getSeries()).getValue();
        this.saveBytes(no, buf, 0, 0, width, height);
    }

    @Override
    public void saveBytes(int no, byte[] buf, Region tile) throws FormatException, IOException {
        this.saveBytes(no, buf, tile.x, tile.y, tile.width, tile.height);
    }

    @Override
    public void savePlane(int no, Object plane) throws FormatException, IOException {
        int width = (Integer)this.metadataRetrieve.getPixelsSizeX(this.getSeries()).getValue();
        int height = (Integer)this.metadataRetrieve.getPixelsSizeY(this.getSeries()).getValue();
        this.savePlane(no, plane, 0, 0, width, height);
    }

    @Override
    public void savePlane(int no, Object plane, int x, int y, int w, int h) throws FormatException, IOException {
        if (!(plane instanceof byte[])) {
            throw new IllegalArgumentException("Object to save must be a byte[]");
        }
        this.saveBytes(no, (byte[])plane, x, y, w, h);
    }

    @Override
    public void savePlane(int no, Object plane, Region tile) throws FormatException, IOException {
        this.savePlane(no, plane, tile.x, tile.y, tile.width, tile.height);
    }

    @Override
    public void setSeries(int series) throws FormatException {
        if (series < 0) {
            throw new FormatException("Series must be > 0.");
        }
        if (series >= this.metadataRetrieve.getImageCount()) {
            throw new FormatException("Series is '" + series + "' but MetadataRetrieve only defines " + this.metadataRetrieve.getImageCount() + " series.");
        }
        this.series = series;
    }

    @Override
    public int getSeries() {
        return this.series;
    }

    @Override
    public void setInterleaved(boolean interleaved) {
        this.interleaved = interleaved;
    }

    @Override
    public boolean isInterleaved() {
        return this.interleaved;
    }

    @Override
    public void setValidBitsPerPixel(int bits) {
        this.validBits = bits;
    }

    @Override
    public boolean canDoStacks() {
        return false;
    }

    @Override
    public void setMetadataRetrieve(MetadataRetrieve retrieve) {
        FormatTools.assertId(this.currentId, false, 1);
        if (retrieve == null) {
            throw new IllegalArgumentException("Metadata object is null");
        }
        this.metadataRetrieve = retrieve;
    }

    @Override
    public MetadataRetrieve getMetadataRetrieve() {
        return this.metadataRetrieve;
    }

    @Override
    public void setColorModel(ColorModel model) {
        this.cm = model;
    }

    @Override
    public ColorModel getColorModel() {
        return this.cm;
    }

    @Override
    public void setFramesPerSecond(int rate) {
        this.fps = rate;
    }

    @Override
    public int getFramesPerSecond() {
        return this.fps;
    }

    @Override
    public String[] getCompressionTypes() {
        return this.compressionTypes;
    }

    @Override
    public void setCompression(String compress) throws FormatException {
        for (int i = 0; i < this.compressionTypes.length; ++i) {
            if (!this.compressionTypes[i].equals(compress)) continue;
            this.compression = compress;
            return;
        }
        throw new FormatException("Invalid compression type: " + compress);
    }

    @Override
    public void setCodecOptions(CodecOptions options) {
        this.options = options;
    }

    @Override
    public String getCompression() {
        return this.compression;
    }

    @Override
    public int[] getPixelTypes() {
        return this.getPixelTypes(this.getCompression());
    }

    @Override
    public int[] getPixelTypes(String codec) {
        return new int[]{0, 1, 2, 3, 4, 5, 6};
    }

    @Override
    public boolean isSupportedType(int type) {
        int[] types = this.getPixelTypes();
        for (int i = 0; i < types.length; ++i) {
            if (type != types[i]) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setWriteSequentially(boolean sequential) {
        this.sequential = sequential;
    }

    @Override
    public void setId(String id) throws FormatException, IOException {
        if (id.equals(this.currentId)) {
            return;
        }
        this.currentId = id;
        if (this.out != null) {
            this.out.close();
        }
        this.out = new RandomAccessOutputStream(this.currentId);
        MetadataRetrieve r = this.getMetadataRetrieve();
        this.initialized = new boolean[r.getImageCount()][];
        for (int i = 0; i < r.getImageCount(); ++i) {
            this.initialized[i] = new boolean[this.getPlaneCount(i)];
        }
    }

    @Override
    public void close() throws IOException {
        if (this.out != null) {
            this.out.close();
        }
        this.out = null;
        this.currentId = null;
        this.initialized = null;
    }

    protected void checkParams(int no, byte[] buf, int x, int y, int w, int h) throws FormatException {
        int minSize;
        MetadataRetrieve r = this.getMetadataRetrieve();
        MetadataTools.verifyMinimumPopulated(r, this.series);
        if (buf == null) {
            throw new FormatException("Buffer cannot be null.");
        }
        int z = (Integer)r.getPixelsSizeZ(this.series).getValue();
        int t = (Integer)r.getPixelsSizeT(this.series).getValue();
        int c = r.getChannelCount(this.series);
        int planes = z * c * t;
        if (no < 0) {
            throw new FormatException(String.format("Plane index:%d must be >= 0", no));
        }
        if (no >= planes) {
            throw new FormatException(String.format("Plane index:%d must be < %d", no, planes));
        }
        int sizeX = (Integer)r.getPixelsSizeX(this.series).getValue();
        int sizeY = (Integer)r.getPixelsSizeY(this.series).getValue();
        if (x < 0) {
            throw new FormatException(String.format("X:%d must be >= 0", x));
        }
        if (y < 0) {
            throw new FormatException(String.format("Y:%d must be >= 0", y));
        }
        if (x >= sizeX) {
            throw new FormatException(String.format("X:%d must be < %d", x, sizeX));
        }
        if (y >= sizeY) {
            throw new FormatException(String.format("Y:%d must be < %d", y, sizeY));
        }
        if (w <= 0) {
            throw new FormatException(String.format("Width:%d must be > 0", w));
        }
        if (h <= 0) {
            throw new FormatException(String.format("Height:%d must be > 0", h));
        }
        if (x + w > sizeX) {
            throw new FormatException(String.format("(w:%d + x:%d) must be <= %d", w, x, sizeX));
        }
        if (y + h > sizeY) {
            throw new FormatException(String.format("(h:%d + y:%d) must be <= %d", h, y, sizeY));
        }
        int pixelType = FormatTools.pixelTypeFromString(r.getPixelsType(this.series).toString());
        int bpp = FormatTools.getBytesPerPixel(pixelType);
        PositiveInteger samples = r.getChannelSamplesPerPixel(this.series, 0);
        if (samples == null) {
            samples = new PositiveInteger(1);
        }
        if (buf.length < (minSize = bpp * w * h * (Integer)samples.getValue())) {
            throw new FormatException("Buffer is too small; expected " + minSize + " bytes, got " + buf.length + " bytes.");
        }
        if (!DataTools.containsValue(this.getPixelTypes(this.compression), pixelType)) {
            throw new FormatException("Unsupported image type '" + FormatTools.getPixelTypeString(pixelType) + "'.");
        }
    }

    protected void seekToPlaneOffset(long baseOffset, int x, int y) throws IOException {
        this.out.seek(baseOffset);
        MetadataRetrieve r = this.getMetadataRetrieve();
        int samples = this.getSamplesPerPixel();
        int pixelType = FormatTools.pixelTypeFromString(r.getPixelsType(this.series).toString());
        int bpp = FormatTools.getBytesPerPixel(pixelType);
        if (this.interleaved) {
            bpp *= samples;
        }
        int sizeX = (Integer)r.getPixelsSizeX(this.series).getValue();
        this.out.skipBytes(bpp * (y * sizeX + x));
    }

    protected boolean isFullPlane(int x, int y, int w, int h) {
        MetadataRetrieve r = this.getMetadataRetrieve();
        int sizeX = (Integer)r.getPixelsSizeX(this.series).getValue();
        int sizeY = (Integer)r.getPixelsSizeY(this.series).getValue();
        return x == 0 && y == 0 && w == sizeX && h == sizeY;
    }

    protected int getSamplesPerPixel() {
        return this.getSamplesPerPixel(this.series);
    }

    protected int getSamplesPerPixel(int series) {
        MetadataRetrieve r = this.getMetadataRetrieve();
        PositiveInteger samples = r.getChannelSamplesPerPixel(series, 0);
        if (samples == null) {
            LOGGER.warn("SamplesPerPixel #0 is null. It is assumed to be 1.");
        }
        return samples == null ? 1 : (Integer)samples.getValue();
    }

    protected int getPlaneCount() {
        return this.getPlaneCount(this.series);
    }

    protected int getPlaneCount(int series) {
        MetadataRetrieve r = this.getMetadataRetrieve();
        int z = (Integer)r.getPixelsSizeZ(series).getValue();
        int t = (Integer)r.getPixelsSizeT(series).getValue();
        int c = (Integer)r.getPixelsSizeC(series).getValue();
        return z * (c /= ((Integer)r.getChannelSamplesPerPixel(series, 0).getValue()).intValue()) * t;
    }
}

