/*
 * Decompiled with CFR 0.152.
 */
package loci.formats;

import java.util.Arrays;
import java.util.Hashtable;
import java.util.Map;
import loci.common.DateTools;
import loci.common.Location;
import loci.common.services.DependencyException;
import loci.common.services.ServiceException;
import loci.common.services.ServiceFactory;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.meta.IMetadata;
import loci.formats.meta.MetadataRetrieve;
import loci.formats.meta.MetadataStore;
import loci.formats.ome.OMEXMLMetadata;
import loci.formats.services.OMEXMLService;
import ome.xml.model.enums.DimensionOrder;
import ome.xml.model.enums.EnumerationException;
import ome.xml.model.enums.PixelType;
import ome.xml.model.primitives.NonNegativeInteger;
import ome.xml.model.primitives.PositiveInteger;
import ome.xml.model.primitives.Timestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MetadataTools {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetadataTools.class);
    private static boolean defaultDateEnabled = false;

    private MetadataTools() {
    }

    public static void populatePixels(MetadataStore store, IFormatReader r) {
        MetadataTools.populatePixels(store, r, false, true);
    }

    public static void populatePixels(MetadataStore store, IFormatReader r, boolean doPlane) {
        MetadataTools.populatePixels(store, r, doPlane, true);
    }

    public static void populatePixels(MetadataStore store, IFormatReader r, boolean doPlane, boolean doImageName) {
        if (store == null || r == null) {
            return;
        }
        int oldSeries = r.getSeries();
        for (int i = 0; i < r.getSeriesCount(); ++i) {
            block10: {
                r.setSeries(i);
                String imageName = null;
                if (doImageName) {
                    Location f = new Location(r.getCurrentFile());
                    imageName = f.getName();
                    if (r.getSeriesCount() > 1) {
                        imageName = imageName + " #" + (i + 1);
                    }
                }
                String pixelType = FormatTools.getPixelTypeString(r.getPixelType());
                MetadataTools.populateMetadata(store, r.getCurrentFile(), i, imageName, r.isLittleEndian(), r.getDimensionOrder(), pixelType, r.getSizeX(), r.getSizeY(), r.getSizeZ(), r.getSizeC(), r.getSizeT(), r.getRGBChannelCount());
                store.setPixelsInterleaved(r.isInterleaved(), i);
                store.setPixelsSignificantBits(new PositiveInteger(r.getBitsPerPixel()), i);
                try {
                    MetadataStore baseStore;
                    OMEXMLService service = new ServiceFactory().getInstance(OMEXMLService.class);
                    if (!service.isOMEXMLRoot(store.getRoot()) || !service.isOMEXMLMetadata(baseStore = r.getMetadataStore())) break block10;
                    try {
                        OMEXMLMetadata omeMeta = service.getOMEMetadata(service.asRetrieve(baseStore));
                        if (omeMeta.getTiffDataCount(i) == 0) {
                            service.addMetadataOnly(omeMeta, i, i == 0);
                        }
                    }
                    catch (ServiceException e) {
                        LOGGER.warn("Failed to add MetadataOnly", e);
                    }
                }
                catch (DependencyException exc) {
                    LOGGER.warn("Failed to add MetadataOnly", exc);
                }
            }
            if (!doPlane) continue;
            for (int q = 0; q < r.getImageCount(); ++q) {
                int[] coords = r.getZCTCoords(q);
                store.setPlaneTheZ(new NonNegativeInteger(coords[0]), i, q);
                store.setPlaneTheC(new NonNegativeInteger(coords[1]), i, q);
                store.setPlaneTheT(new NonNegativeInteger(coords[2]), i, q);
            }
        }
        r.setSeries(oldSeries);
    }

    public static void populateMetadata(MetadataStore store, int series, String imageName, CoreMetadata coreMeta) {
        String pixelType = FormatTools.getPixelTypeString(coreMeta.pixelType);
        int effSizeC = coreMeta.imageCount / coreMeta.sizeZ / coreMeta.sizeT;
        int samplesPerPixel = coreMeta.sizeC / effSizeC;
        MetadataTools.populateMetadata(store, null, series, imageName, coreMeta.littleEndian, coreMeta.dimensionOrder, pixelType, coreMeta.sizeX, coreMeta.sizeY, coreMeta.sizeZ, coreMeta.sizeC, coreMeta.sizeT, samplesPerPixel);
    }

    public static void populateMetadata(MetadataStore store, int series, String imageName, boolean littleEndian, String dimensionOrder, String pixelType, int sizeX, int sizeY, int sizeZ, int sizeC, int sizeT, int samplesPerPixel) {
        MetadataTools.populateMetadata(store, null, series, imageName, littleEndian, dimensionOrder, pixelType, sizeX, sizeY, sizeZ, sizeC, sizeT, samplesPerPixel);
    }

    public static void populateMetadata(MetadataStore store, String file2, int series, String imageName, boolean littleEndian, String dimensionOrder, String pixelType, int sizeX, int sizeY, int sizeZ, int sizeC, int sizeT, int samplesPerPixel) {
        store.setImageID(MetadataTools.createLSID("Image", series), series);
        MetadataTools.setDefaultCreationDate(store, file2, series);
        if (imageName != null) {
            store.setImageName(imageName, series);
        }
        MetadataTools.populatePixelsOnly(store, series, littleEndian, dimensionOrder, pixelType, sizeX, sizeY, sizeZ, sizeC, sizeT, samplesPerPixel);
    }

    public static void populatePixelsOnly(MetadataStore store, IFormatReader r) {
        int oldSeries = r.getSeries();
        for (int i = 0; i < r.getSeriesCount(); ++i) {
            r.setSeries(i);
            String pixelType = FormatTools.getPixelTypeString(r.getPixelType());
            MetadataTools.populatePixelsOnly(store, i, r.isLittleEndian(), r.getDimensionOrder(), pixelType, r.getSizeX(), r.getSizeY(), r.getSizeZ(), r.getSizeC(), r.getSizeT(), r.getRGBChannelCount());
        }
        r.setSeries(oldSeries);
    }

    public static void populatePixelsOnly(MetadataStore store, int series, boolean littleEndian, String dimensionOrder, String pixelType, int sizeX, int sizeY, int sizeZ, int sizeC, int sizeT, int samplesPerPixel) {
        store.setPixelsID(MetadataTools.createLSID("Pixels", series), series);
        store.setPixelsBigEndian(!littleEndian, series);
        try {
            store.setPixelsDimensionOrder(DimensionOrder.fromString(dimensionOrder), series);
        }
        catch (EnumerationException e) {
            LOGGER.warn("Invalid dimension order: " + dimensionOrder, e);
        }
        try {
            store.setPixelsType(PixelType.fromString(pixelType), series);
        }
        catch (EnumerationException e) {
            LOGGER.warn("Invalid pixel type: " + pixelType, e);
        }
        store.setPixelsSizeX(new PositiveInteger(sizeX), series);
        store.setPixelsSizeY(new PositiveInteger(sizeY), series);
        store.setPixelsSizeZ(new PositiveInteger(sizeZ), series);
        store.setPixelsSizeC(new PositiveInteger(sizeC), series);
        store.setPixelsSizeT(new PositiveInteger(sizeT), series);
        int effSizeC = sizeC / samplesPerPixel;
        for (int i = 0; i < effSizeC; ++i) {
            store.setChannelID(MetadataTools.createLSID("Channel", series, i), series, i);
            store.setChannelSamplesPerPixel(new PositiveInteger(samplesPerPixel), series, i);
        }
    }

    public static String createLSID(String type, int ... indices) {
        StringBuffer lsid = new StringBuffer(type);
        for (int index : indices) {
            lsid.append(":");
            lsid.append(index);
        }
        return lsid.toString();
    }

    public static void verifyMinimumPopulated(MetadataRetrieve src) throws FormatException {
        MetadataTools.verifyMinimumPopulated(src, 0);
    }

    public static void verifyMinimumPopulated(MetadataRetrieve src, int n) throws FormatException {
        if (src == null) {
            throw new FormatException("Metadata object is null; call IFormatWriter.setMetadataRetrieve() first");
        }
        if (src instanceof MetadataStore && ((MetadataStore)((Object)src)).getRoot() == null) {
            throw new FormatException("Metadata object has null root; call IMetadata.createRoot() first");
        }
        if (src.getImageID(n) == null) {
            throw new FormatException("Image ID #" + n + " is null");
        }
        if (src.getPixelsID(n) == null) {
            throw new FormatException("Pixels ID #" + n + " is null");
        }
        for (int i = 0; i < src.getChannelCount(n); ++i) {
            if (src.getChannelID(n, i) != null) continue;
            throw new FormatException("Channel ID #" + i + " in Image #" + n + " is null");
        }
        if (src.getPixelsBinDataBigEndian(n, 0) == null) {
            throw new FormatException("BigEndian #" + n + " is null");
        }
        if (src.getPixelsDimensionOrder(n) == null) {
            throw new FormatException("DimensionOrder #" + n + " is null");
        }
        if (src.getPixelsType(n) == null) {
            throw new FormatException("PixelType #" + n + " is null");
        }
        if (src.getPixelsSizeC(n) == null) {
            throw new FormatException("SizeC #" + n + " is null");
        }
        if (src.getPixelsSizeT(n) == null) {
            throw new FormatException("SizeT #" + n + " is null");
        }
        if (src.getPixelsSizeX(n) == null) {
            throw new FormatException("SizeX #" + n + " is null");
        }
        if (src.getPixelsSizeY(n) == null) {
            throw new FormatException("SizeY #" + n + " is null");
        }
        if (src.getPixelsSizeZ(n) == null) {
            throw new FormatException("SizeZ #" + n + " is null");
        }
    }

    public static void setDefaultDateEnabled(boolean enabled) {
        defaultDateEnabled = enabled;
    }

    public static void setDefaultCreationDate(MetadataStore store, String id, int series) {
        if (!defaultDateEnabled) {
            return;
        }
        Location file2 = id == null ? null : new Location(id).getAbsoluteFile();
        long time = System.currentTimeMillis();
        if (file2 != null && file2.exists()) {
            time = file2.lastModified();
        }
        store.setImageAcquisitionDate(new Timestamp(DateTools.convertDate(time, 0)), series);
    }

    public static String makeSaneDimensionOrder(String dimensionOrder) {
        String[] axes;
        String order = dimensionOrder.toUpperCase();
        order = order.replaceAll("[^XYZCT]", "");
        for (String axis : axes = new String[]{"X", "Y", "C", "Z", "T"}) {
            if (order.indexOf(axis) == -1) {
                order = order + axis;
            }
            while (order.indexOf(axis) != order.lastIndexOf(axis)) {
                order = order.replaceFirst(axis, "");
            }
        }
        return order;
    }

    public static String[] keys(Hashtable<String, Object> meta) {
        Object[] keys = new String[meta.size()];
        meta.keySet().toArray(keys);
        Arrays.sort(keys);
        return keys;
    }

    public static void merge(Map<String, Object> src, Map<String, Object> dest, String prefix) {
        for (String key : src.keySet()) {
            dest.put(prefix + key, src.get(key));
        }
    }

    public static IMetadata createOMEXMLMetadata() {
        try {
            OMEXMLService service = new ServiceFactory().getInstance(OMEXMLService.class);
            if (service == null) {
                return null;
            }
            return service.createOMEXMLMetadata();
        }
        catch (DependencyException exc) {
            return null;
        }
        catch (ServiceException exc) {
            return null;
        }
    }
}

