/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import com.google.common.io.BaseEncoding;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Vector;
import loci.common.CBZip2InputStream;
import loci.common.RandomAccessInputStream;
import loci.common.services.DependencyException;
import loci.common.services.ServiceException;
import loci.common.services.ServiceFactory;
import loci.common.xml.BaseHandler;
import loci.common.xml.XMLTools;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.MissingLibraryException;
import loci.formats.codec.CodecOptions;
import loci.formats.codec.JPEG2000Codec;
import loci.formats.codec.JPEGCodec;
import loci.formats.codec.ZlibCodec;
import loci.formats.meta.MetadataStore;
import loci.formats.ome.OMEXMLMetadata;
import loci.formats.services.OMEXMLService;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.helpers.DefaultHandler;

public class OMEXMLReader
extends FormatReader {
    private Vector<BinData> binData;
    private Vector<Long> binDataOffsets;
    private Vector<String> compression;
    private String omexml;
    private boolean hasSPW = false;

    public OMEXMLReader() {
        super("OME-XML", "ome");
        this.domains = FormatTools.NON_GRAPHICS_DOMAINS;
        this.suffixNecessary = false;
    }

    @Override
    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = 64;
        String xml = stream.readString(64);
        return xml.startsWith("<?xml") && xml.indexOf("<OME") >= 0;
    }

    @Override
    public boolean isThisType(String name, boolean open) {
        if (OMEXMLReader.checkSuffix(name, "companion.ome")) {
            return false;
        }
        return super.isThisType(name, open);
    }

    @Override
    public String[] getDomains() {
        String[] stringArray;
        FormatTools.assertId(this.currentId, true, 1);
        if (this.hasSPW) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "High-Content Screening (HCS)";
        } else {
            stringArray = FormatTools.NON_SPECIAL_DOMAINS;
        }
        return stringArray;
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        if (this.binDataOffsets.size() == 0) {
            return buf;
        }
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        int index = no;
        int series = this.getSeries();
        for (int i = 0; i < series; ++i) {
            index += ((CoreMetadata)this.core.get((int)i)).imageCount;
        }
        if (index >= this.binDataOffsets.size()) {
            index = this.binDataOffsets.size() - 1;
        }
        long offset = this.binDataOffsets.get(index);
        String compress = this.compression.get(index);
        this.in.seek(offset);
        int depth = FormatTools.getBytesPerPixel(this.getPixelType());
        int planeSize = this.getSizeX() * this.getSizeY() * depth;
        CodecOptions options = new CodecOptions();
        options.width = this.getSizeX();
        options.height = this.getSizeY();
        options.bitsPerSample = depth * 8;
        options.channels = this.getRGBChannelCount();
        options.maxBytes = planeSize;
        options.littleEndian = this.isLittleEndian();
        options.interleaved = this.isInterleaved();
        String encoded = this.in.readString("<");
        encoded = encoded.trim();
        if (encoded.length() == 0 || encoded.equals("<")) {
            LOGGER.debug("No pixel data for plane #{}", (Object)no);
            return buf;
        }
        encoded = encoded.substring(0, encoded.length() - 1);
        byte[] pixels = BaseEncoding.base64().decode(encoded);
        if (pixels.length == 0) {
            LOGGER.debug("No pixel data for plane #{}", (Object)no);
            return buf;
        }
        if (compress.equals("bzip2")) {
            byte[] tempPixels = pixels;
            pixels = new byte[tempPixels.length - 2];
            System.arraycopy(tempPixels, 2, pixels, 0, pixels.length);
            ByteArrayInputStream bais = new ByteArrayInputStream(pixels);
            CBZip2InputStream bzip = new CBZip2InputStream(bais);
            pixels = new byte[planeSize];
            bzip.read(pixels, 0, pixels.length);
            tempPixels = null;
            bais.close();
            bzip.close();
            bais = null;
            bzip = null;
        } else if (compress.equals("zlib")) {
            pixels = new ZlibCodec().decompress(pixels, options);
        } else if (compress.equals("J2K")) {
            pixels = new JPEG2000Codec().decompress(pixels, options);
        } else if (compress.equals("JPEG")) {
            pixels = new JPEGCodec().decompress(pixels, options);
        }
        for (int row = 0; row < h; ++row) {
            int off = (row + y) * this.getSizeX() * depth + x * depth;
            System.arraycopy(pixels, off, buf, row * w * depth, w * depth);
        }
        pixels = null;
        return buf;
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.compression = null;
            this.binDataOffsets = null;
            this.binData = null;
            this.omexml = null;
            this.hasSPW = false;
        }
    }

    @Override
    protected void initFile(String id) throws FormatException, IOException {
        OMEXMLMetadata omexmlMeta;
        OMEXMLService service;
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        this.in.setEncoding("ASCII");
        this.binData = new Vector();
        this.binDataOffsets = new Vector();
        this.compression = new Vector();
        OMEXMLHandler handler = new OMEXMLHandler();
        try {
            RandomAccessInputStream s = new RandomAccessInputStream(id);
            XMLTools.parseXML(s, (DefaultHandler)handler);
            s.close();
        }
        catch (IOException e) {
            throw new FormatException("Malformed OME-XML", e);
        }
        int lineNumber = 1;
        for (BinData bin : this.binData) {
            int line = bin.getRow();
            int col = bin.getColumn();
            while (lineNumber < line) {
                this.in.readLine();
                ++lineNumber;
            }
            this.binDataOffsets.add(this.in.getFilePointer() + (long)col - 1L);
        }
        LOGGER.info("Populating metadata");
        try {
            ServiceFactory factory = new ServiceFactory();
            service = factory.getInstance(OMEXMLService.class);
            omexmlMeta = service.createOMEXMLMetadata(this.omexml);
        }
        catch (DependencyException de) {
            throw new MissingLibraryException("ome-xml.jar is required to read OME-TIFF files.  Please download it from http://www.openmicroscopy.org/site/support/bio-formats/developers/java-library.html", de);
        }
        catch (ServiceException se) {
            throw new FormatException(se);
        }
        this.hasSPW = omexmlMeta.getPlateCount() > 0;
        this.addGlobalMeta("Is SPW file", this.hasSPW);
        int numDatasets = omexmlMeta.getImageCount();
        int oldSeries = this.getSeries();
        this.core.clear();
        for (int i = 0; i < numDatasets; ++i) {
            CoreMetadata ms = new CoreMetadata();
            this.core.add(ms);
            this.setSeries(i);
            Integer w = (Integer)omexmlMeta.getPixelsSizeX(i).getValue();
            Integer h = (Integer)omexmlMeta.getPixelsSizeY(i).getValue();
            Integer t = (Integer)omexmlMeta.getPixelsSizeT(i).getValue();
            Integer z = (Integer)omexmlMeta.getPixelsSizeZ(i).getValue();
            Integer c = (Integer)omexmlMeta.getPixelsSizeC(i).getValue();
            if (w == null || h == null || t == null || z == null | c == null) {
                throw new FormatException("Image dimensions not found");
            }
            Boolean endian = null;
            if (this.binData.size() > 0) {
                endian = omexmlMeta.getPixelsBinDataBigEndian(i, 0);
            }
            String pixType = omexmlMeta.getPixelsType(i).toString();
            ms.dimensionOrder = omexmlMeta.getPixelsDimensionOrder(i).toString();
            ms.sizeX = w;
            ms.sizeY = h;
            ms.sizeT = t;
            ms.sizeZ = z;
            ms.sizeC = c;
            ms.imageCount = this.getSizeZ() * this.getSizeC() * this.getSizeT();
            ms.littleEndian = endian == null ? false : endian == false;
            ms.rgb = false;
            ms.interleaved = false;
            ms.indexed = false;
            ms.falseColor = true;
            ms.pixelType = FormatTools.pixelTypeFromString(pixType);
            ms.orderCertain = true;
            if (omexmlMeta.getPixelsSignificantBits(i) == null) continue;
            ms.bitsPerPixel = (Integer)omexmlMeta.getPixelsSignificantBits(i).getValue();
        }
        this.setSeries(oldSeries);
        MetadataStore store = this.getMetadataStore();
        service.convertMetadata(omexmlMeta, store);
        MetadataTools.populatePixels(store, this, false, false);
    }

    class BinData {
        private int row;
        private int column;

        public BinData(int row, int column) {
            this.row = row;
            this.column = column;
        }

        public int getRow() {
            return this.row;
        }

        public int getColumn() {
            return this.column;
        }
    }

    class OMEXMLHandler
    extends BaseHandler {
        private StringBuffer xmlBuffer = new StringBuffer();
        private String currentQName;
        private Locator locator;

        @Override
        public void characters(char[] ch, int start, int length) {
            if (this.currentQName.indexOf("BinData") < 0) {
                this.xmlBuffer.append(new String(ch, start, length));
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            this.xmlBuffer.append("</");
            this.xmlBuffer.append(qName);
            this.xmlBuffer.append(">");
        }

        @Override
        public void startElement(String ur, String localName, String qName, Attributes attributes) {
            this.currentQName = qName;
            if (qName.indexOf("BinData") == -1) {
                this.xmlBuffer.append("<");
                this.xmlBuffer.append(qName);
                for (int i = 0; i < attributes.getLength(); ++i) {
                    String key = XMLTools.escapeXML(attributes.getQName(i));
                    String value = XMLTools.escapeXML(attributes.getValue(i));
                    if (key.equals("BigEndian")) {
                        String endian = value.toLowerCase();
                        if (!endian.equals("true") && !endian.equals("false")) {
                            if (endian.startsWith("t")) {
                                endian = "true";
                            } else if (endian.startsWith("f")) {
                                endian = "false";
                            }
                        }
                        value = endian;
                    }
                    this.xmlBuffer.append(" ");
                    this.xmlBuffer.append(key);
                    this.xmlBuffer.append("=\"");
                    this.xmlBuffer.append(value);
                    this.xmlBuffer.append("\"");
                }
                this.xmlBuffer.append(">");
            } else {
                OMEXMLReader.this.binData.add(new BinData(this.locator.getLineNumber(), this.locator.getColumnNumber()));
                String compress = attributes.getValue("Compression");
                OMEXMLReader.this.compression.add(compress == null ? "" : compress);
                this.xmlBuffer.append("<");
                this.xmlBuffer.append(qName);
                for (int i = 0; i < attributes.getLength(); ++i) {
                    String key = XMLTools.escapeXML(attributes.getQName(i));
                    String value = XMLTools.escapeXML(attributes.getValue(i));
                    if (key.equals("Length")) {
                        value = "0";
                    }
                    this.xmlBuffer.append(" ");
                    this.xmlBuffer.append(key);
                    this.xmlBuffer.append("=\"");
                    this.xmlBuffer.append(value);
                    this.xmlBuffer.append("\"");
                }
                this.xmlBuffer.append(">");
            }
        }

        @Override
        public void endDocument() {
            OMEXMLReader.this.omexml = this.xmlBuffer.toString();
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }
    }
}

