/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.out;

import java.io.IOException;
import loci.common.services.DependencyException;
import loci.common.services.ServiceFactory;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.FormatWriter;
import loci.formats.MetadataTools;
import loci.formats.meta.MetadataRetrieve;
import loci.formats.services.WlzService;
import ome.units.UNITS;
import ome.units.quantity.Length;

public class WlzWriter
extends FormatWriter {
    private WlzService wlz = null;
    public static final String NO_WLZ_MSG = "\nWoolz is required to read and write Woolz objects.\nPlease obtain the necessary JAR and native library files from:\nhttp://www.emouseatlas.org/emap/analysis_tools_resources/software/woolz.html.\nThe source code for these is also available from:\nhttps://github.com/ma-tech/Woolz.";
    private String outputOrder = "XYZCT";

    public WlzWriter() {
        super("Woolz", new String[]{"wlz"});
    }

    public void setOutputOrder(String outputOrder) {
        this.outputOrder = outputOrder;
    }

    @Override
    public void saveBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        if (this.wlz != null) {
            this.checkParams(no, buf, x, y, w, h);
            this.wlz.saveBytes(no, buf, x, y, w, h);
        }
    }

    @Override
    public boolean canDoStacks() {
        return true;
    }

    @Override
    public int[] getPixelTypes(String codec) {
        int[] spt = this.wlz != null ? this.wlz.getSupPixelTypes() : new int[]{};
        return spt;
    }

    @Override
    public void setId(String id) throws FormatException, IOException {
        super.setId(id);
        try {
            ServiceFactory factory = new ServiceFactory();
            this.wlz = factory.getInstance(WlzService.class);
        }
        catch (DependencyException e) {
            throw new FormatException(NO_WLZ_MSG, e);
        }
        if (this.wlz != null) {
            MetadataRetrieve meta = this.getMetadataRetrieve();
            MetadataTools.verifyMinimumPopulated(meta, this.series);
            this.wlz.open(id, "w");
            String stageLabelName = null;
            try {
                stageLabelName = meta.getStageLabelName(0);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            int oX = 0;
            int oY = 0;
            int oZ = 0;
            if (stageLabelName != null && stageLabelName.equals(this.wlz.getWlzOrgLabelName())) {
                Length stageX = meta.getStageLabelX(0);
                Length stageY = meta.getStageLabelY(0);
                Length stageZ = meta.getStageLabelZ(0);
                oX = (int)Math.rint(stageX.value(UNITS.REFERENCEFRAME).doubleValue());
                oY = (int)Math.rint(stageY.value(UNITS.REFERENCEFRAME).doubleValue());
                oZ = (int)Math.rint(stageZ.value(UNITS.REFERENCEFRAME).doubleValue());
            }
            int nX = (Integer)meta.getPixelsSizeX(this.series).getValue();
            int nY = (Integer)meta.getPixelsSizeY(this.series).getValue();
            int nZ = (Integer)meta.getPixelsSizeZ(this.series).getValue();
            int nC = (Integer)meta.getPixelsSizeC(this.series).getValue();
            int nT = (Integer)meta.getPixelsSizeT(this.series).getValue();
            double vX = 1.0;
            double vY = 1.0;
            double vZ = 1.0;
            if (meta.getPixelsPhysicalSizeX(0) != null) {
                vX = meta.getPixelsPhysicalSizeX(0).value(UNITS.MICROM).doubleValue();
            }
            if (meta.getPixelsPhysicalSizeY(0) != null) {
                vY = meta.getPixelsPhysicalSizeY(0).value(UNITS.MICROM).doubleValue();
            }
            if (meta.getPixelsPhysicalSizeZ(0) != null) {
                vZ = meta.getPixelsPhysicalSizeZ(0).value(UNITS.MICROM).doubleValue();
            }
            int gType = FormatTools.pixelTypeFromString(meta.getPixelsType(this.series).toString());
            this.wlz.setupWrite(oX, oY, oZ, nX, nY, nZ, nC, nT, vX, vY, vZ, gType);
        }
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (this.wlz != null) {
            this.wlz.close();
        }
    }
}

