/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import ome.xml.model.AbstractOMEModelObject;
import ome.xml.model.MapPair;
import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelObject;
import ome.xml.model.Reference;
import ome.xml.model.enums.EnumerationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MapPairs
implements OMEModelObject {
    private static final Logger LOGGER = LoggerFactory.getLogger(MapPairs.class);
    public static final String PROPERTY_FILE = "omemodel.properties";
    public static final Properties VERSION_PROPERTIES = MapPairs.loadProperties();
    public static final String VERSION = VERSION_PROPERTIES.getProperty("schema.version");
    public static final String MAPNAMESPACE = "http://www.openmicroscopy.org/Schemas/SA/" + VERSION;
    public static final String PAIRSNAMESPACE = "http://www.openmicroscopy.org/Schemas/OME/" + VERSION;
    private List<MapPair> pairs;

    static Properties loadProperties() {
        Properties properties = new Properties();
        try {
            InputStream propertyFile = Class.forName("ome.xml.model.MapPairs").getResourceAsStream(PROPERTY_FILE);
            properties.load(propertyFile);
        }
        catch (ClassNotFoundException e) {
            LOGGER.debug("Failed to load model properties", e);
        }
        catch (IOException e) {
            LOGGER.debug("Failed to load model properties", e);
        }
        return properties;
    }

    public MapPairs() {
        this.pairs = new ArrayList<MapPair>();
    }

    public MapPairs(List<MapPair> pairs) {
        this();
        if (pairs != null) {
            this.pairs.addAll(pairs);
        }
    }

    public MapPairs(MapPairs orig) {
        this(orig.pairs);
    }

    public MapPairs(Element element, OMEModel model) throws EnumerationException {
        this.update(element, model);
    }

    public List<MapPair> getPairs() {
        return Collections.unmodifiableList(this.pairs);
    }

    @Override
    public Element asXMLElement(Document document) {
        return this.asXMLElement(document, null);
    }

    protected Element asXMLElement(Document document, Element pairs) {
        if (pairs == null) {
            pairs = document.createElementNS(MAPNAMESPACE, "Value");
        }
        for (MapPair entry : this.pairs) {
            Element pair = document.createElementNS(PAIRSNAMESPACE, "M");
            pair.setAttribute("K", entry.getName());
            pair.setTextContent(entry.getValue());
            pairs.appendChild(pair);
        }
        return pairs;
    }

    @Override
    public void update(Element element, OMEModel model) throws EnumerationException {
        String tagName = element.getTagName();
        if (!"Map".equals(tagName) && !"Value".equals(tagName)) {
            LOGGER.debug("Expecting node name of Map or Value, got {}", (Object)tagName);
        }
        for (Element child : AbstractOMEModelObject.getChildrenByTagName(element, "M")) {
            if (child.hasAttribute("K")) {
                String key = child.getAttribute("K");
                String value = child.getTextContent();
                this.pairs.add(new MapPair(key, value));
                continue;
            }
            LOGGER.debug("MapPairs entry M does not contain key attribute K");
        }
    }

    @Override
    public boolean link(Reference reference, OMEModelObject o) {
        return false;
    }
}

