/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model;

import java.util.ArrayList;
import java.util.List;
import ome.units.quantity.Length;
import ome.xml.model.AbstractOMEModelObject;
import ome.xml.model.Image;
import ome.xml.model.ImageRef;
import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelObject;
import ome.xml.model.PlateAcquisition;
import ome.xml.model.Reference;
import ome.xml.model.ReferenceList;
import ome.xml.model.Well;
import ome.xml.model.enums.EnumerationException;
import ome.xml.model.enums.UnitsLength;
import ome.xml.model.enums.handlers.UnitsLengthEnumHandler;
import ome.xml.model.primitives.NonNegativeInteger;
import ome.xml.model.primitives.Timestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WellSample
extends AbstractOMEModelObject {
    public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/SPW/2015-01";
    private static final Logger LOGGER = LoggerFactory.getLogger(WellSample.class);
    private NonNegativeInteger index;
    private Length positionX;
    private Length positionY;
    private Timestamp timepoint;
    private String id;
    private Image image;
    private List<PlateAcquisition> plateAcquisitions = new ReferenceList<PlateAcquisition>();
    private Well well;

    public WellSample() {
    }

    public WellSample(Element element, OMEModel model) throws EnumerationException {
        this.update(element, model);
    }

    public WellSample(WellSample orig) {
        this.index = orig.index;
        this.positionX = orig.positionX;
        this.positionY = orig.positionY;
        this.timepoint = orig.timepoint;
        this.id = orig.id;
        this.image = orig.image;
        this.plateAcquisitions = orig.plateAcquisitions;
        this.well = orig.well;
    }

    @Override
    public void update(Element element, OMEModel model) throws EnumerationException {
        Double baseValue;
        UnitsLength modelUnit;
        String unitSymbol;
        super.update(element, model);
        String tagName = element.getTagName();
        if (!"WellSample".equals(tagName)) {
            LOGGER.debug("Expecting node name of WellSample got {}", (Object)tagName);
        }
        if (element.hasAttribute("Index")) {
            this.setIndex(NonNegativeInteger.valueOf(element.getAttribute("Index")));
        }
        if (element.hasAttribute("PositionX")) {
            unitSymbol = element.getAttribute("PositionXUnit");
            if (unitSymbol == null || unitSymbol.isEmpty()) {
                unitSymbol = WellSample.getPositionXUnitXsdDefault();
            }
            modelUnit = UnitsLength.fromString(unitSymbol);
            baseValue = Double.valueOf(element.getAttribute("PositionX"));
            if (baseValue != null) {
                this.setPositionX(UnitsLengthEnumHandler.getQuantity(baseValue, modelUnit));
            }
        }
        if (element.hasAttribute("PositionY")) {
            unitSymbol = element.getAttribute("PositionYUnit");
            if (unitSymbol == null || unitSymbol.isEmpty()) {
                unitSymbol = WellSample.getPositionYUnitXsdDefault();
            }
            modelUnit = UnitsLength.fromString(unitSymbol);
            baseValue = Double.valueOf(element.getAttribute("PositionY"));
            if (baseValue != null) {
                this.setPositionY(UnitsLengthEnumHandler.getQuantity(baseValue, modelUnit));
            }
        }
        if (element.hasAttribute("Timepoint")) {
            this.setTimepoint(Timestamp.valueOf(element.getAttribute("Timepoint")));
        }
        if (!element.hasAttribute("ID") && this.getID() == null) {
            throw new RuntimeException(String.format("WellSample missing required ID property.", new Object[0]));
        }
        if (element.hasAttribute("ID")) {
            this.setID(String.valueOf(element.getAttribute("ID")));
            model.addModelObject(this.getID(), this);
        }
        List<Element> ImageRef_nodeList = WellSample.getChildrenByTagName(element, "ImageRef");
        for (Element ImageRef_element : ImageRef_nodeList) {
            ImageRef image_reference = new ImageRef();
            image_reference.setID(ImageRef_element.getAttribute("ID"));
            model.addReference(this, image_reference);
        }
    }

    @Override
    public boolean link(Reference reference, OMEModelObject o) {
        boolean wasHandledBySuperClass = super.link(reference, o);
        if (wasHandledBySuperClass) {
            return true;
        }
        if (reference instanceof ImageRef) {
            Image o_casted = (Image)o;
            o_casted.linkWellSample(this);
            this.image = o_casted;
            return true;
        }
        LOGGER.debug("Unable to handle reference of type: {}", (Object)reference.getClass());
        return false;
    }

    public NonNegativeInteger getIndex() {
        return this.index;
    }

    public void setIndex(NonNegativeInteger index) {
        this.index = index;
    }

    public Length getPositionX() {
        return this.positionX;
    }

    public void setPositionX(Length positionX) {
        this.positionX = positionX;
    }

    public Length getPositionY() {
        return this.positionY;
    }

    public void setPositionY(Length positionY) {
        this.positionY = positionY;
    }

    public static String getPositionXUnitXsdDefault() {
        return "reference frame";
    }

    public Timestamp getTimepoint() {
        return this.timepoint;
    }

    public void setTimepoint(Timestamp timepoint) {
        this.timepoint = timepoint;
    }

    public static String getPositionYUnitXsdDefault() {
        return "reference frame";
    }

    public String getID() {
        return this.id;
    }

    public void setID(String id) {
        this.id = id;
    }

    public Image getLinkedImage() {
        return this.image;
    }

    public void linkImage(Image o) {
        this.image = o;
    }

    public void unlinkImage(Image o) {
        if (this.image == o) {
            this.image = null;
        }
    }

    public int sizeOfLinkedPlateAcquisitionList() {
        return this.plateAcquisitions.size();
    }

    public List<PlateAcquisition> copyLinkedPlateAcquisitionList() {
        return new ArrayList<PlateAcquisition>(this.plateAcquisitions);
    }

    public PlateAcquisition getLinkedPlateAcquisition(int index) {
        return this.plateAcquisitions.get(index);
    }

    public PlateAcquisition setLinkedPlateAcquisition(int index, PlateAcquisition o) {
        return this.plateAcquisitions.set(index, o);
    }

    public boolean linkPlateAcquisition(PlateAcquisition o) {
        return this.plateAcquisitions.add(o);
    }

    public boolean unlinkPlateAcquisition(PlateAcquisition o) {
        return this.plateAcquisitions.remove(o);
    }

    public Well getWell() {
        return this.well;
    }

    public void setWell(Well well_BackReference) {
        this.well = well_BackReference;
    }

    @Override
    public Element asXMLElement(Document document) {
        return this.asXMLElement(document, null);
    }

    @Override
    protected Element asXMLElement(Document document, Element WellSample_element) {
        UnitsLength enumUnits;
        if (WellSample_element == null) {
            WellSample_element = document.createElementNS(NAMESPACE, "WellSample");
        }
        if (this.index != null) {
            WellSample_element.setAttribute("Index", this.index.toString());
        }
        if (this.positionX != null) {
            if (this.positionX.value() != null) {
                WellSample_element.setAttribute("PositionX", this.positionX.value().toString());
            }
            if (this.positionX.unit() != null) {
                try {
                    enumUnits = UnitsLength.fromString(this.positionX.unit().getSymbol());
                    WellSample_element.setAttribute("PositionXUnit", enumUnits.toString());
                }
                catch (EnumerationException e) {
                    LOGGER.debug("Unable to create xml for WellSample:PositionXUnit: {}", (Object)e.toString());
                }
            }
        }
        if (this.positionY != null) {
            if (this.positionY.value() != null) {
                WellSample_element.setAttribute("PositionY", this.positionY.value().toString());
            }
            if (this.positionY.unit() != null) {
                try {
                    enumUnits = UnitsLength.fromString(this.positionY.unit().getSymbol());
                    WellSample_element.setAttribute("PositionYUnit", enumUnits.toString());
                }
                catch (EnumerationException e) {
                    LOGGER.debug("Unable to create xml for WellSample:PositionYUnit: {}", (Object)e.toString());
                }
            }
        }
        if (this.timepoint != null) {
            WellSample_element.setAttribute("Timepoint", this.timepoint.toString());
        }
        if (this.id != null) {
            WellSample_element.setAttribute("ID", this.id.toString());
        }
        if (this.image != null) {
            ImageRef o = new ImageRef();
            o.setID(this.image.getID());
            WellSample_element.appendChild(o.asXMLElement(document));
        }
        if (this.plateAcquisitions != null) {
            // empty if block
        }
        if (this.well != null) {
            // empty if block
        }
        return super.asXMLElement(document, WellSample_element);
    }
}

