/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model.enums.handlers;

import java.util.Hashtable;
import ome.xml.model.enums.AcquisitionMode;
import ome.xml.model.enums.Enumeration;
import ome.xml.model.enums.EnumerationException;
import ome.xml.model.enums.handlers.IEnumerationHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AcquisitionModeEnumHandler
implements IEnumerationHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(AcquisitionModeEnumHandler.class);
    private static final Hashtable<String, String> patterns = AcquisitionModeEnumHandler.makePatterns();

    private static Hashtable<String, String> makePatterns() {
        Hashtable<String, String> p = new Hashtable<String, String>();
        p.put("^\\s*WideField\\s*", "WideField");
        p.put("^\\s*LaserScanningConfocalMicroscopy\\s*", "LaserScanningConfocalMicroscopy");
        p.put("^\\s*SpinningDiskConfocal\\s*", "SpinningDiskConfocal");
        p.put("^\\s*SlitScanConfocal\\s*", "SlitScanConfocal");
        p.put("^\\s*MultiPhotonMicroscopy\\s*", "MultiPhotonMicroscopy");
        p.put("^\\s*StructuredIllumination\\s*", "StructuredIllumination");
        p.put("^\\s*SingleMoleculeImaging\\s*", "SingleMoleculeImaging");
        p.put("^\\s*TotalInternalReflection\\s*", "TotalInternalReflection");
        p.put("^\\s*FluorescenceLifetime\\s*", "FluorescenceLifetime");
        p.put("^\\s*SpectralImaging\\s*", "SpectralImaging");
        p.put("^\\s*FluorescenceCorrelationSpectroscopy\\s*", "FluorescenceCorrelationSpectroscopy");
        p.put("^\\s*NearFieldScanningOpticalMicroscopy\\s*", "NearFieldScanningOpticalMicroscopy");
        p.put("^\\s*SecondHarmonicGenerationImaging\\s*", "SecondHarmonicGenerationImaging");
        p.put("^\\s*PALM\\s*", "PALM");
        p.put("^\\s*STORM\\s*", "STORM");
        p.put("^\\s*STED\\s*", "STED");
        p.put("^\\s*TIRF\\s*", "TIRF");
        p.put("^\\s*FSM\\s*", "FSM");
        p.put("^\\s*LCM\\s*", "LCM");
        p.put("^\\s*Other\\s*", "Other");
        p.put(".*Widefield.*", "WideField");
        return p;
    }

    @Override
    public Enumeration getEnumeration(String value) throws EnumerationException {
        if (value != null) {
            for (String pattern : patterns.keySet()) {
                if (!value.toLowerCase().matches(pattern.toLowerCase())) continue;
                String v = patterns.get(pattern);
                return AcquisitionMode.fromString(v);
            }
        }
        LOGGER.warn("Unknown {} value '{}' will be stored as \"Other\"", (Object)"AcquisitionMode", (Object)value);
        return AcquisitionMode.OTHER;
    }

    @Override
    public Class<? extends Enumeration> getEntity() {
        return AcquisitionMode.class;
    }
}

