/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.buffer.tboolean;

import cern.colt.PersistentObject;
import cern.colt.buffer.tboolean.BooleanBufferConsumer;
import cern.colt.list.tboolean.BooleanArrayList;

public class BooleanBuffer
extends PersistentObject
implements BooleanBufferConsumer {
    private static final long serialVersionUID = 1L;
    protected BooleanBufferConsumer target;
    protected boolean[] elements;
    protected BooleanArrayList list;
    protected int capacity;
    protected int size;

    public BooleanBuffer(BooleanBufferConsumer target, int capacity) {
        this.target = target;
        this.capacity = capacity;
        this.elements = new boolean[capacity];
        this.list = new BooleanArrayList(this.elements);
        this.size = 0;
    }

    public void add(boolean element) {
        if (this.size == this.capacity) {
            this.flush();
        }
        this.elements[this.size++] = element;
    }

    @Override
    public void addAllOf(BooleanArrayList list) {
        int listSize = list.size();
        if (this.size + listSize >= this.capacity) {
            this.flush();
        }
        this.target.addAllOf(list);
    }

    public void clear() {
        this.size = 0;
    }

    public void flush() {
        if (this.size > 0) {
            this.list.setSize(this.size);
            this.target.addAllOf(this.list);
            this.size = 0;
        }
    }
}

