/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.list.tdouble;

import cern.colt.Arrays;
import cern.colt.Sorting;
import cern.colt.function.tdouble.DoubleProcedure;
import cern.colt.list.tdouble.AbstractDoubleList;
import cern.jet.math.tdouble.DoubleArithmetic;
import cern.jet.random.tdouble.DoubleUniform;
import cern.jet.random.tdouble.engine.DRand;
import java.util.Date;

public class DoubleArrayList
extends AbstractDoubleList {
    private static final long serialVersionUID = 1L;
    protected double[] elements;

    public DoubleArrayList() {
        this(10);
    }

    public DoubleArrayList(double[] elements) {
        this.elements(elements);
    }

    public DoubleArrayList(int initialCapacity) {
        this(new double[initialCapacity]);
        this.setSizeRaw(0);
    }

    @Override
    public void add(double element) {
        if (this.size == this.elements.length) {
            this.ensureCapacity(this.size + 1);
        }
        this.elements[this.size++] = element;
    }

    @Override
    public void beforeInsert(int index, double element) {
        if (this.size == index) {
            this.add(element);
            return;
        }
        if (index > this.size || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        this.ensureCapacity(this.size + 1);
        System.arraycopy(this.elements, index, this.elements, index + 1, this.size - index);
        this.elements[index] = element;
        ++this.size;
    }

    @Override
    public int binarySearchFromTo(double key, int from, int to) {
        return Sorting.binarySearchFromTo(this.elements, key, from, to);
    }

    @Override
    public Object clone() {
        DoubleArrayList clone = new DoubleArrayList((double[])this.elements.clone());
        clone.setSizeRaw(this.size);
        return clone;
    }

    public DoubleArrayList copy() {
        return (DoubleArrayList)this.clone();
    }

    @Override
    public double[] elements() {
        return this.elements;
    }

    @Override
    public AbstractDoubleList elements(double[] elements) {
        this.elements = elements;
        this.size = elements.length;
        return this;
    }

    @Override
    public void ensureCapacity(int minCapacity) {
        this.elements = Arrays.ensureCapacity(this.elements, minCapacity);
    }

    @Override
    public boolean equals(Object otherObj) {
        if (!(otherObj instanceof DoubleArrayList)) {
            return super.equals(otherObj);
        }
        if (this == otherObj) {
            return true;
        }
        if (otherObj == null) {
            return false;
        }
        DoubleArrayList other = (DoubleArrayList)otherObj;
        if (this.size() != other.size()) {
            return false;
        }
        double[] theElements = this.elements();
        double[] otherElements = other.elements();
        int i = this.size();
        while (--i >= 0) {
            if (theElements[i] == otherElements[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean forEach(DoubleProcedure procedure) {
        double[] theElements = this.elements;
        int theSize = this.size;
        int i = 0;
        while (i < theSize) {
            if (procedure.apply(theElements[i++])) continue;
            return false;
        }
        return true;
    }

    @Override
    public double get(int index) {
        if (index >= this.size || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        return this.elements[index];
    }

    @Override
    public double getQuick(int index) {
        return this.elements[index];
    }

    @Override
    public int indexOfFromTo(double element, int from, int to) {
        if (this.size == 0) {
            return -1;
        }
        DoubleArrayList.checkRangeFromTo(from, to, this.size);
        double[] theElements = this.elements;
        int i = from;
        while (i <= to) {
            if (element == theElements[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public int lastIndexOfFromTo(double element, int from, int to) {
        if (this.size == 0) {
            return -1;
        }
        DoubleArrayList.checkRangeFromTo(from, to, this.size);
        double[] theElements = this.elements;
        int i = to;
        while (i >= from) {
            if (element == theElements[i]) {
                return i;
            }
            --i;
        }
        return -1;
    }

    @Override
    public AbstractDoubleList partFromTo(int from, int to) {
        if (this.size == 0) {
            return new DoubleArrayList(0);
        }
        DoubleArrayList.checkRangeFromTo(from, to, this.size);
        double[] part = new double[to - from + 1];
        System.arraycopy(this.elements, from, part, 0, to - from + 1);
        return new DoubleArrayList(part);
    }

    @Override
    public boolean removeAll(AbstractDoubleList other) {
        double M;
        if (!(other instanceof DoubleArrayList)) {
            return super.removeAll(other);
        }
        if (other.size() == 0) {
            return false;
        }
        int limit = other.size() - 1;
        int j = 0;
        double[] theElements = this.elements;
        int mySize = this.size();
        double N = other.size();
        if ((N + (M = (double)mySize)) * DoubleArithmetic.log2(N) < M * N) {
            DoubleArrayList sortedList = (DoubleArrayList)other.clone();
            sortedList.quickSort();
            int i = 0;
            while (i < mySize) {
                if (sortedList.binarySearchFromTo(theElements[i], 0, limit) < 0) {
                    theElements[j++] = theElements[i];
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < mySize) {
                if (other.indexOfFromTo(theElements[i], 0, limit) < 0) {
                    theElements[j++] = theElements[i];
                }
                ++i;
            }
        }
        boolean modified = j != mySize;
        this.setSize(j);
        return modified;
    }

    @Override
    public void replaceFromToWithFrom(int from, int to, AbstractDoubleList other, int otherFrom) {
        if (!(other instanceof DoubleArrayList)) {
            super.replaceFromToWithFrom(from, to, other, otherFrom);
            return;
        }
        int length = to - from + 1;
        if (length > 0) {
            DoubleArrayList.checkRangeFromTo(from, to, this.size());
            DoubleArrayList.checkRangeFromTo(otherFrom, otherFrom + length - 1, other.size());
            System.arraycopy(((DoubleArrayList)other).elements, otherFrom, this.elements, from, length);
        }
    }

    @Override
    public boolean retainAll(AbstractDoubleList other) {
        double M;
        if (!(other instanceof DoubleArrayList)) {
            return super.retainAll(other);
        }
        int limit = other.size() - 1;
        int j = 0;
        double[] theElements = this.elements;
        int mySize = this.size();
        double N = other.size();
        if ((N + (M = (double)mySize)) * DoubleArithmetic.log2(N) < M * N) {
            DoubleArrayList sortedList = (DoubleArrayList)other.clone();
            sortedList.quickSort();
            int i = 0;
            while (i < mySize) {
                if (sortedList.binarySearchFromTo(theElements[i], 0, limit) >= 0) {
                    theElements[j++] = theElements[i];
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < mySize) {
                if (other.indexOfFromTo(theElements[i], 0, limit) >= 0) {
                    theElements[j++] = theElements[i];
                }
                ++i;
            }
        }
        boolean modified = j != mySize;
        this.setSize(j);
        return modified;
    }

    @Override
    public void reverse() {
        int limit = this.size / 2;
        int j = this.size - 1;
        double[] theElements = this.elements;
        int i = 0;
        while (i < limit) {
            double tmp = theElements[i];
            theElements[i++] = theElements[j];
            theElements[j--] = tmp;
        }
    }

    @Override
    public void set(int index, double element) {
        if (index >= this.size || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        this.elements[index] = element;
    }

    @Override
    public void setSizeRaw(int size) {
        this.size = size;
    }

    @Override
    public void setQuick(int index, double element) {
        this.elements[index] = element;
    }

    @Override
    public void shuffleFromTo(int from, int to) {
        if (this.size == 0) {
            return;
        }
        DoubleArrayList.checkRangeFromTo(from, to, this.size);
        DoubleUniform gen = new DoubleUniform(new DRand(new Date()));
        double[] theElements = this.elements;
        int i = from;
        while (i < to) {
            int random = gen.nextIntFromTo(i, to);
            double tmpElement = theElements[random];
            theElements[random] = theElements[i];
            theElements[i] = tmpElement;
            ++i;
        }
    }

    @Override
    public void trimToSize() {
        this.elements = Arrays.trimToCapacity(this.elements, this.size());
    }
}

