/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.io;

import cern.colt.matrix.io.MatrixInfo;
import cern.colt.matrix.io.MatrixSize;
import cern.colt.matrix.io.VectorInfo;
import cern.colt.matrix.io.VectorSize;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;

public class MatrixVectorWriter
extends PrintWriter {
    public MatrixVectorWriter(OutputStream out) {
        super(out);
    }

    public MatrixVectorWriter(OutputStream out, boolean autoFlush) {
        super(out, autoFlush);
    }

    public MatrixVectorWriter(Writer out) {
        super(out);
    }

    public MatrixVectorWriter(Writer out, boolean autoFlush) {
        super(out, autoFlush);
    }

    public void add(int num, int[] indexes) {
        int i = 0;
        while (i < indexes.length) {
            int n = i++;
            indexes[n] = indexes[n] + num;
        }
    }

    public void printMatrixInfo(MatrixInfo info) {
        this.print(info.toString());
    }

    public void printVectorInfo(VectorInfo info) {
        this.print(info.toString());
    }

    public void printMatrixSize(MatrixSize size, MatrixInfo info) {
        this.format("%10d %10d", size.numRows(), size.numColumns());
        if (info.isCoordinate()) {
            this.format(" %19d", size.numEntries());
        }
        this.println();
    }

    public void printMatrixSize(MatrixSize size) {
        this.format("%10d %10d %19d\n", size.numRows(), size.numColumns(), size.numEntries());
    }

    public void printVectorSize(VectorSize size, VectorInfo info) {
        this.format("%10d", size.size());
        if (info.isCoordinate()) {
            this.format(" %19d", size.numEntries());
        }
        this.println();
    }

    public void printVectorSize(VectorSize size) {
        this.format("%10d %19d\n", size.size(), size.numEntries());
    }

    public void printArray(float[] data) {
        int i = 0;
        while (i < data.length) {
            this.format("% .12e\n", Float.valueOf(data[i]));
            ++i;
        }
    }

    public void printArray(double[] data) {
        int i = 0;
        while (i < data.length) {
            this.format("% .12e\n", data[i]);
            ++i;
        }
    }

    public void printArray(float[] dataR, float[] dataI) {
        int size = dataR.length;
        if (size != dataI.length) {
            throw new IllegalArgumentException("All arrays must be of the same size");
        }
        int i = 0;
        while (i < size) {
            this.format("% .12e % .12e\n", Float.valueOf(dataR[i]), Float.valueOf(dataI[i]));
            ++i;
        }
    }

    public void printArray(double[] dataR, double[] dataI) {
        int size = dataR.length;
        if (size != dataI.length) {
            throw new IllegalArgumentException("All arrays must be of the same size");
        }
        int i = 0;
        while (i < size) {
            this.format("% .12e % .12e\n", dataR[i], dataI[i]);
            ++i;
        }
    }

    public void printArray(int[] data) {
        int i = 0;
        while (i < data.length) {
            this.format("%10d\n", data[i]);
            ++i;
        }
    }

    public void printArray(long[] data) {
        int i = 0;
        while (i < data.length) {
            this.format("%10d\n", data[i]);
            ++i;
        }
    }

    public void printCoordinate(int[] index, float[] data, int offset) {
        int size = index.length;
        if (size != data.length) {
            throw new IllegalArgumentException("All arrays must be of the same size");
        }
        int i = 0;
        while (i < size) {
            this.format("%10d % .12e\n", index[i] + offset, Float.valueOf(data[i]));
            ++i;
        }
    }

    public void printCoordinate(int[] index, double[] data, int offset) {
        int size = index.length;
        if (size != data.length) {
            throw new IllegalArgumentException("All arrays must be of the same size");
        }
        int i = 0;
        while (i < size) {
            this.format("%10d % .12e\n", index[i] + offset, data[i]);
            ++i;
        }
    }

    public void printCoordinate(int[] index, int[] data, int offset) {
        int size = index.length;
        if (size != data.length) {
            throw new IllegalArgumentException("All arrays must be of the same size");
        }
        int i = 0;
        while (i < size) {
            this.format("%10d %10d\n", index[i] + offset, data[i]);
            ++i;
        }
    }

    public void printCoordinate(int[] index, long[] data, int offset) {
        int size = index.length;
        if (size != data.length) {
            throw new IllegalArgumentException("All arrays must be of the same size");
        }
        int i = 0;
        while (i < size) {
            this.format("%10d %10d\n", index[i] + offset, data[i]);
            ++i;
        }
    }

    public void printCoordinate(int[] row, int[] column, float[] data, int offset) {
        int size = row.length;
        if (size != column.length || size != data.length) {
            throw new IllegalArgumentException("All arrays must be of the same size");
        }
        int i = 0;
        while (i < size) {
            this.format("%10d %10d % .12e\n", row[i] + offset, column[i] + offset, Float.valueOf(data[i]));
            ++i;
        }
    }

    public void printCoordinate(int[] row, int[] column, double[] data, int offset) {
        int size = row.length;
        if (size != column.length || size != data.length) {
            throw new IllegalArgumentException("All arrays must be of the same size");
        }
        int i = 0;
        while (i < size) {
            this.format("%10d %10d % .12e\n", row[i] + offset, column[i] + offset, data[i]);
            ++i;
        }
    }

    public void printCoordinate(int[] index, float[] dataR, float[] dataI, int offset) {
        int size = index.length;
        if (size != dataR.length || size != dataI.length) {
            throw new IllegalArgumentException("All arrays must be of the same size");
        }
        int i = 0;
        while (i < size) {
            this.format("%10d % .12e % .12e\n", index[i] + offset, Float.valueOf(dataR[i]), Float.valueOf(dataI[i]));
            ++i;
        }
    }

    public void printCoordinate(int[] index, double[] dataR, double[] dataI, int offset) {
        int size = index.length;
        if (size != dataR.length || size != dataI.length) {
            throw new IllegalArgumentException("All arrays must be of the same size");
        }
        int i = 0;
        while (i < size) {
            this.format("%10d % .12e % .12e\n", index[i] + offset, dataR[i], dataI[i]);
            ++i;
        }
    }

    public void printCoordinate(int[] row, int[] column, float[] dataR, float[] dataI, int offset) {
        int size = row.length;
        if (size != column.length || size != dataR.length || size != dataI.length) {
            throw new IllegalArgumentException("All arrays must be of the same size");
        }
        int i = 0;
        while (i < size) {
            this.format("%10d %10d % .12e % .12e\n", row[i] + offset, column[i] + offset, Float.valueOf(dataR[i]), Float.valueOf(dataI[i]));
            ++i;
        }
    }

    public void printCoordinate(int[] row, int[] column, double[] dataR, double[] dataI, int offset) {
        int size = row.length;
        if (size != column.length || size != dataR.length || size != dataI.length) {
            throw new IllegalArgumentException("All arrays must be of the same size");
        }
        int i = 0;
        while (i < size) {
            this.format("%10d %10d % .12e % .12e\n", row[i] + offset, column[i] + offset, dataR[i], dataI[i]);
            ++i;
        }
    }

    public void printCoordinate(int[] row, int[] column, int[] data, int offset) {
        int size = row.length;
        if (size != column.length || size != data.length) {
            throw new IllegalArgumentException("All arrays must be of the same size");
        }
        int i = 0;
        while (i < size) {
            this.format("%10d %10d %19d\n", row[i] + offset, column[i] + offset, data[i]);
            ++i;
        }
    }

    public void printCoordinate(int[] row, int[] column, long[] data, int offset) {
        int size = row.length;
        if (size != column.length || size != data.length) {
            throw new IllegalArgumentException("All arrays must be of the same size");
        }
        int i = 0;
        while (i < size) {
            this.format("%10d %10d %19d\n", row[i] + offset, column[i] + offset, data[i]);
            ++i;
        }
    }

    public void printPattern(int[] row, int[] column, int offset) {
        int size = row.length;
        if (size != column.length) {
            throw new IllegalArgumentException("All arrays must be of the same size");
        }
        int i = 0;
        while (i < size) {
            this.format("%10d %10d\n", row[i] + offset, column[i] + offset);
            ++i;
        }
    }

    public void printPattern(int[] index, int offset) {
        int size = index.length;
        int i = 0;
        while (i < size) {
            this.format("%10d\n", index[i] + offset);
            ++i;
        }
    }

    public void printCoordinate(int[] row, int[] column, float[] data) {
        this.printCoordinate(row, column, data, 0);
    }

    public void printCoordinate(int[] row, int[] column, double[] data) {
        this.printCoordinate(row, column, data, 0);
    }

    public void printCoordinate(int[] row, int[] column, float[] dataR, float[] dataI) {
        this.printCoordinate(row, column, dataR, dataI, 0);
    }

    public void printCoordinate(int[] row, int[] column, double[] dataR, double[] dataI) {
        this.printCoordinate(row, column, dataR, dataI, 0);
    }

    public void printCoordinate(int[] row, int[] column, int[] data) {
        this.printCoordinate(row, column, data, 0);
    }

    public void printCoordinate(int[] row, int[] column, long[] data) {
        this.printCoordinate(row, column, data, 0);
    }

    public void printPattern(int[] row, int[] column) {
        this.printPattern(row, column, 0);
    }

    public void printCoordinate(int[] index, float[] data) {
        this.printCoordinate(index, data, 0);
    }

    public void printCoordinate(int[] index, double[] data) {
        this.printCoordinate(index, data, 0);
    }

    public void printCoordinate(int[] index, float[] dataR, float[] dataI) {
        this.printCoordinate(index, dataR, dataI, 0);
    }

    public void printCoordinate(int[] index, double[] dataR, double[] dataI) {
        this.printCoordinate(index, dataR, dataI, 0);
    }

    public void printCoordinate(int[] index, int[] data) {
        this.printCoordinate(index, data, 0);
    }

    public void printCoordinate(int[] index, long[] data) {
        this.printCoordinate(index, data, 0);
    }

    public void printPattern(int[] index) {
        this.printPattern(index, 0);
    }

    public void printComments(String[] comments) {
        String[] stringArray = comments;
        int n = comments.length;
        int n2 = 0;
        while (n2 < n) {
            String comment = stringArray[n2];
            this.println("%" + comment);
            ++n2;
        }
    }
}

