/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble;

import cern.colt.ConcurrencyUtils;
import cern.colt.function.tdouble.Double9Function;
import cern.colt.function.tdouble.DoubleDoubleFunction;
import cern.colt.function.tdouble.DoubleFunction;
import cern.colt.function.tdouble.DoubleProcedure;
import cern.colt.function.tdouble.IntIntDoubleFunction;
import cern.colt.list.tdouble.DoubleArrayList;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.AbstractMatrix2D;
import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix1DProcedure;
import cern.colt.matrix.tdouble.algo.DoubleFormatter;
import cern.colt.matrix.tdouble.algo.DoubleProperty;
import cern.colt.matrix.tdouble.algo.DoubleSorting;
import cern.jet.math.tdouble.DoubleFunctions;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public abstract class DoubleMatrix2D
extends AbstractMatrix2D {
    private static final long serialVersionUID = 1L;

    protected DoubleMatrix2D() {
    }

    public double aggregate(final DoubleDoubleFunction aggr, final DoubleFunction f) {
        if (this.size() == 0L) {
            return Double.NaN;
        }
        double a = 0.0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Double>(){

                    @Override
                    public Double call() throws Exception {
                        double a = f.apply(DoubleMatrix2D.this.getQuick(firstRow, 0));
                        int d = 1;
                        int r = firstRow;
                        while (r < lastRow) {
                            int c = d;
                            while (c < DoubleMatrix2D.this.columns) {
                                a = aggr.apply(a, f.apply(DoubleMatrix2D.this.getQuick(r, c)));
                                ++c;
                            }
                            d = 0;
                            ++r;
                        }
                        return a;
                    }
                });
                ++j;
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            a = f.apply(this.getQuick(0, 0));
            int d = 1;
            int r = 0;
            while (r < this.rows) {
                int c = d;
                while (c < this.columns) {
                    a = aggr.apply(a, f.apply(this.getQuick(r, c)));
                    ++c;
                }
                d = 0;
                ++r;
            }
        }
        return a;
    }

    public double aggregate(final DoubleDoubleFunction aggr, final DoubleFunction f, final DoubleProcedure cond) {
        if (this.size() == 0L) {
            return Double.NaN;
        }
        double a = 0.0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Double>(){

                    @Override
                    public Double call() throws Exception {
                        double elem = DoubleMatrix2D.this.getQuick(firstRow, 0);
                        double a = 0.0;
                        if (cond.apply(elem)) {
                            a = aggr.apply(a, f.apply(elem));
                        }
                        int d = 1;
                        int r = firstRow;
                        while (r < lastRow) {
                            int c = d;
                            while (c < DoubleMatrix2D.this.columns) {
                                elem = DoubleMatrix2D.this.getQuick(r, c);
                                if (cond.apply(elem)) {
                                    a = aggr.apply(a, f.apply(elem));
                                }
                                ++c;
                            }
                            d = 0;
                            ++r;
                        }
                        return a;
                    }
                });
                ++j;
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            double elem = this.getQuick(0, 0);
            if (cond.apply(elem)) {
                a = aggr.apply(a, f.apply(elem));
            }
            int d = 1;
            int r = 0;
            while (r < this.rows) {
                int c = d;
                while (c < this.columns) {
                    elem = this.getQuick(r, c);
                    if (cond.apply(elem)) {
                        a = aggr.apply(a, f.apply(elem));
                    }
                    ++c;
                }
                d = 0;
                ++r;
            }
        }
        return a;
    }

    public double aggregate(final DoubleDoubleFunction aggr, final DoubleFunction f, IntArrayList rowList, IntArrayList columnList) {
        if (this.size() == 0L) {
            return Double.NaN;
        }
        int size = rowList.size();
        final int[] rowElements = rowList.elements();
        final int[] columnElements = columnList.elements();
        double a = 0.0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && size >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, size);
            Future[] futures = new Future[nthreads];
            int k = size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Double>(){

                    @Override
                    public Double call() throws Exception {
                        double a = f.apply(DoubleMatrix2D.this.getQuick(rowElements[firstIdx], columnElements[firstIdx]));
                        int i = firstIdx + 1;
                        while (i < lastIdx) {
                            double elem = DoubleMatrix2D.this.getQuick(rowElements[i], columnElements[i]);
                            a = aggr.apply(a, f.apply(elem));
                            ++i;
                        }
                        return a;
                    }
                });
                ++j;
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            a = f.apply(this.getQuick(rowElements[0], columnElements[0]));
            int i = 1;
            while (i < size) {
                double elem = this.getQuick(rowElements[i], columnElements[i]);
                a = aggr.apply(a, f.apply(elem));
                ++i;
            }
        }
        return a;
    }

    public double aggregate(final DoubleMatrix2D other, final DoubleDoubleFunction aggr, final DoubleDoubleFunction f) {
        this.checkShape(other);
        if (this.size() == 0L) {
            return Double.NaN;
        }
        double a = 0.0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Double>(){

                    @Override
                    public Double call() throws Exception {
                        double a = f.apply(DoubleMatrix2D.this.getQuick(firstRow, 0), other.getQuick(firstRow, 0));
                        int d = 1;
                        int r = firstRow;
                        while (r < lastRow) {
                            int c = d;
                            while (c < DoubleMatrix2D.this.columns) {
                                a = aggr.apply(a, f.apply(DoubleMatrix2D.this.getQuick(r, c), other.getQuick(r, c)));
                                ++c;
                            }
                            d = 0;
                            ++r;
                        }
                        return a;
                    }
                });
                ++j;
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            a = f.apply(this.getQuick(0, 0), other.getQuick(0, 0));
            int d = 1;
            int r = 0;
            while (r < this.rows) {
                int c = d;
                while (c < this.columns) {
                    a = aggr.apply(a, f.apply(this.getQuick(r, c), other.getQuick(r, c)));
                    ++c;
                }
                d = 0;
                ++r;
            }
        }
        return a;
    }

    public DoubleMatrix2D assign(final DoubleFunction f) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int r = firstRow;
                        while (r < lastRow) {
                            int c = 0;
                            while (c < DoubleMatrix2D.this.columns) {
                                DoubleMatrix2D.this.setQuick(r, c, f.apply(DoubleMatrix2D.this.getQuick(r, c)));
                                ++c;
                            }
                            ++r;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int r = 0;
            while (r < this.rows) {
                int c = 0;
                while (c < this.columns) {
                    this.setQuick(r, c, f.apply(this.getQuick(r, c)));
                    ++c;
                }
                ++r;
            }
        }
        return this;
    }

    public DoubleMatrix2D assign(final DoubleProcedure cond, final DoubleFunction f) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int r = firstRow;
                        while (r < lastRow) {
                            int c = 0;
                            while (c < DoubleMatrix2D.this.columns) {
                                double elem = DoubleMatrix2D.this.getQuick(r, c);
                                if (cond.apply(elem)) {
                                    DoubleMatrix2D.this.setQuick(r, c, f.apply(elem));
                                }
                                ++c;
                            }
                            ++r;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int r = 0;
            while (r < this.rows) {
                int c = 0;
                while (c < this.columns) {
                    double elem = this.getQuick(r, c);
                    if (cond.apply(elem)) {
                        this.setQuick(r, c, f.apply(elem));
                    }
                    ++c;
                }
                ++r;
            }
        }
        return this;
    }

    public DoubleMatrix2D assign(final DoubleProcedure cond, final double value) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int r = firstRow;
                        while (r < lastRow) {
                            int c = 0;
                            while (c < DoubleMatrix2D.this.columns) {
                                double elem = DoubleMatrix2D.this.getQuick(r, c);
                                if (cond.apply(elem)) {
                                    DoubleMatrix2D.this.setQuick(r, c, value);
                                }
                                ++c;
                            }
                            ++r;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int r = 0;
            while (r < this.rows) {
                int c = 0;
                while (c < this.columns) {
                    double elem = this.getQuick(r, c);
                    if (cond.apply(elem)) {
                        this.setQuick(r, c, value);
                    }
                    ++c;
                }
                ++r;
            }
        }
        return this;
    }

    public DoubleMatrix2D assign(final double value) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int r = firstRow;
                        while (r < lastRow) {
                            int c = 0;
                            while (c < DoubleMatrix2D.this.columns) {
                                DoubleMatrix2D.this.setQuick(r, c, value);
                                ++c;
                            }
                            ++r;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int r = 0;
            while (r < this.rows) {
                int c = 0;
                while (c < this.columns) {
                    this.setQuick(r, c, value);
                    ++c;
                }
                ++r;
            }
        }
        return this;
    }

    public DoubleMatrix2D assign(final double[] values) {
        if (values.length != this.rows * this.columns) {
            throw new IllegalArgumentException("Must have same length: length=" + values.length + "rows()*columns()=" + this.rows() * this.columns());
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = firstRow * DoubleMatrix2D.this.columns;
                        int r = firstRow;
                        while (r < lastRow) {
                            int c = 0;
                            while (c < DoubleMatrix2D.this.columns) {
                                DoubleMatrix2D.this.setQuick(r, c, values[idx++]);
                                ++c;
                            }
                            ++r;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = 0;
            int r = 0;
            while (r < this.rows) {
                int c = 0;
                while (c < this.columns) {
                    this.setQuick(r, c, values[idx++]);
                    ++c;
                }
                ++r;
            }
        }
        return this;
    }

    public DoubleMatrix2D assign(final double[][] values) {
        if (values.length != this.rows) {
            throw new IllegalArgumentException("Must have same number of rows: rows=" + values.length + "rows()=" + this.rows());
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int r = firstRow;
                        while (r < lastRow) {
                            double[] currentRow = values[r];
                            if (currentRow.length != DoubleMatrix2D.this.columns) {
                                throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + currentRow.length + "columns()=" + DoubleMatrix2D.this.columns());
                            }
                            int c = 0;
                            while (c < DoubleMatrix2D.this.columns) {
                                DoubleMatrix2D.this.setQuick(r, c, currentRow[c]);
                                ++c;
                            }
                            ++r;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int r = 0;
            while (r < this.rows) {
                double[] currentRow = values[r];
                if (currentRow.length != this.columns) {
                    throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + currentRow.length + "columns()=" + this.columns());
                }
                int c = 0;
                while (c < this.columns) {
                    this.setQuick(r, c, currentRow[c]);
                    ++c;
                }
                ++r;
            }
        }
        return this;
    }

    public DoubleMatrix2D assign(DoubleMatrix2D other) {
        if (other == this) {
            return this;
        }
        this.checkShape(other);
        final DoubleMatrix2D source = this.haveSharedCells(other) ? other.copy() : other;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int r = firstRow;
                        while (r < lastRow) {
                            int c = 0;
                            while (c < DoubleMatrix2D.this.columns) {
                                DoubleMatrix2D.this.setQuick(r, c, source.getQuick(r, c));
                                ++c;
                            }
                            ++r;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int r = 0;
            while (r < this.rows) {
                int c = 0;
                while (c < this.columns) {
                    this.setQuick(r, c, source.getQuick(r, c));
                    ++c;
                }
                ++r;
            }
        }
        return this;
    }

    public DoubleMatrix2D assign(final DoubleMatrix2D y, final DoubleDoubleFunction function) {
        this.checkShape(y);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int r = firstRow;
                        while (r < lastRow) {
                            int c = 0;
                            while (c < DoubleMatrix2D.this.columns) {
                                DoubleMatrix2D.this.setQuick(r, c, function.apply(DoubleMatrix2D.this.getQuick(r, c), y.getQuick(r, c)));
                                ++c;
                            }
                            ++r;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int r = 0;
            while (r < this.rows) {
                int c = 0;
                while (c < this.columns) {
                    this.setQuick(r, c, function.apply(this.getQuick(r, c), y.getQuick(r, c)));
                    ++c;
                }
                ++r;
            }
        }
        return this;
    }

    public DoubleMatrix2D assign(final DoubleMatrix2D y, final DoubleDoubleFunction function, IntArrayList rowList, IntArrayList columnList) {
        this.checkShape(y);
        int size = rowList.size();
        final int[] rowElements = rowList.elements();
        final int[] columnElements = columnList.elements();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && size >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int i = firstIdx;
                        while (i < lastIdx) {
                            DoubleMatrix2D.this.setQuick(rowElements[i], columnElements[i], function.apply(DoubleMatrix2D.this.getQuick(rowElements[i], columnElements[i]), y.getQuick(rowElements[i], columnElements[i])));
                            ++i;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int i = 0;
            while (i < size) {
                this.setQuick(rowElements[i], columnElements[i], function.apply(this.getQuick(rowElements[i], columnElements[i]), y.getQuick(rowElements[i], columnElements[i])));
                ++i;
            }
        }
        return this;
    }

    public DoubleMatrix2D assign(final float[] values) {
        if (values.length != this.rows * this.columns) {
            throw new IllegalArgumentException("Must have same length: length=" + values.length + "rows()*columns()=" + this.rows() * this.columns());
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = firstRow * DoubleMatrix2D.this.columns;
                        int r = firstRow;
                        while (r < lastRow) {
                            int c = 0;
                            while (c < DoubleMatrix2D.this.columns) {
                                DoubleMatrix2D.this.setQuick(r, c, values[idx++]);
                                ++c;
                            }
                            ++r;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = 0;
            int r = 0;
            while (r < this.rows) {
                int c = 0;
                while (c < this.columns) {
                    this.setQuick(r, c, values[idx++]);
                    ++c;
                }
                ++r;
            }
        }
        return this;
    }

    public int cardinality() {
        int cardinality = 0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            Integer[] results = new Integer[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int cardinality = 0;
                        int r = firstRow;
                        while (r < lastRow) {
                            int c = 0;
                            while (c < DoubleMatrix2D.this.columns) {
                                if (DoubleMatrix2D.this.getQuick(r, c) != 0.0) {
                                    ++cardinality;
                                }
                                ++c;
                            }
                            ++r;
                        }
                        return cardinality;
                    }
                });
                ++j;
            }
            try {
                j = 0;
                while (j < nthreads) {
                    results[j] = (Integer)futures[j].get();
                    ++j;
                }
                cardinality = results[0];
                j = 1;
                while (j < nthreads) {
                    cardinality += results[j].intValue();
                    ++j;
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            int r = 0;
            while (r < this.rows) {
                int c = 0;
                while (c < this.columns) {
                    if (this.getQuick(r, c) != 0.0) {
                        ++cardinality;
                    }
                    ++c;
                }
                ++r;
            }
        }
        return cardinality;
    }

    public DoubleMatrix2D copy() {
        return this.like().assign(this);
    }

    public abstract Object elements();

    public boolean equals(double value) {
        return DoubleProperty.DEFAULT.equals(this, value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DoubleMatrix2D)) {
            return false;
        }
        return DoubleProperty.DEFAULT.equals(this, (DoubleMatrix2D)obj);
    }

    public DoubleMatrix2D forEachNonZero(final IntIntDoubleFunction function) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int r = firstRow;
                        while (r < lastRow) {
                            int c = 0;
                            while (c < DoubleMatrix2D.this.columns) {
                                double a;
                                double value = DoubleMatrix2D.this.getQuick(r, c);
                                if (value != 0.0 && (a = function.apply(r, c, value)) != value) {
                                    DoubleMatrix2D.this.setQuick(r, c, a);
                                }
                                ++c;
                            }
                            ++r;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int r = 0;
            while (r < this.rows) {
                int c = 0;
                while (c < this.columns) {
                    double a;
                    double value = this.getQuick(r, c);
                    if (value != 0.0 && (a = function.apply(r, c, value)) != value) {
                        this.setQuick(r, c, a);
                    }
                    ++c;
                }
                ++r;
            }
        }
        return this;
    }

    public double get(int row, int column) {
        if (column < 0 || column >= this.columns || row < 0 || row >= this.rows) {
            throw new IndexOutOfBoundsException("row:" + row + ", column:" + column);
        }
        return this.getQuick(row, column);
    }

    public double[] getMaxLocation() {
        int rowLocation = 0;
        int columnLocation = 0;
        double maxValue = 0.0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            double[][] results = new double[nthreads][2];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<double[]>(){

                    @Override
                    public double[] call() throws Exception {
                        int rowLocation = firstRow;
                        int columnLocation = 0;
                        double maxValue = DoubleMatrix2D.this.getQuick(rowLocation, 0);
                        int d = 1;
                        int r = firstRow;
                        while (r < lastRow) {
                            int c = d;
                            while (c < DoubleMatrix2D.this.columns) {
                                double elem = DoubleMatrix2D.this.getQuick(r, c);
                                if (maxValue < elem) {
                                    maxValue = elem;
                                    rowLocation = r;
                                    columnLocation = c;
                                }
                                ++c;
                            }
                            d = 0;
                            ++r;
                        }
                        return new double[]{maxValue, rowLocation, columnLocation};
                    }
                });
                ++j;
            }
            try {
                j = 0;
                while (j < nthreads) {
                    results[j] = (double[])futures[j].get();
                    ++j;
                }
                maxValue = results[0][0];
                rowLocation = (int)results[0][1];
                columnLocation = (int)results[0][2];
                j = 1;
                while (j < nthreads) {
                    if (maxValue < results[j][0]) {
                        maxValue = results[j][0];
                        rowLocation = (int)results[j][1];
                        columnLocation = (int)results[j][2];
                    }
                    ++j;
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            maxValue = this.getQuick(0, 0);
            int d = 1;
            int r = 0;
            while (r < this.rows) {
                int c = d;
                while (c < this.columns) {
                    double elem = this.getQuick(r, c);
                    if (maxValue < elem) {
                        maxValue = elem;
                        rowLocation = r;
                        columnLocation = c;
                    }
                    ++c;
                }
                d = 0;
                ++r;
            }
        }
        return new double[]{maxValue, rowLocation, columnLocation};
    }

    public double[] getMinLocation() {
        int rowLocation = 0;
        int columnLocation = 0;
        double minValue = 0.0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            double[][] results = new double[nthreads][2];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<double[]>(){

                    @Override
                    public double[] call() throws Exception {
                        int rowLocation = firstRow;
                        int columnLocation = 0;
                        double minValue = DoubleMatrix2D.this.getQuick(rowLocation, 0);
                        int d = 1;
                        int r = firstRow;
                        while (r < lastRow) {
                            int c = d;
                            while (c < DoubleMatrix2D.this.columns) {
                                double elem = DoubleMatrix2D.this.getQuick(r, c);
                                if (minValue > elem) {
                                    minValue = elem;
                                    rowLocation = r;
                                    columnLocation = c;
                                }
                                ++c;
                            }
                            d = 0;
                            ++r;
                        }
                        return new double[]{minValue, rowLocation, columnLocation};
                    }
                });
                ++j;
            }
            try {
                j = 0;
                while (j < nthreads) {
                    results[j] = (double[])futures[j].get();
                    ++j;
                }
                minValue = results[0][0];
                rowLocation = (int)results[0][1];
                columnLocation = (int)results[0][2];
                j = 1;
                while (j < nthreads) {
                    if (minValue > results[j][0]) {
                        minValue = results[j][0];
                        rowLocation = (int)results[j][1];
                        columnLocation = (int)results[j][2];
                    }
                    ++j;
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            minValue = this.getQuick(0, 0);
            int d = 1;
            int r = 0;
            while (r < this.rows) {
                int c = d;
                while (c < this.columns) {
                    double elem = this.getQuick(r, c);
                    if (minValue > elem) {
                        minValue = elem;
                        rowLocation = r;
                        columnLocation = c;
                    }
                    ++c;
                }
                d = 0;
                ++r;
            }
        }
        return new double[]{minValue, rowLocation, columnLocation};
    }

    public void getNegativeValues(IntArrayList rowList, IntArrayList columnList, DoubleArrayList valueList) {
        rowList.clear();
        columnList.clear();
        valueList.clear();
        int r = 0;
        while (r < this.rows) {
            int c = 0;
            while (c < this.columns) {
                double value = this.getQuick(r, c);
                if (value < 0.0) {
                    rowList.add(r);
                    columnList.add(c);
                    valueList.add(value);
                }
                ++c;
            }
            ++r;
        }
    }

    public void getNonZeros(IntArrayList rowList, IntArrayList columnList, DoubleArrayList valueList) {
        rowList.clear();
        columnList.clear();
        valueList.clear();
        int r = 0;
        while (r < this.rows) {
            int c = 0;
            while (c < this.columns) {
                double value = this.getQuick(r, c);
                if (value != 0.0) {
                    rowList.add(r);
                    columnList.add(c);
                    valueList.add(value);
                }
                ++c;
            }
            ++r;
        }
    }

    public void getPositiveValues(IntArrayList rowList, IntArrayList columnList, DoubleArrayList valueList) {
        rowList.clear();
        columnList.clear();
        valueList.clear();
        int r = 0;
        while (r < this.rows) {
            int c = 0;
            while (c < this.columns) {
                double value = this.getQuick(r, c);
                if (value > 0.0) {
                    rowList.add(r);
                    columnList.add(c);
                    valueList.add(value);
                }
                ++c;
            }
            ++r;
        }
    }

    public abstract double getQuick(int var1, int var2);

    public DoubleMatrix2D like() {
        return this.like(this.rows, this.columns);
    }

    public abstract DoubleMatrix2D like(int var1, int var2);

    public abstract DoubleMatrix1D like1D(int var1);

    public void normalize() {
        double min = this.getMinLocation()[0];
        if (min < 0.0) {
            this.assign(DoubleFunctions.minus(min));
        }
        if (this.getMaxLocation()[0] == 0.0) {
            this.assign(1.0 / (double)this.size());
        } else {
            double sumScaleFactor = this.zSum();
            sumScaleFactor = 1.0 / sumScaleFactor;
            this.assign(DoubleFunctions.mult(sumScaleFactor));
        }
    }

    public void set(int row, int column, double value) {
        if (column < 0 || column >= this.columns || row < 0 || row >= this.rows) {
            throw new IndexOutOfBoundsException("row:" + row + ", column:" + column);
        }
        this.setQuick(row, column, value);
    }

    public abstract void setQuick(int var1, int var2, double var3);

    public double[][] toArray() {
        final double[][] values = new double[this.rows][this.columns];
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int r = firstRow;
                        while (r < lastRow) {
                            double[] currentRow = values[r];
                            int c = 0;
                            while (c < DoubleMatrix2D.this.columns) {
                                currentRow[c] = DoubleMatrix2D.this.getQuick(r, c);
                                ++c;
                            }
                            ++r;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int r = 0;
            while (r < this.rows) {
                double[] currentRow = values[r];
                int c = 0;
                while (c < this.columns) {
                    currentRow[c] = this.getQuick(r, c);
                    ++c;
                }
                ++r;
            }
        }
        return values;
    }

    public String toString() {
        return new DoubleFormatter().toString(this);
    }

    public abstract DoubleMatrix1D vectorize();

    public DoubleMatrix1D viewColumn(int column) {
        this.checkColumn(column);
        int viewSize = this.rows;
        int viewZero = (int)this.index(0, column);
        int viewStride = this.rowStride;
        return this.like1D(viewSize, viewZero, viewStride);
    }

    public DoubleMatrix2D viewColumnFlip() {
        return (DoubleMatrix2D)this.view().vColumnFlip();
    }

    public DoubleMatrix2D viewDice() {
        return (DoubleMatrix2D)this.view().vDice();
    }

    public DoubleMatrix2D viewPart(int row, int column, int height, int width) {
        return (DoubleMatrix2D)this.view().vPart(row, column, height, width);
    }

    public DoubleMatrix1D viewRow(int row) {
        this.checkRow(row);
        int viewSize = this.columns;
        int viewZero = (int)this.index(row, 0);
        int viewStride = this.columnStride;
        return this.like1D(viewSize, viewZero, viewStride);
    }

    public DoubleMatrix2D viewRowFlip() {
        return (DoubleMatrix2D)this.view().vRowFlip();
    }

    public DoubleMatrix2D viewSelection(DoubleMatrix1DProcedure condition) {
        IntArrayList matches = new IntArrayList();
        int i = 0;
        while (i < this.rows) {
            if (condition.apply(this.viewRow(i))) {
                matches.add(i);
            }
            ++i;
        }
        matches.trimToSize();
        return this.viewSelection(matches.elements(), null);
    }

    public DoubleMatrix2D viewSelection(int[] rowIndexes, int[] columnIndexes) {
        int i;
        if (rowIndexes == null) {
            rowIndexes = new int[this.rows];
            i = 0;
            while (i < this.rows) {
                rowIndexes[i] = i;
                ++i;
            }
        }
        if (columnIndexes == null) {
            columnIndexes = new int[this.columns];
            i = 0;
            while (i < this.columns) {
                columnIndexes[i] = i;
                ++i;
            }
        }
        this.checkRowIndexes(rowIndexes);
        this.checkColumnIndexes(columnIndexes);
        int[] rowOffsets = new int[rowIndexes.length];
        int[] columnOffsets = new int[columnIndexes.length];
        int i2 = 0;
        while (i2 < rowIndexes.length) {
            rowOffsets[i2] = this._rowOffset(this._rowRank(rowIndexes[i2]));
            ++i2;
        }
        i2 = 0;
        while (i2 < columnIndexes.length) {
            columnOffsets[i2] = this._columnOffset(this._columnRank(columnIndexes[i2]));
            ++i2;
        }
        return this.viewSelectionLike(rowOffsets, columnOffsets);
    }

    public DoubleMatrix2D viewSelection(Set<int[]> indexes) {
        int n = indexes.size();
        int[] rowIndexes = new int[n];
        int[] columnIndexes = new int[n];
        int idx = 0;
        for (int[] is : indexes) {
            rowIndexes[idx] = is[0];
            columnIndexes[idx] = is[1];
            ++idx;
        }
        this.checkRowIndexes(rowIndexes);
        this.checkColumnIndexes(columnIndexes);
        int[] rowOffsets = new int[rowIndexes.length];
        int[] columnOffsets = new int[columnIndexes.length];
        int i = 0;
        while (i < rowIndexes.length) {
            rowOffsets[i] = this._rowOffset(this._rowRank(rowIndexes[i]));
            ++i;
        }
        i = 0;
        while (i < columnIndexes.length) {
            columnOffsets[i] = this._columnOffset(this._columnRank(columnIndexes[i]));
            ++i;
        }
        return this.viewSelectionLike(rowOffsets, columnOffsets);
    }

    public DoubleMatrix2D viewSorted(int column) {
        return DoubleSorting.mergeSort.sort(this, column);
    }

    public DoubleMatrix2D viewStrides(int rowStride, int columnStride) {
        return (DoubleMatrix2D)this.view().vStrides(rowStride, columnStride);
    }

    public void zAssign8Neighbors(DoubleMatrix2D B, Double9Function function) {
        if (function == null) {
            throw new NullPointerException("function must not be null.");
        }
        this.checkShape(B);
        if (this.rows < 3 || this.columns < 3) {
            return;
        }
        int r = this.rows - 1;
        int c = this.columns - 1;
        int i = 1;
        while (i < r) {
            double a00 = this.getQuick(i - 1, 0);
            double a01 = this.getQuick(i - 1, 1);
            double a10 = this.getQuick(i, 0);
            double a11 = this.getQuick(i, 1);
            double a20 = this.getQuick(i + 1, 0);
            double a21 = this.getQuick(i + 1, 1);
            int j = 1;
            while (j < c) {
                double a02 = this.getQuick(i - 1, j + 1);
                double a12 = this.getQuick(i, j + 1);
                double a22 = this.getQuick(i + 1, j + 1);
                B.setQuick(i, j, function.apply(a00, a01, a02, a10, a11, a12, a20, a21, a22));
                a00 = a01;
                a10 = a11;
                a20 = a21;
                a01 = a02;
                a11 = a12;
                a21 = a22;
                ++j;
            }
            ++i;
        }
    }

    public DoubleMatrix1D zMult(DoubleMatrix1D y, DoubleMatrix1D z) {
        return this.zMult(y, z, 1.0, 0.0, false);
    }

    public DoubleMatrix1D zMult(final DoubleMatrix1D y, DoubleMatrix1D z, final double alpha, final double beta, boolean transposeA) {
        if (transposeA) {
            return this.viewDice().zMult(y, z, alpha, beta, false);
        }
        final DoubleMatrix1D zz = z == null ? y.like(this.rows) : z;
        if ((long)this.columns != y.size() || (long)this.rows > zz.size()) {
            throw new IllegalArgumentException("Incompatible args: " + this.toStringShort() + ", " + y.toStringShort() + ", " + zz.toStringShort());
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int r = firstRow;
                        while (r < lastRow) {
                            double s = 0.0;
                            int c = 0;
                            while (c < DoubleMatrix2D.this.columns) {
                                s += DoubleMatrix2D.this.getQuick(r, c) * y.getQuick(c);
                                ++c;
                            }
                            zz.setQuick(r, alpha * s + beta * zz.getQuick(r));
                            ++r;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int r = 0;
            while (r < this.rows) {
                double s = 0.0;
                int c = 0;
                while (c < this.columns) {
                    s += this.getQuick(r, c) * y.getQuick(c);
                    ++c;
                }
                zz.setQuick(r, alpha * s + beta * zz.getQuick(r));
                ++r;
            }
        }
        return zz;
    }

    public DoubleMatrix2D zMult(DoubleMatrix2D B, DoubleMatrix2D C) {
        return this.zMult(B, C, 1.0, 0.0, false, false);
    }

    public DoubleMatrix2D zMult(final DoubleMatrix2D B, DoubleMatrix2D C, final double alpha, final double beta, boolean transposeA, boolean transposeB) {
        if (transposeA) {
            return this.viewDice().zMult(B, C, alpha, beta, false, transposeB);
        }
        if (transposeB) {
            return this.zMult(B.viewDice(), C, alpha, beta, transposeA, false);
        }
        final int m = this.rows;
        final int n = this.columns;
        int p = B.columns;
        final DoubleMatrix2D CC = C == null ? this.like(m, p) : C;
        if (B.rows != n) {
            throw new IllegalArgumentException("Matrix2D inner dimensions must agree:" + this.toStringShort() + ", " + B.toStringShort());
        }
        if (CC.rows != m || CC.columns != p) {
            throw new IllegalArgumentException("Incompatibe result matrix: " + this.toStringShort() + ", " + B.toStringShort() + ", " + CC.toStringShort());
        }
        if (this == CC || B == CC) {
            throw new IllegalArgumentException("Matrices must not be identical");
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, p);
            Future[] futures = new Future[nthreads];
            int k = p / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? p : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int a = firstIdx;
                        while (a < lastIdx) {
                            int b = 0;
                            while (b < m) {
                                double s = 0.0;
                                int c = 0;
                                while (c < n) {
                                    s += DoubleMatrix2D.this.getQuick(b, c) * B.getQuick(c, a);
                                    ++c;
                                }
                                CC.setQuick(b, a, alpha * s + beta * CC.getQuick(b, a));
                                ++b;
                            }
                            ++a;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int a = 0;
            while (a < p) {
                int b = 0;
                while (b < m) {
                    double s = 0.0;
                    int c = 0;
                    while (c < n) {
                        s += this.getQuick(b, c) * B.getQuick(c, a);
                        ++c;
                    }
                    CC.setQuick(b, a, alpha * s + beta * CC.getQuick(b, a));
                    ++b;
                }
                ++a;
            }
        }
        return CC;
    }

    public double zSum() {
        if (this.size() == 0L) {
            return 0.0;
        }
        return this.aggregate(DoubleFunctions.plus, DoubleFunctions.identity);
    }

    protected DoubleMatrix2D getContent() {
        return this;
    }

    protected boolean haveSharedCells(DoubleMatrix2D other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        return this.getContent().haveSharedCellsRaw(other.getContent());
    }

    protected boolean haveSharedCellsRaw(DoubleMatrix2D other) {
        return false;
    }

    protected abstract DoubleMatrix1D like1D(int var1, int var2, int var3);

    protected DoubleMatrix2D view() {
        return (DoubleMatrix2D)this.clone();
    }

    protected abstract DoubleMatrix2D viewSelectionLike(int[] var1, int[] var2);
}

