/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.algo.decomposition;

import cern.colt.matrix.tdouble.DoubleFactory2D;
import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.algo.DoubleProperty;
import cern.colt.matrix.tdouble.impl.DenseColumnDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix2D;
import edu.emory.mathcs.jplasma.tdouble.Dplasma;
import java.io.Serializable;

public class DenseDoubleQRDecomposition
implements Serializable {
    static final long serialVersionUID = 1020L;
    private double[] elementsA;
    private double[] T;
    private boolean columnMatrix = false;
    private DoubleMatrix2D R;
    private DoubleMatrix2D Q;
    private int m;
    private int n;

    public DenseDoubleQRDecomposition(DoubleMatrix2D A) {
        DoubleProperty.DEFAULT.checkRectangular(A);
        DoubleProperty.DEFAULT.checkDense(A);
        if (A instanceof DenseDoubleMatrix2D) {
            this.elementsA = (double[])A.viewDice().copy().elements();
        } else {
            this.columnMatrix = true;
            this.elementsA = (double[])A.copy().elements();
        }
        this.m = A.rows();
        this.n = A.columns();
        int lda = this.m;
        Dplasma.plasma_Init((int)this.m, (int)this.n, (int)1);
        this.T = Dplasma.plasma_Allocate_T((int)this.m, (int)this.n);
        int info = Dplasma.plasma_DGEQRF((int)this.m, (int)this.n, (double[])this.elementsA, (int)0, (int)lda, (double[])this.T, (int)0);
        Dplasma.plasma_Finalize();
        if (info != 0) {
            throw new IllegalArgumentException("Error occured while computing QR decomposition: " + info);
        }
    }

    public DoubleMatrix2D getQ(boolean economySize) {
        if (this.Q == null) {
            Dplasma.plasma_Init((int)this.m, (int)this.n, (int)1);
            this.Q = new DenseColumnDoubleMatrix2D(this.m, this.m);
            double[] elementsQ = (double[])this.Q.elements();
            int i = 0;
            while (i < this.m) {
                elementsQ[this.m * i + i] = 1.0;
                ++i;
            }
            int info = Dplasma.plasma_DORMQR((int)141, (int)111, (int)this.m, (int)this.m, (int)this.n, (double[])this.elementsA, (int)0, (int)this.m, (double[])this.T, (int)0, (double[])elementsQ, (int)0, (int)this.m);
            Dplasma.plasma_Finalize();
            if (info != 0) {
                throw new IllegalArgumentException("Error occured while computing matrix Q: " + info);
            }
            this.Q = this.Q.viewDice().copy();
        }
        if (!this.columnMatrix) {
            if (economySize) {
                return ((DenseColumnDoubleMatrix2D)this.Q.viewPart(0, 0, this.m, this.n)).getRowMajor();
            }
            return ((DenseColumnDoubleMatrix2D)this.Q).getRowMajor();
        }
        if (economySize) {
            return this.Q.viewPart(0, 0, this.m, this.n).copy();
        }
        return this.Q.copy();
    }

    public DoubleMatrix2D getR(boolean economySize) {
        if (this.R == null) {
            this.R = new DenseColumnDoubleMatrix2D(this.m, this.n);
            double[] elementsR = (double[])this.R.elements();
            int c = 0;
            while (c < this.n) {
                int r = 0;
                while (r < this.m) {
                    if (r <= c) {
                        elementsR[c * this.m + r] = this.elementsA[c * this.m + r];
                    }
                    ++r;
                }
                ++c;
            }
        }
        if (!this.columnMatrix) {
            if (economySize) {
                return ((DenseColumnDoubleMatrix2D)this.R.viewPart(0, 0, this.n, this.n)).getRowMajor();
            }
            return ((DenseColumnDoubleMatrix2D)this.R).getRowMajor();
        }
        if (economySize) {
            return ((DenseColumnDoubleMatrix2D)this.R.viewPart(0, 0, this.n, this.n)).copy();
        }
        return this.R.copy();
    }

    public boolean hasFullRank() {
        int j = 0;
        while (j < this.n) {
            if (this.elementsA[j * this.m + j] == 0.0) {
                return false;
            }
            ++j;
        }
        return true;
    }

    public void solve(DoubleMatrix1D b) {
        DoubleProperty.DEFAULT.checkDense(b);
        if (b.size() != (long)this.m) {
            throw new IllegalArgumentException("Matrix row dimensions must agree.");
        }
        if (!this.hasFullRank()) {
            throw new IllegalArgumentException("Matrix is rank deficient.");
        }
        double[] elementsX = b.isView() ? (double[])b.copy().elements() : (double[])b.elements();
        Dplasma.plasma_Init((int)this.m, (int)this.n, (int)1);
        int info = Dplasma.plasma_DORMQR((int)141, (int)111, (int)this.m, (int)1, (int)this.n, (double[])this.elementsA, (int)0, (int)this.m, (double[])this.T, (int)0, (double[])elementsX, (int)0, (int)this.m);
        if (info != 0) {
            throw new IllegalArgumentException("Error occured while solving the system of equation using QR decomposition: " + info);
        }
        info = Dplasma.plasma_DTRSM((int)141, (int)121, (int)111, (int)131, (int)this.n, (int)1, (double[])this.elementsA, (int)0, (int)this.m, (double[])elementsX, (int)0, (int)this.m);
        Dplasma.plasma_Finalize();
        if (info != 0) {
            throw new IllegalArgumentException("Error occured while solving the system of equation using QR decomposition: " + info);
        }
        if (b.isView()) {
            b.assign(elementsX);
        }
    }

    public void solve(DoubleMatrix2D B) {
        if (B.rows() != this.m) {
            throw new IllegalArgumentException("Matrix row dimensions must agree.");
        }
        if (!this.hasFullRank()) {
            throw new IllegalArgumentException("Matrix is rank deficient.");
        }
        DoubleProperty.DEFAULT.checkDense(B);
        double[] elementsX = B instanceof DenseDoubleMatrix2D ? (double[])B.viewDice().copy().elements() : (B.isView() ? (double[])B.copy().elements() : (double[])B.elements());
        int nrhs = B.columns();
        Dplasma.plasma_Init((int)this.m, (int)this.n, (int)nrhs);
        int info = Dplasma.plasma_DORMQR((int)141, (int)111, (int)this.m, (int)nrhs, (int)this.n, (double[])this.elementsA, (int)0, (int)this.m, (double[])this.T, (int)0, (double[])elementsX, (int)0, (int)this.m);
        if (info != 0) {
            throw new IllegalArgumentException("Error occured while solving the system of equation using QR decomposition: " + info);
        }
        info = Dplasma.plasma_DTRSM((int)141, (int)121, (int)111, (int)131, (int)this.n, (int)nrhs, (double[])this.elementsA, (int)0, (int)this.m, (double[])elementsX, (int)0, (int)this.m);
        Dplasma.plasma_Finalize();
        if (info != 0) {
            throw new IllegalArgumentException("Error occured while solving the system of equation using QR decomposition: " + info);
        }
        if (B instanceof DenseDoubleMatrix2D) {
            B.viewDice().assign(elementsX);
        } else if (B.isView()) {
            B.assign(elementsX);
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        String unknown = "Illegal operation or error: ";
        buf.append("-----------------------------------------------------------------\n");
        buf.append("QRDecomposition(A) --> hasFullRank(A), Q, R, pseudo inverse(A)\n");
        buf.append("-----------------------------------------------------------------\n");
        buf.append("hasFullRank = ");
        try {
            buf.append(String.valueOf(this.hasFullRank()));
        }
        catch (IllegalArgumentException exc) {
            buf.append(String.valueOf(unknown) + exc.getMessage());
        }
        buf.append("\n\nQ = ");
        try {
            buf.append(String.valueOf(this.getQ(false)));
        }
        catch (IllegalArgumentException exc) {
            buf.append(String.valueOf(unknown) + exc.getMessage());
        }
        buf.append("\n\nR = ");
        try {
            buf.append(String.valueOf(this.getR(false)));
        }
        catch (IllegalArgumentException exc) {
            buf.append(String.valueOf(unknown) + exc.getMessage());
        }
        buf.append("\n\npseudo inverse(A) = ");
        try {
            DoubleMatrix2D X = DoubleFactory2D.dense.identity(this.m);
            this.solve(X);
            buf.append(String.valueOf(X));
        }
        catch (IllegalArgumentException exc) {
            buf.append(String.valueOf(unknown) + exc.getMessage());
        }
        return buf.toString();
    }
}

