/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import loci.common.DataTools;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.common.services.DependencyException;
import loci.common.services.ServiceException;
import loci.common.services.ServiceFactory;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.MetadataTools;
import loci.formats.MissingLibraryException;
import loci.formats.Modulo;
import loci.formats.in.MinimalTiffReader;
import loci.formats.in.TiffReader;
import loci.formats.meta.MetadataStore;
import loci.formats.ome.OMEXMLMetadata;
import loci.formats.services.OMEXMLService;
import loci.formats.tiff.IFD;
import loci.formats.tiff.IFDList;
import loci.formats.tiff.PhotoInterp;
import loci.formats.tiff.TiffIFDEntry;
import loci.formats.tiff.TiffParser;
import ome.xml.model.primitives.NonNegativeInteger;
import ome.xml.model.primitives.PrimitiveType;
import ome.xml.model.primitives.Timestamp;

public class OMETiffReader
extends FormatReader {
    protected OMETiffPlane[][] info;
    protected String[] used;
    private int lastPlane = 0;
    private boolean hasSPW;
    private int[] tileWidth;
    private int[] tileHeight;
    private OMEXMLService service;
    private transient OMEXMLMetadata meta;
    private String metaFile;
    private String metadataFile;

    public OMETiffReader() {
        super("OME-TIFF", new String[]{"ome.tif", "ome.tiff", "companion.ome"});
        this.suffixNecessary = false;
        this.suffixSufficient = false;
        this.domains = FormatTools.NON_GRAPHICS_DOMAINS;
        this.hasCompanionFiles = true;
        this.datasetDescription = "One or more .ome.tiff files";
    }

    @Override
    public boolean isSingleFile(String id) throws FormatException, IOException {
        OMEXMLMetadata meta;
        if (OMETiffReader.checkSuffix(id, "companion.ome")) {
            return false;
        }
        String fileName = new Location(id).getAbsoluteFile().getAbsolutePath();
        RandomAccessInputStream ras = new RandomAccessInputStream(fileName, 16);
        TiffParser tp = new TiffParser(ras);
        IFD ifd = tp.getFirstIFD();
        long[] ifdOffsets = tp.getIFDOffsets();
        ras.close();
        String xml = ifd.getComment();
        if (this.service == null) {
            this.setupService();
        }
        try {
            meta = this.service.createOMEXMLMetadata(xml);
            this.metaFile = new Location(id).getAbsolutePath();
        }
        catch (ServiceException se) {
            throw new FormatException(se);
        }
        if (meta.getRoot() == null) {
            throw new FormatException("Could not parse OME-XML from TIFF comment");
        }
        int nImages = 0;
        for (int i = 0; i < meta.getImageCount(); ++i) {
            int nChannels = meta.getChannelCount(i);
            if (nChannels == 0) {
                nChannels = 1;
            }
            int z = (Integer)meta.getPixelsSizeZ(i).getValue();
            int t = (Integer)meta.getPixelsSizeT(i).getValue();
            nImages += z * t * nChannels;
        }
        return nImages > 0 && nImages <= ifdOffsets.length;
    }

    @Override
    public boolean isThisType(String name, boolean open) {
        if (OMETiffReader.checkSuffix(name, "companion.ome")) {
            return true;
        }
        this.metaFile = new Location(name).getAbsolutePath();
        boolean valid = super.isThisType(name, open);
        if (valid && !this.isGroupFiles()) {
            try {
                return this.isSingleFile(this.metaFile);
            }
            catch (Exception e) {
                LOGGER.debug("", e);
                return false;
            }
        }
        return valid;
    }

    @Override
    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        TiffParser tp = new TiffParser(stream);
        tp.setDoCaching(false);
        boolean validHeader = tp.isValidHeader();
        if (!validHeader) {
            return false;
        }
        IFD ifd = tp.getFirstIFD();
        if (ifd == null) {
            return false;
        }
        Object description = ifd.get(270);
        if (description == null) {
            return false;
        }
        String comment = null;
        if (description instanceof TiffIFDEntry) {
            Object value = tp.getIFDValue((TiffIFDEntry)description);
            if (value != null) {
                comment = value.toString();
            }
        } else if (description instanceof String) {
            comment = (String)description;
        }
        if (comment == null || comment.trim().length() == 0) {
            return false;
        }
        if (!(comment = comment.trim()).startsWith("<") || !comment.endsWith(">")) {
            return false;
        }
        try {
            if (this.service == null) {
                this.setupService();
            }
            this.meta = this.service.createOMEXMLMetadata(comment);
            try {
                String metadataFile = this.meta.getBinaryOnlyMetadataFile();
                if (metadataFile != null) {
                    return true;
                }
            }
            catch (NullPointerException metadataFile) {
                // empty catch block
            }
            for (int i = 0; i < this.meta.getImageCount(); ++i) {
                this.meta.setPixelsBinDataBigEndian(Boolean.TRUE, i, 0);
                MetadataTools.verifyMinimumPopulated(this.meta, i);
            }
            return this.meta.getImageCount() > 0;
        }
        catch (ServiceException se) {
            LOGGER.debug("OME-XML parsing failed", se);
        }
        catch (NullPointerException e) {
            LOGGER.debug("OME-XML parsing failed", e);
        }
        catch (FormatException e) {
            LOGGER.debug("OME-XML parsing failed", e);
        }
        catch (IndexOutOfBoundsException e) {
            LOGGER.debug("OME-XML parsing failed", e);
        }
        return false;
    }

    @Override
    public String[] getDomains() {
        String[] stringArray;
        FormatTools.assertId(this.currentId, true, 1);
        if (this.hasSPW) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "High-Content Screening (HCS)";
        } else {
            stringArray = FormatTools.NON_SPECIAL_DOMAINS;
        }
        return stringArray;
    }

    @Override
    public byte[][] get8BitLookupTable() throws FormatException, IOException {
        int series = this.getSeries();
        if (this.info[series][this.lastPlane] == null || this.info[series][this.lastPlane].reader == null || this.info[series][this.lastPlane].id == null) {
            return null;
        }
        this.info[series][this.lastPlane].reader.setId(this.info[series][this.lastPlane].id);
        return this.info[series][this.lastPlane].reader.get8BitLookupTable();
    }

    @Override
    public short[][] get16BitLookupTable() throws FormatException, IOException {
        int series = this.getSeries();
        if (this.info[series][this.lastPlane] == null || this.info[series][this.lastPlane].reader == null || this.info[series][this.lastPlane].id == null) {
            return null;
        }
        this.info[series][this.lastPlane].reader.setId(this.info[series][this.lastPlane].id);
        return this.info[series][this.lastPlane].reader.get16BitLookupTable();
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        int series = this.getSeries();
        this.lastPlane = no;
        int i = this.info[series][no].ifd;
        if (!this.info[series][no].exists) {
            Arrays.fill(buf, (byte)0);
            return buf;
        }
        MinimalTiffReader r = (MinimalTiffReader)this.info[series][no].reader;
        if (r.getCurrentFile() == null) {
            r.setId(this.info[series][no].id);
        }
        r.lastPlane = i;
        IFDList ifdList = r.getIFDs();
        if (i >= ifdList.size()) {
            LOGGER.warn("Error untangling IFDs; the OME-TIFF file may be malformed (IFD #{} missing).", (Object)i);
            return buf;
        }
        IFD ifd = (IFD)ifdList.get(i);
        RandomAccessInputStream s = new RandomAccessInputStream(this.info[series][no].id);
        TiffParser p = new TiffParser(s);
        p.getSamples(ifd, buf, x, y, w, h);
        s.close();
        if (r.getImageCount() == 1 && w + x == this.getSizeX() && h + y == this.getSizeY()) {
            r.close();
        }
        return buf;
    }

    @Override
    public String[] getSeriesUsedFiles(boolean noPixels) {
        FormatTools.assertId(this.currentId, true, 1);
        int series = this.getSeries();
        if (noPixels) {
            return null;
        }
        Vector<String> usedFiles = new Vector<String>();
        if (this.metadataFile != null) {
            usedFiles.add(this.metadataFile);
        }
        if (this.info != null && this.info[series] != null) {
            for (int i = 0; i < this.info[series].length; ++i) {
                if (usedFiles.contains(this.info[series][i].id)) continue;
                usedFiles.add(this.info[series][i].id);
            }
        }
        return usedFiles.toArray(new String[usedFiles.size()]);
    }

    @Override
    public int fileGroupOption(String id) {
        try {
            boolean single = this.isSingleFile(id);
            return single ? 1 : 0;
        }
        catch (FormatException e) {
            LOGGER.debug("", e);
        }
        catch (IOException e) {
            LOGGER.debug("", e);
        }
        return 1;
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (this.info != null) {
            OMETiffPlane[][] arr$ = this.info;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                OMETiffPlane[] dimension;
                for (OMETiffPlane plane : dimension = arr$[i$]) {
                    if (plane.reader == null) continue;
                    try {
                        plane.reader.close();
                    }
                    catch (Exception e) {
                        LOGGER.error("Plane closure failure!", e);
                    }
                }
            }
        }
        if (!fileOnly) {
            this.info = null;
            this.used = null;
            this.lastPlane = 0;
            this.tileWidth = null;
            this.tileHeight = null;
            this.metadataFile = null;
        }
    }

    @Override
    public int getOptimalTileWidth() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.tileWidth[this.getSeries()];
    }

    @Override
    public int getOptimalTileHeight() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.tileHeight[this.getSeries()];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void initFile(String id) throws FormatException, IOException {
        int i;
        Location path;
        String xml;
        super.initFile(this.normalizeFilename(null, id));
        id = this.currentId;
        String dir = new File(id).getParent();
        String fileName = new Location(id).getAbsoluteFile().getAbsolutePath();
        if (!new File(fileName).exists()) {
            fileName = this.currentId;
        }
        IFD firstIFD = null;
        boolean companion = false;
        if (OMETiffReader.checkSuffix(fileName, "companion.ome")) {
            xml = DataTools.readFile(fileName);
            companion = true;
        } else {
            RandomAccessInputStream ras = new RandomAccessInputStream(fileName, 16);
            try {
                TiffParser tp = new TiffParser(ras);
                firstIFD = tp.getFirstIFD();
                xml = firstIFD.getComment();
            }
            finally {
                ras.close();
            }
        }
        if (this.service == null) {
            this.setupService();
        }
        try {
            if (this.meta == null || !this.metaFile.equals(this.currentId)) {
                this.meta = this.service.createOMEXMLMetadata(xml);
                this.metaFile = this.currentId;
            }
            if (companion) {
                String firstTIFF = this.meta.getUUIDFileName(0, 0);
                this.initFile(new Location(dir, firstTIFF).getAbsolutePath());
                return;
            }
        }
        catch (ServiceException se) {
            throw new FormatException(se);
        }
        String metadataPath = null;
        try {
            metadataPath = this.meta.getBinaryOnlyMetadataFile();
        }
        catch (NullPointerException tp) {
            // empty catch block
        }
        if (metadataPath != null && (path = new Location(dir, metadataPath)).exists()) {
            this.metadataFile = path.getAbsolutePath();
            xml = this.readMetadataFile();
            try {
                this.meta = this.service.createOMEXMLMetadata(xml);
            }
            catch (ServiceException se) {
                throw new FormatException(se);
            }
            catch (NullPointerException e) {
                this.metadataFile = null;
                metadataPath = null;
            }
        }
        this.hasSPW = this.meta.getPlateCount() > 0;
        for (int i2 = 0; i2 < this.meta.getImageCount(); ++i2) {
            int sizeC = (Integer)this.meta.getPixelsSizeC(i2).getValue();
            this.service.removeChannels(this.meta, i2, sizeC);
        }
        Hashtable originalMetadata = this.service.getOriginalMetadata(this.meta);
        if (originalMetadata != null) {
            this.metadata = originalMetadata;
        }
        LOGGER.trace(xml);
        if (this.meta.getRoot() == null) {
            throw new FormatException("Could not parse OME-XML from TIFF comment");
        }
        String[] acquiredDates = new String[this.meta.getImageCount()];
        for (int i3 = 0; i3 < acquiredDates.length; ++i3) {
            Timestamp acquisitionDate = this.meta.getImageAcquisitionDate(i3);
            if (acquisitionDate == null) continue;
            acquiredDates[i3] = (String)acquisitionDate.getValue();
        }
        String currentUUID = this.meta.getUUID();
        this.service.convertMetadata(this.meta, this.metadataStore);
        int seriesCount = this.meta.getImageCount();
        this.core.clear();
        for (int i4 = 0; i4 < seriesCount; ++i4) {
            this.core.add(new CoreMetadata());
        }
        this.info = new OMETiffPlane[seriesCount][];
        this.tileWidth = new int[seriesCount];
        this.tileHeight = new int[seriesCount];
        Hashtable<String, String> files = new Hashtable<String, String>();
        boolean needSearch = false;
        for (int i5 = 0; i5 < seriesCount; ++i5) {
            int tiffDataCount = this.meta.getTiffDataCount(i5);
            for (int td = 0; td < tiffDataCount; ++td) {
                String uuid = null;
                try {
                    uuid = this.meta.getUUIDValue(i5, td);
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                String filename = null;
                if (uuid == null) {
                    uuid = "";
                    filename = id;
                } else {
                    filename = this.meta.getUUIDFileName(i5, td);
                    if (!new Location(dir, filename).exists()) {
                        filename = null;
                    }
                    if (filename == null) {
                        if (uuid.equals(currentUUID) || currentUUID == null) {
                            filename = id;
                        } else {
                            filename = "";
                            needSearch = true;
                        }
                    } else {
                        filename = this.normalizeFilename(dir, filename);
                    }
                }
                String existing = (String)files.get(uuid);
                if (existing == null) {
                    files.put(uuid, filename);
                    continue;
                }
                if (existing.equals(filename)) continue;
                throw new FormatException("Inconsistent UUID filenames");
            }
        }
        if (needSearch) {
            Enumeration en = files.keys();
            while (en.hasMoreElements()) {
                String uuid = (String)en.nextElement();
                String filename = (String)files.get(uuid);
                if (!filename.equals("")) continue;
                throw new FormatException("Unmatched UUID: " + uuid);
            }
        }
        Enumeration en = files.keys();
        int numUUIDs = files.size();
        HashSet<String> fileSet = new HashSet<String>();
        for (int i6 = 0; i6 < numUUIDs; ++i6) {
            String uuid = (String)en.nextElement();
            String filename = (String)files.get(uuid);
            fileSet.add(filename);
        }
        this.used = new String[fileSet.size()];
        Iterator iter = fileSet.iterator();
        for (int i7 = 0; i7 < this.used.length; ++i7) {
            this.used[i7] = (String)iter.next();
        }
        Hashtable<String, IFormatReader> readers = new Hashtable<String, IFormatReader>();
        boolean adjustedSamples = false;
        for (int i8 = 0; i8 < seriesCount; ++i8) {
            int td;
            int s = i8;
            LOGGER.debug("Image[{}] {", (Object)i8);
            LOGGER.debug("  id = {}", (Object)this.meta.getImageID(i8));
            String order = this.meta.getPixelsDimensionOrder(i8).toString();
            PrimitiveType samplesPerPixel = null;
            if (this.meta.getChannelCount(i8) > 0) {
                samplesPerPixel = this.meta.getChannelSamplesPerPixel(i8, 0);
            }
            int samples = samplesPerPixel == null ? -1 : (Integer)samplesPerPixel.getValue();
            int tiffSamples = firstIFD.getSamplesPerPixel();
            if (adjustedSamples || samples != tiffSamples && (i8 == 0 || samples < 0)) {
                LOGGER.warn("SamplesPerPixel mismatch: OME={}, TIFF={}", (Object)samples, (Object)tiffSamples);
                samples = tiffSamples;
                adjustedSamples = true;
            } else {
                adjustedSamples = false;
            }
            if (adjustedSamples && this.meta.getChannelCount(i8) <= 1) {
                adjustedSamples = false;
            }
            int effSizeC = (Integer)this.meta.getPixelsSizeC(i8).getValue();
            if (!adjustedSamples) {
                effSizeC /= samples;
            }
            if (effSizeC == 0) {
                effSizeC = 1;
            }
            if (effSizeC * samples != (Integer)this.meta.getPixelsSizeC(i8).getValue()) {
                effSizeC = (Integer)this.meta.getPixelsSizeC(i8).getValue();
            }
            int sizeT = (Integer)this.meta.getPixelsSizeT(i8).getValue();
            int sizeZ = (Integer)this.meta.getPixelsSizeZ(i8).getValue();
            int num = effSizeC * sizeT * sizeZ;
            OMETiffPlane[] planes = new OMETiffPlane[num];
            for (int no = 0; no < num; ++no) {
                planes[no] = new OMETiffPlane();
            }
            int tiffDataCount = this.meta.getTiffDataCount(i8);
            Boolean zOneIndexed = null;
            Boolean cOneIndexed = null;
            Boolean tOneIndexed = null;
            for (td = 0; td < tiffDataCount; ++td) {
                int z;
                NonNegativeInteger firstC = this.meta.getTiffDataFirstC(i8, td);
                NonNegativeInteger firstT = this.meta.getTiffDataFirstT(i8, td);
                NonNegativeInteger firstZ = this.meta.getTiffDataFirstZ(i8, td);
                int c = firstC == null ? 0 : (Integer)firstC.getValue();
                int t = firstT == null ? 0 : (Integer)firstT.getValue();
                int n = z = firstZ == null ? 0 : (Integer)firstZ.getValue();
                if (c >= effSizeC && cOneIndexed == null) {
                    cOneIndexed = true;
                } else if (c == 0) {
                    cOneIndexed = false;
                }
                if (z >= sizeZ && zOneIndexed == null) {
                    zOneIndexed = true;
                } else if (z == 0) {
                    zOneIndexed = false;
                }
                if (t >= sizeT && tOneIndexed == null) {
                    tOneIndexed = true;
                    continue;
                }
                if (t != 0) continue;
                tOneIndexed = false;
            }
            for (td = 0; td < tiffDataCount; ++td) {
                int no;
                int count;
                int z;
                LOGGER.debug("    TiffData[{}] {", (Object)td);
                String filename = null;
                String uuid = null;
                try {
                    filename = this.meta.getUUIDFileName(i8, td);
                }
                catch (NullPointerException e) {
                    LOGGER.debug("Ignoring null UUID object when retrieving filename.");
                }
                try {
                    uuid = this.meta.getUUIDValue(i8, td);
                }
                catch (NullPointerException e) {
                    LOGGER.debug("Ignoring null UUID object when retrieving value.");
                }
                NonNegativeInteger tdIFD = this.meta.getTiffDataIFD(i8, td);
                int ifd = tdIFD == null ? 0 : (Integer)tdIFD.getValue();
                NonNegativeInteger numPlanes = this.meta.getTiffDataPlaneCount(i8, td);
                NonNegativeInteger firstC = this.meta.getTiffDataFirstC(i8, td);
                NonNegativeInteger firstT = this.meta.getTiffDataFirstT(i8, td);
                NonNegativeInteger firstZ = this.meta.getTiffDataFirstZ(i8, td);
                int c = firstC == null ? 0 : (Integer)firstC.getValue();
                int t = firstT == null ? 0 : (Integer)firstT.getValue();
                int n = z = firstZ == null ? 0 : (Integer)firstZ.getValue();
                if (cOneIndexed != null && cOneIndexed.booleanValue()) {
                    --c;
                }
                if (zOneIndexed != null && zOneIndexed.booleanValue()) {
                    --z;
                }
                if (tOneIndexed != null && tOneIndexed.booleanValue()) {
                    --t;
                }
                if (z >= sizeZ || c >= effSizeC || t >= sizeT) {
                    LOGGER.warn("Found invalid TiffData: Z={}, C={}, T={}", z, c, t);
                    break;
                }
                int index = FormatTools.getIndex(order, sizeZ, effSizeC, sizeT, num, z, c, t);
                int n2 = count = numPlanes == null ? 1 : (Integer)numPlanes.getValue();
                if (count == 0) {
                    this.core.set(s, null);
                    break;
                }
                filename = filename == null ? (uuid == null ? id : (String)files.get(uuid)) : this.normalizeFilename(dir, filename);
                IFormatReader r = (IFormatReader)readers.get(filename);
                if (r == null) {
                    r = new MinimalTiffReader();
                    readers.put(filename, r);
                }
                Location file2 = new Location(filename);
                boolean exists = true;
                if (!file2.exists()) {
                    filename = filename.substring(filename.lastIndexOf(File.separator) + 1);
                    filename = dir + File.separator + filename;
                    if (!new Location(filename).exists()) {
                        filename = this.currentId;
                        exists = fileSet.size() == 1;
                    }
                }
                for (int q = 0; q < count; ++q) {
                    int no2 = index + q;
                    planes[no2].reader = r;
                    planes[no2].id = filename;
                    planes[no2].ifd = ifd + q;
                    planes[no2].certain = true;
                    planes[no2].exists = exists;
                    LOGGER.debug("      Plane[{}]: file={}, IFD={}", no2, planes[no2].id, planes[no2].ifd);
                }
                if (numPlanes == null) {
                    for (no = index + 1; no < num && !planes[no].certain; ++no) {
                        planes[no].reader = r;
                        planes[no].id = filename;
                        planes[no].ifd = planes[no - 1].ifd + 1;
                        planes[no].exists = exists;
                        LOGGER.debug("      Plane[{}]: FILLED", (Object)no);
                    }
                } else {
                    for (no = index + count; no < num && !planes[no].certain; ++no) {
                        planes[no].reader = null;
                        planes[no].id = null;
                        planes[no].ifd = -1;
                        LOGGER.debug("      Plane[{}]: CLEARED", (Object)no);
                    }
                }
                LOGGER.debug("    }");
            }
            if (this.core.get(s) == null) continue;
            LOGGER.debug("    --------------------------------");
            for (int no = 0; no < num; ++no) {
                LOGGER.debug("    Plane[{}]: file={}, IFD={}", no, planes[no].id, planes[no].ifd);
                if (planes[no].reader != null) continue;
                LOGGER.warn("Image ID '{}': missing plane #{}.  Using TiffReader to determine the number of planes.", (Object)this.meta.getImageID(i8), (Object)no);
                TiffReader r = new TiffReader();
                r.setId(this.currentId);
                try {
                    planes = new OMETiffPlane[r.getImageCount()];
                    for (int plane = 0; plane < planes.length; ++plane) {
                        planes[plane] = new OMETiffPlane();
                        planes[plane].id = this.currentId;
                        planes[plane].reader = r;
                        planes[plane].ifd = plane;
                    }
                    num = planes.length;
                    continue;
                }
                finally {
                    r.close();
                }
            }
            LOGGER.debug("  }");
            CoreMetadata m = (CoreMetadata)this.core.get(s);
            this.info[s] = planes;
            try {
                RandomAccessInputStream testFile = new RandomAccessInputStream(this.info[s][0].id);
                String firstFile = this.info[s][0].id;
                if (!this.info[s][0].reader.isThisType(testFile)) {
                    LOGGER.warn("{} is not a valid OME-TIFF", (Object)this.info[s][0].id);
                    this.info[s][0].id = this.currentId;
                    this.info[s][0].exists = false;
                }
                testFile.close();
                for (int plane = 1; plane < this.info[s].length; ++plane) {
                    if (this.info[s][plane].id.equals(firstFile)) {
                        if (this.info[s][0].exists) continue;
                        this.info[s][plane].id = this.info[s][0].id;
                        this.info[s][plane].exists = false;
                        continue;
                    }
                    testFile = new RandomAccessInputStream(this.info[s][plane].id);
                    if (!this.info[s][plane].reader.isThisType(testFile)) {
                        LOGGER.warn("{} is not a valid OME-TIFF", (Object)this.info[s][plane].id);
                        this.info[s][plane].id = this.info[s][0].id;
                        this.info[s][plane].exists = false;
                    }
                    testFile.close();
                }
                this.info[s][0].reader.setId(this.info[s][0].id);
                this.tileWidth[s] = this.info[s][0].reader.getOptimalTileWidth();
                this.tileHeight[s] = this.info[s][0].reader.getOptimalTileHeight();
                m.sizeX = (Integer)this.meta.getPixelsSizeX(i8).getValue();
                int tiffWidth = (int)firstIFD.getImageWidth();
                if (m.sizeX != tiffWidth && s == 0) {
                    LOGGER.warn("SizeX mismatch: OME={}, TIFF={}", (Object)m.sizeX, (Object)tiffWidth);
                }
                m.sizeY = (Integer)this.meta.getPixelsSizeY(i8).getValue();
                int tiffHeight = (int)firstIFD.getImageLength();
                if (m.sizeY != tiffHeight && s == 0) {
                    LOGGER.warn("SizeY mismatch: OME={}, TIFF={}", (Object)m.sizeY, (Object)tiffHeight);
                }
                m.sizeZ = (Integer)this.meta.getPixelsSizeZ(i8).getValue();
                m.sizeC = (Integer)this.meta.getPixelsSizeC(i8).getValue();
                m.sizeT = (Integer)this.meta.getPixelsSizeT(i8).getValue();
                m.pixelType = FormatTools.pixelTypeFromString(this.meta.getPixelsType(i8).toString());
                int tiffPixelType = firstIFD.getPixelType();
                if (m.pixelType != tiffPixelType && (s == 0 || adjustedSamples)) {
                    LOGGER.warn("PixelType mismatch: OME={}, TIFF={}", (Object)m.pixelType, (Object)tiffPixelType);
                    m.pixelType = tiffPixelType;
                }
                m.imageCount = num;
                m.dimensionOrder = this.meta.getPixelsDimensionOrder(i8).toString();
                String uuidFileName = "";
                try {
                    if (this.meta.getTiffDataCount(i8) > 0) {
                        uuidFileName = this.meta.getUUIDFileName(i8, 0);
                    }
                }
                catch (NullPointerException firstT) {
                    // empty catch block
                }
                if (this.meta.getChannelCount(i8) > 0 && this.meta.getChannelName(i8, 0) == null && this.meta.getTiffDataCount(i8) > 0 && uuidFileName.indexOf("__omero_export") != -1) {
                    m.dimensionOrder = "XYZCT";
                }
                m.orderCertain = true;
                PhotoInterp photo = firstIFD.getPhotometricInterpretation();
                boolean bl = m.rgb = samples > 1 || photo == PhotoInterp.RGB;
                if (samples != m.sizeC && samples % m.sizeC != 0 && m.sizeC % samples != 0 || m.sizeC == 1 || adjustedSamples) {
                    m.sizeC *= samples;
                }
                if (m.sizeZ * m.sizeT * m.sizeC > m.imageCount && !m.rgb) {
                    if (m.sizeZ == m.imageCount) {
                        m.sizeT = 1;
                        m.sizeC = 1;
                    } else if (m.sizeT == m.imageCount) {
                        m.sizeZ = 1;
                        m.sizeC = 1;
                    } else if (m.sizeC == m.imageCount) {
                        m.sizeT = 1;
                        m.sizeZ = 1;
                    }
                }
                if (this.meta.getPixelsBinDataCount(i8) > 1) {
                    LOGGER.warn("OME-TIFF Pixels element contains BinData elements! Ignoring.");
                }
                m.littleEndian = firstIFD.isLittleEndian();
                m.interleaved = false;
                boolean bl2 = m.indexed = photo == PhotoInterp.RGB_PALETTE && firstIFD.getIFDValue(320) != null;
                if (m.indexed) {
                    m.rgb = false;
                }
                m.falseColor = true;
                m.metadataComplete = true;
                if (this.meta.getPixelsSignificantBits(i8) == null) continue;
                m.bitsPerPixel = (Integer)this.meta.getPixelsSignificantBits(i8).getValue();
                continue;
            }
            catch (NullPointerException exc) {
                throw new FormatException("Incomplete Pixels metadata", exc);
            }
        }
        ArrayList series = new ArrayList();
        Vector<OMETiffPlane[]> planeInfo = new Vector<OMETiffPlane[]>();
        for (int i9 = 0; i9 < this.core.size(); ++i9) {
            if (this.core.get(i9) == null) continue;
            series.add(this.core.get(i9));
            planeInfo.add(this.info[i9]);
        }
        this.core = series;
        this.info = (OMETiffPlane[][])planeInfo.toArray((T[])new OMETiffPlane[0][0]);
        if (this.getImageCount() == 1) {
            CoreMetadata ms0 = (CoreMetadata)this.core.get(0);
            ms0.sizeZ = 1;
            if (!ms0.rgb) {
                ms0.sizeC = 1;
            }
            ms0.sizeT = 1;
        }
        for (i = 0; i < this.core.size(); ++i) {
            Modulo t;
            Modulo c;
            CoreMetadata m = (CoreMetadata)this.core.get(i);
            Modulo z = this.service.getModuloAlongZ(this.meta, i);
            if (z != null) {
                m.moduloZ = z;
            }
            if ((c = this.service.getModuloAlongC(this.meta, i)) != null) {
                m.moduloC = c;
            }
            if ((t = this.service.getModuloAlongT(this.meta, i)) == null) continue;
            m.moduloT = t;
        }
        MetadataTools.populatePixels(this.metadataStore, this, false, false);
        for (i = 0; i < acquiredDates.length; ++i) {
            if (acquiredDates[i] == null) continue;
            this.metadataStore.setImageAcquisitionDate(new Timestamp(acquiredDates[i]), i);
        }
        this.metadataStore = this.getMetadataStoreForConversion();
    }

    public MetadataStore getMetadataStoreForDisplay() {
        MetadataStore store = this.getMetadataStore();
        if (this.service.isOMEXMLMetadata(store)) {
            this.service.removeBinData((OMEXMLMetadata)store);
            for (int i = 0; i < this.getSeriesCount(); ++i) {
                if (((OMEXMLMetadata)store).getTiffDataCount(i) != 0) continue;
                this.service.addMetadataOnly((OMEXMLMetadata)store, i);
            }
        }
        return store;
    }

    public MetadataStore getMetadataStoreForConversion() {
        MetadataStore store = this.getMetadataStore();
        int realSeries = this.getSeries();
        for (int i = 0; i < this.getSeriesCount(); ++i) {
            this.setSeries(i);
            store.setPixelsBinDataBigEndian(new Boolean(!this.isLittleEndian()), i, 0);
        }
        this.setSeries(realSeries);
        return store;
    }

    private String normalizeFilename(String dir, String name) {
        File file2 = new File(dir, name);
        if (file2.exists()) {
            return file2.getAbsolutePath();
        }
        return name;
    }

    private void setupService() throws FormatException {
        try {
            ServiceFactory factory = new ServiceFactory();
            this.service = factory.getInstance(OMEXMLService.class);
        }
        catch (DependencyException de) {
            throw new MissingLibraryException("ome-xml.jar is required to read OME-TIFF files.  Please download it from http://www.openmicroscopy.org/site/support/bio-formats/developers/java-library.html", de);
        }
    }

    private String readMetadataFile() throws IOException {
        if (OMETiffReader.checkSuffix(this.metadataFile, "tif") || OMETiffReader.checkSuffix(this.metadataFile, "tiff")) {
            return new TiffParser(this.metadataFile).getComment();
        }
        return DataTools.readFile(this.metadataFile);
    }

    private class OMETiffPlane {
        public IFormatReader reader;
        public String id;
        public int ifd = -1;
        public boolean certain = false;
        public boolean exists = true;

        private OMETiffPlane() {
        }
    }
}

