/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model;

import java.util.List;
import ome.xml.model.BasicAnnotation;
import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelObject;
import ome.xml.model.Reference;
import ome.xml.model.StructuredAnnotations;
import ome.xml.model.enums.EnumerationException;
import ome.xml.model.primitives.Timestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TimestampAnnotation
extends BasicAnnotation {
    public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/SA/2015-01";
    private static final Logger LOGGER = LoggerFactory.getLogger(TimestampAnnotation.class);
    private Timestamp value;
    private StructuredAnnotations structuredAnnotations;

    public TimestampAnnotation() {
    }

    public TimestampAnnotation(Element element, OMEModel model) throws EnumerationException {
        this.update(element, model);
    }

    public TimestampAnnotation(TimestampAnnotation orig) {
        super(orig);
        this.value = orig.value;
        this.structuredAnnotations = orig.structuredAnnotations;
    }

    @Override
    public void update(Element element, OMEModel model) throws EnumerationException {
        List<Element> Value_nodeList;
        super.update(element, model);
        String tagName = element.getTagName();
        if (!"TimestampAnnotation".equals(tagName)) {
            LOGGER.debug("Expecting node name of TimestampAnnotation got {}", (Object)tagName);
        }
        if ((Value_nodeList = TimestampAnnotation.getChildrenByTagName(element, "Value")).size() > 1) {
            throw new RuntimeException(String.format("Value node list size %d != 1", Value_nodeList.size()));
        }
        if (Value_nodeList.size() != 0) {
            this.setValue(Timestamp.valueOf(Value_nodeList.get(0).getTextContent()));
        }
    }

    @Override
    public boolean link(Reference reference, OMEModelObject o) {
        boolean wasHandledBySuperClass = super.link(reference, o);
        if (wasHandledBySuperClass) {
            return true;
        }
        LOGGER.debug("Unable to handle reference of type: {}", (Object)reference.getClass());
        return false;
    }

    public Timestamp getValue() {
        return this.value;
    }

    public void setValue(Timestamp value) {
        this.value = value;
    }

    public StructuredAnnotations getStructuredAnnotations() {
        return this.structuredAnnotations;
    }

    public void setStructuredAnnotations(StructuredAnnotations structuredAnnotations_BackReference) {
        this.structuredAnnotations = structuredAnnotations_BackReference;
    }

    @Override
    public Element asXMLElement(Document document) {
        return this.asXMLElement(document, null);
    }

    @Override
    protected Element asXMLElement(Document document, Element TimestampAnnotation_element) {
        if (TimestampAnnotation_element == null) {
            TimestampAnnotation_element = document.createElementNS(NAMESPACE, "TimestampAnnotation");
        }
        TimestampAnnotation_element = super.asXMLElement(document, TimestampAnnotation_element);
        if (this.value != null) {
            Element value_element = document.createElementNS(NAMESPACE, "Value");
            value_element.setTextContent(this.value.toString());
            TimestampAnnotation_element.appendChild(value_element);
        }
        if (this.structuredAnnotations != null) {
            // empty if block
        }
        return TimestampAnnotation_element;
    }
}

