/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfcomplex.impl;

import cern.colt.ConcurrencyUtils;
import cern.colt.function.tfcomplex.FComplexFComplexFComplexFunction;
import cern.colt.function.tfcomplex.FComplexFComplexFunction;
import cern.colt.function.tfcomplex.FComplexProcedure;
import cern.colt.function.tfcomplex.FComplexRealFunction;
import cern.colt.function.tfcomplex.IntIntFComplexFunction;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.AbstractMatrix1D;
import cern.colt.matrix.tfcomplex.FComplexMatrix1D;
import cern.colt.matrix.tfcomplex.FComplexMatrix2D;
import cern.colt.matrix.tfcomplex.impl.DenseFComplexMatrix1D;
import cern.colt.matrix.tfcomplex.impl.SelectedDenseFComplexMatrix2D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix2D;
import cern.jet.math.tfcomplex.FComplexFunctions;
import cern.jet.math.tfcomplex.FComplexMult;
import edu.emory.mathcs.jtransforms.fft.FloatFFT_2D;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class DenseFComplexMatrix2D
extends FComplexMatrix2D {
    static final long serialVersionUID = 1020177651L;
    private FloatFFT_2D fft2;
    protected float[] elements;

    public DenseFComplexMatrix2D(float[][] values) {
        this(values.length, values.length == 0 ? 0 : values[0].length / 2);
        this.assign(values);
    }

    public DenseFComplexMatrix2D(FloatMatrix2D realPart) {
        this(realPart.rows(), realPart.columns());
        this.assignReal(realPart);
    }

    public DenseFComplexMatrix2D(int rows, int columns) {
        this.setUp(rows, columns, 0, 0, 2 * columns, 2);
        this.elements = new float[rows * 2 * columns];
    }

    public DenseFComplexMatrix2D(int rows, int columns, float[] elements, int rowZero, int columnZero, int rowStride, int columnStride, boolean isNoView) {
        this.setUp(rows, columns, rowZero, columnZero, rowStride, columnStride);
        this.elements = elements;
        this.isNoView = isNoView;
    }

    @Override
    public float[] aggregate(final FComplexFComplexFComplexFunction aggr, final FComplexFComplexFunction f) {
        float[] b = new float[2];
        if (this.size() == 0L) {
            b[0] = Float.NaN;
            b[1] = Float.NaN;
            return b;
        }
        final int zero = (int)this.index(0, 0);
        float[] a = null;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<float[]>(){

                    @Override
                    public float[] call() throws Exception {
                        int idx = zero + firstRow * DenseFComplexMatrix2D.this.rowStride;
                        float[] a = f.apply(DenseFComplexMatrix2D.this.elements[idx], DenseFComplexMatrix2D.this.elements[idx + 1]);
                        int d = 1;
                        int r = firstRow;
                        while (r < lastRow) {
                            int c = d;
                            while (c < DenseFComplexMatrix2D.this.columns) {
                                idx = zero + r * DenseFComplexMatrix2D.this.rowStride + c * DenseFComplexMatrix2D.this.columnStride;
                                a = aggr.apply(a, f.apply(DenseFComplexMatrix2D.this.elements[idx], DenseFComplexMatrix2D.this.elements[idx + 1]));
                                ++c;
                            }
                            d = 0;
                            ++r;
                        }
                        return a;
                    }
                });
                ++j;
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            a = f.apply(this.elements[zero], this.elements[zero + 1]);
            int d = 1;
            int r = 0;
            while (r < this.rows) {
                int c = d;
                while (c < this.columns) {
                    int idx = zero + r * this.rowStride + c * this.columnStride;
                    a = aggr.apply(a, f.apply(this.elements[idx], this.elements[idx + 1]));
                    ++c;
                }
                d = 0;
                ++r;
            }
        }
        return a;
    }

    @Override
    public float[] aggregate(FComplexMatrix2D other, final FComplexFComplexFComplexFunction aggr, final FComplexFComplexFComplexFunction f) {
        if (!(other instanceof DenseFComplexMatrix2D)) {
            return super.aggregate(other, aggr, f);
        }
        this.checkShape(other);
        float[] b = new float[2];
        if (this.size() == 0L) {
            b[0] = Float.NaN;
            b[1] = Float.NaN;
            return b;
        }
        final int zero = (int)this.index(0, 0);
        final int zeroOther = (int)other.index(0, 0);
        final int rowStrideOther = other.rowStride();
        final int columnStrideOther = other.columnStride();
        final float[] elemsOther = (float[])other.elements();
        float[] a = null;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<float[]>(){

                    @Override
                    public float[] call() throws Exception {
                        int idx = zero + firstRow * DenseFComplexMatrix2D.this.rowStride;
                        int idxOther = zeroOther + firstRow * rowStrideOther;
                        float[] a = f.apply(new float[]{DenseFComplexMatrix2D.this.elements[idx], DenseFComplexMatrix2D.this.elements[idx + 1]}, new float[]{elemsOther[idxOther], elemsOther[idxOther + 1]});
                        int d = 1;
                        int r = firstRow;
                        while (r < lastRow) {
                            int c = d;
                            while (c < DenseFComplexMatrix2D.this.columns) {
                                idx = zero + r * DenseFComplexMatrix2D.this.rowStride + c * DenseFComplexMatrix2D.this.columnStride;
                                idxOther = zeroOther + r * rowStrideOther + c * columnStrideOther;
                                a = aggr.apply(a, f.apply(new float[]{DenseFComplexMatrix2D.this.elements[idx], DenseFComplexMatrix2D.this.elements[idx + 1]}, new float[]{elemsOther[idxOther], elemsOther[idxOther + 1]}));
                                ++c;
                            }
                            d = 0;
                            ++r;
                        }
                        return a;
                    }
                });
                ++j;
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            a = f.apply(new float[]{this.elements[zero], this.elements[zero + 1]}, new float[]{elemsOther[zeroOther], elemsOther[zeroOther + 1]});
            int d = 1;
            int r = 0;
            while (r < this.rows) {
                int c = d;
                while (c < this.columns) {
                    int idx = zero + r * this.rowStride + c * this.columnStride;
                    int idxOther = zeroOther + r * rowStrideOther + c * columnStrideOther;
                    a = aggr.apply(a, f.apply(new float[]{this.elements[idx], this.elements[idx + 1]}, new float[]{elemsOther[idxOther], elemsOther[idxOther + 1]}));
                    ++c;
                }
                d = 0;
                ++r;
            }
        }
        return a;
    }

    @Override
    public FComplexMatrix2D assign(final FComplexFComplexFunction function) {
        final int zero = (int)this.index(0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            if (function instanceof FComplexMult) {
                float[] multiplicator = ((FComplexMult)function).multiplicator;
                if (multiplicator[0] == 1.0f && multiplicator[1] == 0.0f) {
                    return this;
                }
                if (multiplicator[0] == 0.0f && multiplicator[1] == 0.0f) {
                    return this.assign(0.0f, 0.0f);
                }
            }
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = zero + firstRow * DenseFComplexMatrix2D.this.rowStride;
                        float[] tmp = new float[2];
                        if (function instanceof FComplexMult) {
                            float[] multiplicator = ((FComplexMult)function).multiplicator;
                            int r = firstRow;
                            while (r < lastRow) {
                                int i = idx;
                                int c = 0;
                                while (c < DenseFComplexMatrix2D.this.columns) {
                                    tmp[0] = DenseFComplexMatrix2D.this.elements[i];
                                    tmp[1] = DenseFComplexMatrix2D.this.elements[i + 1];
                                    DenseFComplexMatrix2D.this.elements[i] = tmp[0] * multiplicator[0] - tmp[1] * multiplicator[1];
                                    DenseFComplexMatrix2D.this.elements[i + 1] = tmp[1] * multiplicator[0] + tmp[0] * multiplicator[1];
                                    i += DenseFComplexMatrix2D.this.columnStride;
                                    ++c;
                                }
                                idx += DenseFComplexMatrix2D.this.rowStride;
                                ++r;
                            }
                        } else {
                            int r = firstRow;
                            while (r < lastRow) {
                                int i = idx;
                                int c = 0;
                                while (c < DenseFComplexMatrix2D.this.columns) {
                                    tmp = function.apply(DenseFComplexMatrix2D.this.elements[i], DenseFComplexMatrix2D.this.elements[i + 1]);
                                    DenseFComplexMatrix2D.this.elements[i] = tmp[0];
                                    DenseFComplexMatrix2D.this.elements[i + 1] = tmp[1];
                                    i += DenseFComplexMatrix2D.this.columnStride;
                                    ++c;
                                }
                                idx += DenseFComplexMatrix2D.this.rowStride;
                                ++r;
                            }
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero;
            float[] tmp = new float[2];
            if (function instanceof FComplexMult) {
                float[] multiplicator = ((FComplexMult)function).multiplicator;
                int r = 0;
                while (r < this.rows) {
                    int i = idx;
                    int c = 0;
                    while (c < this.columns) {
                        tmp[0] = this.elements[i];
                        tmp[1] = this.elements[i + 1];
                        this.elements[i] = tmp[0] * multiplicator[0] - tmp[1] * multiplicator[1];
                        this.elements[i + 1] = tmp[1] * multiplicator[0] + tmp[0] * multiplicator[1];
                        i += this.columnStride;
                        ++c;
                    }
                    idx += this.rowStride;
                    ++r;
                }
            } else {
                int r = 0;
                while (r < this.rows) {
                    int i = idx;
                    int c = 0;
                    while (c < this.columns) {
                        tmp = function.apply(this.elements[i], this.elements[i + 1]);
                        this.elements[i] = tmp[0];
                        this.elements[i + 1] = tmp[1];
                        i += this.columnStride;
                        ++c;
                    }
                    idx += this.rowStride;
                    ++r;
                }
            }
        }
        return this;
    }

    @Override
    public FComplexMatrix2D assign(final FComplexProcedure cond, final FComplexFComplexFunction function) {
        final int zero = (int)this.index(0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        float[] elem = new float[2];
                        int idx = zero + firstRow * DenseFComplexMatrix2D.this.rowStride;
                        int r = firstRow;
                        while (r < lastRow) {
                            int i = idx;
                            int c = 0;
                            while (c < DenseFComplexMatrix2D.this.columns) {
                                elem[0] = DenseFComplexMatrix2D.this.elements[i];
                                elem[1] = DenseFComplexMatrix2D.this.elements[i + 1];
                                if (cond.apply(elem)) {
                                    elem = function.apply(elem);
                                    DenseFComplexMatrix2D.this.elements[i] = elem[0];
                                    DenseFComplexMatrix2D.this.elements[i + 1] = elem[1];
                                }
                                i += DenseFComplexMatrix2D.this.columnStride;
                                ++c;
                            }
                            idx += DenseFComplexMatrix2D.this.rowStride;
                            ++r;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            float[] elem = new float[2];
            int idx = zero;
            int r = 0;
            while (r < this.rows) {
                int i = idx;
                int c = 0;
                while (c < this.columns) {
                    elem[0] = this.elements[i];
                    elem[1] = this.elements[i + 1];
                    if (cond.apply(elem)) {
                        elem = function.apply(elem);
                        this.elements[i] = elem[0];
                        this.elements[i + 1] = elem[1];
                    }
                    i += this.columnStride;
                    ++c;
                }
                idx += this.rowStride;
                ++r;
            }
        }
        return this;
    }

    @Override
    public FComplexMatrix2D assign(final FComplexProcedure cond, final float[] value) {
        final int zero = (int)this.index(0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = zero + firstRow * DenseFComplexMatrix2D.this.rowStride;
                        float[] elem = new float[2];
                        int r = firstRow;
                        while (r < lastRow) {
                            int i = idx;
                            int c = 0;
                            while (c < DenseFComplexMatrix2D.this.columns) {
                                elem[0] = DenseFComplexMatrix2D.this.elements[i];
                                elem[1] = DenseFComplexMatrix2D.this.elements[i + 1];
                                if (cond.apply(elem)) {
                                    DenseFComplexMatrix2D.this.elements[i] = value[0];
                                    DenseFComplexMatrix2D.this.elements[i + 1] = value[1];
                                }
                                i += DenseFComplexMatrix2D.this.columnStride;
                                ++c;
                            }
                            idx += DenseFComplexMatrix2D.this.rowStride;
                            ++r;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            float[] elem = new float[2];
            int idx = zero;
            int r = 0;
            while (r < this.rows) {
                int i = idx;
                int c = 0;
                while (c < this.columns) {
                    elem[0] = this.elements[i];
                    elem[1] = this.elements[i + 1];
                    if (cond.apply(elem)) {
                        this.elements[i] = value[0];
                        this.elements[i + 1] = value[1];
                    }
                    i += this.columnStride;
                    ++c;
                }
                idx += this.rowStride;
                ++r;
            }
        }
        return this;
    }

    @Override
    public FComplexMatrix2D assign(final FComplexRealFunction function) {
        final int zero = (int)this.index(0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = zero + firstRow * DenseFComplexMatrix2D.this.rowStride;
                        float[] tmp = new float[2];
                        if (function == FComplexFunctions.abs) {
                            int r = firstRow;
                            while (r < lastRow) {
                                int i = idx;
                                int c = 0;
                                while (c < DenseFComplexMatrix2D.this.columns) {
                                    float d;
                                    tmp[0] = DenseFComplexMatrix2D.this.elements[i];
                                    tmp[1] = DenseFComplexMatrix2D.this.elements[i + 1];
                                    float absX = Math.abs(DenseFComplexMatrix2D.this.elements[i]);
                                    float absY = Math.abs(DenseFComplexMatrix2D.this.elements[i + 1]);
                                    if (absX == 0.0f && absY == 0.0f) {
                                        DenseFComplexMatrix2D.this.elements[i] = 0.0f;
                                    } else if (absX >= absY) {
                                        d = tmp[1] / tmp[0];
                                        DenseFComplexMatrix2D.this.elements[i] = absX * (float)Math.sqrt(1.0f + d * d);
                                    } else {
                                        d = tmp[0] / tmp[1];
                                        DenseFComplexMatrix2D.this.elements[i] = absY * (float)Math.sqrt(1.0f + d * d);
                                    }
                                    DenseFComplexMatrix2D.this.elements[i + 1] = 0.0f;
                                    i += DenseFComplexMatrix2D.this.columnStride;
                                    ++c;
                                }
                                idx += DenseFComplexMatrix2D.this.rowStride;
                                ++r;
                            }
                        } else {
                            int r = firstRow;
                            while (r < lastRow) {
                                int i = idx;
                                int c = 0;
                                while (c < DenseFComplexMatrix2D.this.columns) {
                                    tmp[0] = DenseFComplexMatrix2D.this.elements[i];
                                    tmp[1] = DenseFComplexMatrix2D.this.elements[i + 1];
                                    tmp[0] = function.apply(tmp);
                                    DenseFComplexMatrix2D.this.elements[i] = tmp[0];
                                    DenseFComplexMatrix2D.this.elements[i + 1] = 0.0f;
                                    i += DenseFComplexMatrix2D.this.columnStride;
                                    ++c;
                                }
                                idx += DenseFComplexMatrix2D.this.rowStride;
                                ++r;
                            }
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero;
            float[] tmp = new float[2];
            if (function == FComplexFunctions.abs) {
                int r = 0;
                while (r < this.rows) {
                    int i = idx;
                    int c = 0;
                    while (c < this.columns) {
                        float d;
                        tmp[0] = this.elements[i];
                        tmp[1] = this.elements[i + 1];
                        float absX = Math.abs(tmp[0]);
                        float absY = Math.abs(tmp[1]);
                        if (absX == 0.0f && absY == 0.0f) {
                            this.elements[i] = 0.0f;
                        } else if (absX >= absY) {
                            d = tmp[1] / tmp[0];
                            this.elements[i] = absX * (float)Math.sqrt(1.0f + d * d);
                        } else {
                            d = tmp[0] / tmp[1];
                            this.elements[i] = absY * (float)Math.sqrt(1.0f + d * d);
                        }
                        this.elements[i + 1] = 0.0f;
                        i += this.columnStride;
                        ++c;
                    }
                    idx += this.rowStride;
                    ++r;
                }
            } else {
                int r = 0;
                while (r < this.rows) {
                    int i = idx;
                    int c = 0;
                    while (c < this.columns) {
                        tmp[0] = this.elements[i];
                        tmp[1] = this.elements[i + 1];
                        tmp[0] = function.apply(tmp);
                        this.elements[i] = tmp[0];
                        this.elements[i + 1] = 0.0f;
                        i += this.columnStride;
                        ++c;
                    }
                    idx += this.rowStride;
                    ++r;
                }
            }
        }
        return this;
    }

    @Override
    public FComplexMatrix2D assign(FComplexMatrix2D source) {
        if (!(source instanceof DenseFComplexMatrix2D)) {
            super.assign(source);
            return this;
        }
        DenseFComplexMatrix2D other = (DenseFComplexMatrix2D)source;
        if (other == this) {
            return this;
        }
        this.checkShape(other);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView && other.isNoView) {
            System.arraycopy(other.elements, 0, this.elements, 0, this.elements.length);
            return this;
        }
        if (this.haveSharedCells(other)) {
            FComplexMatrix2D c = other.copy();
            if (!(c instanceof DenseFComplexMatrix2D)) {
                super.assign(other);
                return this;
            }
            other = (DenseFComplexMatrix2D)c;
        }
        final float[] elemsOther = other.elements;
        if (this.elements == null || elemsOther == null) {
            throw new InternalError();
        }
        final int columnStrideOther = other.columnStride;
        final int rowStrideOther = other.rowStride;
        final int zeroOther = (int)other.index(0, 0);
        final int zero = (int)this.index(0, 0);
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = zero + firstRow * DenseFComplexMatrix2D.this.rowStride;
                        int idxOther = zeroOther + firstRow * rowStrideOther;
                        int r = firstRow;
                        while (r < lastRow) {
                            int i = idx;
                            int j = idxOther;
                            int c = 0;
                            while (c < DenseFComplexMatrix2D.this.columns) {
                                DenseFComplexMatrix2D.this.elements[i] = elemsOther[j];
                                DenseFComplexMatrix2D.this.elements[i + 1] = elemsOther[j + 1];
                                i += DenseFComplexMatrix2D.this.columnStride;
                                j += columnStrideOther;
                                ++c;
                            }
                            idx += DenseFComplexMatrix2D.this.rowStride;
                            idxOther += rowStrideOther;
                            ++r;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero;
            int idxOther = zeroOther;
            int r = 0;
            while (r < this.rows) {
                int i = idx;
                int j = idxOther;
                int c = 0;
                while (c < this.columns) {
                    this.elements[i] = elemsOther[j];
                    this.elements[i + 1] = elemsOther[j + 1];
                    i += this.columnStride;
                    j += columnStrideOther;
                    ++c;
                }
                idx += this.rowStride;
                idxOther += rowStrideOther;
                ++r;
            }
        }
        return this;
    }

    @Override
    public FComplexMatrix2D assign(FComplexMatrix2D y, final FComplexFComplexFComplexFunction function) {
        if (!(y instanceof DenseFComplexMatrix2D)) {
            super.assign(y, function);
            return this;
        }
        this.checkShape(y);
        final float[] elemsOther = ((DenseFComplexMatrix2D)y).elements;
        if (this.elements == null || elemsOther == null) {
            throw new InternalError();
        }
        final int columnStrideOther = y.columnStride();
        final int rowStrideOther = y.rowStride();
        final int zeroOther = (int)y.index(0, 0);
        final int zero = (int)this.index(0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = zero + firstRow * DenseFComplexMatrix2D.this.rowStride;
                        int idxOther = zeroOther + firstRow * rowStrideOther;
                        float[] tmp1 = new float[2];
                        float[] tmp2 = new float[2];
                        if (function == FComplexFunctions.mult) {
                            int r = firstRow;
                            while (r < lastRow) {
                                int i = idx;
                                int j = idxOther;
                                int c = 0;
                                while (c < DenseFComplexMatrix2D.this.columns) {
                                    tmp1[0] = DenseFComplexMatrix2D.this.elements[i];
                                    tmp1[1] = DenseFComplexMatrix2D.this.elements[i + 1];
                                    tmp2[0] = elemsOther[j];
                                    tmp2[1] = elemsOther[j + 1];
                                    DenseFComplexMatrix2D.this.elements[i] = tmp1[0] * tmp2[0] - tmp1[1] * tmp2[1];
                                    DenseFComplexMatrix2D.this.elements[i + 1] = tmp1[1] * tmp2[0] + tmp1[0] * tmp2[1];
                                    i += DenseFComplexMatrix2D.this.columnStride;
                                    j += columnStrideOther;
                                    ++c;
                                }
                                idx += DenseFComplexMatrix2D.this.rowStride;
                                idxOther += rowStrideOther;
                                ++r;
                            }
                        } else if (function == FComplexFunctions.multConjFirst) {
                            int r = firstRow;
                            while (r < lastRow) {
                                int i = idx;
                                int j = idxOther;
                                int c = 0;
                                while (c < DenseFComplexMatrix2D.this.columns) {
                                    tmp1[0] = DenseFComplexMatrix2D.this.elements[i];
                                    tmp1[1] = DenseFComplexMatrix2D.this.elements[i + 1];
                                    tmp2[0] = elemsOther[j];
                                    tmp2[1] = elemsOther[j + 1];
                                    DenseFComplexMatrix2D.this.elements[i] = tmp1[0] * tmp2[0] + tmp1[1] * tmp2[1];
                                    DenseFComplexMatrix2D.this.elements[i + 1] = -tmp1[1] * tmp2[0] + tmp1[0] * tmp2[1];
                                    i += DenseFComplexMatrix2D.this.columnStride;
                                    j += columnStrideOther;
                                    ++c;
                                }
                                idx += DenseFComplexMatrix2D.this.rowStride;
                                idxOther += rowStrideOther;
                                ++r;
                            }
                        } else if (function == FComplexFunctions.multConjSecond) {
                            int r = firstRow;
                            while (r < lastRow) {
                                int i = idx;
                                int j = idxOther;
                                int c = 0;
                                while (c < DenseFComplexMatrix2D.this.columns) {
                                    tmp1[0] = DenseFComplexMatrix2D.this.elements[i];
                                    tmp1[1] = DenseFComplexMatrix2D.this.elements[i + 1];
                                    tmp2[0] = elemsOther[j];
                                    tmp2[1] = elemsOther[j + 1];
                                    DenseFComplexMatrix2D.this.elements[i] = tmp1[0] * tmp2[0] + tmp1[1] * tmp2[1];
                                    DenseFComplexMatrix2D.this.elements[i + 1] = tmp1[1] * tmp2[0] - tmp1[0] * tmp2[1];
                                    i += DenseFComplexMatrix2D.this.columnStride;
                                    j += columnStrideOther;
                                    ++c;
                                }
                                idx += DenseFComplexMatrix2D.this.rowStride;
                                idxOther += rowStrideOther;
                                ++r;
                            }
                        } else {
                            int r = firstRow;
                            while (r < lastRow) {
                                int i = idx;
                                int j = idxOther;
                                int c = 0;
                                while (c < DenseFComplexMatrix2D.this.columns) {
                                    tmp1[0] = DenseFComplexMatrix2D.this.elements[i];
                                    tmp1[1] = DenseFComplexMatrix2D.this.elements[i + 1];
                                    tmp2[0] = elemsOther[j];
                                    tmp2[1] = elemsOther[j + 1];
                                    tmp1 = function.apply(tmp1, tmp2);
                                    DenseFComplexMatrix2D.this.elements[i] = tmp1[0];
                                    DenseFComplexMatrix2D.this.elements[i + 1] = tmp1[1];
                                    i += DenseFComplexMatrix2D.this.columnStride;
                                    j += columnStrideOther;
                                    ++c;
                                }
                                idx += DenseFComplexMatrix2D.this.rowStride;
                                idxOther += rowStrideOther;
                                ++r;
                            }
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            float[] tmp1 = new float[2];
            float[] tmp2 = new float[2];
            int idx = zero;
            int idxOther = zeroOther;
            if (function == FComplexFunctions.mult) {
                int r = 0;
                while (r < this.rows) {
                    int i = idx;
                    int j = idxOther;
                    int c = 0;
                    while (c < this.columns) {
                        tmp1[0] = this.elements[i];
                        tmp1[1] = this.elements[i + 1];
                        tmp2[0] = elemsOther[j];
                        tmp2[1] = elemsOther[j + 1];
                        this.elements[i] = tmp1[0] * tmp2[0] - tmp1[1] * tmp2[1];
                        this.elements[i + 1] = tmp1[1] * tmp2[0] + tmp1[0] * tmp2[1];
                        i += this.columnStride;
                        j += columnStrideOther;
                        ++c;
                    }
                    idx += this.rowStride;
                    idxOther += rowStrideOther;
                    ++r;
                }
            } else if (function == FComplexFunctions.multConjFirst) {
                int r = 0;
                while (r < this.rows) {
                    int i = idx;
                    int j = idxOther;
                    int c = 0;
                    while (c < this.columns) {
                        tmp1[0] = this.elements[i];
                        tmp1[1] = this.elements[i + 1];
                        tmp2[0] = elemsOther[j];
                        tmp2[1] = elemsOther[j + 1];
                        this.elements[i] = tmp1[0] * tmp2[0] + tmp1[1] * tmp2[1];
                        this.elements[i + 1] = -tmp1[1] * tmp2[0] + tmp1[0] * tmp2[1];
                        i += this.columnStride;
                        j += columnStrideOther;
                        ++c;
                    }
                    idx += this.rowStride;
                    idxOther += rowStrideOther;
                    ++r;
                }
            } else if (function == FComplexFunctions.multConjSecond) {
                int r = 0;
                while (r < this.rows) {
                    int i = idx;
                    int j = idxOther;
                    int c = 0;
                    while (c < this.columns) {
                        tmp1[0] = this.elements[i];
                        tmp1[1] = this.elements[i + 1];
                        tmp2[0] = elemsOther[j];
                        tmp2[1] = elemsOther[j + 1];
                        this.elements[i] = tmp1[0] * tmp2[0] + tmp1[1] * tmp2[1];
                        this.elements[i + 1] = tmp1[1] * tmp2[0] - tmp1[0] * tmp2[1];
                        i += this.columnStride;
                        j += columnStrideOther;
                        ++c;
                    }
                    idx += this.rowStride;
                    idxOther += rowStrideOther;
                    ++r;
                }
            } else {
                int r = 0;
                while (r < this.rows) {
                    int i = idx;
                    int j = idxOther;
                    int c = 0;
                    while (c < this.columns) {
                        tmp1[0] = this.elements[i];
                        tmp1[1] = this.elements[i + 1];
                        tmp2[0] = elemsOther[j];
                        tmp2[1] = elemsOther[j + 1];
                        tmp1 = function.apply(tmp1, tmp2);
                        this.elements[i] = tmp1[0];
                        this.elements[i + 1] = tmp1[1];
                        i += this.columnStride;
                        j += columnStrideOther;
                        ++c;
                    }
                    idx += this.rowStride;
                    idxOther += rowStrideOther;
                    ++r;
                }
            }
        }
        return this;
    }

    @Override
    public FComplexMatrix2D assign(final float re, final float im) {
        final int zero = (int)this.index(0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = zero + firstRow * DenseFComplexMatrix2D.this.rowStride;
                        int r = firstRow;
                        while (r < lastRow) {
                            int i = idx;
                            int c = 0;
                            while (c < DenseFComplexMatrix2D.this.columns) {
                                DenseFComplexMatrix2D.this.elements[i] = re;
                                DenseFComplexMatrix2D.this.elements[i + 1] = im;
                                i += DenseFComplexMatrix2D.this.columnStride;
                                ++c;
                            }
                            idx += DenseFComplexMatrix2D.this.rowStride;
                            ++r;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero;
            int r = 0;
            while (r < this.rows) {
                int i = idx;
                int c = 0;
                while (c < this.columns) {
                    this.elements[i] = re;
                    this.elements[i + 1] = im;
                    i += this.columnStride;
                    ++c;
                }
                idx += this.rowStride;
                ++r;
            }
        }
        return this;
    }

    @Override
    public FComplexMatrix2D assign(final float[] values) {
        if (values.length != this.rows * 2 * this.columns) {
            throw new IllegalArgumentException("Must have same length: length=" + values.length + "rows()*2*columns()=" + this.rows() * 2 * this.columns());
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView) {
            System.arraycopy(values, 0, this.elements, 0, values.length);
        } else {
            final int zero = (int)this.index(0, 0);
            if (nthreads > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                nthreads = Math.min(nthreads, this.rows);
                Future[] futures = new Future[nthreads];
                int k = this.rows / nthreads;
                int j = 0;
                while (j < nthreads) {
                    final int firstRow = j * k;
                    final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                    futures[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            int idxOther = firstRow * DenseFComplexMatrix2D.this.columns * 2;
                            int idx = zero + firstRow * DenseFComplexMatrix2D.this.rowStride;
                            int r = firstRow;
                            while (r < lastRow) {
                                int i = idx;
                                int c = 0;
                                while (c < DenseFComplexMatrix2D.this.columns) {
                                    DenseFComplexMatrix2D.this.elements[i] = values[idxOther++];
                                    DenseFComplexMatrix2D.this.elements[i + 1] = values[idxOther++];
                                    i += DenseFComplexMatrix2D.this.columnStride;
                                    ++c;
                                }
                                idx += DenseFComplexMatrix2D.this.rowStride;
                                ++r;
                            }
                        }
                    });
                    ++j;
                }
                ConcurrencyUtils.waitForCompletion(futures);
            } else {
                int idxOther = 0;
                int idx = zero;
                int r = 0;
                while (r < this.rows) {
                    int i = idx;
                    int c = 0;
                    while (c < this.columns) {
                        this.elements[i] = values[idxOther++];
                        this.elements[i + 1] = values[idxOther++];
                        i += this.columnStride;
                        ++c;
                    }
                    idx += this.rowStride;
                    ++r;
                }
            }
        }
        return this;
    }

    @Override
    public FComplexMatrix2D assign(final float[][] values) {
        if (values.length != this.rows) {
            throw new IllegalArgumentException("Must have same number of rows: rows=" + values.length + "rows()=" + this.rows());
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView) {
            if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
                nthreads = Math.min(nthreads, this.rows);
                Future[] futures = new Future[nthreads];
                int k = this.rows / nthreads;
                int j = 0;
                while (j < nthreads) {
                    final int firstRow = j * k;
                    final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                    futures[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            int idx = 2 * DenseFComplexMatrix2D.this.columns;
                            int i = firstRow * DenseFComplexMatrix2D.this.rowStride;
                            int r = firstRow;
                            while (r < lastRow) {
                                float[] currentRow = values[r];
                                if (currentRow.length != idx) {
                                    throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + currentRow.length + "2*columns()=" + idx);
                                }
                                System.arraycopy(currentRow, 0, DenseFComplexMatrix2D.this.elements, i, idx);
                                i += idx;
                                ++r;
                            }
                        }
                    });
                    ++j;
                }
                ConcurrencyUtils.waitForCompletion(futures);
            } else {
                int idx = 2 * this.columns;
                int i = 0;
                int r = 0;
                while (r < this.rows) {
                    float[] currentRow = values[r];
                    if (currentRow.length != idx) {
                        throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + currentRow.length + "2*columns()=" + idx);
                    }
                    System.arraycopy(currentRow, 0, this.elements, i, idx);
                    i += idx;
                    ++r;
                }
            }
        } else {
            final int zero = (int)this.index(0, 0);
            if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
                nthreads = Math.min(nthreads, this.rows);
                Future[] futures = new Future[nthreads];
                int k = this.rows / nthreads;
                int j = 0;
                while (j < nthreads) {
                    final int firstRow = j * k;
                    final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                    futures[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            int idx = zero + firstRow * DenseFComplexMatrix2D.this.rowStride;
                            int r = firstRow;
                            while (r < lastRow) {
                                float[] currentRow = values[r];
                                if (currentRow.length != 2 * DenseFComplexMatrix2D.this.columns) {
                                    throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + currentRow.length + "2*columns()=" + 2 * DenseFComplexMatrix2D.this.columns());
                                }
                                int i = idx;
                                int c = 0;
                                while (c < DenseFComplexMatrix2D.this.columns) {
                                    DenseFComplexMatrix2D.this.elements[i] = currentRow[2 * c];
                                    DenseFComplexMatrix2D.this.elements[i + 1] = currentRow[2 * c + 1];
                                    i += DenseFComplexMatrix2D.this.columnStride;
                                    ++c;
                                }
                                idx += DenseFComplexMatrix2D.this.rowStride;
                                ++r;
                            }
                        }
                    });
                    ++j;
                }
                ConcurrencyUtils.waitForCompletion(futures);
            } else {
                int idx = zero;
                int r = 0;
                while (r < this.rows) {
                    float[] currentRow = values[r];
                    if (currentRow.length != 2 * this.columns) {
                        throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + currentRow.length + "2*columns()=" + 2 * this.columns());
                    }
                    int i = idx;
                    int c = 0;
                    while (c < this.columns) {
                        this.elements[i] = currentRow[2 * c];
                        this.elements[i + 1] = currentRow[2 * c + 1];
                        i += this.columnStride;
                        ++c;
                    }
                    idx += this.rowStride;
                    ++r;
                }
            }
        }
        return this;
    }

    @Override
    public FComplexMatrix2D assignImaginary(FloatMatrix2D other) {
        this.checkShape(other);
        final int columnStrideOther = other.columnStride();
        final int rowStrideOther = other.rowStride();
        final int zeroOther = (int)other.index(0, 0);
        final int zero = (int)this.index(0, 0);
        final float[] elemsOther = ((DenseFloatMatrix2D)other).elements();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = zero + firstRow * DenseFComplexMatrix2D.this.rowStride;
                        int idxOther = zeroOther + firstRow * rowStrideOther;
                        int r = firstRow;
                        while (r < lastRow) {
                            int i = idx;
                            int j = idxOther;
                            int c = 0;
                            while (c < DenseFComplexMatrix2D.this.columns) {
                                DenseFComplexMatrix2D.this.elements[i + 1] = elemsOther[j];
                                i += DenseFComplexMatrix2D.this.columnStride;
                                j += columnStrideOther;
                                ++c;
                            }
                            idx += DenseFComplexMatrix2D.this.rowStride;
                            idxOther += rowStrideOther;
                            ++r;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero;
            int idxOther = zeroOther;
            int r = 0;
            while (r < this.rows) {
                int i = idx;
                int j = idxOther;
                int c = 0;
                while (c < this.columns) {
                    this.elements[i + 1] = elemsOther[j];
                    i += this.columnStride;
                    j += columnStrideOther;
                    ++c;
                }
                idx += this.rowStride;
                idxOther += rowStrideOther;
                ++r;
            }
        }
        return this;
    }

    @Override
    public FComplexMatrix2D assignReal(FloatMatrix2D other) {
        this.checkShape(other);
        final int columnStrideOther = other.columnStride();
        final int rowStrideOther = other.rowStride();
        final int zeroOther = (int)other.index(0, 0);
        final int zero = (int)this.index(0, 0);
        final float[] elemsOther = ((DenseFloatMatrix2D)other).elements();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = zero + firstRow * DenseFComplexMatrix2D.this.rowStride;
                        int idxOther = zeroOther + firstRow * rowStrideOther;
                        int r = firstRow;
                        while (r < lastRow) {
                            int i = idx;
                            int j = idxOther;
                            int c = 0;
                            while (c < DenseFComplexMatrix2D.this.columns) {
                                DenseFComplexMatrix2D.this.elements[i] = elemsOther[j];
                                i += DenseFComplexMatrix2D.this.columnStride;
                                j += columnStrideOther;
                                ++c;
                            }
                            idx += DenseFComplexMatrix2D.this.rowStride;
                            idxOther += rowStrideOther;
                            ++r;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero;
            int idxOther = zeroOther;
            int r = 0;
            while (r < this.rows) {
                int i = idx;
                int j = idxOther;
                int c = 0;
                while (c < this.columns) {
                    this.elements[i] = elemsOther[j];
                    i += this.columnStride;
                    j += columnStrideOther;
                    ++c;
                }
                idx += this.rowStride;
                idxOther += rowStrideOther;
                ++r;
            }
        }
        return this;
    }

    @Override
    public int cardinality() {
        int cardinality = 0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        final int zero = (int)this.index(0, 0);
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            Integer[] results = new Integer[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int cardinality = 0;
                        int idx = zero + firstRow * DenseFComplexMatrix2D.this.rowStride;
                        int r = firstRow;
                        while (r < lastRow) {
                            int i = idx;
                            int c = 0;
                            while (c < DenseFComplexMatrix2D.this.columns) {
                                if ((double)DenseFComplexMatrix2D.this.elements[i] != 0.0 || (double)DenseFComplexMatrix2D.this.elements[i + 1] != 0.0) {
                                    ++cardinality;
                                }
                                i += DenseFComplexMatrix2D.this.columnStride;
                                ++c;
                            }
                            idx += DenseFComplexMatrix2D.this.rowStride;
                            ++r;
                        }
                        return cardinality;
                    }
                });
                ++j;
            }
            try {
                j = 0;
                while (j < nthreads) {
                    results[j] = (Integer)futures[j].get();
                    ++j;
                }
                cardinality = results[0];
                j = 1;
                while (j < nthreads) {
                    cardinality += results[j].intValue();
                    ++j;
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            int idx = zero;
            int r = 0;
            while (r < this.rows) {
                int i = idx;
                int c = 0;
                while (c < this.columns) {
                    if ((double)this.elements[i] != 0.0 || (double)this.elements[i + 1] != 0.0) {
                        ++cardinality;
                    }
                    i += this.columnStride;
                    ++c;
                }
                idx += this.rowStride;
                ++r;
            }
        }
        return cardinality;
    }

    public void fft2() {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        if (this.fft2 == null) {
            this.fft2 = new FloatFFT_2D(this.rows, this.columns);
        }
        if (this.isNoView) {
            this.fft2.complexForward(this.elements);
        } else {
            FComplexMatrix2D copy = this.copy();
            this.fft2.complexForward((float[])copy.elements());
            this.assign((float[])copy.elements());
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public void fftColumns() {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstColumn = j * k;
                final int lastColumn = j == nthreads - 1 ? this.columns : firstColumn + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int c = firstColumn;
                        while (c < lastColumn) {
                            ((DenseFComplexMatrix1D)DenseFComplexMatrix2D.this.viewColumn(c)).fft();
                            ++c;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            int c = 0;
            while (c < this.columns) {
                ((DenseFComplexMatrix1D)this.viewColumn(c)).fft();
                ++c;
            }
        }
    }

    public void fftRows() {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int r = firstRow;
                        while (r < lastRow) {
                            ((DenseFComplexMatrix1D)DenseFComplexMatrix2D.this.viewRow(r)).fft();
                            ++r;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            int r = 0;
            while (r < this.rows) {
                ((DenseFComplexMatrix1D)this.viewRow(r)).fft();
                ++r;
            }
        }
    }

    @Override
    public FComplexMatrix2D forEachNonZero(final IntIntFComplexFunction function) {
        final int zero = (int)this.index(0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = zero + firstRow * DenseFComplexMatrix2D.this.rowStride;
                        float[] value = new float[2];
                        int r = firstRow;
                        while (r < lastRow) {
                            int i = idx;
                            int c = 0;
                            while (c < DenseFComplexMatrix2D.this.columns) {
                                value[0] = DenseFComplexMatrix2D.this.elements[i];
                                value[1] = DenseFComplexMatrix2D.this.elements[i + 1];
                                if (value[0] != 0.0f || value[1] != 0.0f) {
                                    float[] v = function.apply(r, c, value);
                                    DenseFComplexMatrix2D.this.elements[i] = v[0];
                                    DenseFComplexMatrix2D.this.elements[i + 1] = v[1];
                                }
                                i += DenseFComplexMatrix2D.this.columnStride;
                                ++c;
                            }
                            idx += DenseFComplexMatrix2D.this.rowStride;
                            ++r;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero;
            float[] value = new float[2];
            int r = 0;
            while (r < this.rows) {
                int i = idx;
                int c = 0;
                while (c < this.columns) {
                    value[0] = this.elements[i];
                    value[1] = this.elements[i + 1];
                    if (value[0] != 0.0f || value[1] != 0.0f) {
                        float[] v = function.apply(r, c, value);
                        this.elements[i] = v[0];
                        this.elements[i + 1] = v[1];
                    }
                    i += this.columnStride;
                    ++c;
                }
                idx += this.rowStride;
                ++r;
            }
        }
        return this;
    }

    @Override
    public FComplexMatrix2D getConjugateTranspose() {
        FComplexMatrix2D transpose = this.viewDice().copy();
        final float[] elemsOther = ((DenseFComplexMatrix2D)transpose).elements;
        final int zeroOther = (int)transpose.index(0, 0);
        final int columnStrideOther = transpose.columnStride();
        final int rowStrideOther = transpose.rowStride();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        final int columnsOther = transpose.columns();
        int rowsOther = transpose.rows();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, rowsOther);
            Future[] futures = new Future[nthreads];
            int k = rowsOther / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? rowsOther : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idxOther = zeroOther + firstRow * rowStrideOther;
                        int r = firstRow;
                        while (r < lastRow) {
                            int c = 0;
                            while (c < columnsOther) {
                                elemsOther[idxOther + 1] = -elemsOther[idxOther + 1];
                                idxOther += columnStrideOther;
                                ++c;
                            }
                            ++r;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idxOther = zeroOther;
            int r = 0;
            while (r < rowsOther) {
                int c = 0;
                while (c < columnsOther) {
                    elemsOther[idxOther + 1] = -elemsOther[idxOther + 1];
                    idxOther += columnStrideOther;
                    ++c;
                }
                ++r;
            }
        }
        return transpose;
    }

    public float[] elements() {
        return this.elements;
    }

    @Override
    public FloatMatrix2D getImaginaryPart() {
        DenseFloatMatrix2D Im = new DenseFloatMatrix2D(this.rows, this.columns);
        final float[] elemsOther = Im.elements();
        final int columnStrideOther = Im.columnStride();
        final int rowStrideOther = Im.rowStride();
        final int zeroOther = (int)Im.index(0, 0);
        final int zero = (int)this.index(0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = zero + firstRow * DenseFComplexMatrix2D.this.rowStride;
                        int idxOther = zeroOther + firstRow * rowStrideOther;
                        int r = firstRow;
                        while (r < lastRow) {
                            int i = idx;
                            int j = idxOther;
                            int c = 0;
                            while (c < DenseFComplexMatrix2D.this.columns) {
                                elemsOther[j] = DenseFComplexMatrix2D.this.elements[i + 1];
                                i += DenseFComplexMatrix2D.this.columnStride;
                                j += columnStrideOther;
                                ++c;
                            }
                            idx += DenseFComplexMatrix2D.this.rowStride;
                            idxOther += rowStrideOther;
                            ++r;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero;
            int idxOther = zeroOther;
            int r = 0;
            while (r < this.rows) {
                int i = idx;
                int j = idxOther;
                int c = 0;
                while (c < this.columns) {
                    elemsOther[j] = this.elements[i + 1];
                    i += this.columnStride;
                    j += columnStrideOther;
                    ++c;
                }
                idx += this.rowStride;
                idxOther += rowStrideOther;
                ++r;
            }
        }
        return Im;
    }

    @Override
    public void getNonZeros(IntArrayList rowList, IntArrayList columnList, ArrayList<float[]> valueList) {
        rowList.clear();
        columnList.clear();
        valueList.clear();
        int idx = (int)this.index(0, 0);
        int r = 0;
        while (r < this.rows) {
            int i = idx;
            int c = 0;
            while (c < this.columns) {
                float[] value = new float[]{this.elements[i], this.elements[i + 1]};
                if (value[0] != 0.0f || value[1] != 0.0f) {
                    rowList.add(r);
                    columnList.add(c);
                    valueList.add(value);
                }
                i += this.columnStride;
                ++c;
            }
            idx += this.rowStride;
            ++r;
        }
    }

    @Override
    public float[] getQuick(int row, int column) {
        int idx = this.rowZero + row * this.rowStride + this.columnZero + column * this.columnStride;
        return new float[]{this.elements[idx], this.elements[idx + 1]};
    }

    @Override
    public FloatMatrix2D getRealPart() {
        DenseFloatMatrix2D R = new DenseFloatMatrix2D(this.rows, this.columns);
        final float[] elemsOther = R.elements();
        final int columnStrideOther = R.columnStride();
        final int rowStrideOther = R.rowStride();
        final int zeroOther = (int)R.index(0, 0);
        final int zero = (int)this.index(0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = zero + firstRow * DenseFComplexMatrix2D.this.rowStride;
                        int idxOther = zeroOther + firstRow * rowStrideOther;
                        int r = firstRow;
                        while (r < lastRow) {
                            int i = idx;
                            int j = idxOther;
                            int c = 0;
                            while (c < DenseFComplexMatrix2D.this.columns) {
                                elemsOther[j] = DenseFComplexMatrix2D.this.elements[i];
                                i += DenseFComplexMatrix2D.this.columnStride;
                                j += columnStrideOther;
                                ++c;
                            }
                            idx += DenseFComplexMatrix2D.this.rowStride;
                            idxOther += rowStrideOther;
                            ++r;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero;
            int idxOther = zeroOther;
            int r = 0;
            while (r < this.rows) {
                int i = idx;
                int j = idxOther;
                int c = 0;
                while (c < this.columns) {
                    elemsOther[j] = this.elements[i];
                    i += this.columnStride;
                    j += columnStrideOther;
                    ++c;
                }
                idx += this.rowStride;
                idxOther += rowStrideOther;
                ++r;
            }
        }
        return R;
    }

    public void ifft2(boolean scale) {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        if (this.fft2 == null) {
            this.fft2 = new FloatFFT_2D(this.rows, this.columns);
        }
        if (this.isNoView) {
            this.fft2.complexInverse(this.elements, scale);
        } else {
            FComplexMatrix2D copy = this.copy();
            this.fft2.complexInverse((float[])copy.elements(), scale);
            this.assign((float[])copy.elements());
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public void ifftColumns(final boolean scale) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstColumn = j * k;
                final int lastColumn = j == nthreads - 1 ? this.columns : firstColumn + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int c = firstColumn;
                        while (c < lastColumn) {
                            ((DenseFComplexMatrix1D)DenseFComplexMatrix2D.this.viewColumn(c)).ifft(scale);
                            ++c;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            int c = 0;
            while (c < this.columns) {
                ((DenseFComplexMatrix1D)this.viewColumn(c)).ifft(scale);
                ++c;
            }
        }
    }

    public void ifftRows(final boolean scale) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int r = firstRow;
                        while (r < lastRow) {
                            ((DenseFComplexMatrix1D)DenseFComplexMatrix2D.this.viewRow(r)).ifft(scale);
                            ++r;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            int r = 0;
            while (r < this.rows) {
                ((DenseFComplexMatrix1D)this.viewRow(r)).ifft(scale);
                ++r;
            }
        }
    }

    @Override
    public FComplexMatrix2D like(int rows, int columns) {
        return new DenseFComplexMatrix2D(rows, columns);
    }

    @Override
    public FComplexMatrix1D like1D(int size) {
        return new DenseFComplexMatrix1D(size);
    }

    @Override
    public void setQuick(int row, int column, float re, float im) {
        int idx = this.rowZero + row * this.rowStride + this.columnZero + column * this.columnStride;
        this.elements[idx] = re;
        this.elements[idx + 1] = im;
    }

    @Override
    public void setQuick(int row, int column, float[] value) {
        int idx = this.rowZero + row * this.rowStride + this.columnZero + column * this.columnStride;
        this.elements[idx] = value[0];
        this.elements[idx + 1] = value[1];
    }

    @Override
    public float[][] toArray() {
        final float[][] values = new float[this.rows][2 * this.columns];
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        final int zero = (int)this.index(0, 0);
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = zero + firstRow * DenseFComplexMatrix2D.this.rowStride;
                        int r = firstRow;
                        while (r < lastRow) {
                            int i = idx;
                            int c = 0;
                            while (c < DenseFComplexMatrix2D.this.columns) {
                                values[r][2 * c] = DenseFComplexMatrix2D.this.elements[i];
                                values[r][2 * c + 1] = DenseFComplexMatrix2D.this.elements[i + 1];
                                i += DenseFComplexMatrix2D.this.columnStride;
                                ++c;
                            }
                            idx += DenseFComplexMatrix2D.this.rowStride;
                            ++r;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero;
            int r = 0;
            while (r < this.rows) {
                int i = idx;
                int c = 0;
                while (c < this.columns) {
                    values[r][2 * c] = this.elements[i];
                    values[r][2 * c + 1] = this.elements[i + 1];
                    i += this.columnStride;
                    ++c;
                }
                idx += this.rowStride;
                ++r;
            }
        }
        return values;
    }

    @Override
    public FComplexMatrix1D vectorize() {
        DenseFComplexMatrix1D v = new DenseFComplexMatrix1D((int)this.size());
        final int zero = (int)this.index(0, 0);
        final int zeroOther = (int)((AbstractMatrix1D)v).index(0);
        final int strideOther = v.stride();
        final float[] elemsOther = (float[])((FComplexMatrix1D)v).elements();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstColumn = j * k;
                final int lastColumn = j == nthreads - 1 ? this.columns : firstColumn + k;
                final int firstIdx = j * k * this.rows;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = 0;
                        int idxOther = zeroOther + firstIdx * strideOther;
                        int c = firstColumn;
                        while (c < lastColumn) {
                            idx = zero + c * DenseFComplexMatrix2D.this.columnStride;
                            int r = 0;
                            while (r < DenseFComplexMatrix2D.this.rows) {
                                elemsOther[idxOther] = DenseFComplexMatrix2D.this.elements[idx];
                                elemsOther[idxOther + 1] = DenseFComplexMatrix2D.this.elements[idx + 1];
                                idx += DenseFComplexMatrix2D.this.rowStride;
                                idxOther += strideOther;
                                ++r;
                            }
                            ++c;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = 0;
            int idxOther = zeroOther;
            int c = 0;
            while (c < this.columns) {
                idx = zero + c * this.columnStride;
                int r = 0;
                while (r < this.rows) {
                    elemsOther[idxOther] = this.elements[idx];
                    elemsOther[idxOther + 1] = this.elements[idx + 1];
                    idx += this.rowStride;
                    idxOther += strideOther;
                    ++r;
                }
                ++c;
            }
        }
        return v;
    }

    @Override
    public FComplexMatrix1D zMult(FComplexMatrix1D y, FComplexMatrix1D z, final float[] alpha, final float[] beta, boolean transposeA) {
        if (transposeA) {
            return this.getConjugateTranspose().zMult(y, z, alpha, beta, false);
        }
        FComplexMatrix1D zz = z == null ? new DenseFComplexMatrix1D(this.rows) : z;
        if ((long)this.columns != y.size() || (long)this.rows > zz.size()) {
            throw new IllegalArgumentException("Incompatible args: " + this.toStringShort() + ", " + y.toStringShort() + ", " + zz.toStringShort());
        }
        final float[] elemsY = (float[])y.elements();
        final float[] elemsZ = (float[])zz.elements();
        if (this.elements == null || elemsY == null || elemsZ == null) {
            throw new InternalError();
        }
        final int strideY = y.stride();
        final int strideZ = zz.stride();
        final int zero = (int)this.index(0, 0);
        final int zeroY = (int)y.index(0);
        final int zeroZ = (int)zz.index(0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idxZero = zero + firstRow * DenseFComplexMatrix2D.this.rowStride;
                        int idxZeroZ = zeroZ + firstRow * strideZ;
                        int r = firstRow;
                        while (r < lastRow) {
                            float reS = 0.0f;
                            float imS = 0.0f;
                            int idx = idxZero;
                            int idxY = zeroY;
                            int c = 0;
                            while (c < DenseFComplexMatrix2D.this.columns) {
                                float reA = DenseFComplexMatrix2D.this.elements[idx];
                                float imA = DenseFComplexMatrix2D.this.elements[idx + 1];
                                float reY = elemsY[idxY];
                                float imY = elemsY[idxY + 1];
                                reS += reA * reY - imA * imY;
                                imS += imA * reY + reA * imY;
                                idx += DenseFComplexMatrix2D.this.columnStride;
                                idxY += strideY;
                                ++c;
                            }
                            float reZ = elemsZ[idxZeroZ];
                            float imZ = elemsZ[idxZeroZ + 1];
                            elemsZ[idxZeroZ] = reS * alpha[0] - imS * alpha[1] + reZ * beta[0] - imZ * beta[1];
                            elemsZ[idxZeroZ + 1] = imS * alpha[0] + reS * alpha[1] + imZ * beta[0] + reZ * beta[1];
                            idxZero += DenseFComplexMatrix2D.this.rowStride;
                            idxZeroZ += strideZ;
                            ++r;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idxZero = zero;
            int idxZeroZ = zeroZ;
            int r = 0;
            while (r < this.rows) {
                float reS = 0.0f;
                float imS = 0.0f;
                int idx = idxZero;
                int idxY = zeroY;
                int c = 0;
                while (c < this.columns) {
                    float reA = this.elements[idx];
                    float imA = this.elements[idx + 1];
                    float reY = elemsY[idxY];
                    float imY = elemsY[idxY + 1];
                    reS += reA * reY - imA * imY;
                    imS += imA * reY + reA * imY;
                    idx += this.columnStride;
                    idxY += strideY;
                    ++c;
                }
                float reZ = elemsZ[idxZeroZ];
                float imZ = elemsZ[idxZeroZ + 1];
                elemsZ[idxZeroZ] = reS * alpha[0] - imS * alpha[1] + reZ * beta[0] - imZ * beta[1];
                elemsZ[idxZeroZ + 1] = imS * alpha[0] + reS * alpha[1] + imZ * beta[0] + reZ * beta[1];
                idxZero += this.rowStride;
                idxZeroZ += strideZ;
                ++r;
            }
        }
        return zz;
    }

    @Override
    public FComplexMatrix2D zMult(FComplexMatrix2D B, FComplexMatrix2D C, final float[] alpha, final float[] beta, final boolean transposeA, final boolean transposeB) {
        int columnsC;
        int rowsA = this.rows;
        int columnsA = this.columns;
        int rowsB = B.rows();
        int columnsB = B.columns();
        int rowsC = transposeA ? columnsA : rowsA;
        int n = columnsC = transposeB ? rowsB : columnsB;
        if (C == null) {
            C = new DenseFComplexMatrix2D(rowsC, columnsC);
        }
        if (transposeA) {
            return this.getConjugateTranspose().zMult(B, C, alpha, beta, false, transposeB);
        }
        if (transposeB) {
            return this.zMult(B.getConjugateTranspose(), C, alpha, beta, transposeA, false);
        }
        if (B.rows() != columnsA) {
            throw new IllegalArgumentException("Matrix2D inner dimensions must agree:" + this.toStringShort() + ", " + B.toStringShort());
        }
        if (C.rows() != rowsA || C.columns() != columnsB) {
            throw new IllegalArgumentException("Incompatibe result matrix: " + this.toStringShort() + ", " + B.toStringShort() + ", " + C.toStringShort());
        }
        if (this == C || B == C) {
            throw new IllegalArgumentException("Matrices must not be identical");
        }
        long flops = 2L * (long)rowsA * (long)columnsA * (long)columnsB;
        int noOfTasks = (int)Math.min(flops / 30000L, (long)ConcurrencyUtils.getNumberOfThreads());
        boolean splitB = columnsB >= noOfTasks;
        int width = splitB ? columnsB : rowsA;
        noOfTasks = Math.min(width, noOfTasks);
        if (noOfTasks < 2) {
            return this.zMultSeq(B, C, alpha, beta, transposeA, transposeB);
        }
        int span = width / noOfTasks;
        Future[] subTasks = new Future[noOfTasks];
        int i = 0;
        while (i < noOfTasks) {
            FComplexMatrix2D CC;
            FComplexMatrix2D BB;
            FComplexMatrix2D AA;
            int offset = i * span;
            if (i == noOfTasks - 1) {
                span = width - span * i;
            }
            if (splitB) {
                AA = this;
                BB = B.viewPart(0, offset, columnsA, span);
                CC = C.viewPart(0, offset, rowsA, span);
            } else {
                AA = this.viewPart(offset, 0, span, columnsA);
                BB = B;
                CC = C.viewPart(offset, 0, span, columnsB);
            }
            subTasks[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    ((DenseFComplexMatrix2D)AA).zMultSeq(BB, CC, alpha, beta, transposeA, transposeB);
                }
            });
            ++i;
        }
        ConcurrencyUtils.waitForCompletion(subTasks);
        return C;
    }

    protected FComplexMatrix2D zMultSeq(FComplexMatrix2D B, FComplexMatrix2D C, float[] alpha, float[] beta, boolean transposeA, boolean transposeB) {
        if (transposeA) {
            return this.getConjugateTranspose().zMult(B, C, alpha, beta, false, transposeB);
        }
        if (transposeB) {
            return this.zMult(B.getConjugateTranspose(), C, alpha, beta, transposeA, false);
        }
        int m = this.rows;
        int n = this.columns;
        int p = B.columns();
        if (C == null) {
            C = new DenseFComplexMatrix2D(m, p);
        }
        if (!(C instanceof DenseFComplexMatrix2D)) {
            return super.zMult(B, C, alpha, beta, transposeA, transposeB);
        }
        if (B.rows() != n) {
            throw new IllegalArgumentException("Matrix2D inner dimensions must agree:" + this.toStringShort() + ", " + B.toStringShort());
        }
        if (C.rows() != m || C.columns() != p) {
            throw new IllegalArgumentException("Incompatibel result matrix: " + this.toStringShort() + ", " + B.toStringShort() + ", " + C.toStringShort());
        }
        if (this == C || B == C) {
            throw new IllegalArgumentException("Matrices must not be identical");
        }
        DenseFComplexMatrix2D BB = (DenseFComplexMatrix2D)B;
        DenseFComplexMatrix2D CC = (DenseFComplexMatrix2D)C;
        float[] AElems = this.elements;
        float[] BElems = BB.elements;
        float[] CElems = CC.elements;
        if (AElems == null || BElems == null || CElems == null) {
            throw new InternalError();
        }
        int cA = this.columnStride;
        int cB = BB.columnStride;
        int cC = CC.columnStride;
        int rA = this.rowStride;
        int rB = BB.rowStride;
        int rC = CC.rowStride;
        int BLOCK_SIZE = 30000;
        int m_optimal = (30000 - n) / (n + 1);
        if (m_optimal <= 0) {
            m_optimal = 1;
        }
        int blocks = m / m_optimal;
        int rr = 0;
        if (m % m_optimal != 0) {
            ++blocks;
        }
        while (--blocks >= 0) {
            int jB = (int)BB.index(0, 0);
            int indexA = (int)this.index(rr, 0);
            int jC = (int)CC.index(rr, 0);
            rr += m_optimal;
            if (blocks == 0) {
                m_optimal += m - rr;
            }
            int j = p;
            while (--j >= 0) {
                int iA = indexA;
                int iC = jC;
                int i = m_optimal;
                while (--i >= 0) {
                    float imB;
                    float reB;
                    float imA;
                    float reA;
                    int kA = iA;
                    int kB = jB;
                    float reS = 0.0f;
                    float imS = 0.0f;
                    kA -= cA;
                    kB -= rB;
                    int k = n % 4;
                    while (--k >= 0) {
                        reA = AElems[kA += cA];
                        imA = AElems[kA + 1];
                        reB = BElems[kB += rB];
                        imB = BElems[kB + 1];
                        reS += reA * reB - imA * imB;
                        imS += imA * reB + reA * imB;
                    }
                    k = n / 4;
                    while (--k >= 0) {
                        reA = AElems[kA += cA];
                        imA = AElems[kA + 1];
                        reB = BElems[kB += rB];
                        imB = BElems[kB + 1];
                        reS += reA * reB - imA * imB;
                        imS += imA * reB + reA * imB;
                        reA = AElems[kA += cA];
                        imA = AElems[kA + 1];
                        reB = BElems[kB += rB];
                        imB = BElems[kB + 1];
                        reS += reA * reB - imA * imB;
                        imS += imA * reB + reA * imB;
                        reA = AElems[kA += cA];
                        imA = AElems[kA + 1];
                        reB = BElems[kB += rB];
                        imB = BElems[kB + 1];
                        reS += reA * reB - imA * imB;
                        imS += imA * reB + reA * imB;
                        reA = AElems[kA += cA];
                        imA = AElems[kA + 1];
                        reB = BElems[kB += rB];
                        imB = BElems[kB + 1];
                        reS += reA * reB - imA * imB;
                        imS += imA * reB + reA * imB;
                    }
                    float reC = CElems[iC];
                    float imC = CElems[iC + 1];
                    CElems[iC] = alpha[0] * reS - alpha[1] * imS + beta[0] * reC - beta[1] * imC;
                    CElems[iC + 1] = alpha[1] * reS + alpha[0] * imS + beta[1] * reC + beta[0] * imC;
                    iA += rA;
                    iC += rC;
                }
                jB += cB;
                jC += cC;
            }
        }
        return C;
    }

    @Override
    public float[] zSum() {
        float[] sum = new float[2];
        final int zero = (int)this.index(0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<float[]>(){

                    @Override
                    public float[] call() throws Exception {
                        float[] sum = new float[2];
                        int idx = zero + firstRow * DenseFComplexMatrix2D.this.rowStride;
                        int r = firstRow;
                        while (r < lastRow) {
                            int i = idx;
                            int c = 0;
                            while (c < DenseFComplexMatrix2D.this.columns) {
                                sum[0] = sum[0] + DenseFComplexMatrix2D.this.elements[i];
                                sum[1] = sum[1] + DenseFComplexMatrix2D.this.elements[i + 1];
                                i += DenseFComplexMatrix2D.this.columnStride;
                                ++c;
                            }
                            idx += DenseFComplexMatrix2D.this.rowStride;
                            ++r;
                        }
                        return sum;
                    }
                });
                ++j;
            }
            try {
                int j2 = 0;
                while (j2 < nthreads) {
                    float[] tmp = (float[])futures[j2].get();
                    sum[0] = sum[0] + tmp[0];
                    sum[1] = sum[1] + tmp[1];
                    ++j2;
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            int idx = zero;
            int r = 0;
            while (r < this.rows) {
                int i = idx;
                int c = 0;
                while (c < this.columns) {
                    sum[0] = sum[0] + this.elements[i];
                    sum[1] = sum[1] + this.elements[i + 1];
                    i += this.columnStride;
                    ++c;
                }
                idx += this.rowStride;
                ++r;
            }
        }
        return sum;
    }

    @Override
    protected boolean haveSharedCellsRaw(FComplexMatrix2D other) {
        if (other instanceof SelectedDenseFComplexMatrix2D) {
            SelectedDenseFComplexMatrix2D otherMatrix = (SelectedDenseFComplexMatrix2D)other;
            return this.elements == otherMatrix.elements;
        }
        if (other instanceof DenseFComplexMatrix2D) {
            DenseFComplexMatrix2D otherMatrix = (DenseFComplexMatrix2D)other;
            return this.elements == otherMatrix.elements;
        }
        return false;
    }

    @Override
    public long index(int row, int column) {
        return this.rowZero + row * this.rowStride + this.columnZero + column * this.columnStride;
    }

    @Override
    protected FComplexMatrix1D like1D(int size, int zero, int stride) {
        return new DenseFComplexMatrix1D(size, this.elements, zero, stride, false);
    }

    @Override
    protected FComplexMatrix2D viewSelectionLike(int[] rowOffsets, int[] columnOffsets) {
        return new SelectedDenseFComplexMatrix2D(this.elements, rowOffsets, columnOffsets, 0);
    }
}

