package plugins.vannary.morphomaths;

import icy.plugin.abstract_.Plugin;
import icy.plugin.interface_.PluginBundled;
import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.vars.lang.VarEnum;
import plugins.adufour.vars.lang.VarSequence;

public class Watershed extends Plugin implements Block, PluginBundled {

	// Input sequence
	VarSequence in;
	VarEnum<WshedDisplay> wshedDisplay;
	
	VarSequence out;

	@Override
	public void run() {
		// TODO Auto-generated method stub

	}

	@Override
	public void declareInput(VarList inputMap) {
		inputMap.add(in);
		inputMap.add(wshedDisplay);
	}

	@Override
	public void declareOutput(VarList outputMap) {
		outputMap.add(out);
	}

	@Override
	public String getMainPluginClassName() {
		return MorphoMaths.class.getName();
	}

	// Enum containing the different type of watershed that can be calculated
	private enum WshedDisplay {
		SEP_VERSANTS("Separate basins"), CARTE_BASSINS_VERSANTS("Basins map"), WSHED_ONLY("Watershed only");

		private final String name;

		private WshedDisplay(String string) {
			this.name = string;
		}

		public String toString() {
			return this.name;
		}
	}

}
