package plugins.adufour.blocks.tools.roi;

import icy.plugin.abstract_.Plugin;
import icy.roi.BooleanMask2D;
import icy.roi.BooleanMask3D;
import icy.roi.ROI;
import icy.type.rectangle.Rectangle3D;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.vars.lang.VarROIArray;
import plugins.kernel.roi.roi3d.ROI3DArea;

public class SubtractROI extends Plugin implements ROIBlock
{
    VarROIArray roiA   = new VarROIArray("List of ROI #1");
    
    VarROIArray roiB   = new VarROIArray("List of ROI #2");
    
    VarROIArray roiOut = new VarROIArray("Subtracted ROI");
    
    @Override
    public void run()
    {
        roiOut.setValue(new ROI[0]);
        
        for (ROI a : roiA.getValue())
        {
            ROI output = a.getCopy();
            
            for (ROI b : roiB.getValue())
            {
                if (!output.intersects(b)) continue;
                
                // 3D subtraction doesn't seem to work (noticed in Icy 1.5.3.1)
                if (output instanceof ROI3DArea && b instanceof ROI3DArea)
                {
                    ROI3DArea sub3 = (ROI3DArea) output;
                    ROI3DArea roi3 = (ROI3DArea) b;
                    
                    Rectangle3D.Integer r3 = new Rectangle3D.Integer();
                    Rectangle3D.union(sub3.getBounds3D(), roi3.getBounds3D(), r3);
                    
                    BooleanMask2D[] masks = new BooleanMask2D[r3.sizeZ];
                    
                    // process union
                    for (int z = 0; z < r3.sizeZ; z++)
                    {
                        masks[z] = sub3.getBooleanMask2D(r3.z + z, true).getSubtraction(roi3.getBooleanMask2D(r3.z + z, true));
                    }
                    
                    output = new ROI3DArea(new BooleanMask3D(r3, masks));
                }
                else
                {
                    output = output.getSubtraction(b);
                }
            }
            
            if (!output.getBounds5D().isEmpty())
            {
                roiOut.add(output);
            }
        }
    }
    
    @Override
    public void declareInput(VarList inputMap)
    {
        inputMap.add("List of ROI #1", roiA);
        inputMap.add("List of ROI #2", roiB);
    }
    
    @Override
    public void declareOutput(VarList outputMap)
    {
        outputMap.add("subtraction output ROI", roiOut);
    }
    
}
