package plugins.adufour.activemeshes.mesh;

/**
 * Class defining an exception which occurs when a contour is splitting during its evolution
 * 
 * @author Alexandre Dufour
 * 
 */
public class MeshSplittingException extends MeshException
{
	private static final long	serialVersionUID	= 1L;

	public final Mesh[]		children;
	
	public MeshSplittingException(Mesh contour, Mesh[] children)
	{
		super(contour, "Contour is splitting");
		this.children = children;
	}
}
