package plugins.adufour.activemeshes.painters;

import icy.canvas.Canvas2D;
import icy.canvas.Canvas3D;
import icy.canvas.IcyCanvas;
import icy.painter.AbstractPainter;
import icy.sequence.Sequence;

import java.awt.Graphics2D;
import java.util.ArrayList;

import plugins.adufour.activemeshes.mesh.Mesh;
import vtk.vtkActor;

public class VTKMeshPainter extends AbstractPainter
{
	private final ArrayList<Mesh>		meshesToPaint	= new ArrayList<Mesh>();
	
	private final ArrayList<vtkActor>	actors			= new ArrayList<vtkActor>();
	
	@Override
	public void paint(Graphics2D g, Sequence sequence, IcyCanvas canvas)
	{
		if (canvas instanceof Canvas2D)
		{
			// TODO display rasterized view of the meshes on the 2D view
		}
		else if (canvas instanceof Canvas3D)
		{
			Canvas3D c3d = (Canvas3D) canvas;
			
			c3d.getRenderer().SetGlobalWarningDisplay(0);
			
			for (vtkActor actor : actors)
				c3d.getRenderer().RemoveActor(actor);
			
			actors.clear();
			
			synchronized (meshesToPaint)
			{
				for (Mesh mesh : meshesToPaint)
				{
					if (mesh.getT() != canvas.getPositionT()) continue;
					
					mesh.updateVTK();
					actors.add(mesh.getVTKMesh().actor);
					c3d.getRenderer().AddActor(mesh.getVTKMesh().actor);
				}
			}
			
		}
	}
	
	/**
	 * Adds the specified mesh to this painter if (and only if) it's underlying VTK structure is
	 * non-null (indicated during Mesh construction)
	 * 
	 * @param mesh
	 */
	public void addMesh(Mesh mesh)
	{
		if (mesh.getVTKMesh() == null) return;
		
		synchronized (meshesToPaint)
		{
			meshesToPaint.add(mesh);
		}
	}
	
	/**
	 * Removes the specified mesh from this painter. No action is taken if the specified painter is
	 * not registered in this painter
	 * 
	 * @param mesh
	 */
	public void removeMesh(Mesh mesh)
	{
		if (!meshesToPaint.contains(mesh)) return;
		
		synchronized (meshesToPaint)
		{
			meshesToPaint.remove(mesh);
		}
	}
	
	public void reset()
	{
		meshesToPaint.clear();
	}
}
