package plugins.tprovoost.Microscopy.MicroManager.event;

import icy.sequence.Sequence;

import java.util.List;

import mmcorej.TaggedImage;

import org.json.JSONObject;
import org.micromanager.api.SequenceSettings;

import plugins.tprovoost.Microscopy.MicroManager.MicroManager;
import plugins.tprovoost.Microscopy.MicroManager.tools.MMUtils;
import plugins.tprovoost.Microscopy.MicroManagerForIcy.MicroscopePlugin;

/**
 * @see MicroManager#addAcquisitionListener(AcquisitionListener)
 * @author Irsath Nguyen
 */
public interface AcquisitionListener
{
    /**
     * Called when a new image is captured from the a core sequence acquisition (not continuous
     * sequence acquisition).</br>
     * You can retrieve the current global acquisition result by using
     * {@link MicroManager#getAcquisitionResult()}.
     * 
     * @param image
     *        The tagged image retrieved from the core.
     * @see MMUtils#convertToIcyImage(TaggedImage)
     * @see MicroManager#getAcquisitionResult()
     */
    public void acqImgReveived(TaggedImage image);

    /**
     * Callback when {@link MicroManager#startSequenceAcquisition(int, double, boolean)} have
     * been called by a {@link MicroscopePlugin}
     */
    public void acquisitionStarted(SequenceSettings settings, JSONObject metadata);

    /**
     * Callback when an acquisition started by
     * {@link MicroManager#startSequenceAcquisition(int, double, boolean)} have been completed
     * 
     * @param result
     *        sequences with all acquisition image. You can have multiple sequence if the
     *        acquisition contains different position for each frame.
     * @see MicroManager#getAcquisitionResult()
     */
    public void acquisitionFinished(List<Sequence> result);
}