package plugins.tprovoost.Microscopy.MicroscopeLive;

import icy.canvas.IcyCanvas;
import icy.canvas.Layer;
import icy.painter.Overlay;
import icy.sequence.Sequence;
import icy.util.StringUtil;

import java.awt.BasicStroke;
import java.awt.Font;
import java.awt.Graphics2D;

import plugins.tprovoost.Microscopy.MicroManager.MicroManager;
import plugins.tprovoost.Microscopy.MicroManager.MicroscopeOverlayPreferences;

public class PainterCoordinates extends Overlay
{
    private MicroscopeOverlayPreferences prefs = MicroscopeOverlayPreferences.getInstance();
    protected String xValue = "0.0000 m";
    protected String yValue = "0.0000 m";
    protected String zValue = "0.0000 m";

    public PainterCoordinates()
    {
        super("PainterCoordinates");

        String nameXY = MicroManager.getCore().getXYStageDevice();
        String nameZ = MicroManager.getCore().getFocusDevice();
        try
        {
            if (nameXY != null && nameXY.length() != 0)
            {
                xValue = StringUtil.toString(MicroManager.getCore().getXPosition(nameXY), 4);
                yValue = StringUtil.toString(MicroManager.getCore().getYPosition(nameXY), 4);
            }
            if (nameZ != null && nameZ.length() != 0)
            {
                zValue = StringUtil.toString(MicroManager.getCore().getPosition(nameZ), 4);
            }
        }
        catch (Exception e)
        {
        }
    }

    @Override
    public void paint(Graphics2D g, Sequence sequence, IcyCanvas canvas)
    {
        // -------------
        // VERIFICATIONS
        // -------------
        if (g == null)
            return;

        if (xValue.contains("0.0000") && yValue.contains("0.0000") && zValue.contains("0.0000"))
            return;
        Layer layer = canvas.getLayer(this);
        if (layer != null && !layer.getName().equals("Coordinates"))
            layer.setName("Coordinates");
        // VARIABLES
        int w = sequence.getWidth();
        int h = sequence.getHeight();

        // SETUP OF THE TEXT
        String toDisplay = "Stage:  x: " + xValue + "  y: " + yValue + "  z: " + zValue;
        Font f;
        if (w > h)
            f = g.getFont().deriveFont(14F * h / 512);
        else
            f = g.getFont().deriveFont(14F * w / 512);
        g.setFont(f);
        int fh = g.getFontMetrics().getHeight();
        int wh = g.getFontMetrics().charsWidth(toDisplay.toCharArray(), 0, toDisplay.length());
        // DRAW
        g.setColor(prefs.getColor("Background"));
        g.fillRect(0, h - fh, wh + fh * 2, fh);
        g.setStroke(new BasicStroke((float) canvas.canvasToImageLogDeltaX(4)));
        g.setColor(prefs.getColor("Borders"));
        g.setStroke(new BasicStroke(1));
        g.drawRect(0, h - fh, wh + fh * 2, fh);
        g.setColor(prefs.getColor("Text"));
        g.drawString(toDisplay, fh, h - fh / 4);
    }

    public void setXY(double x, double y)
    {
        xValue = StringUtil.toString(x, 4) + " m";
        yValue = StringUtil.toString(y, 4) + " m";

        painterChanged();
    }

    public void setZ(double z)
    {
        zValue = StringUtil.toString(z, 4) + " m";

        painterChanged();
    }
}