/**
 * 
 */
package plugins.stef.roi.bloc.op;

import icy.plugin.abstract_.Plugin;
import icy.plugin.interface_.PluginBundled;
import icy.plugin.interface_.PluginLibrary;
import icy.roi.ROI;
import icy.util.ShapeUtil.BooleanOperator;

import java.util.ArrayList;
import java.util.List;

import plugins.adufour.blocks.tools.roi.ROIBlock;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.vars.lang.VarEnum;
import plugins.adufour.vars.lang.VarROIArray;
import plugins.stef.roi.bloc.RoiBlocks;

/**
 * Block to merge two set of ROIs together applying a logic Boolean Operation (OR, AND or XOR)
 * 
 * @author Stephane
 */
public class BooleanOperationROI extends Plugin implements ROIBlock, PluginLibrary, PluginBundled
{
    protected VarROIArray roiSet1 = new VarROIArray("ROI first set", null);
    protected VarROIArray roiSet2 = new VarROIArray("ROI second set", null);
    protected VarEnum<BooleanOperator> op = new VarEnum<BooleanOperator>("Operation", BooleanOperator.OR);
    protected VarROIArray output = new VarROIArray("Result");

    @Override
    public void run()
    {
        final List<ROI> result = new ArrayList<ROI>();

        for (ROI roi1 : roiSet1.getValue())
        {
            for (ROI roi2 : roiSet2.getValue())
            {
                if (roi1 != null)
                {
                    final ROI r = roi1.merge(roi2, op.getValue());

                    if (r != null)
                        result.add(r);
                }
            }
        }

        output.setValue(result.toArray(new ROI[result.size()]));
    }

    @Override
    public void declareInput(VarList inputMap)
    {
        inputMap.add("roi1", roiSet1);
        inputMap.add("roi2", roiSet2);
        inputMap.add("op", op);
    }

    @Override
    public void declareOutput(VarList outputMap)
    {
        outputMap.add("out", output);
    }

    @Override
    public String getMainPluginClassName()
    {
        return RoiBlocks.class.getName();
    }
}
