package plugins.tprovoost.Microscopy.MicroManager.event;

import icy.image.IcyBufferedImage;
import plugins.tprovoost.Microscopy.MicroManager.MicroManager;

/**
 * @see MicroManager#addLiveListener(LiveListener)
 * @author Irsath Nguyen
 */
public interface LiveListener
{
    /**
     * Called when a new image is captured by the core when live mode is on.<br/>
     * Note that the new image properties may have changed (such as the image size, binning,
     * exposure...)<br/>
     * You can retrieve the associated metadata by using {@link MicroManager#getMetadata(int)}.
     * 
     * @param image
     *        the last image received from live
     * @see MicroManager#startLiveMode()
     * @see MicroManager#stopLiveMode(boolean)
     * @see MicroManager#isLiveRunning()
     */
    public void liveImgReceived(IcyBufferedImage image);

    /**
     * Notify that live have just been started.
     * 
     * @see MicroManager#startLiveMode()
     */
    public void liveStarted();

    /**
     * Notify that live have just been stopped.
     * 
     * @see MicroManager#stopLiveMode(boolean)
     */
    public void liveStopped();
}