package plugins.tprovoost.Microscopy.MicroManagerForIcy;

import icy.main.Icy;
import icy.plugin.abstract_.PluginActionable;
import icy.plugin.interface_.PluginThreaded;
import icy.system.thread.ThreadUtil;
import mmcorej.CMMCore;
import plugins.tprovoost.Microscopy.MicroManager.MicroManager;
import plugins.tprovoost.Microscopy.MicroManager.tools.MMUtils;

public final class MicromanagerPlugin extends PluginActionable implements PluginThreaded
{
    /**
     * Initialize the Micro-Manager library.<br>
     * Better to use {@link MicromanagerPlugin#init()} instead.
     */
    public static void init()
    {
        // verify that system libraries are loaded
        if (!MMUtils.isSystemLibrairiesLoaded())
        {
            // load micro manager libraries
            if (!MMUtils.fixSystemLibrairies())
                return;
        }

        // sometime a frame can ask to re-init when Icy is exiting...
        if (!MicroManager.isInitialized() && !Icy.isExiting())
        {
            // currently initializing ?
            if (MicroManager.isInitializing())
            {
                // wait for initialization
                while (MicroManager.isInitializing())
                    ThreadUtil.sleep(10);
            }
            else
                // initialize micro manager
                MicroManager.init();
        }
    }

    @Override
    public final void run()
    {
        init();
    }

    /**
     * @deprecated Only provided for backward compatibility. Use {@link MicroManager#getCore()} instead.
     */
    @Deprecated
    public static CMMCore getCore()
    {
        return MicroManager.getCore();
    }
}