package plugins.tprovoost.Microscopy.MicroManager.gui;

import javax.swing.JProgressBar;

import plugins.tprovoost.Microscopy.MicroManagerForIcy.MicroscopePlugin;

/**
 * The Running Progress class allows the creation of progress bars for
 * plugins in order to let them show the progress of their acquisition. It
 * is also used for the Continuous Acquisition bar.
 * 
 * @author Thomas Provoost
 */
public class RunningProgress extends JProgressBar
{
    /** generated UID */
    private static final long serialVersionUID = 1L;
    private int progress = 0;
    private String renderedName;
    private MicroscopePlugin plugin;
    private boolean valueDisplayed;

    /**
     * @param MicroManagerPlugin
     *        : Plugin which call for the RunningProgress
     * @param pluginName
     *        : Plugin name.
     * @param valueDisplayed
     *        : Display or not the progress as text.
     */
    public RunningProgress(MicroscopePlugin MicroManagerPlugin, String pluginName, boolean valueDisplayed)
    {
        this.plugin = MicroManagerPlugin;
        this.renderedName = pluginName;
        this.valueDisplayed = valueDisplayed;
    }

    /**
     * Used only for Continuous Acquisition.
     */
    public RunningProgress()
    {
        plugin = null;
        renderedName = "Continuous Acquisition / Live mode";
        valueDisplayed = false;
    }

    /**
     * Change the progress status.
     * 
     * @param progress
     *        : new progress value.
     */
    public void setProgress(int progress)
    {
        this.progress = progress;
    }

    public int getProgress()
    {
        return progress;
    }

    public MicroscopePlugin getPlugin()
    {
        return plugin;
    }

    public void setPlugin(MicroscopePlugin plugin)
    {
        this.plugin = plugin;
    }

    public String getRenderedName()
    {
        return renderedName;
    }

    public void setRenderedName(String renderedName)
    {
        this.renderedName = renderedName;
    }

    public boolean isValueDisplayed()
    {
        return valueDisplayed;
    }

    public void setValueDisplayed(boolean valueDisplayed)
    {
        this.valueDisplayed = valueDisplayed;
    }
}
