package plugins.tprovoost.sequenceblocks.infos;

import icy.gui.component.renderer.ColormapComboBoxRenderer;
import icy.image.colormap.IcyColorMap;
import icy.image.colormap.LinearColorMap;

import java.util.List;

import javax.swing.JComboBox;

import plugins.adufour.vars.gui.VarEditor;
import plugins.adufour.vars.gui.model.ValueSelectionModel;
import plugins.adufour.vars.gui.swing.ComboBox;
import plugins.adufour.vars.lang.Var;

/**
 * Define a specific Var type for ColorMap object
 * 
 * @author emilie
 */
public class VarColormap extends Var<IcyColorMap>
{
    public static class ColormapSelectionModel extends ValueSelectionModel<IcyColorMap>
    {
        @Override
        public IcyColorMap getDefaultValue()
        {
            return LinearColorMap.gray_;
        }

        @Override
        public List<IcyColorMap> getValidValues()
        {
            return IcyColorMap.getAllColorMaps(true, true);
        }
        
        @Override
        public boolean isValid(IcyColorMap value)
        {
            return true;
        }

        @Override
        public boolean isFreeInput()
        {
            return false;
        }
    }

    /**
     * Create a new VarColormap with given name and default value
     */
    public VarColormap(String name, IcyColorMap defaultValue)
    {
        super(name, new ColormapSelectionModel());
    }

    @Override
    public VarEditor<IcyColorMap> createVarEditor()
    {
        // create the var editor (combo box type here)
        final ComboBox<IcyColorMap> result = new ComboBox<IcyColorMap>(this);
        // get the editor component
        final JComboBox combo = result.getEditorComponent();
        // and set a specific renderer
        combo.setRenderer(new ColormapComboBoxRenderer(combo));

        return result;
    }
}
