package plugins.fab.trackmanager.processors;

import icy.file.xls.XlsManager;
import icy.gui.dialog.MessageDialog;
import icy.gui.util.GuiUtil;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;

import plugins.fab.trackmanager.PluginTrackManagerProcessor;
import plugins.fab.trackmanager.TrackSegment;
import plugins.nchenouard.spot.Detection;

public class TrackProcessorExportTrackToXLS  extends PluginTrackManagerProcessor implements ActionListener {

	JButton exportTracksToXLSButton = new JButton("export tracks to excel");
	
	public TrackProcessorExportTrackToXLS() {

		setName( "Export Tracks to XLS" );
		
		panel.setLayout( new BoxLayout( panel , BoxLayout.PAGE_AXIS ) );
		panel.add( GuiUtil.createLineBoxPanel( exportTracksToXLSButton ) );
		exportTracksToXLSButton.addActionListener( this );
		
	}
	
	@Override
	public void Close() {


		
	}

	@Override
	public void Compute() {

		
	}

	@Override
	public void displaySequenceChanged() {

		
	}

	@Override
	public void actionPerformed(ActionEvent e) {

		exportToXLS( (ArrayList<TrackSegment>) trackPool.getTrackSegmentList().clone() );
		
	}

	private void exportToXLS(ArrayList<TrackSegment> trackSegmentList ) {

		JFileChooser chooser = new JFileChooser();
		chooser.setDialogTitle("Select xls file.");
		
		int returnVal = chooser.showOpenDialog(null);
		if(returnVal != JFileChooser.APPROVE_OPTION) return;
		
		File file = chooser.getSelectedFile();

		XlsManager xls = null;
		try {
			 xls = new XlsManager( file );
		} catch (IOException e) {
		
			MessageDialog.showDialog( "Cannot open file." , MessageDialog.ERROR_MESSAGE );
			return;
		}		
		xls.createNewPage("Tracks");
		
		int cursorY = 0;
		
		for ( TrackSegment ts : trackSegmentList )
		{
			cursorY++;
			xls.setLabel( 0 , cursorY, "track #");
			xls.setNumber( 1 , cursorY, trackSegmentList.indexOf( ts ) );
			cursorY++;
			
			xls.setLabel( 2 , cursorY, "t");
			xls.setLabel( 3 , cursorY, "x");
			xls.setLabel( 4 , cursorY, "y");
			xls.setLabel( 5 , cursorY, "z");
			cursorY++;
			
			ArrayList<Detection> detectionList = ts.getDetectionList();
			
			for ( int i = 0;  i < detectionList.size() ; i++  )
			{
				Detection d = detectionList.get( i );

				if ( d.isEnabled() )
				{
					xls.setNumber( 2 , cursorY , d.getT() );
					xls.setNumber( 3 , cursorY , d.getX() );
					xls.setNumber( 4 , cursorY , d.getY() );
					xls.setNumber( 5 , cursorY , d.getZ() );

					cursorY++;
				}
				
			}	
			
		}
		
		xls.SaveAndClose();
		
	}

	
	
}
