/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.Roi;
import ij.io.RoiEncoder;
import ij.io.SaveDialog;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import java.io.IOException;

public class RoiWriter
implements PlugInFilter {
    ImagePlus imp;

    public int setup(String arg, ImagePlus imp) {
        this.imp = imp;
        return 1183;
    }

    public void run(ImageProcessor ip) {
        try {
            this.saveRoi(this.imp);
        }
        catch (IOException e) {
            String msg = e.getMessage();
            if (msg == null || msg.equals("")) {
                msg = "" + e;
            }
            IJ.error("ROI Writer", msg);
        }
    }

    public void saveRoi(ImagePlus imp) throws IOException {
        SaveDialog sd;
        Roi roi = imp.getRoi();
        if (roi == null) {
            throw new IllegalArgumentException("ROI required");
        }
        String name = roi.getName();
        if (name == null) {
            name = imp.getTitle();
        }
        if ((name = (sd = new SaveDialog("Save Selection...", name, ".roi")).getFileName()) == null) {
            return;
        }
        String dir = sd.getDirectory();
        RoiEncoder re = new RoiEncoder(dir + name);
        re.write(roi);
        if (name.endsWith(".roi")) {
            name = name.substring(0, name.length() - 4);
        }
        roi.setName(name);
    }
}

