/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.algo.solver.preconditioner;

import cern.colt.Sorting;
import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.algo.solver.preconditioner.DoublePreconditioner;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix1D;
import cern.colt.matrix.tdouble.impl.SparseRCDoubleMatrix2D;

public class DoubleILU
implements DoublePreconditioner {
    private SparseRCDoubleMatrix2D LU;
    private final DoubleMatrix1D y;
    private int[] diagind;
    private final int n;

    public DoubleILU(int n) {
        this.n = n;
        this.y = new DenseDoubleMatrix1D(n);
    }

    @Override
    public DoubleMatrix1D apply(DoubleMatrix1D b, DoubleMatrix1D x) {
        if (x == null) {
            x = b.like();
        }
        this.lowerUnitSolve(b, this.y);
        return this.upperSolve(this.y, x);
    }

    @Override
    public DoubleMatrix1D transApply(DoubleMatrix1D b, DoubleMatrix1D x) {
        if (x == null) {
            x = b.like();
        }
        this.upperTransSolve(b, this.y);
        return this.loverUnitTransSolve(this.y, x);
    }

    @Override
    public void setMatrix(DoubleMatrix2D A) {
        if (A.rows() != this.n) {
            throw new IllegalArgumentException("A.rows() != n");
        }
        this.LU = new SparseRCDoubleMatrix2D(this.n, this.n);
        this.LU.assign(A);
        if (!this.LU.hasColumnIndexesSorted()) {
            this.LU.sortColumnIndexes();
        }
        this.factor();
    }

    /*
     * Unable to fully structure code
     */
    private void factor() {
        colind = this.LU.getColumnIndexes();
        rowptr = this.LU.getRowPointers();
        data = this.LU.getValues();
        this.diagind = this.findDiagonalIndexes(this.n, colind, rowptr);
        k = 1;
        while (k < this.n) {
            i = rowptr[k];
            while (i < this.diagind[k]) {
                index = colind[i];
                LUii = data[this.diagind[index]];
                if (LUii == 0.0) {
                    throw new RuntimeException("Zero pivot encountered on row " + (i + 1) + " during ILU process");
                }
                v0 = i;
                v1 = data[v0] / LUii;
                data[v0] = v1;
                LUki = v1;
                j = this.diagind[index] + 1;
                l = rowptr[k] + 1;
                ** GOTO lbl27
                {
                    ++l;
                    do {
                        if (l < rowptr[k + 1] && colind[l] < colind[j]) continue block2;
                        if (colind[l] == colind[j]) {
                            v2 = l;
                            data[v2] = data[v2] - LUki * data[j];
                        }
                        ++j;
lbl27:
                        // 2 sources

                    } while (j < rowptr[index + 1]);
                }
                ++i;
            }
            ++k;
        }
    }

    private int[] findDiagonalIndexes(int m, int[] colind, int[] rowptr) {
        int[] diagind = new int[m];
        int k = 0;
        while (k < m) {
            diagind[k] = Sorting.binarySearchFromTo(colind, k, rowptr[k], rowptr[k + 1] - 1);
            if (diagind[k] < 0) {
                throw new RuntimeException("Missing diagonal entry on row " + (k + 1));
            }
            ++k;
        }
        return diagind;
    }

    private DoubleMatrix1D lowerUnitSolve(DoubleMatrix1D b, DoubleMatrix1D x) {
        double[] bd = ((DenseDoubleMatrix1D)b).elements();
        double[] xd = ((DenseDoubleMatrix1D)x).elements();
        int[] colind = this.LU.getColumnIndexes();
        int[] rowptr = this.LU.getRowPointers();
        double[] data = this.LU.getValues();
        int rows = this.LU.rows();
        int i = 0;
        while (i < rows) {
            double sum = 0.0;
            int j = rowptr[i];
            while (j < this.diagind[i]) {
                sum += data[j] * xd[colind[j]];
                ++j;
            }
            xd[i] = bd[i] - sum;
            ++i;
        }
        return x;
    }

    private DoubleMatrix1D loverUnitTransSolve(DoubleMatrix1D b, DoubleMatrix1D x) {
        x.assign(b);
        double[] xd = ((DenseDoubleMatrix1D)x).elements();
        int[] colind = this.LU.getColumnIndexes();
        int[] rowptr = this.LU.getRowPointers();
        double[] data = this.LU.getValues();
        int rows = this.LU.rows();
        int i = rows - 1;
        while (i >= 0) {
            int j = rowptr[i];
            while (j < this.diagind[i]) {
                int n = colind[j];
                xd[n] = xd[n] - data[j] * xd[i];
                ++j;
            }
            --i;
        }
        return x;
    }

    private DoubleMatrix1D upperSolve(DoubleMatrix1D b, DoubleMatrix1D x) {
        double[] bd = ((DenseDoubleMatrix1D)b).elements();
        double[] xd = ((DenseDoubleMatrix1D)x).elements();
        int[] colind = this.LU.getColumnIndexes();
        int[] rowptr = this.LU.getRowPointers();
        double[] data = this.LU.getValues();
        int rows = this.LU.rows();
        int i = rows - 1;
        while (i >= 0) {
            double sum = 0.0;
            int j = this.diagind[i] + 1;
            while (j < rowptr[i + 1]) {
                sum += data[j] * xd[colind[j]];
                ++j;
            }
            xd[i] = (bd[i] - sum) / data[this.diagind[i]];
            --i;
        }
        return x;
    }

    private DoubleMatrix1D upperTransSolve(DoubleMatrix1D b, DoubleMatrix1D x) {
        x.assign(b);
        double[] xd = ((DenseDoubleMatrix1D)x).elements();
        int[] colind = this.LU.getColumnIndexes();
        int[] rowptr = this.LU.getRowPointers();
        double[] data = this.LU.getValues();
        int rows = this.LU.rows();
        int i = 0;
        while (i < rows) {
            int n = i;
            xd[n] = xd[n] / data[this.diagind[i]];
            int j = this.diagind[i] + 1;
            while (j < rowptr[i + 1]) {
                int n2 = colind[j];
                xd[n2] = xd[n2] - data[j] * xd[i];
                ++j;
            }
            ++i;
        }
        return x;
    }
}

