/*
 * Decompiled with CFR 0.152.
 */
package plugins.mitiv.io;

import icy.image.IcyBufferedImage;
import icy.sequence.Sequence;
import icy.type.collection.array.Array1DUtil;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import mitiv.array.Double2D;
import mitiv.array.Double3D;
import mitiv.array.Float2D;
import mitiv.array.Float3D;
import mitiv.array.ShapedArray;
import mitiv.base.Shape;
import mitiv.io.BufferedImageUtils;
import mitiv.utils.CommonUtils;

public class IcyBufferedImageUtils {
    public static ShapedArray imageToArray(ArrayList<IcyBufferedImage> listImage) {
        int width = listImage.get(0).getWidth();
        int height = listImage.get(0).getHeight();
        int sizeZ = listImage.size();
        int[] shape = new int[]{width, height, sizeZ};
        return IcyBufferedImageUtils.imageToArray(listImage, shape[0], shape[1], shape[2]);
    }

    public static ShapedArray imageToArray(ArrayList<IcyBufferedImage> listImage, int[] shape) {
        if (shape.length != 3) {
            throw new IllegalArgumentException("Shape should be of size 3, because input is three dimensionnal data");
        }
        return IcyBufferedImageUtils.imageToArray(listImage, shape[0], shape[1], shape[2]);
    }

    public static ShapedArray imageToArray(ArrayList<IcyBufferedImage> listImage, int width, int height, int sizeZ) {
        int[] shape = new int[]{width, height, sizeZ};
        try {
            double[] out = new double[sizeZ * width * height];
            int j = 0;
            while (j < sizeZ) {
                double[] tmp = listImage.get(j).getDataCopyCXYAsDouble();
                int i = 0;
                while (i < tmp.length) {
                    out[i + j * tmp.length] = tmp[i];
                    ++i;
                }
                ++j;
            }
            return Double3D.wrap(out, shape);
        }
        catch (Exception e) {
            ArrayList<IcyBufferedImage> list = new ArrayList<IcyBufferedImage>(listImage);
            return BufferedImageUtils.imageToArray(list);
        }
    }

    public static ShapedArray imageToArray(IcyBufferedImage image) {
        int[] shape = new int[]{image.getWidth(), image.getHeight()};
        return IcyBufferedImageUtils.imageToArray(image, shape[0], shape[1]);
    }

    public static ShapedArray imageToArray(IcyBufferedImage image, int[] shape) {
        if (shape.length != 2) {
            throw new IllegalArgumentException("Shape should be of size 2, because input is two dimensionnal data");
        }
        return IcyBufferedImageUtils.imageToArray(image, shape[0], shape[1]);
    }

    public static ShapedArray imageToArray(IcyBufferedImage image, int width, int height) {
        int[] shape = new int[]{width, height};
        try {
            return Double2D.wrap(image.getDataCopyCXYAsDouble(), shape);
        }
        catch (Exception e) {
            return BufferedImageUtils.imageToArray((BufferedImage)image);
        }
    }

    public static ShapedArray imageToArray(Sequence seq, int canal) {
        if (seq.getSizeZ() == 1) {
            return IcyBufferedImageUtils.imageToArray(seq, Shape.make(seq.getSizeX(), seq.getSizeY()), canal);
        }
        return IcyBufferedImageUtils.imageToArray(seq, Shape.make(seq.getSizeX(), seq.getSizeY(), seq.getSizeZ()), canal);
    }

    public static ShapedArray imageToArray(Sequence seq, Shape shape, int canal) {
        if (seq.getSizeT() != 1) {
            throw new IllegalArgumentException("The input canno't be a 4D sequence");
        }
        try {
            double[] out = Array1DUtil.arrayToDoubleArray((Object)seq.getDataCopyXYZT(canal), (boolean)seq.isSignedDataType());
            if (shape.rank() == 2) {
                return Double2D.wrap(out, shape);
            }
            return Double3D.wrap(out, shape);
        }
        catch (Exception e) {
            System.err.println("Canno't take only one canal " + e);
            if (shape.rank() == 2) {
                return Double2D.wrap(IcyBufferedImageUtils.icyImage3DToArray1D(seq.getAllImage(), shape.dimension(0), shape.dimension(1), 1, false), shape);
            }
            return Double3D.wrap(IcyBufferedImageUtils.icyImage3DToArray1D(seq.getAllImage(), shape.dimension(0), shape.dimension(1), shape.dimension(2), false), shape);
        }
    }

    public static ShapedArray sequenceToArray(IcyBufferedImage image, int width, int height) {
        int[] shape = new int[]{width, height};
        try {
            return Double2D.wrap(image.getDataCopyCXYAsDouble(), shape);
        }
        catch (Exception e) {
            return BufferedImageUtils.imageToArray((BufferedImage)image);
        }
    }

    public static Sequence IcyBufferedToSequence(ArrayList<IcyBufferedImage> image) {
        Sequence tmp = new Sequence();
        int i = 0;
        while (i < image.size()) {
            tmp.addImage(i, (BufferedImage)image.get(i));
            ++i;
        }
        return tmp;
    }

    public static Sequence BufferedToSequence(ArrayList<BufferedImage> image) {
        Sequence tmp = new Sequence();
        int i = 0;
        while (i < image.size()) {
            tmp.addImage(i, image.get(i));
            ++i;
        }
        return tmp;
    }

    public static double[] shiftIcyPsf3DToArray1D(ArrayList<IcyBufferedImage> listPSF, int width, int height, int sizeZ, boolean isComplex) {
        double[] out = isComplex ? new double[width * height * sizeZ * 2] : new double[width * height * sizeZ];
        double[] psfIn = IcyBufferedImageUtils.icyImage3DToArray1D(listPSF, width, height, sizeZ, isComplex);
        if (psfIn.length != out.length) {
            System.err.println("Bad size for psf and output deconvutil l356");
        }
        CommonUtils.fftShift3D(psfIn, out, width, height, sizeZ);
        return out;
    }

    public static ArrayList<IcyBufferedImage> arrayToImage(ShapedArray array) {
        Shape shape = array.getShape();
        int width = shape.dimension(0);
        int height = shape.dimension(1);
        if (array.getType() == 5) {
            if (shape.rank() == 2) {
                return IcyBufferedImageUtils.fill(new IcyBufferedImage(width, height, (Object)((Double2D)array).flatten()));
            }
            if (shape.rank() == 3) {
                double[] data = ((Double3D)array).flatten();
                int sizeZ = shape.dimension(2);
                ArrayList<IcyBufferedImage> list = new ArrayList<IcyBufferedImage>();
                int j = 0;
                while (j < sizeZ) {
                    double[] tmp = new double[width * height];
                    int i = 0;
                    while (i < width * height) {
                        tmp[i] = data[i + j * width * height];
                        ++i;
                    }
                    IcyBufferedImage icyTmp = new IcyBufferedImage(width, height, (Object)tmp);
                    list.add(icyTmp);
                    ++j;
                }
                return list;
            }
            throw new IllegalArgumentException("Rank of the Shaped Array can only be 2 or 3");
        }
        if (shape.rank() == 2) {
            return IcyBufferedImageUtils.fill(new IcyBufferedImage(width, height, (Object)((Float2D)array).toFloat().flatten()));
        }
        if (shape.rank() == 3) {
            float[] data = ((Float3D)array).flatten();
            int sizeZ = shape.dimension(2);
            ArrayList<IcyBufferedImage> list = new ArrayList<IcyBufferedImage>();
            int j = 0;
            while (j < sizeZ) {
                float[] tmp = new float[width * height];
                int i = 0;
                while (i < width * height) {
                    tmp[i] = data[i + j * width * height];
                    ++i;
                }
                IcyBufferedImage icyTmp = new IcyBufferedImage(width, height, (Object)tmp);
                list.add(icyTmp);
                ++j;
            }
            return list;
        }
        throw new IllegalArgumentException("Rank of the Shaped Array can only be 2 or 3");
    }

    private static ArrayList<IcyBufferedImage> fill(IcyBufferedImage img) {
        ArrayList<IcyBufferedImage> list = new ArrayList<IcyBufferedImage>();
        list.add(img);
        return list;
    }

    @Deprecated
    public static double[] icyImage3DToArray1D(ArrayList<IcyBufferedImage> listImage, int width, int height, int sizeZ, boolean isComplex) {
        double[] out;
        if (isComplex) {
            out = new double[2 * sizeZ * width * height];
            int strideW = width;
            int strideH = width * height;
            int k = 0;
            while (k < sizeZ) {
                double[] tmp = CommonUtils.imageToArray1D((BufferedImage)listImage.get(k), false);
                int j = 0;
                while (j < height) {
                    int i = 0;
                    while (i < width) {
                        out[2 * i + 2 * j * strideW + 2 * k * strideH] = tmp[i + j * strideW];
                        ++i;
                    }
                    ++j;
                }
                ++k;
            }
        } else {
            out = new double[sizeZ * width * height];
            int j = 0;
            while (j < sizeZ) {
                double[] tmp = CommonUtils.imageToArray1D((BufferedImage)listImage.get(j), false);
                int i = 0;
                while (i < tmp.length) {
                    out[i + j * tmp.length] = tmp[i];
                    ++i;
                }
                ++j;
            }
        }
        return out;
    }

    public static ArrayList<BufferedImage> arrayToIcyImage3D(double[] array, boolean isComplex, int width, int height, int sizeZ) {
        ArrayList<BufferedImage> out = new ArrayList<BufferedImage>();
        if (isComplex) {
            int k = 0;
            while (k < sizeZ) {
                double[] tmp = new double[width * height];
                int j = 0;
                while (j < height) {
                    int i = 0;
                    while (i < width) {
                        tmp[i + j * width] = array[2 * i + 2 * j * width + 2 * k * height * width];
                        ++i;
                    }
                    ++j;
                }
                out.add((BufferedImage)new IcyBufferedImage(width, height, (Object)tmp));
                ++k;
            }
        } else {
            int j = 0;
            while (j < sizeZ) {
                double[] tmp = new double[width * height];
                int i = 0;
                while (i < width * height) {
                    tmp[i] = array[i + j * height * width];
                    ++i;
                }
                out.add((BufferedImage)new IcyBufferedImage(width, height, (Object)tmp));
                ++j;
            }
        }
        return out;
    }

    public static Sequence arrayToSequence(double[] array, boolean isComplex, int width, int height, int sizeZ) {
        ArrayList<BufferedImage> tmp = IcyBufferedImageUtils.arrayToIcyImage3D(array, isComplex, width, height, sizeZ);
        return IcyBufferedImageUtils.BufferedToSequence(tmp);
    }
}

