/*
 * Decompiled with CFR 0.152.
 */
package mitiv.deconv.impl;

import mitiv.array.DoubleArray;
import mitiv.array.ShapedArray;
import mitiv.deconv.Convolution;
import mitiv.exception.IncorrectSpaceException;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.ShapedVector;
import mitiv.linalg.shaped.ShapedVectorSpace;

public abstract class ConvolutionDouble
extends Convolution {
    private double[] tmp = null;
    private double[] mtf = null;

    protected ConvolutionDouble(ShapedVectorSpace space) {
        super(space);
        if (space.getType() != 5) {
            throw new IllegalArgumentException("Vector space must be for double data type");
        }
    }

    protected ConvolutionDouble(ShapedVectorSpace inp, ShapedVectorSpace out) {
        super(inp, out);
        if (inp.getType() != 5) {
            throw new IllegalArgumentException("Input vector space must be for double data type");
        }
        if (out.getType() != 5) {
            throw new IllegalArgumentException("Output vector space must be for double data type");
        }
    }

    public double[] getWorkspace() {
        if (this.tmp == null) {
            this.tmp = new double[2 * this.number];
        }
        return this.tmp;
    }

    @Override
    public void push(ShapedVector inp) {
        if (!inp.belongsTo(this.inputSpace)) {
            throw new IncorrectSpaceException("Vector does not belong to input space");
        }
        this.push(((DoubleShapedVector)inp).getData());
    }

    public void push(double[] x) {
        double zero = 0.0;
        double[] z = this.getWorkspace();
        if (x == null || x.length != this.number) {
            throw new IllegalArgumentException("Bad input size");
        }
        int k = 0;
        while (k < this.number) {
            int real = k + k;
            int imag = real + 1;
            z[real] = x[k];
            z[imag] = 0.0;
            ++k;
        }
    }

    @Override
    public void pull(ShapedVector out) {
        if (!out.belongsTo(this.outputSpace)) {
            throw new IncorrectSpaceException("Vector does not belong to output space");
        }
        this.pull(((DoubleShapedVector)out).getData());
    }

    public abstract void pull(double[] var1);

    public abstract void forwardFFT(double[] var1);

    @Override
    public void forwardFFT() {
        this.forwardFFT(this.getWorkspace());
    }

    public abstract void backwardFFT(double[] var1);

    @Override
    public void backwardFFT() {
        this.forwardFFT(this.getWorkspace());
    }

    @Override
    public void convolve(boolean conj) {
        if (this.mtf == null) {
            throw new IllegalArgumentException("You must set the PSF or the MTF first");
        }
        double[] h = this.mtf;
        double[] z = this.getWorkspace();
        this.forwardFFT();
        if (conj) {
            int k = 0;
            while (k < this.number) {
                int real = k + k;
                int imag = real + 1;
                double h_re = h[real];
                double h_im = h[imag];
                double z_re = z[real];
                double z_im = z[imag];
                z[real] = h_re * z_re + h_im * z_im;
                z[imag] = h_re * z_im - h_im * z_re;
                ++k;
            }
        } else {
            int k = 0;
            while (k < this.number) {
                int real = k + k;
                int imag = real + 1;
                double h_re = h[real];
                double h_im = h[imag];
                double z_re = z[real];
                double z_im = z[imag];
                z[real] = h_re * z_re - h_im * z_im;
                z[imag] = h_re * z_im + h_im * z_re;
                ++k;
            }
        }
        this.backwardFFT(z);
    }

    @Override
    public void setPSF(ShapedVector psf) {
        if (!psf.belongsTo(this.inputSpace)) {
            throw new IncorrectSpaceException("PSF does not belong to the correct space");
        }
        this.computeMTF(((DoubleShapedVector)psf).getData());
    }

    @Override
    public void setPSF(ShapedArray psf, int[] cen) {
        psf = this.adjustPSF(psf.toDouble(), cen);
        this.computeMTF(((DoubleArray)psf).flatten());
    }

    private final void computeMTF(double[] psf) {
        double zero = 0.0;
        if (this.mtf == null) {
            this.mtf = new double[2 * this.number];
        }
        int k = 0;
        while (k < this.number) {
            int real = k + k;
            int imag = real + 1;
            this.mtf[real] = psf[k];
            this.mtf[imag] = 0.0;
            ++k;
        }
        this.forwardFFT(this.mtf);
    }
}

