/*
 * Decompiled with CFR 0.152.
 */
package plugins.mitiv.deconv;

import icy.gui.frame.progress.AnnounceFrame;
import icy.image.IcyBufferedImage;
import icy.sequence.MetaDataUtil;
import icy.sequence.Sequence;
import icy.util.OMEUtil;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import javax.swing.SwingUtilities;
import loci.common.services.ServiceException;
import loci.formats.meta.MetadataRetrieve;
import loci.formats.ome.OMEXMLMetadata;
import loci.formats.ome.OMEXMLMetadataImpl;
import mitiv.array.ArrayUtils;
import mitiv.array.Double1D;
import mitiv.array.Double2D;
import mitiv.array.Double3D;
import mitiv.array.DoubleArray;
import mitiv.array.ShapedArray;
import mitiv.base.Shape;
import mitiv.invpb.ReconstructionJob;
import mitiv.invpb.ReconstructionViewer;
import mitiv.linalg.WeightGenerator;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.DoubleShapedVectorSpace;
import mitiv.microscopy.PSF_Estimation;
import mitiv.microscopy.WideFieldModel;
import mitiv.utils.FFTUtils;
import mitiv.utils.MathUtils;
import mitiv.utils.reconstruction.ReconstructionThread;
import mitiv.utils.reconstruction.ReconstructionThreadToken;
import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.ezplug.EzButton;
import plugins.adufour.ezplug.EzComponent;
import plugins.adufour.ezplug.EzGroup;
import plugins.adufour.ezplug.EzLabel;
import plugins.adufour.ezplug.EzPanel;
import plugins.adufour.ezplug.EzPlug;
import plugins.adufour.ezplug.EzStoppable;
import plugins.adufour.ezplug.EzTabs;
import plugins.adufour.ezplug.EzVar;
import plugins.adufour.ezplug.EzVarBoolean;
import plugins.adufour.ezplug.EzVarChannel;
import plugins.adufour.ezplug.EzVarDouble;
import plugins.adufour.ezplug.EzVarInteger;
import plugins.adufour.ezplug.EzVarListener;
import plugins.adufour.ezplug.EzVarSequence;
import plugins.adufour.ezplug.EzVarText;
import plugins.adufour.vars.lang.Var;
import plugins.mitiv.io.IcyBufferedImageUtils;
import plugins.mitiv.myEzPlug.MyMetadata;
import plugins.mitiv.reconstruction.TotalVariationJobForIcy;

public class MitivBlindDeconvolution
extends EzPlug
implements EzStoppable,
Block {
    private EzVarDouble dxy_nm;
    private EzVarDouble dz_nm;
    private EzVarDouble na;
    private EzVarDouble lambda;
    private EzVarDouble ni;
    private EzVarInteger nbIteration;
    private EzVarInteger bDecTotalIteration;
    private EzVarInteger DefocusMaxIter;
    private EzVarInteger PhaseMaxIter;
    private EzVarInteger ModulusMaxIter;
    private EzVarInteger paddingSizeXY;
    private EzVarInteger paddingSizeZ;
    private WideFieldModel pupil = null;
    private EzVarDouble mu;
    private EzVarDouble epsilon;
    private EzVarDouble gain;
    private EzVarDouble noise;
    private EzVarSequence image;
    private EzVarSequence restart;
    private EzVarSequence weights;
    private EzVarSequence deadPixel;
    private EzVarSequence outputHeadlessImage;
    private EzVarSequence outputHeadlessPSF;
    private EzVarText weightsMethod;
    private EzVarText nbAlphaCoef;
    private EzVarText nbBetaCoef;
    private EzVarChannel canalImage;
    private EzVarBoolean deadPixGiven;
    private EzVarBoolean positivity;
    private EzVarBoolean radial;
    private final String[] weightOptions = new String[]{"None", "Inverse covariance map", "Variance map", "Computed variance"};
    private final String[] nAlphaOptions = new String[]{"0", "1", "3", "7", "8", "12", "18", "19", "25", "33", "34", "42", "52", "53", "63", "75", "76", "88", "102", "103"};
    private final String[] nBetaOptions = new String[]{"0", "3", "4", "6", "10", "11", "15", "21", "22", "28", "36", "37", "45", "55", "56", "66", "78", "79", "91", "105", "106"};
    private final String[] nAlphaOptionsR = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9"};
    private final String[] nBetaOptionsR = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9"};
    private MyMetadata meta = null;
    private EzButton saveMetaData;
    private EzButton showPSF;
    private EzButton psfShow2;
    private EzButton showWeight;
    private EzButton showModulus;
    private EzButton showPhase;
    private EzButton startDec;
    private EzButton startBlind;
    private EzButton stopDec;
    private EzButton stopBlind;
    private EzButton cropResult;
    private EzButton resetPSF;
    private EzVarText imageSize;
    private EzVarText outputSize;
    private EzVarText resultCostPrior;
    private EzVarText resultDefocus;
    private EzVarText resultPhase;
    private EzVarText resultModulus;
    private EzLabel docDec;
    private EzLabel docBlind;
    private EzPanel imageGlob;
    private EzPanel varianceGlob;
    private EzPanel deconvGlob;
    private EzPanel bdecGlob;
    private EzPanel resultGlob;
    private EzTabs tabbedPane;
    private double grtol = 0.0;
    private int nbAlpha = 0;
    private int nbBeta = 1;
    private int sizeX = 512;
    private int sizeY = 512;
    private int sizeZ = 128;
    private Shape imageShape;
    private int Nxy = 512;
    private int Nz = 128;
    private Shape outputShape;
    private boolean guessPhase;
    DoubleShapedVectorSpace defocuSpace = null;
    DoubleShapedVectorSpace alphaSpace = null;
    DoubleShapedVectorSpace betaSpace = null;
    DoubleShapedVector defocusVector = null;
    DoubleShapedVector alphaVector = null;
    DoubleShapedVector betaVector = null;
    boolean run = true;
    boolean runBdec;
    private ReconstructionThreadToken token;
    ReconstructionThread thread;
    private boolean debug = false;
    private boolean verbose = false;
    TotalVariationJobForIcy tvDec;
    PSF_Estimation PSFEstimation;
    Sequence sequence;
    private boolean guessModulus;
    Sequence lastSequence;

    private static void throwError(String s) {
        new AnnounceFrame(s);
    }

    public void clean() {
        if (this.token != null) {
            this.token.stop();
            this.token.exit();
        }
    }

    protected void updateOutputSize() {
        String text = String.valueOf(this.Nxy) + "x" + this.Nxy + "x" + this.Nz;
        this.outputSize.setValue((Object)text);
    }

    protected void updateImageSize() {
        String text = String.valueOf(this.sizeX) + "x" + this.sizeY + "x" + this.sizeZ;
        this.imageSize.setValue((Object)text);
    }

    protected void updatePaddedSize() {
        int sizeXY = Math.max(this.sizeX, this.sizeY);
        this.Nxy = FFTUtils.bestDimension(sizeXY + (Integer)this.paddingSizeXY.getValue());
        this.Nz = FFTUtils.bestDimension(this.sizeZ + (Integer)this.paddingSizeZ.getValue());
        this.outputShape = Shape.make(this.Nxy, this.Nxy, this.Nz);
    }

    private void setDefaultValue() {
        this.weightsMethod.setValue((Object)this.weightOptions[3]);
        this.radial.setValue((Object)false);
        if (this.debug) {
            this.resultCostPrior.setValue((Object)"No results yet");
            this.resultDefocus.setValue((Object)"No results yet");
            this.resultModulus.setValue((Object)"No results yet");
            this.resultPhase.setValue((Object)"No results yet");
        }
        if (!this.isHeadLess()) {
            this.outputSize.setEnabled(false);
            this.imageSize.setEnabled(false);
            if (this.debug) {
                this.resultCostPrior.setEnabled(false);
                this.resultDefocus.setEnabled(false);
                this.resultModulus.setEnabled(false);
                this.resultPhase.setEnabled(false);
            }
        }
    }

    protected void initialize() {
        if (!this.isHeadLess()) {
            this.getUI().setParametersIOVisible(false);
            this.getUI().setActionPanelVisible(false);
        }
        this.tabbedPane = new EzTabs("BlindTabs", EzTabs.TabPlacement.TOP);
        this.imageGlob = new EzPanel("FILE", new EzComponent[0]);
        EzPanel imagePan = new EzPanel("FILEPanel", new EzComponent[0]);
        this.image = new EzVarSequence("Sequence:");
        this.canalImage = new EzVarChannel("Canal:", (Var)this.image.getVariable(), true);
        this.imageSize = new EzVarText("Image size:");
        this.outputSize = new EzVarText("Output size:");
        this.paddingSizeXY = new EzVarInteger("padding xy:", 0, Integer.MAX_VALUE, 1);
        this.paddingSizeZ = new EzVarInteger("padding z :", 0, Integer.MAX_VALUE, 1);
        this.saveMetaData = new EzButton("Save metadata", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MitivBlindDeconvolution.this.debug) {
                    System.out.println("Saving metadata");
                    MitivBlindDeconvolution.this.updateMetaData();
                }
            }
        });
        this.updatePaddedSize();
        this.updateOutputSize();
        this.updateImageSize();
        EzVarListener<Integer> zeroPadActionListener = new EzVarListener<Integer>(){

            public void variableChanged(EzVar<Integer> source, Integer newValue) {
                MitivBlindDeconvolution.this.updatePaddedSize();
                MitivBlindDeconvolution.this.updateImageSize();
                MitivBlindDeconvolution.this.updateOutputSize();
                MitivBlindDeconvolution.this.resetPSF();
            }
        };
        this.paddingSizeXY.addVarChangeListener((EzVarListener)zeroPadActionListener);
        this.paddingSizeZ.addVarChangeListener((EzVarListener)zeroPadActionListener);
        this.image.addVarChangeListener((EzVarListener)new EzVarListener<Sequence>(){

            public void variableChanged(EzVar<Sequence> source, Sequence newValue) {
                Sequence seq;
                if (MitivBlindDeconvolution.this.debug) {
                    System.out.println("Seq ch..." + MitivBlindDeconvolution.this.image.getValue());
                }
                if ((seq = (Sequence)MitivBlindDeconvolution.this.image.getValue()) != null) {
                    MitivBlindDeconvolution.this.meta = MitivBlindDeconvolution.this.getMetaData(seq);
                    MitivBlindDeconvolution.this.sizeX = seq.getSizeX();
                    MitivBlindDeconvolution.this.sizeY = seq.getSizeY();
                    MitivBlindDeconvolution.this.sizeZ = seq.getSizeZ();
                    MitivBlindDeconvolution.this.dxy_nm.setValue((Object)((MitivBlindDeconvolution)MitivBlindDeconvolution.this).meta.dxy);
                    MitivBlindDeconvolution.this.dz_nm.setValue((Object)((MitivBlindDeconvolution)MitivBlindDeconvolution.this).meta.dz);
                    MitivBlindDeconvolution.this.na.setValue((Object)((MitivBlindDeconvolution)MitivBlindDeconvolution.this).meta.na);
                    MitivBlindDeconvolution.this.lambda.setValue((Object)((MitivBlindDeconvolution)MitivBlindDeconvolution.this).meta.lambda);
                    MitivBlindDeconvolution.this.ni.setValue((Object)((MitivBlindDeconvolution)MitivBlindDeconvolution.this).meta.ni);
                    MitivBlindDeconvolution.this.updatePaddedSize();
                    MitivBlindDeconvolution.this.updateOutputSize();
                    MitivBlindDeconvolution.this.updateImageSize();
                    MitivBlindDeconvolution.this.imageShape = Shape.make(MitivBlindDeconvolution.this.sizeX, MitivBlindDeconvolution.this.sizeY, MitivBlindDeconvolution.this.sizeZ);
                    if (MitivBlindDeconvolution.this.debug) {
                        System.out.println("Seq changed:" + MitivBlindDeconvolution.this.sizeX + "  " + MitivBlindDeconvolution.this.Nxy);
                    }
                    MitivBlindDeconvolution.this.restart.setValue(newValue);
                }
            }
        });
        this.image.setNoSequenceSelection();
        EzVarListener<Double> metaActionListener = new EzVarListener<Double>(){

            public void variableChanged(EzVar<Double> source, Double newValue) {
                Sequence seq = (Sequence)MitivBlindDeconvolution.this.image.getValue();
                if (seq != null) {
                    MitivBlindDeconvolution.this.setMetaData(seq);
                }
                MitivBlindDeconvolution.this.resetPSF();
            }
        };
        this.dxy_nm = new EzVarDouble("dxy(nm):", 64.5, 0.0, Double.MAX_VALUE, 1.0);
        this.dxy_nm.addVarChangeListener((EzVarListener)metaActionListener);
        this.dz_nm = new EzVarDouble("dz(nm):", 128.0, 0.0, Double.MAX_VALUE, 1.0);
        this.dz_nm.addVarChangeListener((EzVarListener)metaActionListener);
        this.na = new EzVarDouble("NA:", 1.4, 0.0, Double.MAX_VALUE, 0.05);
        this.na.addVarChangeListener((EzVarListener)metaActionListener);
        this.ni = new EzVarDouble("ni:", 1.518, 1.0, 2.0, 0.01);
        this.ni.addVarChangeListener((EzVarListener)metaActionListener);
        this.lambda = new EzVarDouble("\u03bb(nm):", 542.0, 10.0, 15000.0, 10.0);
        this.lambda.addVarChangeListener((EzVarListener)metaActionListener);
        this.showPSF = new EzButton("Show PSF", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MitivBlindDeconvolution.this.psfClicked();
                if (MitivBlindDeconvolution.this.debug) {
                    System.out.println("Showing PSF Button");
                }
            }
        });
        this.varianceGlob = new EzPanel("Variance", new EzComponent[0]);
        EzPanel varianceTab = new EzPanel("VarianceTab", new EzComponent[0]);
        this.weightsMethod = new EzVarText("Weighting:", this.weightOptions, Boolean.valueOf(false));
        this.weights = new EzVarSequence("Map:");
        this.gain = new EzVarDouble("Gain:", 1.0, 0.01, Double.MAX_VALUE, 0.01);
        this.noise = new EzVarDouble("Readout Noise:", 3.0, 0.0, Double.MAX_VALUE, 0.1);
        this.deadPixGiven = new EzVarBoolean("Data Map?", false);
        this.deadPixel = new EzVarSequence("Map:");
        this.weightsMethod.addVarChangeListener((EzVarListener)new EzVarListener<String>(){

            public void variableChanged(EzVar<String> source, String newValue) {
                if (MitivBlindDeconvolution.this.weightsMethod.getValue() == MitivBlindDeconvolution.this.weightOptions[0]) {
                    MitivBlindDeconvolution.this.weights.setVisible(false);
                    MitivBlindDeconvolution.this.gain.setVisible(false);
                    MitivBlindDeconvolution.this.noise.setVisible(false);
                } else if (MitivBlindDeconvolution.this.weightsMethod.getValue() == MitivBlindDeconvolution.this.weightOptions[1] || MitivBlindDeconvolution.this.weightsMethod.getValue() == MitivBlindDeconvolution.this.weightOptions[2]) {
                    MitivBlindDeconvolution.this.weights.setVisible(true);
                    MitivBlindDeconvolution.this.gain.setVisible(false);
                    MitivBlindDeconvolution.this.noise.setVisible(false);
                } else if (MitivBlindDeconvolution.this.weightsMethod.getValue() == MitivBlindDeconvolution.this.weightOptions[3]) {
                    MitivBlindDeconvolution.this.weights.setVisible(false);
                    MitivBlindDeconvolution.this.gain.setVisible(true);
                    MitivBlindDeconvolution.this.noise.setVisible(true);
                } else {
                    MitivBlindDeconvolution.throwError("Invalid argument passed to weight method");
                    return;
                }
            }
        });
        this.deadPixGiven.addVarChangeListener((EzVarListener)new EzVarListener<Boolean>(){

            public void variableChanged(EzVar<Boolean> source, Boolean newValue) {
                MitivBlindDeconvolution.this.deadPixel.setVisible(((Boolean)MitivBlindDeconvolution.this.deadPixGiven.getValue()).booleanValue());
            }
        });
        this.weights.setVisible(false);
        this.gain.setVisible(false);
        this.noise.setVisible(false);
        this.deadPixel.setVisible(false);
        this.showWeight = new EzButton("Show weight map", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MitivBlindDeconvolution.this.showWeightClicked();
                if (MitivBlindDeconvolution.this.debug) {
                    System.out.println("Weight compute");
                }
            }
        });
        this.deconvGlob = new EzPanel("Deconvolution", new EzComponent[0]);
        EzPanel deconvTab = new EzPanel("DeconvolutionTab", new EzComponent[0]);
        this.mu = new EzVarDouble("Regularization level:", 0.01, 0.0, Double.MAX_VALUE, 0.01);
        this.epsilon = new EzVarDouble("Threshold level:", 0.01, 0.0, Double.MAX_VALUE, 0.01);
        this.nbIteration = new EzVarInteger("Number of iterations: ");
        this.positivity = new EzVarBoolean("Enforce nonnegativity:", true);
        this.restart = new EzVarSequence("Starting point:");
        this.docDec = new EzLabel("Launch a deconvolution by using a psf (ifgiven) or creating a simple PSF from parameters from PSF tab", Color.red);
        this.startDec = new EzButton("Start Deconvolution", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Thread workerThread = new Thread(){

                    @Override
                    public void run() {
                        MitivBlindDeconvolution.this.launch(true);
                    }
                };
                workerThread.start();
            }
        });
        this.restart.setNoSequenceSelection();
        this.stopDec = new EzButton("STOP Computation", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MitivBlindDeconvolution.this.stopExecution();
            }
        });
        EzGroup groupStop1 = new EzGroup("Emergency STOP", new EzComponent[]{this.stopDec});
        this.bdecGlob = new EzPanel("BDec", new EzComponent[0]);
        EzPanel bdecTab = new EzPanel("BDecTab", new EzComponent[0]);
        this.nbAlphaCoef = new EzVarText("Number of phase coefs N\u03b1:", this.nAlphaOptions, Boolean.valueOf(false));
        this.nbBetaCoef = new EzVarText("Number of modulus coefs N\u03b2:", this.nBetaOptions, Boolean.valueOf(false));
        this.radial = new EzVarBoolean("Radially symmetric PSF", false);
        this.DefocusMaxIter = new EzVarInteger("Max. nb. of iterations for defocus:");
        this.PhaseMaxIter = new EzVarInteger("Max. nb. of iterations for phase:");
        this.ModulusMaxIter = new EzVarInteger("Max. nb. of iterations for modulus:");
        this.bDecTotalIteration = new EzVarInteger("Number of loops:");
        this.resetPSF = new EzButton("Reset PSF", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MitivBlindDeconvolution.this.resetPSF();
            }
        });
        this.radial.addVarChangeListener((EzVarListener)new EzVarListener<Boolean>(){

            public void variableChanged(EzVar<Boolean> source, Boolean newValue) {
                MitivBlindDeconvolution.this.nbAlphaCoef.setDefaultValues((Object[])MitivBlindDeconvolution.this.nAlphaOptionsR, 1, false);
                MitivBlindDeconvolution.this.nbBetaCoef.setDefaultValues((Object[])MitivBlindDeconvolution.this.nBetaOptionsR, 1, false);
                MitivBlindDeconvolution.this.resetPSF();
            }
        });
        this.psfShow2 = new EzButton("Show PSF", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MitivBlindDeconvolution.this.psfClicked();
                if (MitivBlindDeconvolution.this.debug) {
                    System.out.println("First PSF compute");
                }
            }
        });
        this.showPhase = new EzButton("Show phase of the pupil", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MitivBlindDeconvolution.this.phaseClicked();
                if (MitivBlindDeconvolution.this.debug) {
                    System.out.println("Show phase");
                }
            }
        });
        this.showModulus = new EzButton("Show modulus of the pupil", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MitivBlindDeconvolution.this.modulusClicked();
                if (MitivBlindDeconvolution.this.debug) {
                    System.out.println("Show modulus");
                }
            }
        });
        this.docBlind = new EzLabel("BlindDeconvolution use the parameters from previous tab to compute the PSF", Color.RED);
        this.startBlind = new EzButton("Guess PSF", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Thread workerThread = new Thread(){

                    @Override
                    public void run() {
                        MitivBlindDeconvolution.this.launch(false);
                    }
                };
                workerThread.start();
            }
        });
        EzGroup show = new EzGroup("Visualization", new EzComponent[]{this.psfShow2, this.showPhase, this.showModulus});
        this.stopBlind = new EzButton("STOP Computation", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MitivBlindDeconvolution.this.stopExecution();
            }
        });
        EzGroup groupStop2 = new EzGroup("Emergency STOP", new EzComponent[]{this.stopBlind});
        this.cropResult = new EzButton("Show deconvolved image with the size of the input", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ShapedArray prevResult;
                if (MitivBlindDeconvolution.this.tvDec != null && (prevResult = MitivBlindDeconvolution.this.tvDec.getResult()) != null) {
                    Sequence croppedResult = new Sequence("Cropped Result");
                    ShapedArray croppedArray = ArrayUtils.crop(prevResult, MitivBlindDeconvolution.this.imageShape);
                    double[] in = croppedArray.toDouble().flatten();
                    int j = 0;
                    while (j < MitivBlindDeconvolution.this.sizeZ) {
                        double[] temp = new double[MitivBlindDeconvolution.this.sizeX * MitivBlindDeconvolution.this.sizeY];
                        int i = 0;
                        while (i < MitivBlindDeconvolution.this.sizeX * MitivBlindDeconvolution.this.sizeY) {
                            temp[i] = in[i + j * MitivBlindDeconvolution.this.sizeX * MitivBlindDeconvolution.this.sizeY];
                            ++i;
                        }
                        croppedResult.setImage(0, j, (BufferedImage)new IcyBufferedImage(MitivBlindDeconvolution.this.sizeX, MitivBlindDeconvolution.this.sizeY, (Object)temp));
                        ++j;
                    }
                    MitivBlindDeconvolution.this.addSequence(croppedResult);
                }
            }
        });
        this.resultGlob = new EzPanel("Results", new EzComponent[0]);
        EzPanel resultTab = new EzPanel("ResultsTab", new EzComponent[0]);
        this.resultCostPrior = new EzVarText("Costs");
        this.resultDefocus = new EzVarText("Defocus");
        this.resultModulus = new EzVarText("Modulus");
        this.resultPhase = new EzVarText("Phase");
        this.image.setToolTipText("The image on which we will work");
        this.weights.setToolTipText("The weight map to possibly ignore or minize errors in the image");
        this.weightsMethod.setToolTipText("The weight map to possibly ignore or minize errors in the image");
        this.deadPixel.setToolTipText("The binary pixel map representing the pixels that we should ignore");
        this.canalImage.setToolTipText("Choose the image canal to use for the deconvolution");
        this.dxy_nm.setToolTipText("Lateral pixel size (nm)");
        this.dz_nm.setToolTipText("Axial pixel size (nm)");
        this.na.setToolTipText("Numerical Aperture");
        this.lambda.setToolTipText("Wavelength (nm)");
        this.ni.setToolTipText("Refractive index of the immersion medium");
        this.gain.setToolTipText("The gain in e-/level");
        this.noise.setToolTipText("The readout noise i.e the RMS in e-/pixel");
        this.mu.setToolTipText("Mu");
        this.epsilon.setToolTipText("Epsilon");
        this.nbIteration.setToolTipText("Maximum number of iterations, -1 for no limits");
        this.paddingSizeXY.setToolTipText("Add X zero lines around the image");
        this.paddingSizeZ.setToolTipText("Add X zero lines around the image");
        this.nbAlphaCoef.setToolTipText("Number of zernike describing the pupil phase");
        this.nbBetaCoef.setToolTipText("Number of zernike describing the pupil modulus");
        this.bDecTotalIteration.setToolTipText("The maximum number of loop the algorithm is allowed to do, the higher the potentially longer");
        this.restart.setToolTipText("Restart from previous result, if enabled will start with last image and PSF");
        this.positivity.setToolTipText("Limit the negatives values while computing the solution");
        this.cropResult.setToolTipText("<html><pre>To ensure that the output will be of the same size as the input.<br/><font color=\"red\">WARNING:</font> Enabling this option may alter restarting with previous result. <br/></pre></html>");
        resultTab.setToolTipText("The output size as the nearest power of 2 size");
        imagePan.add(new EzComponent[]{this.image});
        imagePan.add(new EzComponent[]{this.canalImage});
        imagePan.add(new EzComponent[]{this.imageSize});
        imagePan.add(new EzComponent[]{this.paddingSizeXY});
        imagePan.add(new EzComponent[]{this.paddingSizeZ});
        imagePan.add(new EzComponent[]{this.outputSize});
        imagePan.add(new EzComponent[]{this.dxy_nm});
        imagePan.add(new EzComponent[]{this.dz_nm});
        imagePan.add(new EzComponent[]{this.na});
        imagePan.add(new EzComponent[]{this.ni});
        imagePan.add(new EzComponent[]{this.lambda});
        imagePan.add(new EzComponent[]{this.saveMetaData});
        imagePan.add(new EzComponent[]{this.showPSF});
        this.imageGlob.add(new EzComponent[]{imagePan});
        this.tabbedPane.add(new EzComponent[]{this.imageGlob});
        varianceTab.add(new EzComponent[]{this.weightsMethod});
        varianceTab.add(new EzComponent[]{this.weights});
        varianceTab.add(new EzComponent[]{this.gain});
        varianceTab.add(new EzComponent[]{this.noise});
        varianceTab.add(new EzComponent[]{this.deadPixGiven});
        varianceTab.add(new EzComponent[]{this.deadPixel});
        varianceTab.add(new EzComponent[]{this.showWeight});
        this.varianceGlob.add(new EzComponent[]{varianceTab});
        this.tabbedPane.add(new EzComponent[]{this.varianceGlob});
        deconvTab.add(new EzComponent[]{this.mu});
        deconvTab.add(new EzComponent[]{this.epsilon});
        deconvTab.add(new EzComponent[]{this.nbIteration});
        deconvTab.add(new EzComponent[]{this.positivity});
        deconvTab.add(new EzComponent[]{this.restart});
        deconvTab.add(new EzComponent[]{this.docDec});
        deconvTab.add(new EzComponent[]{this.startDec});
        deconvTab.add(new EzComponent[]{groupStop1});
        this.deconvGlob.add(new EzComponent[]{deconvTab});
        this.tabbedPane.add(new EzComponent[]{this.deconvGlob});
        bdecTab.add(new EzComponent[]{this.resetPSF});
        bdecTab.add(new EzComponent[]{this.nbAlphaCoef});
        bdecTab.add(new EzComponent[]{this.nbBetaCoef});
        bdecTab.add(new EzComponent[]{this.radial});
        bdecTab.add(new EzComponent[]{this.DefocusMaxIter});
        bdecTab.add(new EzComponent[]{this.PhaseMaxIter});
        bdecTab.add(new EzComponent[]{this.ModulusMaxIter});
        bdecTab.add(new EzComponent[]{this.bDecTotalIteration});
        bdecTab.add(new EzComponent[]{this.docBlind});
        bdecTab.add(new EzComponent[]{this.startBlind});
        bdecTab.add(new EzComponent[]{show});
        bdecTab.add(new EzComponent[]{this.cropResult});
        bdecTab.add(new EzComponent[]{groupStop2});
        this.bdecGlob.add(new EzComponent[]{bdecTab});
        this.tabbedPane.add(new EzComponent[]{this.bdecGlob});
        if (this.debug) {
            resultTab.add(new EzComponent[]{this.resultCostPrior});
            resultTab.add(new EzComponent[]{this.resultDefocus});
            resultTab.add(new EzComponent[]{this.resultModulus});
            resultTab.add(new EzComponent[]{this.resultPhase});
            this.resultGlob.add(new EzComponent[]{resultTab});
            this.tabbedPane.add(new EzComponent[]{this.resultGlob});
        }
        this.addEzComponent((EzComponent)this.tabbedPane);
        show.setFoldedState(true);
        this.setDefaultValue();
        if (this.isHeadLess()) {
            this.outputHeadlessImage = new EzVarSequence("Output Image");
            this.outputHeadlessPSF = new EzVarSequence("Output PSF");
        }
        this.token = new ReconstructionThreadToken(new double[]{(Double)this.mu.getValue(), (Double)this.epsilon.getValue(), 0.0, this.grtol});
        this.thread = new ReconstructionThread(this.token);
        this.thread.start();
    }

    protected void resetPSF() {
        this.defocuSpace = null;
        this.defocusVector = null;
        this.alphaSpace = null;
        this.alphaVector = null;
        this.betaSpace = null;
        this.betaVector = null;
        this.buildpupil();
    }

    public boolean launchDeconvolution(DoubleArray imgArray, DoubleArray psfArray, DoubleArray weight) {
        return this.launchDeconvolution(imgArray, psfArray, weight, true, false);
    }

    public boolean launchDeconvolution(DoubleArray imgArray, DoubleArray psfArray, DoubleArray weight, boolean cleanPrevResult, boolean ignoreRestart) {
        if (this.tvDec == null) {
            this.tvDec = new TotalVariationJobForIcy(this.token);
            this.tvDec.setResult(null);
        }
        this.tvDec.setAbsoluteTolerance(0.0);
        this.tvDec.setWeight(weight);
        this.tvDec.setData(imgArray);
        this.tvDec.setPsf(psfArray);
        this.tvDec.setViewer(new TvViewer());
        this.thread.setJob(this.tvDec);
        if (!ignoreRestart && this.restart.getValue() != null) {
            Sequence restartSeq = (Sequence)this.restart.getValue();
            if (restartSeq != null) {
                boolean sameAsPrevious;
                int numCanal = (Integer)this.canalImage.getValue();
                ShapedArray tmpDoubleArray = IcyBufferedImageUtils.imageToArray(restartSeq, numCanal);
                boolean sameAsOrigin = tmpDoubleArray.getRank() == 3 && tmpDoubleArray.getDimension(0) == this.sizeX && tmpDoubleArray.getDimension(1) == this.sizeY && tmpDoubleArray.getDimension(2) == this.sizeZ;
                boolean bl = sameAsPrevious = tmpDoubleArray.getRank() == 3 && tmpDoubleArray.getDimension(0) == this.Nxy && tmpDoubleArray.getDimension(1) == this.Nxy && tmpDoubleArray.getDimension(2) == this.Nz;
                if (!sameAsOrigin && !sameAsPrevious) {
                    MitivBlindDeconvolution.throwError("The previous result does not have the same dimensions as the input image");
                    return false;
                }
                tmpDoubleArray = ArrayUtils.pad(tmpDoubleArray, this.outputShape);
                this.tvDec.setResult(tmpDoubleArray);
            }
        } else if (cleanPrevResult) {
            this.tvDec.setResult(null);
        } else {
            this.tvDec.setResult(this.tvDec.getResult());
        }
        this.tvDec.setPositivity((Boolean)this.positivity.getValue());
        this.tvDec.setRegularizationWeight((Double)this.mu.getValue());
        this.tvDec.setRegularizationThreshold((Double)this.epsilon.getValue());
        this.tvDec.setRelativeTolerance(this.grtol);
        this.tvDec.setMaximumIterations((Integer)this.nbIteration.getValue());
        this.tvDec.setOutputShape(this.outputShape);
        this.token.start();
        this.setResult(this.tvDec);
        return true;
    }

    protected void execute() {
        this.launch(false);
    }

    protected void launch(boolean runDeconv) {
        block27: {
            try {
                if (this.debug) {
                    System.out.println("-------------IMAGE-------------------");
                    System.out.println("File: " + this.image.getValue());
                    System.out.println("Canal: " + this.canalImage.getValue());
                    System.out.println("--------------PSF------------------");
                    System.out.println("dxy: " + (Double)this.dxy_nm.getValue() * 1.0E-9);
                    System.out.println("dz: " + (Double)this.dz_nm.getValue() * 1.0E-9);
                    System.out.println("Nxy: " + this.Nxy);
                    System.out.println("Nx: " + this.Nz);
                    System.out.println("NA: " + this.na.getValue());
                    System.out.println("\u03bb: " + (Double)this.lambda.getValue() * 1.0E-9);
                    System.out.println("ni: " + this.ni.getValue());
                    System.out.println("--------------Variance------------------");
                    System.out.println("Weights: " + this.weights.getValue());
                    System.out.println("Gain: " + this.gain.getValue());
                    System.out.println("Noise: " + this.noise.getValue());
                    System.out.println("deadPix: " + this.deadPixel.getValue());
                    System.out.println("--------------DECONV------------------");
                    System.out.println("zeroPad xy: " + this.paddingSizeXY.getValue());
                    System.out.println("zeroPad z: " + this.paddingSizeZ.getValue());
                    System.out.println("nbIter: " + this.nbIteration.getValue());
                    System.out.println("Restart: " + this.restart.getValue());
                    System.out.println("Positivity: " + this.positivity.getValue());
                    System.out.println("--------------BDEC------------------");
                    System.out.println("nbIter: " + this.nbIteration.getValue());
                    System.out.println("zeroPad: " + this.paddingSizeXY.getValue());
                    System.out.println("Number of total iterations: " + this.bDecTotalIteration.getValue());
                    System.out.println("------------------------------------");
                    System.out.println("");
                }
                this.run = true;
                Sequence imgSeq = (Sequence)this.image.getValue();
                if (imgSeq == null) {
                    MitivBlindDeconvolution.throwError("An image/sequence of images should be given");
                    return;
                }
                if (this.sizeZ == 1) {
                    MitivBlindDeconvolution.throwError("Input data must be 3D");
                    return;
                }
                if ((double)((Integer)this.paddingSizeXY.getValue()).intValue() < 0.0) {
                    MitivBlindDeconvolution.throwError("Padding value cannot be negative");
                    return;
                }
                if ((double)((Integer)this.paddingSizeZ.getValue()).intValue() < 0.0) {
                    MitivBlindDeconvolution.throwError("Padding value cannot be negative");
                    return;
                }
                int numCanal = (Integer)this.canalImage.getValue();
                boolean bl = this.runBdec = !runDeconv;
                if (this.pupil == null) {
                    this.buildpupil();
                }
                DoubleArray imgArray = (DoubleArray)IcyBufferedImageUtils.imageToArray(imgSeq, this.imageShape, numCanal);
                DoubleArray weight = this.createWeight(imgArray).toDouble();
                imgArray = (DoubleArray)ArrayUtils.pad(imgArray, this.outputShape);
                weight = (DoubleArray)ArrayUtils.pad(weight, this.outputShape);
                if (this.runBdec) {
                    if (this.alphaVector == null || Integer.parseInt((String)this.nbAlphaCoef.getValue()) != this.nbAlpha) {
                        this.nbAlpha = Integer.parseInt((String)this.nbAlphaCoef.getValue());
                        if (this.nbAlpha == 0) {
                            this.guessPhase = false;
                        } else {
                            this.guessPhase = true;
                            this.alphaSpace = new DoubleShapedVectorSpace(new int[]{this.nbAlpha});
                            this.alphaVector = this.alphaSpace.create();
                        }
                    }
                    if (this.betaVector == null || Integer.parseInt((String)this.nbBetaCoef.getValue()) != this.nbBeta) {
                        this.nbBeta = Integer.parseInt((String)this.nbBetaCoef.getValue());
                        if (this.nbBeta == 0) {
                            this.guessModulus = false;
                        } else {
                            this.guessModulus = true;
                            double[] beta = new double[this.nbBeta];
                            beta[0] = 1.0;
                            this.betaSpace = new DoubleShapedVectorSpace(new int[]{beta.length});
                            this.betaVector = this.betaSpace.wrap(beta);
                        }
                    }
                    if (this.defocuSpace == null) {
                        double[] defocus = new double[]{(Double)this.ni.getValue() / ((Double)this.lambda.getValue() * 1.0E-9), 0.0, 0.0};
                        this.defocuSpace = new DoubleShapedVectorSpace(new int[]{defocus.length});
                        this.defocusVector = this.defocuSpace.wrap(defocus);
                    }
                    this.PSFEstimation = new PSF_Estimation(this.pupil);
                    this.PSFEstimation.setWeight(weight);
                    this.PSFEstimation.setData(imgArray);
                    this.PSFEstimation.enablePositivity(false);
                    this.PSFEstimation.setAbsoluteTolerance(0.0);
                    int i = 0;
                    while (i < (Integer)this.bDecTotalIteration.getValue()) {
                        DoubleArray psfArray = (DoubleArray)ArrayUtils.roll(Double3D.wrap(this.pupil.getPSF(), this.outputShape));
                        if (!this.launchDeconvolution(imgArray, psfArray, weight, false, i != 0)) {
                            return;
                        }
                        this.PSFEstimation.setObj(this.tvDec.getResult());
                        if ((Integer)this.DefocusMaxIter.getValue() > 0) {
                            if (this.debug && this.verbose) {
                                System.out.println("------------------");
                                System.out.println("Defocus estimation");
                                System.out.println("------------------");
                            }
                            this.PSFEstimation.setRelativeTolerance(0.0);
                            this.PSFEstimation.setMaximumIterations((Integer)this.DefocusMaxIter.getValue());
                            this.PSFEstimation.fitPSF(this.defocusVector, 1);
                            System.out.println("Defocus   " + Arrays.toString(this.PSFEstimation.getPupil().getDefocusMultiplyByLambda()));
                        }
                        if ((Integer)this.PhaseMaxIter.getValue() > 0 & this.guessPhase) {
                            if (this.debug && this.verbose) {
                                System.out.println("Phase estimation");
                                System.out.println("------------------");
                            }
                            this.PSFEstimation.setResult(null);
                            this.PSFEstimation.setMaximumIterations((Integer)this.PhaseMaxIter.getValue());
                            this.PSFEstimation.fitPSF(this.alphaVector, 2);
                        }
                        if ((Integer)this.ModulusMaxIter.getValue() > 0 & this.guessModulus) {
                            if (this.debug && this.verbose) {
                                System.out.println("Modulus estimation");
                                System.out.println("------------------");
                            }
                            this.PSFEstimation.setResult(null);
                            this.PSFEstimation.setMaximumIterations((Integer)this.ModulusMaxIter.getValue());
                            this.PSFEstimation.fitPSF(this.betaVector, 3);
                        }
                        if (this.debug) {
                            this.showResult(i);
                        }
                        if (!this.run) {
                            return;
                        }
                        ++i;
                    }
                    this.pupil = this.PSFEstimation.getPupil();
                } else {
                    DoubleArray psfArray = (DoubleArray)ArrayUtils.roll(Double3D.wrap(this.pupil.getPSF(), this.outputShape));
                    this.launchDeconvolution(imgArray, psfArray, weight);
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MitivBlindDeconvolution.this.restart.setValue(MitivBlindDeconvolution.this.lastSequence);
                    }
                });
                this.lastSequence = this.sequence;
                this.sequence = null;
            }
            catch (IllegalArgumentException e) {
                new AnnounceFrame("Oops, Error: " + e.getMessage());
                if (!this.debug) break block27;
                e.printStackTrace();
            }
        }
    }

    private ShapedArray createWeight(ShapedArray data) {
        Sequence tmp;
        WeightGenerator weightGen = new WeightGenerator();
        ShapedArray deadPixMap = null;
        if (((Boolean)this.deadPixGiven.getValue()).booleanValue() && (tmp = (Sequence)this.deadPixel.getValue()) != null) {
            deadPixMap = IcyBufferedImageUtils.imageToArray(tmp.getAllImage());
        }
        if (this.weightsMethod.getValue() == this.weightOptions[0]) {
            double[] weight = new double[this.sizeX * this.sizeY * this.sizeZ];
            int i = 0;
            while (i < weight.length) {
                weight[i] = 1.0;
                ++i;
            }
            weightGen.setWeightMap(Double1D.wrap(weight, weight.length));
        } else if (this.weightsMethod.getValue() == this.weightOptions[1]) {
            tmp = (Sequence)this.weights.getValue();
            if (tmp != null) {
                ShapedArray array = IcyBufferedImageUtils.imageToArray(tmp.getAllImage());
                weightGen.setWeightMap(array);
            }
        } else if (this.weightsMethod.getValue() == this.weightOptions[2]) {
            tmp = (Sequence)this.weights.getValue();
            if (tmp != null) {
                ShapedArray array = IcyBufferedImageUtils.imageToArray(tmp.getAllImage());
                weightGen.setVarianceMap(array);
            }
        } else if (this.weightsMethod.getValue() == this.weightOptions[3]) {
            weightGen.setComputedVariance(data, (Double)this.gain.getValue(), (Double)this.noise.getValue());
        }
        weightGen.setPixelMap(deadPixMap);
        return weightGen.getWeightMap(data.getShape()).toDouble();
    }

    private void setResult(ReconstructionJob tvDec) {
        try {
            if (this.sequence == null || this.sequence != null && this.sequence.isEmpty()) {
                this.sequence = new Sequence();
                this.setMetaData((Sequence)this.image.getValue(), this.sequence);
                if (this.isHeadLess()) {
                    this.outputHeadlessImage.setValue(this.sequence);
                } else {
                    this.addSequence(this.sequence);
                }
            }
            this.sequence.beginUpdate();
            double[] in = tvDec.getResult().toDouble().flatten();
            int j = 0;
            while (j < this.Nz) {
                double[] temp = new double[this.Nxy * this.Nxy];
                int i = 0;
                while (i < this.Nxy * this.Nxy) {
                    temp[i] = in[i + j * this.Nxy * this.Nxy];
                    ++i;
                }
                this.sequence.setImage(0, j, (BufferedImage)new IcyBufferedImage(this.Nxy, this.Nxy, (Object)temp));
                ++j;
            }
            this.sequence.endUpdate();
            this.sequence.setName("TV mu:" + this.mu.getValue() + " Iteration:" + tvDec.getIterations());
            System.out.println("Cost " + tvDec.getCost());
            if (this.runBdec && this.debug) {
                this.resultCostPrior.setValue((Object)("Cost " + tvDec.getCost()));
                this.resultDefocus.setValue((Object)("Defocus   " + Arrays.toString(this.pupil.getDefocusMultiplyByLambda())));
                this.resultModulus.setValue((Object)("Modulus    " + this.pupil.getRho()[0]));
                this.resultPhase.setValue((Object)("Phase      " + this.pupil.getPhi()[0]));
            }
        }
        catch (NullPointerException e) {
            System.out.println("INFO: Emergency stop detected in setResult");
            e.printStackTrace();
        }
    }

    private void showResult(int num) {
        Sequence psf3DSequence = new Sequence();
        Double3D psf = Double3D.wrap(this.pupil.getPSF(), this.outputShape);
        double[] PSF_shift = ArrayUtils.roll(psf).toDouble().flatten();
        psf3DSequence.setName("PSF Estimated - " + num);
        int k = 0;
        while (k < this.Nz) {
            psf3DSequence.setImage(0, k, (BufferedImage)new IcyBufferedImage(this.Nxy, this.Nxy, (Object)MathUtils.getArray(PSF_shift, this.Nxy, this.Nxy, k)));
            ++k;
        }
        if (this.isHeadLess()) {
            this.outputHeadlessPSF.setValue(psf3DSequence);
        } else {
            this.addSequence(psf3DSequence);
        }
    }

    private void buildpupil() {
        this.pupil = new WideFieldModel((Double)this.na.getValue(), (Double)this.lambda.getValue() * 1.0E-9, (Double)this.ni.getValue(), (Double)this.dxy_nm.getValue() * 1.0E-9, (Double)this.dz_nm.getValue() * 1.0E-9, this.Nxy, this.Nxy, this.Nz, (Boolean)this.radial.getValue());
    }

    private void psfClicked() {
        if (this.pupil == null) {
            this.buildpupil();
        }
        Sequence PSF0Sequence = new Sequence();
        Double3D psf = Double3D.wrap(this.pupil.getPSF(), this.outputShape);
        double[] PSF_shift = ArrayUtils.roll(psf).toDouble().flatten();
        int k = 0;
        while (k < this.Nz) {
            PSF0Sequence.setImage(0, k, (BufferedImage)new IcyBufferedImage(this.Nxy, this.Nxy, (Object)MathUtils.getArray(PSF_shift, this.Nxy, this.Nxy, k)));
            ++k;
        }
        this.setMetaData(PSF0Sequence);
        PSF0Sequence.setName("PSF");
        this.addSequence(PSF0Sequence);
    }

    private void phaseClicked() {
        if (this.pupil == null) {
            this.buildpupil();
        }
        Sequence phaseSequence = new Sequence();
        phaseSequence.setName("Phase of the pupil");
        Double2D psf = Double2D.wrap(this.pupil.getPhi(), Shape.make(this.Nxy, this.Nxy));
        double[] phase_shift = ArrayUtils.roll(psf).toDouble().flatten();
        phaseSequence.addImage((BufferedImage)new IcyBufferedImage(this.Nxy, this.Nxy, (Object)phase_shift));
        this.addSequence(phaseSequence);
    }

    private void modulusClicked() {
        if (this.pupil == null) {
            this.buildpupil();
        }
        Sequence modulusSequence = new Sequence();
        modulusSequence.setName("Modulus of the pupil");
        Double2D psf = Double2D.wrap(this.pupil.getRho(), Shape.make(this.Nxy, this.Nxy));
        double[] modulus_shift = ArrayUtils.roll(psf).toDouble().flatten();
        modulusSequence.addImage((BufferedImage)new IcyBufferedImage(this.Nxy, this.Nxy, (Object)modulus_shift));
        this.addSequence(modulusSequence);
    }

    private void showWeightClicked() {
        Sequence img = (Sequence)this.image.getValue();
        if (img == null) {
            new AnnounceFrame("No image input found");
            return;
        }
        Shape myShape = Shape.make(this.sizeX, this.sizeY);
        int numCanal = (Integer)this.canalImage.getValue();
        DoubleArray input = (DoubleArray)IcyBufferedImageUtils.imageToArray(img, myShape, numCanal);
        Sequence WeightSequence = new Sequence();
        WeightSequence.setName("Weight");
        double[] wght = this.createWeight(input).toDouble().flatten();
        if (wght.length != this.sizeX * this.sizeY * this.sizeZ) {
            new AnnounceFrame("Invalid weight size");
            return;
        }
        int k = 0;
        while (k < this.sizeZ) {
            WeightSequence.setImage(0, k, (BufferedImage)new IcyBufferedImage(this.sizeX, this.sizeY, (Object)MathUtils.getArray(wght, this.sizeX, this.sizeY, k)));
            ++k;
        }
        this.addSequence(WeightSequence);
    }

    private MyMetadata getMetaData(Sequence seq) {
        OMEXMLMetadataImpl metDat = seq.getMetadata();
        if (this.meta == null) {
            this.meta = new MyMetadata();
            if (metDat.getInstrumentCount() > 0) {
                try {
                    this.meta.na = metDat.getObjectiveLensNA(0, 0);
                }
                catch (Exception e) {
                    System.out.println("Failed to get some metadatas, will use default values for na, lambda");
                }
            } else if (this.debug && this.verbose) {
                System.out.println("INFO: Metadata: No instrument so no metadata.");
            }
        }
        this.meta.nxy = seq.getSizeX();
        this.meta.nz = seq.getSizeZ();
        this.meta.dxy = seq.getPixelSizeX() * 1000.0;
        this.meta.dz = seq.getPixelSizeZ() * 1000.0;
        this.meta.na = (Double)this.na.getValue();
        this.meta.lambda = (Double)this.lambda.getValue();
        this.meta.ni = (Double)this.ni.getValue();
        return this.meta;
    }

    private void setMetaData(Sequence seqOld, Sequence seqNew) {
        OMEXMLMetadataImpl newMetdat = OMEUtil.createOMEMetadata((MetadataRetrieve)seqOld.getMetadata());
        newMetdat.setPixelsPhysicalSizeX(OMEUtil.getLength((double)((Double)this.dxy_nm.getValue() * 1.0E-9)), 0);
        newMetdat.setPixelsPhysicalSizeY(OMEUtil.getLength((double)((Double)this.dxy_nm.getValue() * 1.0E-9)), 0);
        newMetdat.setPixelsPhysicalSizeZ(OMEUtil.getLength((double)((Double)this.dz_nm.getValue() * 1.0E-9)), 0);
    }

    private void setMetaData(Sequence seqNew) {
        OMEXMLMetadataImpl newMetdat = OMEUtil.createOMEMetadata();
        newMetdat.setPixelsPhysicalSizeX(OMEUtil.getLength((double)((Double)this.dxy_nm.getValue() * 1.0E-9)), 0);
        newMetdat.setPixelsPhysicalSizeY(OMEUtil.getLength((double)((Double)this.dxy_nm.getValue() * 1.0E-9)), 0);
        newMetdat.setPixelsPhysicalSizeZ(OMEUtil.getLength((double)((Double)this.dz_nm.getValue() * 1.0E-9)), 0);
    }

    private void updateMetaData() {
        Sequence seq = (Sequence)this.image.getValue();
        if (seq != null) {
            try {
                OMEXMLMetadata newMetdat = MetaDataUtil.generateMetaData((Sequence)seq, (boolean)false);
                newMetdat.setPixelsPhysicalSizeX(OMEUtil.getLength((double)((Double)this.dxy_nm.getValue() * 1.0E-9)), 0);
                newMetdat.setPixelsPhysicalSizeY(OMEUtil.getLength((double)((Double)this.dxy_nm.getValue() * 1.0E-9)), 0);
                newMetdat.setPixelsPhysicalSizeZ(OMEUtil.getLength((double)((Double)this.dz_nm.getValue() * 1.0E-9)), 0);
            }
            catch (ServiceException e) {
                e.printStackTrace();
            }
        } else {
            new AnnounceFrame("Nothing to save");
        }
    }

    public void stopExecution() {
        if (this.token != null) {
            this.token.stop();
        }
        if (this.PSFEstimation != null) {
            this.PSFEstimation.stop();
        }
        this.run = false;
    }

    private void ZernikeClicked() {
        if (this.pupil == null) {
            this.buildpupil();
        }
        Sequence PSF0Sequence = new Sequence();
        int k = 0;
        while (k < this.pupil.getNZern()) {
            PSF0Sequence.setImage(0, k, (BufferedImage)new IcyBufferedImage(this.Nxy, this.Nxy, (Object)ArrayUtils.roll(Double2D.wrap(this.pupil.getZernike(k), Shape.make(this.Nxy, this.Nxy))).toDouble().flatten()));
            ++k;
        }
        PSF0Sequence.setName("Zernike");
        this.addSequence(PSF0Sequence);
    }

    private void addImage(double[] in, String name, int width, int height, int sizeZ) {
        Sequence tmpSeq = new Sequence();
        int j = 0;
        while (j < sizeZ) {
            double[] temp = new double[width * height];
            int i = 0;
            while (i < width * height) {
                temp[i] = in[i + j * width * height];
                ++i;
            }
            tmpSeq.setImage(0, j, (BufferedImage)new IcyBufferedImage(width, height, (Object)temp));
            ++j;
        }
        tmpSeq.setName(name);
        this.addSequence(tmpSeq);
    }

    public void declareInput(VarList inputMap) {
        this.initialize();
        inputMap.add("Image", (Var)this.image.getVariable());
        inputMap.add("dxy(nm)", this.dxy_nm.getVariable());
        inputMap.add("dz(nm)", this.dz_nm.getVariable());
        inputMap.add("NA", this.na.getVariable());
        inputMap.add("ni", this.ni.getVariable());
        inputMap.add("\u03bb(nm):", this.lambda.getVariable());
        inputMap.add("Regularization level", this.mu.getVariable());
        inputMap.add("Threshold level", this.epsilon.getVariable());
        inputMap.add("Number of iterations", this.nbIteration.getVariable());
        inputMap.add("Number of phase coefs N\u03b1", this.nbAlphaCoef.getVariable());
        inputMap.add("Number of modulus coefs N\u03b2", this.nbBetaCoef.getVariable());
        inputMap.add("Max. nb. of iterations for defocus", this.DefocusMaxIter.getVariable());
        inputMap.add("Max. nb. of iterations for phase", this.PhaseMaxIter.getVariable());
        inputMap.add("Max. nb. of iterations for modulus", this.ModulusMaxIter.getVariable());
        inputMap.add("Number of loops", this.bDecTotalIteration.getVariable());
    }

    public void declareOutput(VarList outputMap) {
        outputMap.add("output Image", (Var)this.outputHeadlessImage.getVariable());
        outputMap.add("output PSF", (Var)this.outputHeadlessPSF.getVariable());
    }

    public class TvViewer
    implements ReconstructionViewer {
        @Override
        public void display(ReconstructionJob job) {
            MitivBlindDeconvolution.this.setResult(job);
        }
    }
}

