/*
 * Decompiled with CFR 0.152.
 */
package mitiv.linalg;

import mitiv.exception.IncorrectSpaceException;
import mitiv.linalg.VectorSpace;

public abstract class Vector {
    protected final VectorSpace space;
    protected final int number;

    protected Vector(VectorSpace owner) {
        this.space = owner;
        this.number = owner.number;
    }

    public VectorSpace getOwner() {
        return this.space;
    }

    public final int getNumber() {
        return this.number;
    }

    public final int length() {
        return this.number;
    }

    public VectorSpace getSpace() {
        return this.space;
    }

    public final boolean belongsTo(VectorSpace space) {
        return this.space == space;
    }

    public final void assertBelongsTo(VectorSpace space) throws IncorrectSpaceException {
        if (!this.belongsTo(space)) {
            throw new IncorrectSpaceException();
        }
    }

    public abstract double get(int var1) throws IndexOutOfBoundsException;

    public abstract void set(int var1, double var2) throws IndexOutOfBoundsException;

    public Vector clone() {
        return this.space._clone(this);
    }

    public final void copyTo(Vector dst) throws IncorrectSpaceException {
        if (dst != this) {
            this.space.check(dst);
            this.space._copy(dst, this);
        }
    }

    public final void copyFrom(Vector src) throws IncorrectSpaceException {
        if (src != this) {
            this.space.check(src);
            this.space._copy(this, src);
        }
    }

    public final void swap(Vector v) throws IncorrectSpaceException {
        if (v != this) {
            this.space.check(v);
            this.space._swap(this, v);
        }
    }

    public final void scale(double alpha) {
        this.space._scale(this, alpha);
    }

    public final double dot(Vector other) {
        if (other == null || !other.belongsTo(this.space)) {
            throw new IncorrectSpaceException();
        }
        return this.space._dot(this, other);
    }

    public final double dot(Vector v1, Vector v2) {
        if (v1 == null || !v1.belongsTo(this.space) || v2 == null || !v2.belongsTo(this.space)) {
            throw new IncorrectSpaceException();
        }
        return this.space._dot(this, v1, v2);
    }

    public final double norm1() {
        return this.space._norm1(this);
    }

    public final double norm2() {
        return this.space._norm2(this);
    }

    public final double normInf() {
        return this.space._normInf(this);
    }

    public final void fill(double value) {
        this.space._fill(this, value);
    }

    public final void zero() {
        this.space._zero(this);
    }

    public final void combine(double alpha, Vector x, double beta, Vector y) throws IncorrectSpaceException {
        this.space.check(x);
        this.space.check(y);
        this.space._combine(this, alpha, x, beta, y);
    }

    public final void combine(double alpha, Vector x, double beta, Vector y, double gamma, Vector z) throws IncorrectSpaceException {
        this.space.check(x);
        this.space.check(y);
        this.space.check(z);
        this.space._combine(this, alpha, x, beta, y, gamma, z);
    }

    public final void multiply(Vector other) throws IncorrectSpaceException {
        this.space.check(other);
        this.space._multiply(this, this, other);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < this.number) {
            buf.append(i == 0 ? "{" : ", ");
            buf.append(this.get(i));
            ++i;
        }
        buf.append("}");
        return buf.toString();
    }
}

