/*
 * Decompiled with CFR 0.152.
 */
package mcib3d.geom;

import mcib3d.geom.Vector3D;
import mcib3d.utils.ArrayUtil;

public class GeomTransform3D {
    double[][] matrix;
    int size = 4;
    boolean identity;

    public GeomTransform3D() {
        double[][] dArrayArray = new double[][]{{1.0, 0.0, 0.0, 0.0}, {0.0, 1.0, 0.0, 0.0}, {0.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 0.0, 1.0}};
        this.matrix = dArrayArray;
        this.identity = true;
    }

    public GeomTransform3D(double[][] dArray) {
        this.matrix = dArray;
        this.testIdentity();
    }

    public GeomTransform3D(ArrayUtil arrayUtil) {
        double[][] dArrayArray = new double[][]{{1.0, 0.0, 0.0, 0.0}, {0.0, 1.0, 0.0, 0.0}, {0.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 0.0, 1.0}};
        this.matrix = dArrayArray;
        this.setTranslation(arrayUtil.getValue(0), arrayUtil.getValue(1), arrayUtil.getValue(2));
        this.setRotationDegrees(arrayUtil.getValue(3), arrayUtil.getValue(4), arrayUtil.getValue(5));
        this.testIdentity();
    }

    public GeomTransform3D(double d, double d2, double d3, double d4, double d5, double d6) {
        double[][] dArrayArray = new double[][]{{1.0, 0.0, 0.0, 0.0}, {0.0, 1.0, 0.0, 0.0}, {0.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 0.0, 1.0}};
        this.matrix = dArrayArray;
        this.setTranslation(d, d2, d3);
        this.setRotationDegrees(d4, d5, d6);
        this.testIdentity();
    }

    public void reset() {
        double[][] dArrayArray = new double[][]{{1.0, 0.0, 0.0, 0.0}, {0.0, 1.0, 0.0, 0.0}, {0.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 0.0, 1.0}};
        this.matrix = dArrayArray;
        this.identity = true;
    }

    public void setTransform(double d, double d2, double d3, double d4, double d5, double d6) {
        this.setTranslation(d, d2, d3);
        this.setRotationDegrees(d4, d5, d6);
        this.testIdentity();
    }

    public void setTranslation(double d, double d2, double d3) {
        double[][] dArrayArray = new double[][]{{1.0, 0.0, 0.0, d}, {0.0, 1.0, 0.0, d2}, {0.0, 0.0, 1.0, d3}, {0.0, 0.0, 0.0, 1.0}};
        this.multBy(dArrayArray);
        this.testIdentity();
    }

    public void setScale(double d, double d2, double d3) {
        double[][] dArrayArray = new double[][]{{d, 0.0, 0.0, 0.0}, {0.0, d2, 0.0, 0.0}, {0.0, 0.0, d3, 0.0}, {0.0, 0.0, 0.0, 1.0}};
        this.multBy(dArrayArray);
        this.testIdentity();
    }

    public void setRotationXAxis(double d) {
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        double[][] dArrayArray = new double[][]{{1.0, 0.0, 0.0, 0.0}, {0.0, d2, -d3, 0.0}, {0.0, d3, d2, 0.0}, {0.0, 0.0, 0.0, 1.0}};
        this.multBy(dArrayArray);
        this.testIdentity();
    }

    public void setRotationYAxis(double d) {
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        double[][] dArrayArray = new double[][]{{d2, 0.0, -d3, 0.0}, {0.0, 1.0, 0.0, 0.0}, {d3, 0.0, d2, 0.0}, {0.0, 0.0, 0.0, 1.0}};
        this.multBy(dArrayArray);
        this.testIdentity();
    }

    public void setRotationZAxis(double d) {
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        double[][] dArrayArray = new double[][]{{d2, -d3, 0.0, 0.0}, {d3, d2, 0.0, 0.0}, {0.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 0.0, 1.0}};
        this.multBy(dArrayArray);
        this.testIdentity();
    }

    public void setRotation(double d, double d2, double d3) {
        this.setRotationXAxis(d);
        this.setRotationYAxis(d2);
        this.setRotationZAxis(d3);
    }

    public void setRotation(Vector3D vector3D, double d) {
        vector3D.normalize();
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        double d4 = 1.0 - d2;
        vector3D.normalize();
        double d5 = vector3D.getX();
        double d6 = vector3D.getY();
        double d7 = vector3D.getZ();
        double[][] dArrayArray = new double[][]{{d4 * d5 * d5 + d2, d4 * d5 * d6 - d3 * d7, d4 * d5 * d7 + d3 * d6, 0.0}, {d4 * d5 * d6 + d3 * d7, d4 * d6 * d6 + d2, d4 * d6 * d7 - d3 * d5, 0.0}, {d4 * d5 * d7 - d3 * d6, d4 * d6 * d7 + d3 * d5, d4 * d7 * d7 + d2, 0.0}, {0.0, 0.0, 0.0, 1.0}};
        this.multBy(dArrayArray);
        this.testIdentity();
    }

    public void setRotationDegrees(double d, double d2, double d3) {
        this.setRotationXAxis(Math.toRadians(d));
        this.setRotationYAxis(Math.toRadians(d2));
        this.setRotationZAxis(Math.toRadians(d3));
    }

    public void addTransform(GeomTransform3D geomTransform3D) {
        this.multBy(geomTransform3D.matrix);
    }

    public void addTransform(ArrayUtil arrayUtil) {
        this.multBy(new GeomTransform3D((ArrayUtil)arrayUtil).matrix);
    }

    private void multBy(double[][] dArray) {
        double[][] dArray2 = new double[this.size][this.size];
        for (int i = 0; i < this.size; ++i) {
            for (int j = 0; j < this.size; ++j) {
                for (int k = 0; k < this.size; ++k) {
                    double[] dArray3 = dArray2[j];
                    int n = i;
                    dArray3[n] = dArray3[n] + this.matrix[j][k] * dArray[k][i];
                }
            }
        }
        this.matrix = dArray2;
    }

    public double getValue(int n, int n2) {
        return this.matrix[n][n2];
    }

    public double[][] getMatrix() {
        return this.matrix;
    }

    public void invert() {
        double[][] dArray = new double[4][4];
        GeomTransform3D.invert4x4(dArray, this.matrix);
        this.matrix = dArray;
    }

    private void testIdentity() {
        double[][] dArrayArray = new double[][]{{1.0, 0.0, 0.0, 0.0}, {0.0, 1.0, 0.0, 0.0}, {0.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 0.0, 1.0}};
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                if (this.matrix[i][j] == dArrayArray[i][j]) continue;
                this.identity = false;
                return;
            }
        }
        this.identity = true;
    }

    public boolean isIdentity() {
        return this.identity;
    }

    public Vector3D getVectorTransformed(Vector3D vector3D, Vector3D vector3D2) {
        double d = vector3D.getX() - vector3D2.getX();
        double d2 = vector3D.getY() - vector3D2.getY();
        double d3 = vector3D.getZ() - vector3D2.getZ();
        double d4 = this.matrix[0][0] * d + this.matrix[0][1] * d2 + this.matrix[0][2] * d3 + this.matrix[0][3];
        double d5 = this.matrix[1][0] * d + this.matrix[1][1] * d2 + this.matrix[1][2] * d3 + this.matrix[1][3];
        double d6 = this.matrix[2][0] * d + this.matrix[2][1] * d2 + this.matrix[2][2] * d3 + this.matrix[2][3];
        Vector3D vector3D3 = new Vector3D(d4 + vector3D2.getX(), d5 + vector3D2.getY(), d6 + vector3D2.getZ());
        return vector3D3;
    }

    public static void invert4x4(double[][] dArray, double[][] dArray2) {
        double[] dArray3 = new double[20];
        double[] dArray4 = new double[4];
        dArray3[0] = dArray2[0][0];
        dArray3[1] = dArray2[0][1];
        dArray3[2] = dArray2[0][2];
        dArray3[3] = dArray2[0][3];
        dArray3[4] = 1.0;
        dArray3[5] = dArray2[1][0];
        dArray3[6] = dArray2[1][1];
        dArray3[7] = dArray2[1][2];
        dArray3[8] = dArray2[1][3];
        dArray3[9] = 0.0;
        dArray3[10] = dArray2[2][0];
        dArray3[11] = dArray2[2][1];
        dArray3[12] = dArray2[2][2];
        dArray3[13] = dArray2[2][3];
        dArray3[14] = 0.0;
        dArray3[15] = dArray2[3][0];
        dArray3[16] = dArray2[3][1];
        dArray3[17] = dArray2[3][2];
        dArray3[18] = dArray2[3][3];
        dArray3[19] = 0.0;
        if (GeomTransform3D.GaussElim(dArray3, dArray4) <= 0) {
            return;
        }
        dArray[0][0] = dArray4[0];
        dArray[1][0] = dArray4[1];
        dArray[2][0] = dArray4[2];
        dArray[3][0] = dArray4[3];
        dArray3[0] = dArray2[0][0];
        dArray3[1] = dArray2[0][1];
        dArray3[2] = dArray2[0][2];
        dArray3[3] = dArray2[0][3];
        dArray3[4] = 0.0;
        dArray3[5] = dArray2[1][0];
        dArray3[6] = dArray2[1][1];
        dArray3[7] = dArray2[1][2];
        dArray3[8] = dArray2[1][3];
        dArray3[9] = 1.0;
        dArray3[10] = dArray2[2][0];
        dArray3[11] = dArray2[2][1];
        dArray3[12] = dArray2[2][2];
        dArray3[13] = dArray2[2][3];
        dArray3[14] = 0.0;
        dArray3[15] = dArray2[3][0];
        dArray3[16] = dArray2[3][1];
        dArray3[17] = dArray2[3][2];
        dArray3[18] = dArray2[3][3];
        dArray3[19] = 0.0;
        if (GeomTransform3D.GaussElim(dArray3, dArray4) <= 0) {
            return;
        }
        dArray[0][1] = dArray4[0];
        dArray[1][1] = dArray4[1];
        dArray[2][1] = dArray4[2];
        dArray[3][1] = dArray4[3];
        dArray3[0] = dArray2[0][0];
        dArray3[1] = dArray2[0][1];
        dArray3[2] = dArray2[0][2];
        dArray3[3] = dArray2[0][3];
        dArray3[4] = 0.0;
        dArray3[5] = dArray2[1][0];
        dArray3[6] = dArray2[1][1];
        dArray3[7] = dArray2[1][2];
        dArray3[8] = dArray2[1][3];
        dArray3[9] = 0.0;
        dArray3[10] = dArray2[2][0];
        dArray3[11] = dArray2[2][1];
        dArray3[12] = dArray2[2][2];
        dArray3[13] = dArray2[2][3];
        dArray3[14] = 1.0;
        dArray3[15] = dArray2[3][0];
        dArray3[16] = dArray2[3][1];
        dArray3[17] = dArray2[3][2];
        dArray3[18] = dArray2[3][3];
        dArray3[19] = 0.0;
        if (GeomTransform3D.GaussElim(dArray3, dArray4) <= 0) {
            return;
        }
        dArray[0][2] = dArray4[0];
        dArray[1][2] = dArray4[1];
        dArray[2][2] = dArray4[2];
        dArray[3][2] = dArray4[3];
        dArray3[0] = dArray2[0][0];
        dArray3[1] = dArray2[0][1];
        dArray3[2] = dArray2[0][2];
        dArray3[3] = dArray2[0][3];
        dArray3[4] = 0.0;
        dArray3[5] = dArray2[1][0];
        dArray3[6] = dArray2[1][1];
        dArray3[7] = dArray2[1][2];
        dArray3[8] = dArray2[1][3];
        dArray3[9] = 0.0;
        dArray3[10] = dArray2[2][0];
        dArray3[11] = dArray2[2][1];
        dArray3[12] = dArray2[2][2];
        dArray3[13] = dArray2[2][3];
        dArray3[14] = 0.0;
        dArray3[15] = dArray2[3][0];
        dArray3[16] = dArray2[3][1];
        dArray3[17] = dArray2[3][2];
        dArray3[18] = dArray2[3][3];
        dArray3[19] = 1.0;
        if (GeomTransform3D.GaussElim(dArray3, dArray4) <= 0) {
            return;
        }
        dArray[0][3] = dArray4[0];
        dArray[1][3] = dArray4[1];
        dArray[2][3] = dArray4[2];
        dArray[3][3] = dArray4[3];
    }

    private static int GaussElim(double[] dArray, double[] dArray2) {
        int n;
        int n2;
        int n3 = dArray2.length;
        for (n2 = 0; n2 < n3; ++n2) {
            dArray2[n2] = 0.0;
        }
        n2 = n3 + 1;
        for (n = 0; n < n3 - 1; ++n) {
            double d;
            int n4;
            int n5;
            for (n5 = n; n5 < n3 && dArray[n5 * n2 + n] == 0.0; ++n5) {
            }
            if (n5 == n3) {
                return 0;
            }
            if (n5 != n) {
                for (n4 = 0; n4 < n2; ++n4) {
                    d = dArray[n * n2 + n4];
                    dArray[n * n2 + n4] = dArray[n5 * n2 + n4];
                    dArray[n5 * n2 + n4] = d;
                }
            }
            for (n4 = n + 1; n4 < n3; ++n4) {
                d = dArray[n4 * n2 + n] / dArray[n * n2 + n];
                for (int i = 0; i <= n3; ++i) {
                    dArray[n4 * n2 + i] = dArray[n4 * n2 + i] - d * dArray[n * n2 + i];
                }
            }
        }
        if (dArray[(n3 - 1) * n2 + (n3 - 1)] == 0.0) {
            return 0;
        }
        dArray2[n3 - 1] = dArray[(n3 - 1) * n2 + n3] / dArray[(n3 - 1) * n2 + (n3 - 1)];
        for (n = n3 - 2; n >= 0; --n) {
            double d = 0.0;
            for (int i = n + 1; i < n3; ++i) {
                d += dArray[n * n2 + i] * dArray2[i];
            }
            dArray2[n] = (dArray[n * n2 + n3] - d) / dArray[n * n2 + n];
        }
        return 1;
    }
}

