/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tlong.impl;

import cern.colt.matrix.tlong.LongMatrix1D;
import cern.colt.matrix.tlong.LongMatrix2D;
import cern.colt.matrix.tlong.impl.DenseLongMatrix1D;
import cern.colt.matrix.tlong.impl.WrapperLongMatrix2D;

public class DenseLargeLongMatrix2D
extends WrapperLongMatrix2D {
    private static final long serialVersionUID = 1L;
    private long[][] elements;

    public DenseLargeLongMatrix2D(int rows, int columns) {
        block2: {
            super(null);
            try {
                this.setUp(rows, columns);
            }
            catch (IllegalArgumentException exc) {
                if ("matrix too large".equals(exc.getMessage())) break block2;
                throw exc;
            }
        }
        this.elements = new long[rows][columns];
        this.content = this;
    }

    @Override
    public long getQuick(int row, int column) {
        return this.elements[row][column];
    }

    @Override
    public void setQuick(int row, int column, long value) {
        this.elements[row][column] = value;
    }

    public long[][] elements() {
        return this.elements;
    }

    @Override
    protected LongMatrix2D getContent() {
        return this;
    }

    @Override
    public LongMatrix2D like(int rows, int columns) {
        return new DenseLargeLongMatrix2D(rows, columns);
    }

    @Override
    public LongMatrix1D like1D(int size) {
        return new DenseLongMatrix1D(size);
    }
}

