/*
 * Decompiled with CFR 0.152.
 */
package mitiv.cost;

import mitiv.cost.DifferentiableCostFunction;
import mitiv.exception.IncorrectSpaceException;
import mitiv.linalg.Vector;
import mitiv.linalg.VectorSpace;

public class DifferentiableInverseProblemCost
implements DifferentiableCostFunction {
    protected final VectorSpace inputSpace;
    protected final DifferentiableCostFunction fdata;
    protected final DifferentiableCostFunction fprior;
    protected double mu;
    protected int nfx;
    protected int ngx;

    public DifferentiableInverseProblemCost(DifferentiableCostFunction fdata, double mu, DifferentiableCostFunction fprior) {
        this.inputSpace = fdata.getInputSpace();
        if (this.inputSpace != fprior.getInputSpace()) {
            throw new IncorrectSpaceException("Fdata and Fprior must operate on the same vector space");
        }
        this.fdata = fdata;
        this.fprior = fprior;
        this.mu = mu;
        this.nfx = 0;
        this.ngx = 0;
    }

    public void setRelativeWeight(double value) {
        this.mu = value;
    }

    public double getRelativeWeight() {
        return this.mu;
    }

    public int getNumberOfFunctionCalls() {
        return this.nfx;
    }

    public int getNumberOfGradientCalls() {
        return this.ngx;
    }

    @Override
    public double evaluate(double alpha, Vector x) {
        double fx = this.fdata.evaluate(alpha, x) + this.fprior.evaluate(this.mu * alpha, x);
        ++this.nfx;
        return fx;
    }

    @Override
    public double computeCostAndGradient(double alpha, Vector x, Vector gx, boolean clr) {
        double fx = this.fdata.computeCostAndGradient(alpha, x, gx, clr);
        ++this.nfx;
        ++this.ngx;
        return fx += this.fprior.computeCostAndGradient(this.mu * alpha, x, gx, false);
    }

    @Override
    public VectorSpace getInputSpace() {
        return this.inputSpace;
    }
}

