/*
 * Decompiled with CFR 0.152.
 */
package mcib3d.image3d.processing;

import ij.ImageStack;
import java.util.concurrent.atomic.AtomicInteger;
import mcib3d.geom.Object3D;
import mcib3d.geom.Object3DVoxels;
import mcib3d.image3d.ImageByte;
import mcib3d.image3d.ImageFloat;
import mcib3d.image3d.ImageHandler;
import mcib3d.image3d.ImageInt;
import mcib3d.image3d.ImageShort;
import mcib3d.utils.ThreadUtil;

public class FastFilters3D {
    public static final int MEAN = 0;
    public static final int MEDIAN = 1;
    public static final int MIN = 2;
    public static final int MAX = 3;
    public static final int MAXLOCAL = 4;
    public static final int TOPHAT = 5;
    public static final int OPENGRAY = 6;
    public static final int CLOSEGRAY = 7;
    public static final int VARIANCE = 8;
    public static final int SOBEL = 9;
    public static final int ADAPTIVE = 10;

    public static ImageStack filterIntImageStack(ImageStack imageStack, int n, float f, float f2, float f3, int n2, boolean bl) {
        return FastFilters3D.filterIntImage(ImageInt.wrap(imageStack), n, f, f2, f3, n2, bl).getImageStack();
    }

    public static ImageInt filterIntImage(ImageInt imageInt, int n, float f, float f2, float f3, int n2, boolean bl) {
        final float f4 = f;
        final float f5 = f2;
        final float f6 = f3;
        final ImageInt imageInt2 = imageInt;
        ImageInt imageInt3 = (ImageInt)imageInt2.createSameDimensions();
        if (n == 0 || n == 1 || n == 2 || n == 3 || n == 4 || n == 5 || n == 8 || n == 7 || n == 6) {
            int n3;
            ImageInt imageInt4;
            final ImageInt imageInt5 = imageInt3;
            final AtomicInteger atomicInteger = new AtomicInteger(0);
            final int n4 = n2 == 0 ? ThreadUtil.getNbCpus() : n2;
            int n5 = n;
            if (n5 == 5 || n5 == 6) {
                n5 = 2;
            }
            if (n5 == 7) {
                n5 = 3;
            }
            final int n6 = n5;
            final int n7 = (int)Math.ceil((double)imageInt2.sizeZ / (double)n4);
            Thread[] threadArray = ThreadUtil.createThreadArray(n4);
            for (int i = 0; i < threadArray.length; ++i) {
                threadArray[i] = new Thread(){

                    @Override
                    public void run() {
                        ImageInt imageInt = imageInt2;
                        int n = atomicInteger.getAndIncrement();
                        while (n < n4) {
                            imageInt.filterGeneric(imageInt5, f4, f5, f6, n7 * n, n7 * (n + 1), n6);
                            n = atomicInteger.getAndIncrement();
                        }
                    }
                };
            }
            ThreadUtil.startAndJoin(threadArray);
            if (n == 5 || n == 6) {
                imageInt4 = (ImageInt)imageInt2.createSameDimensions();
                atomicInteger.set(0);
                for (n3 = 0; n3 < threadArray.length; ++n3) {
                    threadArray[n3] = new Thread(){

                        @Override
                        public void run() {
                            ImageInt imageInt = imageInt5;
                            int n = atomicInteger.getAndIncrement();
                            while (n < n4) {
                                imageInt.filterGeneric(imageInt4, f4, f5, f6, n7 * n, n7 * (n + 1), 3);
                                n = atomicInteger.getAndIncrement();
                            }
                        }
                    };
                }
                ThreadUtil.startAndJoin(threadArray);
                imageInt3 = n == 5 ? imageInt2.substractImage(imageInt4) : imageInt4;
            }
            if (n == 7) {
                imageInt4 = (ImageInt)imageInt2.createSameDimensions();
                atomicInteger.set(0);
                for (n3 = 0; n3 < threadArray.length; ++n3) {
                    threadArray[n3] = new Thread(){

                        @Override
                        public void run() {
                            ImageInt imageInt = imageInt5;
                            int n = atomicInteger.getAndIncrement();
                            while (n < n4) {
                                imageInt.filterGeneric(imageInt4, f4, f5, f6, n7 * n, n7 * (n + 1), 2);
                                n = atomicInteger.getAndIncrement();
                            }
                        }
                    };
                }
                ThreadUtil.startAndJoin(threadArray);
                imageInt3 = imageInt4;
            }
        } else if (n == 9) {
            imageInt3 = imageInt2.sobelFilter();
        } else if (n == 10) {
            imageInt3 = imageInt2.adaptiveFilter(f4, f5, f6, n2);
        }
        return imageInt3;
    }

    public static ImageStack filterImageStack(ImageStack imageStack, int n, float f, float f2, float f3, int n2, boolean bl) {
        int n3 = imageStack.getBitDepth();
        if (n3 == 8 || n3 == 16) {
            return FastFilters3D.filterImageStack(imageStack, n, f, f2, f3, n2, bl);
        }
        if (n3 == 32) {
            return FastFilters3D.filterFloatImageStack(imageStack, n, f, f2, f3, n2, bl);
        }
        return null;
    }

    public static ImageHandler filterImage(ImageHandler imageHandler, int n, float f, float f2, float f3, int n2, boolean bl) {
        if (imageHandler instanceof ImageByte || imageHandler instanceof ImageShort) {
            return FastFilters3D.filterIntImage((ImageInt)imageHandler, n, f, f2, f3, n2, bl);
        }
        if (imageHandler instanceof ImageFloat) {
            return FastFilters3D.filterFloatImage((ImageFloat)imageHandler, n, f, f2, f3, n2, bl);
        }
        return null;
    }

    public static ImageFloat filterFloatImage(ImageFloat imageFloat, int n, float f, float f2, float f3, int n2, boolean bl) {
        final float f4 = f;
        final float f5 = f2;
        final float f6 = f3;
        final ImageFloat imageFloat2 = imageFloat;
        ImageFloat imageFloat3 = (ImageFloat)imageFloat2.createSameDimensions();
        if (n == 0 || n == 1 || n == 2 || n == 3 || n == 4 || n == 5 || n == 8 || n == 7 || n == 6) {
            int n3;
            ImageFloat imageFloat4;
            final ImageFloat imageFloat5 = imageFloat3;
            final AtomicInteger atomicInteger = new AtomicInteger(0);
            final int n4 = n2 == 0 ? ThreadUtil.getNbCpus() : n2;
            int n5 = n;
            if (n5 == 5 || n5 == 6) {
                n5 = 2;
            }
            if (n5 == 7) {
                n5 = 3;
            }
            final int n6 = n5;
            final int n7 = (int)Math.ceil((double)imageFloat2.sizeZ / (double)n4);
            Thread[] threadArray = ThreadUtil.createThreadArray(n4);
            for (int i = 0; i < threadArray.length; ++i) {
                threadArray[i] = new Thread(){

                    @Override
                    public void run() {
                        ImageFloat imageFloat = imageFloat2;
                        int n = atomicInteger.getAndIncrement();
                        while (n < n4) {
                            imageFloat.filterGeneric(imageFloat5, f4, f5, f6, n7 * n, n7 * (n + 1), n6);
                            n = atomicInteger.getAndIncrement();
                        }
                    }
                };
            }
            ThreadUtil.startAndJoin(threadArray);
            if (n == 5 || n == 6) {
                imageFloat4 = (ImageFloat)imageFloat2.createSameDimensions();
                atomicInteger.set(0);
                for (n3 = 0; n3 < threadArray.length; ++n3) {
                    threadArray[n3] = new Thread(){

                        @Override
                        public void run() {
                            ImageFloat imageFloat = imageFloat5;
                            int n = atomicInteger.getAndIncrement();
                            while (n < n4) {
                                imageFloat.filterGeneric(imageFloat4, f4, f5, f6, n7 * n, n7 * (n + 1), 3);
                                n = atomicInteger.getAndIncrement();
                            }
                        }
                    };
                }
                ThreadUtil.startAndJoin(threadArray);
                imageFloat3 = n == 5 ? imageFloat2.substractImage(imageFloat4) : imageFloat4;
            }
            if (n == 7) {
                imageFloat4 = (ImageFloat)imageFloat2.createSameDimensions();
                atomicInteger.set(0);
                for (n3 = 0; n3 < threadArray.length; ++n3) {
                    threadArray[n3] = new Thread(){

                        @Override
                        public void run() {
                            ImageFloat imageFloat = imageFloat5;
                            int n = atomicInteger.getAndIncrement();
                            while (n < n4) {
                                imageFloat.filterGeneric(imageFloat4, f4, f5, f6, n7 * n, n7 * (n + 1), 2);
                                n = atomicInteger.getAndIncrement();
                            }
                        }
                    };
                }
                ThreadUtil.startAndJoin(threadArray);
                imageFloat3 = imageFloat4;
            }
        } else if (n == 9) {
            imageFloat3 = imageFloat2.sobelFilter();
        } else if (n == 10) {
            imageFloat3 = imageFloat2.adaptiveFilter(f4, f5, f6, n2);
        }
        return imageFloat3;
    }

    public static ImageStack filterFloatImageStack(ImageStack imageStack, int n, float f, float f2, float f3, int n2, boolean bl) {
        return FastFilters3D.filterFloatImage((ImageFloat)ImageFloat.wrap(imageStack), n, f, f2, f3, n2, bl).getImageStack();
    }

    public static int[] createKernelEllipsoid(float f, float f2, float f3) {
        int n = (int)Math.ceil(f);
        int n2 = (int)Math.ceil(f2);
        int n3 = (int)Math.ceil(f3);
        int[] nArray = new int[(2 * n + 1) * (2 * n2 + 1) * (2 * n3 + 1)];
        double d = f * f;
        double d2 = f2 * f2;
        double d3 = f3 * f3;
        d = d != 0.0 ? 1.0 / d : 0.0;
        d2 = d2 != 0.0 ? 1.0 / d2 : 0.0;
        d3 = d3 != 0.0 ? 1.0 / d3 : 0.0;
        int n4 = 0;
        for (int i = -n3; i <= n3; ++i) {
            for (int j = -n2; j <= n2; ++j) {
                for (int k = -n; k <= n; ++k) {
                    double d4 = (double)(k * k) * d + (double)(j * j) * d2 + (double)(i * i) * d3;
                    nArray[n4] = d4 <= 1.0 ? 1 : 0;
                    ++n4;
                }
            }
        }
        return nArray;
    }

    public static int[] createKernelFromObject(Object3D object3D) {
        int[] nArray = object3D.getBoundingBox();
        ImageInt imageInt = object3D.getLabelImage();
        int n = nArray[1] - nArray[0] + 1;
        int n2 = nArray[3] - nArray[2] + 1;
        int n3 = nArray[5] - nArray[4] + 1;
        int[] nArray2 = new int[n * n2 * n3];
        int n4 = 0;
        for (int i = nArray[4]; i <= nArray[5]; ++i) {
            for (int j = nArray[2]; j <= nArray[3]; ++j) {
                for (int k = nArray[0]; k <= nArray[1]; ++k) {
                    nArray2[n4] = imageInt.getPixel(k, j, i) > 0.0f ? 1 : 0;
                    ++n4;
                }
            }
        }
        return nArray2;
    }

    public static int getNbFromKernel(int[] nArray) {
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] <= 0) continue;
            ++n;
        }
        return n;
    }

    public static float[] getRadiiFromObject(Object3D object3D) {
        int[] nArray = object3D.getBoundingBox();
        float f = (float)Math.ceil(0.5 * (double)(nArray[1] - nArray[0]));
        float f2 = (float)Math.ceil(0.5 * (double)(nArray[3] - nArray[2]));
        float f3 = (float)Math.ceil(0.5 * (double)(nArray[5] - nArray[4]));
        return new float[]{f, f2, f3};
    }

    public static ImageHandler filterImage(ImageHandler imageHandler, int n, Object3DVoxels object3DVoxels, int n2, boolean bl) {
        if (imageHandler instanceof ImageByte || imageHandler instanceof ImageShort) {
            return FastFilters3D.filterIntImage((ImageInt)imageHandler, n, object3DVoxels, n2, bl);
        }
        if (imageHandler instanceof ImageFloat) {
            return FastFilters3D.filterFloatImage((ImageFloat)imageHandler, n, object3DVoxels, n2, bl);
        }
        return null;
    }

    public static ImageInt filterIntImage(ImageInt imageInt, int n, Object3DVoxels object3DVoxels, int n2, boolean bl) {
        boolean bl2 = bl;
        final Object3DVoxels object3DVoxels2 = object3DVoxels;
        final ImageInt imageInt2 = imageInt;
        ImageInt imageInt3 = (ImageInt)imageInt2.createSameDimensions();
        if (n == 0 || n == 1 || n == 2 || n == 3 || n == 4 || n == 5 || n == 8 || n == 7 || n == 6) {
            int n3;
            ImageInt imageInt4;
            final ImageInt imageInt5 = imageInt3;
            final AtomicInteger atomicInteger = new AtomicInteger(0);
            final int n4 = n2 == 0 ? ThreadUtil.getNbCpus() : n2;
            int n5 = n;
            if (n5 == 5 || n5 == 6) {
                n5 = 2;
            }
            if (n5 == 7) {
                n5 = 3;
            }
            final int n6 = n5;
            final int n7 = (int)Math.ceil((double)imageInt2.sizeZ / (double)n4);
            Thread[] threadArray = ThreadUtil.createThreadArray(n4);
            for (int i = 0; i < threadArray.length; ++i) {
                threadArray[i] = new Thread(){

                    @Override
                    public void run() {
                        ImageInt imageInt = imageInt2;
                        int n = atomicInteger.getAndIncrement();
                        while (n < n4) {
                            imageInt.filterGeneric(imageInt5, object3DVoxels2, n7 * n, n7 * (n + 1), n6);
                            n = atomicInteger.getAndIncrement();
                        }
                    }
                };
            }
            ThreadUtil.startAndJoin(threadArray);
            if (n == 5 || n == 6) {
                imageInt4 = (ImageInt)imageInt2.createSameDimensions();
                atomicInteger.set(0);
                for (n3 = 0; n3 < threadArray.length; ++n3) {
                    threadArray[n3] = new Thread(){

                        @Override
                        public void run() {
                            ImageInt imageInt = imageInt5;
                            int n = atomicInteger.getAndIncrement();
                            while (n < n4) {
                                imageInt.filterGeneric(imageInt4, object3DVoxels2, n7 * n, n7 * (n + 1), 3);
                                n = atomicInteger.getAndIncrement();
                            }
                        }
                    };
                }
                ThreadUtil.startAndJoin(threadArray);
                imageInt3 = n == 5 ? imageInt2.substractImage(imageInt4) : imageInt4;
            }
            if (n == 7) {
                imageInt4 = (ImageInt)imageInt2.createSameDimensions();
                atomicInteger.set(0);
                for (n3 = 0; n3 < threadArray.length; ++n3) {
                    threadArray[n3] = new Thread(){

                        @Override
                        public void run() {
                            ImageInt imageInt = imageInt5;
                            int n = atomicInteger.getAndIncrement();
                            while (n < n4) {
                                imageInt.filterGeneric(imageInt4, object3DVoxels2, n7 * n, n7 * (n + 1), 2);
                                n = atomicInteger.getAndIncrement();
                            }
                        }
                    };
                }
                ThreadUtil.startAndJoin(threadArray);
                imageInt3 = imageInt4;
            }
        } else if (n == 9) {
            imageInt3 = imageInt2.sobelFilter();
        } else if (n == 10) {
            // empty if block
        }
        return imageInt3;
    }

    public static ImageFloat filterFloatImage(ImageFloat imageFloat, int n, Object3DVoxels object3DVoxels, int n2, boolean bl) {
        boolean bl2 = bl;
        final Object3DVoxels object3DVoxels2 = object3DVoxels;
        final ImageFloat imageFloat2 = imageFloat;
        ImageFloat imageFloat3 = (ImageFloat)imageFloat2.createSameDimensions();
        if (n == 0 || n == 1 || n == 2 || n == 3 || n == 4 || n == 5 || n == 8 || n == 7 || n == 6) {
            int n3;
            ImageFloat imageFloat4;
            final ImageFloat imageFloat5 = imageFloat3;
            final AtomicInteger atomicInteger = new AtomicInteger(0);
            final int n4 = n2 == 0 ? ThreadUtil.getNbCpus() : n2;
            int n5 = n;
            if (n5 == 5 || n5 == 6) {
                n5 = 2;
            }
            if (n5 == 7) {
                n5 = 3;
            }
            final int n6 = n5;
            final int n7 = (int)Math.ceil((double)imageFloat2.sizeZ / (double)n4);
            Thread[] threadArray = ThreadUtil.createThreadArray(n4);
            for (int i = 0; i < threadArray.length; ++i) {
                threadArray[i] = new Thread(){

                    @Override
                    public void run() {
                        ImageFloat imageFloat = imageFloat2;
                        int n = atomicInteger.getAndIncrement();
                        while (n < n4) {
                            imageFloat.filterGeneric(imageFloat5, object3DVoxels2, n7 * n, n7 * (n + 1), n6);
                            n = atomicInteger.getAndIncrement();
                        }
                    }
                };
            }
            ThreadUtil.startAndJoin(threadArray);
            if (n == 5 || n == 6) {
                imageFloat4 = (ImageFloat)imageFloat2.createSameDimensions();
                atomicInteger.set(0);
                for (n3 = 0; n3 < threadArray.length; ++n3) {
                    threadArray[n3] = new Thread(){

                        @Override
                        public void run() {
                            ImageFloat imageFloat = imageFloat5;
                            int n = atomicInteger.getAndIncrement();
                            while (n < n4) {
                                imageFloat.filterGeneric(imageFloat4, object3DVoxels2, n7 * n, n7 * (n + 1), 3);
                                n = atomicInteger.getAndIncrement();
                            }
                        }
                    };
                }
                ThreadUtil.startAndJoin(threadArray);
                imageFloat3 = n == 5 ? imageFloat2.substractImage(imageFloat4) : imageFloat4;
            }
            if (n == 7) {
                imageFloat4 = (ImageFloat)imageFloat2.createSameDimensions();
                atomicInteger.set(0);
                for (n3 = 0; n3 < threadArray.length; ++n3) {
                    threadArray[n3] = new Thread(){

                        @Override
                        public void run() {
                            ImageFloat imageFloat = imageFloat5;
                            int n = atomicInteger.getAndIncrement();
                            while (n < n4) {
                                imageFloat.filterGeneric(imageFloat4, object3DVoxels2, n7 * n, n7 * (n + 1), 2);
                                n = atomicInteger.getAndIncrement();
                            }
                        }
                    };
                }
                ThreadUtil.startAndJoin(threadArray);
                imageFloat3 = imageFloat4;
            }
        } else if (n == 9) {
            imageFloat3 = imageFloat2.sobelFilter();
        } else if (n == 10) {
            // empty if block
        }
        return imageFloat3;
    }
}

