/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.awt;

import com.jogamp.opengl.util.GLPixelBuffer;
import com.jogamp.opengl.util.TileRenderer;
import com.jogamp.opengl.util.awt.AWTGLPixelBuffer;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import javax.imageio.ImageIO;
import javax.media.nativewindow.util.DimensionImmutable;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLEventListener;
import jogamp.opengl.Debug;

public class AWTTilePainter {
    private static final boolean DEBUG_TILES = Debug.debug("TileRenderer.PNG");
    public final TileRenderer renderer;
    public final int componentCount;
    public final double scaleMatX;
    public final double scaleMatY;
    public final int customTileWidth;
    public final int customTileHeight;
    public final int customNumSamples;
    public final boolean verbose;
    public boolean flipVertical;
    public boolean originBottomLeft;
    private AWTGLPixelBuffer tBuffer = null;
    private BufferedImage vFlipImage = null;
    private Graphics2D g2d = null;
    private AffineTransform saveAT = null;
    private int scaledYOffset;
    final GLEventListener preTileGLEL = new GLEventListener(){

        @Override
        public void init(GLAutoDrawable gLAutoDrawable) {
        }

        @Override
        public void dispose(GLAutoDrawable gLAutoDrawable) {
        }

        @Override
        public void display(GLAutoDrawable gLAutoDrawable) {
            GL gL = gLAutoDrawable.getGL();
            if (null == AWTTilePainter.this.tBuffer) {
                int n = AWTTilePainter.this.renderer.getParam(9);
                int n2 = AWTTilePainter.this.renderer.getParam(10);
                AWTGLPixelBuffer.AWTGLPixelBufferProvider aWTGLPixelBufferProvider = new AWTGLPixelBuffer.AWTGLPixelBufferProvider(true);
                GLPixelBuffer.GLPixelAttributes gLPixelAttributes = aWTGLPixelBufferProvider.getAttributes(gL, AWTTilePainter.this.componentCount);
                AWTTilePainter.this.tBuffer = aWTGLPixelBufferProvider.allocate(gL, gLPixelAttributes, n, n2, 1, true, 0);
                AWTTilePainter.this.renderer.setTileBuffer(AWTTilePainter.this.tBuffer);
                if (AWTTilePainter.this.flipVertical) {
                    AWTTilePainter.this.vFlipImage = new BufferedImage(((AWTTilePainter)AWTTilePainter.this).tBuffer.width, ((AWTTilePainter)AWTTilePainter.this).tBuffer.height, ((AWTTilePainter)AWTTilePainter.this).tBuffer.image.getType());
                } else {
                    AWTTilePainter.this.vFlipImage = null;
                }
            }
            if (AWTTilePainter.this.verbose) {
                System.err.println("XXX tile-pre " + AWTTilePainter.this.renderer);
            }
        }

        @Override
        public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        }
    };
    static int _counter = 0;
    final GLEventListener postTileGLEL = new GLEventListener(){

        @Override
        public void init(GLAutoDrawable gLAutoDrawable) {
        }

        @Override
        public void dispose(GLAutoDrawable gLAutoDrawable) {
        }

        @Override
        public void display(GLAutoDrawable gLAutoDrawable) {
            Object object;
            BufferedImage bufferedImage;
            Object object2;
            Object object3;
            DimensionImmutable dimensionImmutable = AWTTilePainter.this.renderer.getClippedImageSize();
            int n = AWTTilePainter.this.renderer.getParam(5);
            int n2 = AWTTilePainter.this.renderer.getParam(6);
            int n3 = AWTTilePainter.this.renderer.getParam(4);
            int n4 = AWTTilePainter.this.renderer.getParam(13);
            int n5 = AWTTilePainter.this.originBottomLeft ? 0 : AWTTilePainter.this.renderer.getParam(10) - n2;
            int n6 = AWTTilePainter.this.renderer.getParam(3);
            int n7 = dimensionImmutable.getHeight() - (n3 - n4 + n2) + AWTTilePainter.this.scaledYOffset;
            if (DEBUG_TILES) {
                object3 = String.format("file_%03d_0_tile_[%02d][%02d]_sz_%03dx%03d_pos0_%03d_%03d_yOff_%03d_pos1_%03d_%03d.png", _counter, AWTTilePainter.this.renderer.getParam(18), AWTTilePainter.this.renderer.getParam(17), n, n2, n6, n3, n4, n6, n7).replace(' ', '_');
                System.err.println("XXX file " + (String)object3);
                object2 = new File((String)object3);
                try {
                    ImageIO.write((RenderedImage)((AWTTilePainter)AWTTilePainter.this).tBuffer.image, "png", (File)object2);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            if (AWTTilePainter.this.flipVertical) {
                object3 = ((AWTTilePainter)AWTTilePainter.this).tBuffer.image;
                bufferedImage = AWTTilePainter.this.vFlipImage;
                object2 = ((DataBufferInt)((BufferedImage)object3).getRaster().getDataBuffer()).getData();
                object = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
                if (DEBUG_TILES) {
                    Arrays.fill((int[])object, 85);
                }
                int n8 = ((AWTTilePainter)AWTTilePainter.this).tBuffer.width;
                int n9 = 0;
                for (int i = (n2 - 1) * ((AWTTilePainter)AWTTilePainter.this).tBuffer.width; i >= 0; i -= n8) {
                    System.arraycopy(object2, n9, object, i, n8);
                    n9 += n8;
                }
            } else {
                bufferedImage = ((AWTTilePainter)AWTTilePainter.this).tBuffer.image;
            }
            if (DEBUG_TILES) {
                object3 = String.format("file_%03d_1_tile_[%02d][%02d]_sz_%03dx%03d_pos0_%03d_%03d_yOff_%03d_pos1_%03d_%03d.png", _counter, AWTTilePainter.this.renderer.getParam(18), AWTTilePainter.this.renderer.getParam(17), n, n2, n6, n3, n4, n6, n7).replace(' ', '_');
                System.err.println("XXX file " + (String)object3);
                object2 = new File((String)object3);
                try {
                    ImageIO.write((RenderedImage)bufferedImage, "png", (File)object2);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                ++_counter;
            }
            object3 = bufferedImage.getSubimage(0, n5, n, n2);
            boolean bl = AWTTilePainter.this.g2d.drawImage((Image)object3, n6, n7, null);
            if (AWTTilePainter.this.verbose) {
                object = AWTTilePainter.this.g2d.getClip();
                System.err.println("XXX tile-post.X tile 0 / " + n5 + " " + n + "x" + n2 + ", clippedImgSize " + dimensionImmutable);
                System.err.println("XXX tile-post.X pYf " + dimensionImmutable.getHeight() + " - ( " + n3 + " - " + n4 + " + " + n2 + " ) " + AWTTilePainter.this.scaledYOffset + " = " + n7);
                System.err.println("XXX tile-post.X clip " + object + " + " + n6 + " / [pY " + n3 + ", pYOff " + n4 + ", pYf " + n7 + "] -> " + AWTTilePainter.this.g2d.getClip());
                AWTTilePainter.this.g2d.setColor(Color.BLACK);
                AWTTilePainter.this.g2d.drawRect(n6, n7, n, n2);
                if (null != object) {
                    Rectangle rectangle = object.getBounds();
                    AWTTilePainter.this.g2d.setColor(Color.YELLOW);
                    AWTTilePainter.this.g2d.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                }
                System.err.println("XXX tile-post.X " + AWTTilePainter.this.renderer);
                System.err.println("XXX tile-post.X dst-img " + bufferedImage.getWidth() + "x" + bufferedImage.getHeight());
                System.err.println("XXX tile-post.X out-img " + ((BufferedImage)object3).getWidth() + "x" + ((BufferedImage)object3).getHeight());
                System.err.println("XXX tile-post.X y-flip " + AWTTilePainter.this.flipVertical + ", originBottomLeft " + AWTTilePainter.this.originBottomLeft + " -> " + n6 + "/" + n7 + ", drawDone " + bl);
            }
        }

        @Override
        public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        }
    };

    public static void dumpHintsAndScale(Graphics2D graphics2D) {
        RenderingHints renderingHints = graphics2D.getRenderingHints();
        Set<Map.Entry<Object, Object>> set = renderingHints.entrySet();
        int n = 0;
        for (Map.Entry<Object, Object> entry : set) {
            System.err.println("Hint[" + n + "]: " + entry.getKey() + " -> " + entry.getValue());
            ++n;
        }
        AffineTransform affineTransform = graphics2D.getTransform();
        if (null != affineTransform) {
            System.err.println(" type " + affineTransform.getType());
            System.err.println(" scale " + affineTransform.getScaleX() + " x " + affineTransform.getScaleY());
            System.err.println(" move " + affineTransform.getTranslateX() + " x " + affineTransform.getTranslateY());
            System.err.println(" mat  " + affineTransform);
        } else {
            System.err.println(" null transform");
        }
    }

    public int getNumSamples(GLCapabilitiesImmutable gLCapabilitiesImmutable) {
        if (0 > this.customNumSamples) {
            return 0;
        }
        if (0 < this.customNumSamples) {
            if (!gLCapabilitiesImmutable.getGLProfile().isGL2ES3()) {
                return 0;
            }
            return Math.max(gLCapabilitiesImmutable.getNumSamples(), this.customNumSamples);
        }
        return gLCapabilitiesImmutable.getNumSamples();
    }

    public AWTTilePainter(TileRenderer tileRenderer, int n, double d, double d2, int n2, int n3, int n4, boolean bl) {
        this.renderer = tileRenderer;
        this.renderer.setGLEventListener(this.preTileGLEL, this.postTileGLEL);
        this.componentCount = n;
        this.scaleMatX = d;
        this.scaleMatY = d2;
        this.customNumSamples = n2;
        this.customTileWidth = n3;
        this.customTileHeight = n4;
        this.verbose = bl;
        this.flipVertical = true;
    }

    public String toString() {
        return "AWTTilePainter[flipVertical " + this.flipVertical + ", startFromBottom " + this.originBottomLeft + ", " + this.renderer.toString() + "]";
    }

    public void setGLOrientation(boolean bl, boolean bl2) {
        this.flipVertical = bl;
        this.originBottomLeft = bl2;
    }

    private static Rectangle2D getClipBounds2D(Graphics2D graphics2D) {
        Shape shape = graphics2D.getClip();
        return null != shape ? shape.getBounds2D() : null;
    }

    private static Rectangle2D clipNegative(Rectangle2D rectangle2D) {
        if (null == rectangle2D) {
            return null;
        }
        double d = rectangle2D.getX();
        double d2 = rectangle2D.getY();
        double d3 = rectangle2D.getWidth();
        double d4 = rectangle2D.getHeight();
        if (0.0 > d) {
            d3 += d;
            d = 0.0;
        }
        if (0.0 > d2) {
            d4 += d2;
            d2 = 0.0;
        }
        return new Rectangle2D.Double(d, d2, d3, d4);
    }

    public void setupGraphics2DAndClipBounds(Graphics2D graphics2D, int n, int n2) throws NoninvertibleTransformException {
        Rectangle2D rectangle2D;
        this.g2d = graphics2D;
        this.saveAT = graphics2D.getTransform();
        if (null == this.saveAT) {
            this.saveAT = new AffineTransform();
        }
        Rectangle2D rectangle2D2 = AWTTilePainter.getClipBounds2D(graphics2D);
        Rectangle2D rectangle2D3 = AWTTilePainter.clipNegative(rectangle2D2);
        Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, n, n2);
        Object object = new AffineTransform(this.saveAT);
        ((AffineTransform)object).scale(this.scaleMatX, this.scaleMatY);
        Cloneable cloneable = ((AffineTransform)object).createInverse();
        object = this.saveAT.createTransformedShape(double_);
        Rectangle2D rectangle2D4 = cloneable.createTransformedShape((Shape)object).getBounds2D();
        if (null == rectangle2D3) {
            rectangle2D = (Rectangle2D)rectangle2D4.clone();
        } else {
            object = this.saveAT.createTransformedShape(rectangle2D3);
            rectangle2D = cloneable.createTransformedShape((Shape)object).getBounds2D();
        }
        cloneable = rectangle2D.getBounds();
        object = rectangle2D4.getBounds();
        this.renderer.setImageSize(((Rectangle)object).width, ((Rectangle)object).height);
        this.renderer.clipImageSize(((Rectangle)cloneable).width, ((Rectangle)cloneable).height);
        int n3 = Math.min(((Rectangle)object).height, ((Rectangle)cloneable).height);
        this.scaledYOffset = ((Rectangle)cloneable).y;
        this.renderer.setTileOffset(((Rectangle)cloneable).x, ((Rectangle)object).height - (((Rectangle)cloneable).y + n3));
        graphics2D.scale(this.scaleMatX, this.scaleMatY);
        if (this.verbose) {
            System.err.println("AWT print.0: image " + double_ + " -> " + rectangle2D4 + " -> " + object);
            System.err.println("AWT print.0: clip  " + rectangle2D2 + " -> " + rectangle2D3 + " -> " + rectangle2D + " -> " + cloneable);
            System.err.println("AWT print.0: " + this.renderer);
        }
    }

    public void resetGraphics2D() {
        this.g2d.setTransform(this.saveAT);
    }

    public void dispose() {
        this.renderer.detachAutoDrawable();
        this.g2d = null;
        if (null != this.tBuffer) {
            this.tBuffer.dispose();
            this.tBuffer = null;
        }
        if (null != this.vFlipImage) {
            this.vFlipImage.flush();
            this.vFlipImage = null;
        }
    }
}

