/*
 * Decompiled with CFR 0.152.
 */
package mitiv.linalg.shaped;

import mitiv.array.FloatArray;
import mitiv.array.ShapedArray;
import mitiv.base.Shape;
import mitiv.linalg.ArrayOps;
import mitiv.linalg.Vector;
import mitiv.linalg.shaped.FloatShapedVector;
import mitiv.linalg.shaped.ShapedVectorSpace;

public class FloatShapedVectorSpace
extends ShapedVectorSpace {
    public FloatShapedVectorSpace(Shape shape) {
        super(4, shape);
    }

    public FloatShapedVectorSpace(int[] dims) {
        super(4, dims);
    }

    public FloatShapedVectorSpace(int dim1) {
        super(4, dim1);
    }

    public FloatShapedVectorSpace(int dim1, int dim2) {
        super(4, dim1, dim2);
    }

    public FloatShapedVectorSpace(int dim1, int dim2, int dim3) {
        super(4, dim1, dim2, dim3);
    }

    public FloatShapedVectorSpace(int dim1, int dim2, int dim3, int dim4) {
        super(4, dim1, dim2, dim3, dim4);
    }

    @Override
    public FloatShapedVector create() {
        return new FloatShapedVector(this);
    }

    @Override
    public FloatShapedVector create(double value) {
        FloatShapedVector v = new FloatShapedVector(this);
        ArrayOps.fill(this.number, v.getData(), value);
        return v;
    }

    @Override
    public FloatShapedVector create(ShapedArray arr) {
        return this.create(arr, false);
    }

    @Override
    public FloatShapedVector create(ShapedArray arr, boolean forceCopy) {
        this.checkShape(arr);
        FloatArray tmp = arr.toFloat();
        return new FloatShapedVector(this, tmp.flatten(forceCopy && tmp == arr));
    }

    public FloatShapedVector create(FloatArray arr) {
        return this.create(arr, false);
    }

    public FloatShapedVector create(FloatArray arr, boolean forceCopy) {
        this.checkShape(arr);
        return new FloatShapedVector(this, arr.flatten(forceCopy));
    }

    public FloatShapedVector clone(FloatShapedVector vec) {
        this.check(vec);
        return this._clone(vec);
    }

    protected FloatShapedVector _clone(FloatShapedVector vec) {
        FloatShapedVector cpy = new FloatShapedVector(this);
        this._copy(vec, cpy);
        return cpy;
    }

    @Override
    public FloatShapedVector clone(Vector vec) {
        this.check(vec);
        return this._clone(vec);
    }

    @Override
    protected FloatShapedVector _clone(Vector vec) {
        return this._clone((FloatShapedVector)vec);
    }

    public FloatShapedVector wrap(float[] x) {
        return new FloatShapedVector(this, x);
    }

    public void copy(float[] src, Vector dst) {
        this.check(dst);
        ((FloatShapedVector)dst).set(src);
    }

    @Override
    protected void _copy(Vector src, Vector dst) {
        ArrayOps.copy(this.number, ((FloatShapedVector)src).getData(), ((FloatShapedVector)dst).getData());
    }

    @Override
    protected void _swap(Vector x, Vector y) {
        this._copy(x, y);
    }

    protected void _swap(FloatShapedVector vx, FloatShapedVector vy) {
        float[] x = vx.getData();
        float[] y = vy.getData();
        int n = vx.getNumber();
        int j = 0;
        while (j < n) {
            float a = x[j];
            x[j] = y[j];
            y[j] = a;
            ++j;
        }
    }

    @Override
    protected void _fill(Vector x, double alpha) {
        ArrayOps.fill(this.number, ((FloatShapedVector)x).getData(), alpha);
    }

    @Override
    protected double _dot(Vector x, Vector y) {
        return ArrayOps.dot(this.number, ((FloatShapedVector)x).getData(), ((FloatShapedVector)y).getData());
    }

    @Override
    protected double _norm2(Vector x) {
        return ArrayOps.norm2(((FloatShapedVector)x).getData());
    }

    @Override
    protected double _norm1(Vector x) {
        return ArrayOps.norm1(((FloatShapedVector)x).getData());
    }

    @Override
    protected double _normInf(Vector x) {
        return ArrayOps.normInf(((FloatShapedVector)x).getData());
    }

    @Override
    protected void _axpby(double alpha, Vector x, double beta, Vector y) {
        ArrayOps.axpby(this.number, alpha, ((FloatShapedVector)x).getData(), beta, ((FloatShapedVector)y).getData());
    }

    @Override
    protected void _axpby(double alpha, Vector x, double beta, Vector y, Vector dst) {
        ArrayOps.axpby(this.number, alpha, ((FloatShapedVector)x).getData(), beta, ((FloatShapedVector)y).getData(), ((FloatShapedVector)dst).getData());
    }

    @Override
    protected void _axpbypcz(double alpha, Vector x, double beta, Vector y, double gamma, Vector z, Vector dst) {
        ArrayOps.axpbypcz(this.number, alpha, ((FloatShapedVector)x).getData(), beta, ((FloatShapedVector)y).getData(), gamma, ((FloatShapedVector)z).getData(), ((FloatShapedVector)dst).getData());
    }
}

