/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.buffer.tbyte;

import cern.colt.PersistentObject;
import cern.colt.buffer.tbyte.ByteBufferConsumer;
import cern.colt.list.tbyte.ByteArrayList;

public class ByteBuffer
extends PersistentObject
implements ByteBufferConsumer {
    private static final long serialVersionUID = 1L;
    protected ByteBufferConsumer target;
    protected byte[] elements;
    protected ByteArrayList list;
    protected int capacity;
    protected int size;

    public ByteBuffer(ByteBufferConsumer target, int capacity) {
        this.target = target;
        this.capacity = capacity;
        this.elements = new byte[capacity];
        this.list = new ByteArrayList(this.elements);
        this.size = 0;
    }

    public void add(byte element) {
        if (this.size == this.capacity) {
            this.flush();
        }
        this.elements[this.size++] = element;
    }

    @Override
    public void addAllOf(ByteArrayList list) {
        int listSize = list.size();
        if (this.size + listSize >= this.capacity) {
            this.flush();
        }
        this.target.addAllOf(list);
    }

    public void clear() {
        this.size = 0;
    }

    public void flush() {
        if (this.size > 0) {
            this.list.setSize(this.size);
            this.target.addAllOf(this.list);
            this.size = 0;
        }
    }
}

