/*
 * Decompiled with CFR 0.152.
 */
package mcib3d.image3d.processing;

import mcib3d.image3d.ImageByte;
import mcib3d.image3d.ImageFloat;
import mcib3d.image3d.ImageInt;
import mcib3d.image3d.ImageShort;
import mcib3d.image3d.distanceMap3d.EDT;
import mcib3d.utils.ThreadRunner;
import mcib3d.utils.ThreadUtil;
import mcib3d.utils.exceptionPrinter;

public class BinaryMorpho {
    public static final byte MORPHO_DILATE = 1;
    public static final byte MORPHO_ERODE = 2;
    public static final byte MORPHO_CLOSE = 3;
    public static final byte MORPHO_OPEN = 4;

    public static ImageByte binaryMorpho(ImageInt imageInt, int n, float f, float f2) {
        return BinaryMorpho.binaryMorpho(imageInt, n, f, f2, 0);
    }

    public static ImageByte binaryMorpho(ImageInt imageInt, int n, float f, float f2, int n2) {
        switch (n) {
            case 1: {
                return BinaryMorpho.binaryDilate(imageInt, f, f2, n2);
            }
            case 3: {
                return BinaryMorpho.binaryClose(imageInt, f, f2, n2);
            }
            case 2: {
                return BinaryMorpho.binaryErode(imageInt, f, f2, n2);
            }
            case 4: {
                return BinaryMorpho.binaryOpen(imageInt, f, f2, n2);
            }
        }
        return null;
    }

    public static ImageByte binaryOpen(ImageInt imageInt, float f, float f2) {
        return BinaryMorpho.binaryOpen(imageInt, f, f2, 0);
    }

    public static ImageByte binaryOpen(ImageInt imageInt, float f, float f2, int n) {
        try {
            if (n == 0) {
                n = ThreadUtil.getNbCpus();
            }
            if (f <= 1.0f && f2 <= 1.0f) {
                return BinaryMorpho.binaryOpenRad1(imageInt, 1.0f, n);
            }
            ImageFloat imageFloat = EDT.run(imageInt, 0.0f, 1.0f, f / f2, false, n);
            ImageByte imageByte = imageFloat.threshold(f, false, true);
            imageFloat.closeImagePlus();
            imageFloat = EDT.run(imageByte, 0.0f, 1.0f, f / f2, true, n);
            imageByte.closeImagePlus();
            imageByte = imageFloat.threshold(f, true, false);
            imageFloat.closeImagePlus();
            imageFloat = null;
            System.gc();
            imageByte.setOffset(imageInt);
            imageByte.setScale(imageInt);
            return imageByte;
        }
        catch (Exception exception) {
            exceptionPrinter.print(exception, null, true);
            return null;
        }
    }

    public static ImageByte binaryErode(ImageInt imageInt, float f, float f2) {
        return BinaryMorpho.binaryErode(imageInt, f, f2, 0);
    }

    public static ImageByte binaryErode(ImageInt imageInt, float f, float f2, int n) {
        try {
            if (n == 0) {
                n = ThreadUtil.getNbCpus();
            }
            if (f <= 1.0f && f2 <= 1.0f) {
                return BinaryMorpho.binaryErodeRad1(imageInt, 1.0f, n);
            }
            ImageFloat imageFloat = EDT.run(imageInt, 0.0f, 1.0f, f / f2, false, n);
            ImageByte imageByte = imageFloat.threshold(f, false, true);
            imageFloat.flush();
            imageFloat = null;
            imageByte.setOffset(imageInt);
            imageByte.setScale(imageInt);
            return imageByte;
        }
        catch (Exception exception) {
            exceptionPrinter.print(exception, null, true);
            return null;
        }
    }

    public static ImageByte binaryDilate(ImageInt imageInt, float f, float f2) {
        return BinaryMorpho.binaryDilate(imageInt, f, f2, 0);
    }

    public static ImageByte binaryDilate(ImageInt imageInt, float f, float f2, int n) {
        try {
            if (n == 0) {
                n = ThreadUtil.getNbCpus();
            }
            if (f <= 1.0f && f2 <= 1.0f) {
                return BinaryMorpho.binaryDilateRad1(imageInt, 1.0f, n);
            }
            int n2 = (int)(f + 1.0f);
            int n3 = (int)(f + 1.0f);
            int n4 = (int)(f2 + 1.0f);
            ImageInt imageInt2 = (ImageInt)imageInt.resize(n2, n3, n4);
            ImageFloat imageFloat = EDT.run(imageInt2, 0.0f, 1.0f, f / f2, true, n);
            ImageByte imageByte = imageFloat.threshold(f, true, false);
            imageFloat.flush();
            imageFloat = null;
            imageByte.setOffset(imageInt);
            imageByte.offsetX -= n2;
            imageByte.offsetY -= n3;
            imageByte.offsetZ -= n4;
            imageByte.setScale(imageInt);
            return imageByte;
        }
        catch (Exception exception) {
            exceptionPrinter.print(exception, null, true);
            return null;
        }
    }

    public static ImageByte binaryClose(ImageInt imageInt, float f, float f2) {
        return BinaryMorpho.binaryClose(imageInt, f, f2, 0);
    }

    public static ImageByte binaryClose(ImageInt imageInt, float f, float f2, int n) {
        try {
            if (n == 0) {
                n = ThreadUtil.getNbCpus();
            }
            if (f <= 1.0f && f2 <= 1.0f) {
                return BinaryMorpho.binaryCloseRad1(imageInt, 1.0f, n);
            }
            int n2 = (int)f + 1;
            int n3 = (int)f2 + 1;
            int n4 = 0;
            ImageInt imageInt2 = (ImageInt)imageInt.resize(n2 + n4, n2 + n4, n3 + n4);
            ImageFloat imageFloat = EDT.run(imageInt2, 0.0f, 1.0f, f / f2, true, n);
            imageInt2.closeImagePlus();
            ImageByte imageByte = imageFloat.threshold(f, true, false);
            imageFloat.closeImagePlus();
            imageFloat = EDT.run(imageByte, 0.0f, 1.0f, f / f2, false, n);
            imageByte.closeImagePlus();
            ImageFloat imageFloat2 = (ImageFloat)imageFloat.resize(-n2, -n2, -n3);
            imageFloat.closeImagePlus();
            imageFloat = null;
            System.gc();
            imageByte = imageFloat2.threshold(f, false, true);
            imageFloat2.closeImagePlus();
            imageFloat2 = null;
            System.gc();
            imageByte.offsetX = imageInt.offsetX - n4;
            imageByte.offsetY = imageInt.offsetY - n4;
            imageByte.offsetZ = imageInt.offsetZ - n4;
            imageByte.setScale(imageInt);
            return imageByte;
        }
        catch (Exception exception) {
            exceptionPrinter.print(exception, null, true);
            return null;
        }
    }

    private static ImageByte binaryOpenRad1(final ImageInt imageInt, final float f, int n) {
        if (n == 0) {
            n = ThreadUtil.getNbCpus();
        }
        final ImageByte imageByte = new ImageByte("min", imageInt.sizeX, imageInt.sizeY, imageInt.sizeZ);
        final ThreadRunner threadRunner = new ThreadRunner(0, imageInt.sizeZ, n);
        for (int i = 0; i < threadRunner.threads.length; ++i) {
            threadRunner.threads[i] = new Thread(new Runnable(){

                @Override
                public void run() {
                    int n = threadRunner.ai.getAndIncrement();
                    while (n < threadRunner.end) {
                        for (int i = 0; i < imageInt.sizeY; ++i) {
                            for (int j = 0; j < imageInt.sizeX; ++j) {
                                if (!BinaryMorpho.minRad1(imageInt, f, j, i, n)) continue;
                                imageByte.pixels[n][j + i * imageInt.sizeX] = -1;
                            }
                        }
                        n = threadRunner.ai.getAndIncrement();
                    }
                }
            });
        }
        threadRunner.startAndJoin();
        final ImageByte imageByte2 = new ImageByte(imageInt.getTitle() + "::open", imageInt.sizeX, imageInt.sizeY, imageInt.sizeZ);
        final ThreadRunner threadRunner2 = new ThreadRunner(0, imageInt.sizeZ, n);
        for (int i = 0; i < threadRunner2.threads.length; ++i) {
            threadRunner2.threads[i] = new Thread(new Runnable(){

                @Override
                public void run() {
                    int n = threadRunner2.ai.getAndIncrement();
                    while (n < threadRunner2.end) {
                        for (int i = 0; i < imageInt.sizeY; ++i) {
                            for (int j = 0; j < imageInt.sizeX; ++j) {
                                if (!BinaryMorpho.maxRad1(imageByte, 1.0f, j, i, n)) continue;
                                imageByte2.pixels[n][j + i * imageInt.sizeX] = -1;
                            }
                        }
                        n = threadRunner2.ai.getAndIncrement();
                    }
                }
            });
        }
        threadRunner2.startAndJoin();
        imageByte.closeImagePlus();
        imageByte2.setScale(imageInt);
        imageByte2.setOffset(imageInt);
        return imageByte2;
    }

    private static ImageByte binaryErodeRad1(final ImageInt imageInt, final float f, int n) {
        if (n == 0) {
            n = ThreadUtil.getNbCpus();
        }
        final ImageByte imageByte = new ImageByte("min", imageInt.sizeX, imageInt.sizeY, imageInt.sizeZ);
        final ThreadRunner threadRunner = new ThreadRunner(0, imageInt.sizeZ, n);
        for (int i = 0; i < threadRunner.threads.length; ++i) {
            threadRunner.threads[i] = new Thread(new Runnable(){

                @Override
                public void run() {
                    int n = threadRunner.ai.getAndIncrement();
                    while (n < threadRunner.end) {
                        for (int i = 0; i < imageInt.sizeY; ++i) {
                            for (int j = 0; j < imageInt.sizeX; ++j) {
                                if (!BinaryMorpho.minRad1(imageInt, f, j, i, n)) continue;
                                imageByte.pixels[n][j + i * imageInt.sizeX] = -1;
                            }
                        }
                        n = threadRunner.ai.getAndIncrement();
                    }
                }
            });
        }
        threadRunner.startAndJoin();
        imageByte.setScale(imageInt);
        imageByte.setOffset(imageInt);
        return imageByte;
    }

    private static ImageByte binaryDilateRad1(final ImageInt imageInt, final float f, int n) {
        if (n == 0) {
            n = ThreadUtil.getNbCpus();
        }
        final ImageByte imageByte = new ImageByte("max", imageInt.sizeX, imageInt.sizeY, imageInt.sizeZ);
        final ThreadRunner threadRunner = new ThreadRunner(0, imageInt.sizeZ, n);
        for (int i = 0; i < threadRunner.threads.length; ++i) {
            threadRunner.threads[i] = new Thread(new Runnable(){

                @Override
                public void run() {
                    int n = threadRunner.ai.getAndIncrement();
                    while (n < threadRunner.end) {
                        for (int i = 0; i < imageInt.sizeY; ++i) {
                            for (int j = 0; j < imageInt.sizeX; ++j) {
                                if (!BinaryMorpho.maxRad1(imageInt, f, j, i, n)) continue;
                                imageByte.pixels[n][j + i * imageInt.sizeX] = -1;
                            }
                        }
                        n = threadRunner.ai.getAndIncrement();
                    }
                }
            });
        }
        threadRunner.startAndJoin();
        imageByte.setScale(imageInt);
        imageByte.setOffset(imageInt);
        return imageByte;
    }

    private static ImageByte binaryCloseRad1(final ImageInt imageInt, final float f, int n) {
        if (n == 0) {
            n = ThreadUtil.getNbCpus();
        }
        final ImageByte imageByte = new ImageByte("max", imageInt.sizeX, imageInt.sizeY, imageInt.sizeZ);
        final ThreadRunner threadRunner = new ThreadRunner(0, imageInt.sizeZ, n);
        for (int i = 0; i < threadRunner.threads.length; ++i) {
            threadRunner.threads[i] = new Thread(new Runnable(){

                @Override
                public void run() {
                    int n = threadRunner.ai.getAndIncrement();
                    while (n < threadRunner.end) {
                        for (int i = 0; i < imageInt.sizeY; ++i) {
                            for (int j = 0; j < imageInt.sizeX; ++j) {
                                if (!BinaryMorpho.maxRad1(imageInt, f, j, i, n)) continue;
                                imageByte.pixels[n][j + i * imageInt.sizeX] = -1;
                            }
                        }
                        n = threadRunner.ai.getAndIncrement();
                    }
                }
            });
        }
        threadRunner.startAndJoin();
        final ThreadRunner threadRunner2 = new ThreadRunner(0, imageInt.sizeZ, n);
        final ImageByte imageByte2 = new ImageByte(imageInt.getTitle() + "::close", imageInt.sizeX, imageInt.sizeY, imageInt.sizeZ);
        for (int i = 0; i < threadRunner2.threads.length; ++i) {
            threadRunner2.threads[i] = new Thread(new Runnable(){

                @Override
                public void run() {
                    int n = threadRunner2.ai.getAndIncrement();
                    while (n < threadRunner2.end) {
                        for (int i = 0; i < imageInt.sizeY; ++i) {
                            for (int j = 0; j < imageInt.sizeX; ++j) {
                                if (!BinaryMorpho.minRad1(imageByte, 1.0f, j, i, n)) continue;
                                imageByte2.pixels[n][j + i * imageInt.sizeX] = -1;
                            }
                        }
                        n = threadRunner2.ai.getAndIncrement();
                    }
                }
            });
        }
        threadRunner2.startAndJoin();
        imageByte.closeImagePlus();
        imageByte2.setOffset(imageInt);
        imageByte2.setScale(imageInt);
        return imageByte2;
    }

    private static boolean minRad1(ImageInt imageInt, float f, int n, int n2, int n3) {
        if (imageInt.getPixel(n, n2, n3) >= f) {
            if (imageInt.touchBorders(n, n2, n3)) {
                return false;
            }
            if (imageInt.getPixel(n - 1, n2, n3) < f) {
                return false;
            }
            if (imageInt.getPixel(n + 1, n2, n3) < f) {
                return false;
            }
            if (imageInt.getPixel(n, n2 - 1, n3) < f) {
                return false;
            }
            if (imageInt.getPixel(n, n2 + 1, n3) < f) {
                return false;
            }
            if (imageInt.getPixel(n, n2, n3 - 1) < f) {
                return false;
            }
            return !(imageInt.getPixel(n, n2, n3 + 1) < f);
        }
        return false;
    }

    private static boolean maxRad1(ImageInt imageInt, float f, int n, int n2, int n3) {
        if (imageInt.getPixel(n, n2, n3) < f) {
            if (n > 0 && imageInt.getPixel(n - 1, n2, n3) >= f) {
                return true;
            }
            if (n < imageInt.sizeX - 1 && imageInt.getPixel(n + 1, n2, n3) >= f) {
                return true;
            }
            if (n2 > 0 && imageInt.getPixel(n, n2 - 1, n3) >= f) {
                return true;
            }
            if (n2 < imageInt.sizeY - 1 && imageInt.getPixel(n, n2 + 1, n3) >= f) {
                return true;
            }
            if (n3 > 0 && imageInt.getPixel(n, n2, n3 - 1) >= f) {
                return true;
            }
            return n3 < imageInt.sizeZ - 1 && imageInt.getPixel(n, n2, n3 + 1) >= f;
        }
        return true;
    }

    public static ImageInt binaryOpenMultilabel(ImageInt imageInt, float f, float f2) {
        return BinaryMorpho.binaryOpenMultilabel(imageInt, f, f2, 0);
    }

    public static ImageInt binaryOpenMultilabel(ImageInt imageInt, float f, float f2, int n) {
        ImageInt[] imageIntArray = imageInt.crop3DBinary();
        if (imageIntArray != null) {
            for (int i = 0; i < imageIntArray.length; ++i) {
                imageIntArray[i] = f <= 1.0f && f2 <= 1.0f ? BinaryMorpho.binaryOpenRad1(imageIntArray[i], 1.0f, n) : BinaryMorpho.binaryOpen(imageIntArray[i], f, f2, n);
            }
            ImageShort imageShort = ImageShort.merge3DBinary(imageIntArray, imageInt.sizeX, imageInt.sizeY, imageInt.sizeZ);
            imageShort.setScale(imageInt);
            return imageShort;
        }
        return imageInt;
    }

    public static ImageInt binaryCloseMultilabel(ImageInt imageInt, float f, float f2) {
        return BinaryMorpho.binaryCloseMultilabel(imageInt, f, f2, 0);
    }

    public static ImageInt binaryCloseMultilabel(ImageInt imageInt, float f, float f2, int n) {
        ImageInt[] imageIntArray = imageInt.crop3DBinary();
        if (imageIntArray != null) {
            for (int i = 0; i < imageIntArray.length; ++i) {
                imageIntArray[i] = f <= 1.0f && f2 <= 1.0f ? BinaryMorpho.binaryCloseRad1(imageIntArray[i], 1.0f, n) : BinaryMorpho.binaryClose(imageIntArray[i], f, f2, n);
            }
            ImageShort imageShort = ImageShort.merge3DBinary(imageIntArray, imageInt.sizeX, imageInt.sizeY, imageInt.sizeZ);
            imageShort.setScale(imageInt);
            return imageShort;
        }
        return imageInt;
    }

    public static ImageInt binaryDilateMultilabel(ImageInt imageInt, float f, float f2) {
        return BinaryMorpho.binaryDilateMultilabel(imageInt, f, f2, 0);
    }

    public static ImageInt binaryDilateMultilabel(ImageInt imageInt, float f, float f2, int n) {
        ImageInt[] imageIntArray = imageInt.crop3DBinary();
        if (imageIntArray != null) {
            int n2 = imageIntArray.length;
            for (int i = 0; i < n2; ++i) {
                imageIntArray[i] = BinaryMorpho.binaryDilate(imageIntArray[i], f, f2, n);
            }
            ImageShort imageShort = ImageShort.merge3DBinary(imageIntArray, imageInt.sizeX, imageInt.sizeY, imageInt.sizeZ);
            imageShort.setScale(imageInt);
            return imageShort;
        }
        return imageInt;
    }

    public static ImageInt binaryCloseMultilabel(ImageInt imageInt, float[] fArray, float[] fArray2, int n) {
        ImageInt[] imageIntArray = imageInt.crop3DBinary();
        if (fArray.length != imageIntArray.length || fArray2.length != imageIntArray.length) {
            return null;
        }
        if (imageIntArray != null) {
            for (int i = 0; i < imageIntArray.length; ++i) {
                imageIntArray[i] = fArray[i] <= 1.0f && fArray2[i] <= 1.0f ? BinaryMorpho.binaryCloseRad1(imageIntArray[i], 1.0f, n) : BinaryMorpho.binaryClose(imageIntArray[i], fArray[i], fArray2[i], n);
            }
            ImageShort imageShort = ImageShort.merge3DBinary(imageIntArray, imageInt.sizeX, imageInt.sizeY, imageInt.sizeZ);
            imageShort.setScale(imageInt);
            return imageShort;
        }
        return imageInt;
    }

    public static ImageInt binaryDilateMultilabel(ImageInt imageInt, float[] fArray, float[] fArray2, int n) {
        ImageInt[] imageIntArray = imageInt.crop3DBinary();
        if (fArray.length != imageIntArray.length || fArray2.length != imageIntArray.length) {
            return null;
        }
        if (imageIntArray != null) {
            for (int i = 0; i < imageIntArray.length; ++i) {
                imageIntArray[i] = BinaryMorpho.binaryDilate(imageIntArray[i], fArray[i], fArray2[i], n);
            }
            ImageShort imageShort = ImageShort.merge3DBinary(imageIntArray, imageInt.sizeX, imageInt.sizeY, imageInt.sizeZ);
            imageShort.setScale(imageInt);
            return imageShort;
        }
        return imageInt;
    }
}

