/*
 * Decompiled with CFR 0.152.
 */
package mitiv.linalg.shaped;

import mitiv.array.FloatArray;
import mitiv.array.ShapedArray;
import mitiv.base.Shape;
import mitiv.linalg.ArrayOps;
import mitiv.linalg.Vector;
import mitiv.linalg.shaped.FloatShapedVector;
import mitiv.linalg.shaped.ShapedVectorSpace;

public class FloatShapedVectorSpace
extends ShapedVectorSpace {
    public FloatShapedVectorSpace(Shape shape) {
        super(4, shape);
    }

    public FloatShapedVectorSpace(int[] dims) {
        super(4, dims);
    }

    public FloatShapedVectorSpace(int dim1) {
        super(4, dim1);
    }

    public FloatShapedVectorSpace(int dim1, int dim2) {
        super(4, dim1, dim2);
    }

    public FloatShapedVectorSpace(int dim1, int dim2, int dim3) {
        super(4, dim1, dim2, dim3);
    }

    public FloatShapedVectorSpace(int dim1, int dim2, int dim3, int dim4) {
        super(4, dim1, dim2, dim3, dim4);
    }

    private float[] getData(Vector v) {
        return ((FloatShapedVector)v).getData();
    }

    @Override
    public FloatShapedVector create() {
        return new FloatShapedVector(this);
    }

    @Override
    public FloatShapedVector create(double value) {
        FloatShapedVector v = new FloatShapedVector(this);
        ArrayOps.fill(v.getData(), this.number, value);
        return v;
    }

    @Override
    public FloatShapedVector create(ShapedArray arr) {
        return this.create(arr, false);
    }

    @Override
    public FloatShapedVector create(ShapedArray arr, boolean forceCopy) {
        this.checkShape(arr);
        FloatArray tmp = arr.toFloat();
        return new FloatShapedVector(this, tmp.flatten(forceCopy && tmp == arr));
    }

    public FloatShapedVector create(FloatArray arr) {
        return this.create(arr, false);
    }

    public FloatShapedVector create(FloatArray arr, boolean forceCopy) {
        this.checkShape(arr);
        return new FloatShapedVector(this, arr.flatten(forceCopy));
    }

    public FloatShapedVector clone(FloatShapedVector vec) {
        this.check(vec);
        return this._clone(vec);
    }

    protected FloatShapedVector _clone(FloatShapedVector vec) {
        FloatShapedVector cpy = new FloatShapedVector(this);
        this._copy(cpy, vec);
        return cpy;
    }

    @Override
    public FloatShapedVector clone(Vector vec) {
        this.check(vec);
        return this._clone(vec);
    }

    @Override
    protected FloatShapedVector _clone(Vector vec) {
        return this._clone((FloatShapedVector)vec);
    }

    public FloatShapedVector wrap(float[] x) {
        return new FloatShapedVector(this, x);
    }

    public void copy(Vector dst, float[] src) {
        this.check(dst);
        ArrayOps.copy(this.getData(dst), src);
    }

    @Override
    protected void _copy(Vector dst, Vector src) {
        if (dst != src) {
            System.arraycopy(this.getData(src), 0, this.getData(dst), 0, this.number);
        }
    }

    @Override
    protected void _swap(Vector vx, Vector vy) {
        float[] x = this.getData(vx);
        float[] y = this.getData(vy);
        int n = x.length;
        int i = 0;
        while (i < n) {
            float xi = x[i];
            x[i] = y[i];
            y[i] = xi;
            ++i;
        }
    }

    @Override
    protected void _fill(Vector vec, double alpha) {
        float[] x = this.getData(vec);
        float a = (float)alpha;
        int i = 0;
        while (i < this.number) {
            x[i] = a;
            ++i;
        }
    }

    @Override
    protected double _dot(Vector x, Vector y) {
        return ArrayOps.dot(this.number, this.getData(x), this.getData(y));
    }

    @Override
    protected double _dot(Vector w, Vector x, Vector y) {
        return ArrayOps.dot(this.number, this.getData(w), this.getData(x), this.getData(y));
    }

    @Override
    protected double _norm2(Vector x) {
        return ArrayOps.norm2(this.getData(x));
    }

    @Override
    protected double _norm1(Vector x) {
        return ArrayOps.norm1(this.getData(x));
    }

    @Override
    protected double _normInf(Vector x) {
        return ArrayOps.normInf(this.getData(x));
    }

    @Override
    protected void _scale(Vector vec, double alpha) {
        if (alpha == 0.0) {
            this._fill(vec, 0.0);
        } else if (alpha != 1.0) {
            float[] x = this.getData(vec);
            float a = (float)alpha;
            int i = 0;
            while (i < this.number) {
                int n = i++;
                x[n] = x[n] * a;
            }
        }
    }

    @Override
    protected void _scale(Vector dst, double alpha, Vector src) {
        if (alpha == 0.0) {
            this._fill(dst, 0.0);
        } else if (alpha == 1.0) {
            this._copy(dst, src);
        } else {
            float[] x = this.getData(src);
            float[] y = this.getData(dst);
            float a = (float)alpha;
            int i = 0;
            while (i < this.number) {
                y[i] = a * x[i];
                ++i;
            }
        }
    }

    @Override
    protected void _combine(double alpha, Vector x, double beta, Vector y) {
        ArrayOps.combine(this.number, alpha, this.getData(x), beta, this.getData(y));
    }

    @Override
    protected void _combine(Vector dst, double alpha, Vector x, double beta, Vector y) {
        ArrayOps.combine(this.getData(dst), this.number, alpha, this.getData(x), beta, this.getData(y));
    }

    @Override
    protected void _combine(Vector dst, double alpha, Vector x, double beta, Vector y, double gamma, Vector z) {
        ArrayOps.combine(this.getData(dst), this.number, alpha, this.getData(x), beta, this.getData(y), gamma, this.getData(z));
    }

    @Override
    protected void _multiply(Vector dst, Vector vx, Vector vy) {
        float[] x = this.getData(vx);
        float[] y = this.getData(vy);
        float[] z = this.getData(dst);
        int n = x.length;
        int i = 0;
        while (i < n) {
            z[i] = x[i] * y[i];
            ++i;
        }
    }
}

